/***************************************************************************
 * SPDX-FileCopyrightText: 2024 S. MANKOWSKI stephane@mankowski.fr
 * SPDX-FileCopyrightText: 2024 G. DE BURE support@mankowski.fr
 * SPDX-License-Identifier: GPL-3.0-or-later
 ***************************************************************************/
/** @file
 * This file is a test script.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtestmacro.h"
#include "skgbankincludes.h"
#include "skgimportexportmanager.h"

/**
 * The main function of the unit test
 * @param argc the number of arguments
 * @param argv the list of arguments
 */
int main(int argc, char** argv)
{
    Q_UNUSED(argc)
    Q_UNUSED(argv)

    // Init test
    SKGINITTEST(true)

    {
        // Test import KMY
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("IMPORT_KMY"), err)
            SKGImportExportManager impmissing(&document1, QUrl::fromLocalFile(QLatin1String("missingfile.kmy")));
            SKGTESTERROR(QLatin1String("imp1.importFile"), impmissing.importFile(), false)

            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("IN")) % "/skgtestimportkmy/rapprochement-incorrect.kmy"));
            SKGTESTERROR(QLatin1String("KMY.importFile"), imp1.importFile(), true)
        }

        {
            SKGAccountObject account(&document1);
            SKGTESTERROR(QLatin1String("KMY.setName"), account.setName(QLatin1String("CCP")), true)
            SKGTESTERROR(QLatin1String("KMY.load"), account.load(), true)
            SKGTEST(QLatin1String("KMY:getCurrentAmount"), SKGServices::doubleToString(account.getCurrentAmount()), QLatin1String("750"))
        }

        {
            SKGAccountObject account(&document1);
            SKGTESTERROR(QLatin1String("KMY.setName"), account.setName(QLatin1String("CEL Donald")), true)
            SKGTESTERROR(QLatin1String("KMY.load"), account.load(), true)
            SKGTEST(QLatin1String("KMY:getCurrentAmount"), SKGServices::doubleToString(account.getCurrentAmount()), QLatin1String("150"))
        }

        {
            SKGAccountObject account(&document1);
            SKGTESTERROR(QLatin1String("KMY.setName"), account.setName(QLatin1String("PEEs")), true)
            SKGTESTERROR(QLatin1String("KMY.load"), account.load(), true)
            SKGTEST(QLatin1String("KMY:getCurrentAmount"), SKGServices::doubleToString(account.getCurrentAmount()), QLatin1String("640"))
        }

        {
            // Scope of the transaction
            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("OUT")) % "/skgtestimportkmy1/rapprochement-incorrect.kmy"));
            SKGTESTERROR(QLatin1String("KMY.exportFile"), imp1.exportFile(), true)
        }
    }

    {
        // Test import KMY
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("IMPORT_KMY"), err)

            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("IN")) % "/skgtestimportkmy/mytest.kmy"));
            SKGTESTERROR(QLatin1String("KMY.importFile"), imp1.importFile(), true)
        }

        int nb = 0;
        SKGTESTERROR(QLatin1String("KMY:getNbObjects(recurrentoperation)"), document1.getNbObjects(QLatin1String("recurrentoperation"), QLatin1String(""), nb), true)
        SKGTEST(QLatin1String("KMY:getNbObjects(recurrentoperation)"), nb, 8)
    }

    {
        // Test import KMY
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("IMPORT_KMY"), err)

            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("IN")) % "/skgtestimportkmy/action.kmy"));
            SKGTESTERROR(QLatin1String("KMY.importFile"), imp1.importFile(), true)
        }

        {
            SKGAccountObject account(&document1);
            SKGTESTERROR(QLatin1String("KMY.setName"), account.setName(QLatin1String("courant")), true)
            SKGTESTERROR(QLatin1String("KMY.load"), account.load(), true)
            SKGTEST(QLatin1String("KMY:getCurrentAmount"), SKGServices::doubleToString(account.getCurrentAmount()), QLatin1String("-600"))
        }

        {
            SKGAccountObject account(&document1);
            SKGTESTERROR(QLatin1String("KMY.setName"), account.setName(QLatin1String("actions")), true)
            SKGTESTERROR(QLatin1String("KMY.load"), account.load(), true)
            SKGTEST(QLatin1String("KMY:getCurrentAmount"), SKGServices::doubleToString(account.getCurrentAmount()), QLatin1String("100"))
        }

        // test multi import
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("IMPORT_KMY"), err)

            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("IN")) % "/skgtestimportkmy/action.kmy"));
            SKGTESTERROR(QLatin1String("KMY.importFile"), imp1.importFile(), true)
        }
    }

    {
        // Test import KMY
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("IMPORT_KMY"), err)

            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("IN")) % "/skgtestimportkmy/252869.kmy"));
            SKGTESTERROR(QLatin1String("KMY.importFile"), imp1.importFile(), true)
        }

        int nb = 0;
        SKGTESTERROR(QLatin1String("KMY:getNbObjects(recurrentoperation)"), document1.getNbObjects(QLatin1String("bank"), QLatin1String("t_name='Test Bank'"), nb), true)
        SKGTEST(QLatin1String("KMY:getNbObjects(recurrentoperation)"), nb, 1)
    }

    {
        // 384119
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("IMPORT_KMY"), err)

            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("IN")) % "/skgtestimportkmy/384119.kmy"));
            SKGTESTERROR(QLatin1String("KMY.importFile"), imp1.importFile(), true)
        }

        int nb = 0;
        SKGTESTERROR(QLatin1String("KMY:getNbObjects(transactions without suboperation)"), document1.getNbObjects(QLatin1String("operation"), QLatin1String("NOT EXISTS (SELECT 1 FROM suboperation where rd_operation_id=operation.id)"), nb), true)
        SKGTEST(QLatin1String("KMY:getNbObjects(transactions without suboperation)"), nb, 0)
    }

    {
        // Non utf8
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("document1.initialize()"), document1.initialize(), true)
        SKGError err;
        {
            // Scope of the transaction
            SKGBEGINTRANSACTION(document1, QLatin1String("IMPORT_KMY"), err)

            SKGImportExportManager imp1(&document1, QUrl::fromLocalFile(SKGTest::getTestPath(QLatin1String("IN")) % "/skgtestimportkmy/non_utf8.kmy"));
            SKGTESTERROR(QLatin1String("KMY.importFile"), imp1.importFile(), true)
        }
    }
    // End test
    SKGENDTEST()
}
