/***************************************************************************
 * SPDX-FileCopyrightText: 2024 S. MANKOWSKI stephane@mankowski.fr
 * SPDX-FileCopyrightText: 2024 G. DE BURE support@mankowski.fr
 * SPDX-License-Identifier: GPL-3.0-or-later
 ***************************************************************************/
/** @file
 * This file is a test script.
 *
 * @author Stephane MANKOWSKI / Guillaume DE BURE
 */
#include "skgtestmacro.h"
#include "skgbankincludes.h"
#include <utility>

/**
 * The main function of the unit test
 * @param argc the number of arguments
 * @param argv the list of arguments
 */
int main(int argc, char** argv)
{
    Q_UNUSED(argc)
    Q_UNUSED(argv)

    // Init test
    SKGINITTEST(true)

    // test class SKGDocument / PARAMETERS
    {
        SKGDocument document1;
        SKGTESTERROR(QLatin1String("PARAM:initialize"), document1.initialize(), true)
        SKGTESTERROR(QLatin1String("PARAM:beginTransaction"), document1.beginTransaction(QLatin1String("t1")), true)
        SKGTESTERROR(QLatin1String("PARAM:setParameter"), document1.setParameter(QLatin1String("ATT1"), QLatin1String("VAL1")), true)
        SKGTEST(QLatin1String("PARAM:getParameter"), document1.getParameter(QLatin1String("ATT1")), QLatin1String("VAL1"))
        SKGTESTERROR(QLatin1String("PARAM:setParameter"), document1.setParameter(QLatin1String("ATT1"), QLatin1String("VAL1UPDATED")), true)
        SKGTEST(QLatin1String("PARAM:getParameter"), document1.getParameter(QLatin1String("ATT1")), QLatin1String("VAL1UPDATED"))
        SKGTESTERROR(QLatin1String("PARAM:setParameter"), document1.setParameter(QLatin1String("ATT2"), QLatin1String("VAL2")), true)
        SKGTEST(QLatin1String("PARAM:getParameter"), document1.getParameter(QLatin1String("ATT1")), QLatin1String("VAL1UPDATED"))
        SKGTEST(QLatin1String("PARAM:getParameter"), document1.getParameter(QLatin1String("ATT2")), QLatin1String("VAL2"))
        SKGTEST(QLatin1String("PARAM:getParameter"), document1.getParameter(QLatin1String("NOTFOUND")), QLatin1String(""))
        SKGTESTERROR(QLatin1String("PARAM:setParameter+sql injection"), document1.setParameter(QLatin1String("'"), QLatin1String("VAL3")), true)
        SKGTEST(QLatin1String("PARAM:getParameter+sql injection"), document1.getParameter(QLatin1String("'")), QLatin1String("VAL3"))
        SKGTESTERROR(QLatin1String("PARAM:endTransaction"), document1.endTransaction(true), true)
    }

    // Test parameters on object
    {
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("PROP:initialize"), document1.initialize(), true)
        SKGTESTERROR(QLatin1String("PROP:beginTransaction"), document1.beginTransaction(QLatin1String("t1")), true)
        SKGTESTERROR(QLatin1String("PROP:setParameter"), document1.setParameter(QLatin1String("ATT1"), QLatin1String("VAL1")), true)

        SKGObjectBase obj1(&document1, QLatin1String("bank"));
        SKGTESTERROR(QLatin1String("PROP:setAttribute"), obj1.setAttribute(QLatin1String("t_name"), QLatin1String("CL")), true)
        SKGTESTERROR(QLatin1String("PROP:Replace"), obj1.save(), true)

        SKGTESTERROR(QLatin1String("PROP:setProperty"), obj1.setProperty(QLatin1String("ATT1"), QLatin1String("VAL2"), QVariant(145)), true)

        // Check
        SKGTEST(QLatin1String("PROP:getParameter"), document1.getParameter(QLatin1String("ATT1")), QLatin1String("VAL1"))
        SKGTEST(QLatin1String("PROP:getProperty"), obj1.getProperty(QLatin1String("ATT1")), QLatin1String("VAL2"))
        SKGTEST(QLatin1String("PROP:getProperty"), obj1.getPropertyBlob(QLatin1String("ATT1")).toInt(), 145)


        QStringList oResult;
        SKGTESTERROR(QLatin1String("PROP:getDistinctValues"), document1.getDistinctValues(QLatin1String("parameters"), QLatin1String("t_value"), QLatin1String("t_value like 'VAL%'"), oResult), true)
        SKGTEST(QLatin1String("PROP:oResult.size"), oResult.size(), 2)

        // delete cascade
        SKGTESTERROR(QLatin1String("PROP:Replace"), obj1.remove(), true)
        SKGTESTERROR(QLatin1String("PROP:getDistinctValues"), document1.getDistinctValues(QLatin1String("parameters"), QLatin1String("t_value"), QLatin1String("t_value like 'VAL%'"), oResult), true)
        SKGTEST(QLatin1String("PROP:oResult.size"), oResult.size(), 1)

        SKGTESTERROR(QLatin1String("PROP:setProperty"), obj1.setProperty(QLatin1String("ATT4"), QLatin1String("VAL4"), SKGTest::getTestPath(QLatin1String("IN")) % "/dates.txt"), true)
        SKGTESTERROR(QLatin1String("PROP:setProperty"), obj1.setProperty(QLatin1String("ATT5"), QLatin1String("VAL5"), SKGTest::getTestPath(QLatin1String("IN"))), true)

        {
            // Scope of the transaction
            SKGError err;
            SKGBEGINTRANSACTION(document1, QLatin1String("T1"), err)

            SKGPropertyObject propAdded1;
            SKGTESTERROR(QLatin1String("PROP.setProperty"), obj1.setProperty(QLatin1String("normal"), QLatin1String("value"), QVariant(), &propAdded1), true)
            SKGTEST(QLatin1String("PROP.getUrl"), propAdded1.getUrl().toDisplayString(), QLatin1String(""))

            SKGPropertyObject propAdded2;
            SKGTESTERROR(QLatin1String("PROP.setProperty"), obj1.setProperty(QLatin1String("url"), QLatin1String("https://skrooge.org/"), QVariant(), &propAdded2), true)
            SKGTEST(QLatin1String("PROP.getUrl"), propAdded2.getUrl().toDisplayString(), QLatin1String("https://skrooge.org/"))

            SKGPropertyObject propAdded3;
            SKGTESTERROR(QLatin1String("PROP.setProperty"), obj1.setProperty(QLatin1String("file copied"), SKGTest::getTestPath(QLatin1String("IN")) % "dates.txt", QVariant(), &propAdded3), true)
            SKGTEST(QLatin1String("PROP.getUrl"), propAdded3.getUrl().toDisplayString(), "file://" % SKGTest::getTestPath(QLatin1String("IN")) % "dates.txt")

            SKGPropertyObject propAdded4;
            SKGTESTERROR(QLatin1String("PROP.setProperty"), obj1.setProperty(QLatin1String("file moved"), QLatin1String("test.txt"), QVariant("ABC"), &propAdded4), true)
            SKGTESTBOOL("PROP.getUrl", propAdded4.getUrl().toDisplayString().startsWith(QLatin1String("file://")), true)
            SKGTESTBOOL("PROP.getUrl", propAdded4.getUrl().toDisplayString().endsWith(QLatin1String("test.txt")), true)

            SKGTESTBOOL("PROP.getUrl", propAdded4.getUrl(true).toDisplayString().startsWith(QLatin1String("file://")), true)
            SKGTESTBOOL("PROP.getUrl", propAdded4.getUrl(true).toDisplayString().endsWith(QLatin1String("test.txt")), true)
        }
    }

    {
        SKGDocumentBank document1;
        SKGTESTERROR(QLatin1String("DOC:initialize"), document1.initialize(), true)
        QStringList listTables;
        SKGTESTERROR(QLatin1String("DOC::getTablesList"), document1.getTablesList(listTables), true)
        for (const auto& table : std::as_const(listTables)) {
            document1.getDisplaySchemas(table);
        }
    }

    // End test
    SKGENDTEST()
}
