/*
   SPDX-FileCopyrightText: 2025 Laurent Montel <montel@kde.org>

   SPDX-License-Identifier: GPL-2.0-or-later
*/

#include "autogenerateanswerseditorinterface.h"
using namespace Qt::Literals::StringLiterals;

#include "autogenerateanswerseditordialog.h"
#include "autogenerateanswerseditorplugin_debug.h"
#include <KActionCollection>
#include <KLocalizedString>
#include <QAction>
#include <QMenu>
#include <TextAutoGenerateText/TextAutoGenerateAskJob>
#include <TextAutoGenerateText/TextAutoGenerateDialog>

AutoGenerateAnswersEditorInterface::AutoGenerateAnswersEditorInterface(QObject *parent)
    : MessageComposer::PluginEditorInterface(parent)
{
}

AutoGenerateAnswersEditorInterface::~AutoGenerateAnswersEditorInterface() = default;

void AutoGenerateAnswersEditorInterface::createAction(KActionCollection *ac)
{
    auto action = new QAction(i18nc("@action", "Autogenerate Answer"), this);
    ac->addAction(u"quick_answer"_s, action);
    MessageComposer::PluginActionType type(action, MessageComposer::PluginActionType::Edit);
    setActionType(type);
    auto menu = new QMenu(parentWidget());
    auto act = menu->addAction(i18nc("@action", "Summary Text"));
    connect(act, &QAction::triggered, this, [this]() {
        mAnswerType = AnswerType::SummaryText;
        Q_EMIT emitPluginActivated(this);
    });

    act = menu->addAction(i18nc("@action", "Correct Text"));
    connect(act, &QAction::triggered, this, [this]() {
        mAnswerType = AnswerType::FixTypo;
        Q_EMIT emitPluginActivated(this);
    });

    act = menu->addAction(i18nc("@action", "Quick Answer"));
    connect(act, &QAction::triggered, this, [this]() {
        mAnswerType = AnswerType::QuickAnswer;
        Q_EMIT emitPluginActivated(this);
    });
    action->setMenu(menu);
}

void AutoGenerateAnswersEditorInterface::exec()
{
    switch (mAnswerType) {
    case AnswerType::Unknown:
        qCWarning(KMAIL_EDITOR_AUTOGENERATEANSWER_PLUGIN_LOG) << "AnswerType::Unknown: it's a bug";
        return;
    case AnswerType::SummaryText:
        break;
    case AnswerType::QuickAnswer:
        break;
    case AnswerType::FixTypo:
        break;
    }
    auto job = new TextAutoGenerateText::TextAutoGenerateAskJob(this);
    // TODO add manager
    connect(job, &TextAutoGenerateText::TextAutoGenerateAskJob::generateTextInProgress, this, &AutoGenerateAnswersEditorInterface::slotGenerateTextInProgress);
    job->start();
}

void AutoGenerateAnswersEditorInterface::slotGenerateTextInProgress(const QString &str)
{
    // TODO
}

#include "moc_autogenerateanswerseditorinterface.cpp"
