
CREATE TABLE IF NOT EXISTS APPS (
org TEXT,
name TEXT,
adddate DATE,
comment TEXT,
PRIMARY KEY(org)
);

CREATE TABLE IF NOT EXISTS TAGS (
tag TEXT,
color TEXT,
adddate DATE,
comment TEXT,
PRIMARY KEY(tag)
);

CREATE TABLE IF NOT EXISTS APP_TAGS (
tag TEXT,
org TEXT,
adddate DATE,
PRIMARY KEY(tag, org),
FOREIGN KEY(tag) REFERENCES TAGS(tag),
FOREIGN KEY(org) REFERENCES APPS(org)
);

CREATE TABLE IF NOT EXISTS TAGS_URLS (
tag TEXT,
url TEXT,
title TEXT,
comment TEXT,
mime TEXT,
adddate DATE,
PRIMARY KEY(tag, url),
FOREIGN KEY(tag) REFERENCES TAGS(tag)
);

COMMIT;
