import QtQuick 2.14
import QtQuick.Controls 2.14

import org.mauikit.controls 1.3 as Maui
import org.kde.kirigami 2.6 as Kirigami
import org.mauikit.filebrowsing 1.0 as FB

/**
 * PlacesListBrowser
 * A global sidebar for the application window that can be collapsed.
 *
 *
 *
 *
 *
 *
 */
Maui.ListBrowser
{
    id: control

    /**
      * list : PlacesList
      */
    property alias list : placesList

    /**
      * itemMenu : Menu
      */
    property alias itemMenu : _menu

    /**
      * iconSize : int
      */
    property int iconSize : Maui.Style.iconSizes.small

    /**
      * placeClicked :
      */
    signal placeClicked (string path)
    signal itemClicked(int index)
    signal itemDoubleClicked(int index)
    signal itemRightClicked(int index)
    
    focus: true
    model: Maui.BaseModel
    {
        id: placesModel
        list: FB.PlacesList
        {
            id: placesList
            groups: [
                FB.FMList.PLACES_PATH,
                FB.FMList.APPS_PATH,
                FB.FMList.BOOKMARKS_PATH,
                FB.FMList.DRIVES_PATH]
        }
    }

    section.property: "type"
    section.criteria: ViewSection.FullString
    section.delegate: Maui.LabelDelegate
    {
        id: delegate
        label: section
        labelTxt.font.pointSize: Maui.Style.fontSizes.big

        isSection: true
        width: parent.width
        height: Maui.Style.toolBarHeightAlt
    }

    onItemClicked:
    {
        var item = placesModel.get(index)
        var path = item.path
        placeClicked(path)
    }

    onItemRightClicked: _menu.popup()

    Maui.ContextualMenu
    {
        id: _menu
        property int index

        MenuItem
        {
            text: i18n("Edit")
        }

        MenuItem
        {
            text: i18n("Hide")
        }

        MenuItem
        {
            text: i18n("Remove")
            Kirigami.Theme.textColor: Kirigami.Theme.negativeTextColor
            onTriggered: list.removePlace(control.currentIndex)
        }
    }

    delegate: Maui.ListDelegate
    {
        width: ListView.view.width
        iconSize: control.iconSize
        template.headerSizeHint: iconSize + Maui.Style.space.small

        labelVisible: true
        iconVisible: true
        label: model.label
        iconName: model.icon

        onClicked:
        {
            control.currentIndex = index
            itemClicked(index)
        }

        onRightClicked:
        {
            control.currentIndex = index
            itemRightClicked(index)
        }

        onPressAndHold:
        {
            control.currentIndex = index
            itemRightClicked(index)
        }
    }
}
