/*
    Copyright (c) 2016 Christian Mollekopf <mollekopf@kolabsystems.com>

    This library is free software; you can redistribute it and/or modify it
    under the terms of the GNU Library General Public License as published by
    the Free Software Foundation; either version 2 of the License, or (at your
    option) any later version.

    This library is distributed in the hope that it will be useful, but WITHOUT
    ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
    FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Library General Public
    License for more details.

    You should have received a copy of the GNU Library General Public License
    along with this library; see the file COPYING.LIB.  If not, write to the
    Free Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
    02110-1301, USA.
*/

#pragma once

#include "kube_export.h"
#include <QObject>
#include <QVariant>
#include <QUrl>

/**
 * A factory to instantiate account-plugins.
 */
class KUBE_EXPORT AccountFactory : public QObject
{
    Q_OBJECT
    Q_PROPERTY(QString accountId MEMBER mAccountId WRITE setAccountId);
    Q_PROPERTY(QString accountType MEMBER mAccountType WRITE setAccountType);
    Q_PROPERTY(QString accountName MEMBER mAccountName NOTIFY accountLoaded);
    Q_PROPERTY(QUrl uiPath MEMBER mUiPath NOTIFY accountLoaded);
    Q_PROPERTY(QUrl loginUi MEMBER mLoginUi NOTIFY accountLoaded);
    Q_PROPERTY(bool requiresKeyring MEMBER mRequiresKeyring NOTIFY accountLoaded);
public:
    explicit AccountFactory(QObject *parent = Q_NULLPTR);

    void setAccountId(const QString &);
    void setAccountType(const QString &);

signals:
    void accountLoaded();

private:
    void loadPackage();
    QString mAccountId;
    QString mAccountName;
    QUrl mUiPath;
    QUrl mLoginUi;
    QByteArray mAccountType;
    bool mRequiresKeyring = true;
};
