/*
SPDX-FileCopyrightText: 2021 Hamed Masafi <hamed.masfi@gmail.com>

SPDX-License-Identifier: GPL-3.0-or-later
*/

#pragma once

#include "filestatus.h"
#include "libkommitgui_private_export.h"
#include <QTreeWidget>

class LIBKOMMITGUI_TESTS_EXPORT FilesStatusesList : public QTreeWidget
{
    Q_OBJECT
public:
    explicit FilesStatusesList(QWidget *parent = nullptr);

    const QList<Git::FileStatus> &files() const;
    void setFiles(const QList<Git::FileStatus> &newFiles);
    bool showCheckboxes() const;
    void setShowCheckboxes(bool newShowCheckboxes);

private:
    QList<Git::FileStatus> mFiles;
    bool mShowCheckboxes{false};
};
