% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_main_indel_contexts.R
\name{plot_main_indel_contexts}
\alias{plot_main_indel_contexts}
\title{Plot the main indel contexts}
\usage{
plot_main_indel_contexts(counts, same_y = FALSE)
}
\arguments{
\item{counts}{A tibble containing the number of indels per COSMIC context.}

\item{same_y}{A boolean describing whether the same y axis should be used for all samples.}
}
\value{
A ggplot figure.
}
\description{
Plot the main indel contexts
}
\details{
Plots the number of indels per main COSMIC context per sample.
The contexts are not subdivided into the number of repeats/microhomology length.
It takes a tibble with counts as its input. This tibble can be generated by count_indel_contexts
Each sample is plotted in a separate facet.
The same y axis can be used for all samples or a separate y axis can be used.
}
\examples{
## Get The indel counts
## See 'count_indel_contexts()' for more info on how to do this.
indel_counts <- readRDS(system.file("states/blood_indel_counts.rds",
  package = "MutationalPatterns"
))

## Plot contexts
plot_main_indel_contexts(indel_counts)

## Use the same y axis for all samples.
plot_main_indel_contexts(indel_counts, same_y = TRUE)
}
\seealso{
\code{\link{count_indel_contexts}}, \code{\link{plot_indel_contexts}}

Other Indels: 
\code{\link{count_indel_contexts}()},
\code{\link{get_indel_context}()},
\code{\link{plot_compare_indels}()},
\code{\link{plot_indel_contexts}()}
}
\concept{Indels}
