% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotTrainStats.R
\name{trainCurveFactors}
\alias{trainCurveFactors}
\title{Training curve for the number of active factors}
\usage{
trainCurveFactors(object)
}
\arguments{
\item{object}{a \code{\link{MOFAmodel}} object.}
}
\value{
plot of number of active factors during training
}
\description{
The MOFA model starts with an initial number of factors and inactive factors
 can be dropped during training if they explain small amounts of variation 
 (as defined in \code{\link{getDefaultModelOptions}}). 
This allows the model to automatically infer the dimensionality of the latent space.
The corresponding hyperparameters are defined in \code{\link{prepareMOFA}}. \cr
All training statistics, including the number of active factors, can be fetch from the
 TrainStats slot of \code{\link{MOFAmodel}} .
}
\examples{
# Example on the CLL data
filepath <- system.file("extdata", "CLL_model.hdf5", package = "MOFAdata")
MOFA_CLL <- loadModel(filepath)
trainCurveFactors(MOFA_CLL)
# Example on the scMT data
filepath <- system.file("extdata", "scMT_model.hdf5", package = "MOFAdata")
MOFA_scMT <- loadModel(filepath)
trainCurveFactors(MOFA_scMT) 
}
