; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 -mattr=+d,+zfh,+zvfh,+v -verify-machineinstrs < %s | FileCheck %s
; RUN: llc -mtriple=riscv64 -mattr=+d,+zfh,+zvfh,+v -verify-machineinstrs < %s | FileCheck %s

define <vscale x 1 x i8> @sextload_nxv1i1_nxv1i8(<vscale x 1 x i1>* %x) {
; CHECK-LABEL: sextload_nxv1i1_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vlm.v v0, (a0)
; CHECK-NEXT:    vmv.v.i v8, 0
; CHECK-NEXT:    vmerge.vim v8, v8, -1, v0
; CHECK-NEXT:    ret
  %y = load <vscale x 1 x i1>, <vscale x 1 x i1>* %x
  %z = sext <vscale x 1 x i1> %y to <vscale x 1 x i8>
  ret <vscale x 1 x i8> %z
}

define <vscale x 1 x i16> @sextload_nxv1i8_nxv1i16(<vscale x 1 x i8>* %x) {
; CHECK-LABEL: sextload_nxv1i8_nxv1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vle8.v v9, (a0)
; CHECK-NEXT:    vsext.vf2 v8, v9
; CHECK-NEXT:    ret
  %y = load <vscale x 1 x i8>, <vscale x 1 x i8>* %x
  %z = sext <vscale x 1 x i8> %y to <vscale x 1 x i16>
  ret <vscale x 1 x i16> %z
}

define <vscale x 1 x i16> @zextload_nxv1i8_nxv1i16(<vscale x 1 x i8>* %x) {
; CHECK-LABEL: zextload_nxv1i8_nxv1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vle8.v v9, (a0)
; CHECK-NEXT:    vzext.vf2 v8, v9
; CHECK-NEXT:    ret
  %y = load <vscale x 1 x i8>, <vscale x 1 x i8>* %x
  %z = zext <vscale x 1 x i8> %y to <vscale x 1 x i16>
  ret <vscale x 1 x i16> %z
}

define <vscale x 1 x i32> @sextload_nxv1i8_nxv1i32(<vscale x 1 x i8>* %x) {
; CHECK-LABEL: sextload_nxv1i8_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vle8.v v9, (a0)
; CHECK-NEXT:    vsext.vf4 v8, v9
; CHECK-NEXT:    ret
  %y = load <vscale x 1 x i8>, <vscale x 1 x i8>* %x
  %z = sext <vscale x 1 x i8> %y to <vscale x 1 x i32>
  ret <vscale x 1 x i32> %z
}

define <vscale x 1 x i32> @zextload_nxv1i8_nxv1i32(<vscale x 1 x i8>* %x) {
; CHECK-LABEL: zextload_nxv1i8_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vle8.v v9, (a0)
; CHECK-NEXT:    vzext.vf4 v8, v9
; CHECK-NEXT:    ret
  %y = load <vscale x 1 x i8>, <vscale x 1 x i8>* %x
  %z = zext <vscale x 1 x i8> %y to <vscale x 1 x i32>
  ret <vscale x 1 x i32> %z
}

define <vscale x 1 x i64> @sextload_nxv1i8_nxv1i64(<vscale x 1 x i8>* %x) {
; CHECK-LABEL: sextload_nxv1i8_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; CHECK-NEXT:    vle8.v v9, (a0)
; CHECK-NEXT:    vsext.vf8 v8, v9
; CHECK-NEXT:    ret
  %y = load <vscale x 1 x i8>, <vscale x 1 x i8>* %x
  %z = sext <vscale x 1 x i8> %y to <vscale x 1 x i64>
  ret <vscale x 1 x i64> %z
}

define <vscale x 1 x i64> @zextload_nxv1i8_nxv1i64(<vscale x 1 x i8>* %x) {
; CHECK-LABEL: zextload_nxv1i8_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; CHECK-NEXT:    vle8.v v9, (a0)
; CHECK-NEXT:    vzext.vf8 v8, v9
; CHECK-NEXT:    ret
  %y = load <vscale x 1 x i8>, <vscale x 1 x i8>* %x
  %z = zext <vscale x 1 x i8> %y to <vscale x 1 x i64>
  ret <vscale x 1 x i64> %z
}

define <vscale x 2 x i16> @sextload_nxv2i8_nxv2i16(<vscale x 2 x i8>* %x) {
; CHECK-LABEL: sextload_nxv2i8_nxv2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vle8.v v9, (a0)
; CHECK-NEXT:    vsext.vf2 v8, v9
; CHECK-NEXT:    ret
  %y = load <vscale x 2 x i8>, <vscale x 2 x i8>* %x
  %z = sext <vscale x 2 x i8> %y to <vscale x 2 x i16>
  ret <vscale x 2 x i16> %z
}

define <vscale x 2 x i16> @zextload_nxv2i8_nxv2i16(<vscale x 2 x i8>* %x) {
; CHECK-LABEL: zextload_nxv2i8_nxv2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vle8.v v9, (a0)
; CHECK-NEXT:    vzext.vf2 v8, v9
; CHECK-NEXT:    ret
  %y = load <vscale x 2 x i8>, <vscale x 2 x i8>* %x
  %z = zext <vscale x 2 x i8> %y to <vscale x 2 x i16>
  ret <vscale x 2 x i16> %z
}

define <vscale x 2 x i32> @sextload_nxv2i8_nxv2i32(<vscale x 2 x i8>* %x) {
; CHECK-LABEL: sextload_nxv2i8_nxv2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-NEXT:    vle8.v v9, (a0)
; CHECK-NEXT:    vsext.vf4 v8, v9
; CHECK-NEXT:    ret
  %y = load <vscale x 2 x i8>, <vscale x 2 x i8>* %x
  %z = sext <vscale x 2 x i8> %y to <vscale x 2 x i32>
  ret <vscale x 2 x i32> %z
}

define <vscale x 2 x i32> @zextload_nxv2i8_nxv2i32(<vscale x 2 x i8>* %x) {
; CHECK-LABEL: zextload_nxv2i8_nxv2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-NEXT:    vle8.v v9, (a0)
; CHECK-NEXT:    vzext.vf4 v8, v9
; CHECK-NEXT:    ret
  %y = load <vscale x 2 x i8>, <vscale x 2 x i8>* %x
  %z = zext <vscale x 2 x i8> %y to <vscale x 2 x i32>
  ret <vscale x 2 x i32> %z
}

define <vscale x 2 x i64> @sextload_nxv2i8_nxv2i64(<vscale x 2 x i8>* %x) {
; CHECK-LABEL: sextload_nxv2i8_nxv2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e64, m2, ta, ma
; CHECK-NEXT:    vle8.v v10, (a0)
; CHECK-NEXT:    vsext.vf8 v8, v10
; CHECK-NEXT:    ret
  %y = load <vscale x 2 x i8>, <vscale x 2 x i8>* %x
  %z = sext <vscale x 2 x i8> %y to <vscale x 2 x i64>
  ret <vscale x 2 x i64> %z
}

define <vscale x 2 x i64> @zextload_nxv2i8_nxv2i64(<vscale x 2 x i8>* %x) {
; CHECK-LABEL: zextload_nxv2i8_nxv2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e64, m2, ta, ma
; CHECK-NEXT:    vle8.v v10, (a0)
; CHECK-NEXT:    vzext.vf8 v8, v10
; CHECK-NEXT:    ret
  %y = load <vscale x 2 x i8>, <vscale x 2 x i8>* %x
  %z = zext <vscale x 2 x i8> %y to <vscale x 2 x i64>
  ret <vscale x 2 x i64> %z
}

define <vscale x 4 x i16> @sextload_nxv4i8_nxv4i16(<vscale x 4 x i8>* %x) {
; CHECK-LABEL: sextload_nxv4i8_nxv4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; CHECK-NEXT:    vle8.v v9, (a0)
; CHECK-NEXT:    vsext.vf2 v8, v9
; CHECK-NEXT:    ret
  %y = load <vscale x 4 x i8>, <vscale x 4 x i8>* %x
  %z = sext <vscale x 4 x i8> %y to <vscale x 4 x i16>
  ret <vscale x 4 x i16> %z
}

define <vscale x 4 x i16> @zextload_nxv4i8_nxv4i16(<vscale x 4 x i8>* %x) {
; CHECK-LABEL: zextload_nxv4i8_nxv4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; CHECK-NEXT:    vle8.v v9, (a0)
; CHECK-NEXT:    vzext.vf2 v8, v9
; CHECK-NEXT:    ret
  %y = load <vscale x 4 x i8>, <vscale x 4 x i8>* %x
  %z = zext <vscale x 4 x i8> %y to <vscale x 4 x i16>
  ret <vscale x 4 x i16> %z
}

define <vscale x 4 x i32> @sextload_nxv4i8_nxv4i32(<vscale x 4 x i8>* %x) {
; CHECK-LABEL: sextload_nxv4i8_nxv4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; CHECK-NEXT:    vle8.v v10, (a0)
; CHECK-NEXT:    vsext.vf4 v8, v10
; CHECK-NEXT:    ret
  %y = load <vscale x 4 x i8>, <vscale x 4 x i8>* %x
  %z = sext <vscale x 4 x i8> %y to <vscale x 4 x i32>
  ret <vscale x 4 x i32> %z
}

define <vscale x 4 x i32> @zextload_nxv4i8_nxv4i32(<vscale x 4 x i8>* %x) {
; CHECK-LABEL: zextload_nxv4i8_nxv4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; CHECK-NEXT:    vle8.v v10, (a0)
; CHECK-NEXT:    vzext.vf4 v8, v10
; CHECK-NEXT:    ret
  %y = load <vscale x 4 x i8>, <vscale x 4 x i8>* %x
  %z = zext <vscale x 4 x i8> %y to <vscale x 4 x i32>
  ret <vscale x 4 x i32> %z
}

define <vscale x 4 x i64> @sextload_nxv4i8_nxv4i64(<vscale x 4 x i8>* %x) {
; CHECK-LABEL: sextload_nxv4i8_nxv4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e64, m4, ta, ma
; CHECK-NEXT:    vle8.v v12, (a0)
; CHECK-NEXT:    vsext.vf8 v8, v12
; CHECK-NEXT:    ret
  %y = load <vscale x 4 x i8>, <vscale x 4 x i8>* %x
  %z = sext <vscale x 4 x i8> %y to <vscale x 4 x i64>
  ret <vscale x 4 x i64> %z
}

define <vscale x 4 x i64> @zextload_nxv4i8_nxv4i64(<vscale x 4 x i8>* %x) {
; CHECK-LABEL: zextload_nxv4i8_nxv4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e64, m4, ta, ma
; CHECK-NEXT:    vle8.v v12, (a0)
; CHECK-NEXT:    vzext.vf8 v8, v12
; CHECK-NEXT:    ret
  %y = load <vscale x 4 x i8>, <vscale x 4 x i8>* %x
  %z = zext <vscale x 4 x i8> %y to <vscale x 4 x i64>
  ret <vscale x 4 x i64> %z
}

define <vscale x 8 x i16> @sextload_nxv8i8_nxv8i16(<vscale x 8 x i8>* %x) {
; CHECK-LABEL: sextload_nxv8i8_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl1r.v v10, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vsext.vf2 v8, v10
; CHECK-NEXT:    ret
  %y = load <vscale x 8 x i8>, <vscale x 8 x i8>* %x
  %z = sext <vscale x 8 x i8> %y to <vscale x 8 x i16>
  ret <vscale x 8 x i16> %z
}

define <vscale x 8 x i16> @zextload_nxv8i8_nxv8i16(<vscale x 8 x i8>* %x) {
; CHECK-LABEL: zextload_nxv8i8_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl1r.v v10, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v8, v10
; CHECK-NEXT:    ret
  %y = load <vscale x 8 x i8>, <vscale x 8 x i8>* %x
  %z = zext <vscale x 8 x i8> %y to <vscale x 8 x i16>
  ret <vscale x 8 x i16> %z
}

define <vscale x 8 x i32> @sextload_nxv8i8_nxv8i32(<vscale x 8 x i8>* %x) {
; CHECK-LABEL: sextload_nxv8i8_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl1r.v v12, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vsext.vf4 v8, v12
; CHECK-NEXT:    ret
  %y = load <vscale x 8 x i8>, <vscale x 8 x i8>* %x
  %z = sext <vscale x 8 x i8> %y to <vscale x 8 x i32>
  ret <vscale x 8 x i32> %z
}

define <vscale x 8 x i32> @zextload_nxv8i8_nxv8i32(<vscale x 8 x i8>* %x) {
; CHECK-LABEL: zextload_nxv8i8_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl1r.v v12, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vzext.vf4 v8, v12
; CHECK-NEXT:    ret
  %y = load <vscale x 8 x i8>, <vscale x 8 x i8>* %x
  %z = zext <vscale x 8 x i8> %y to <vscale x 8 x i32>
  ret <vscale x 8 x i32> %z
}

define <vscale x 8 x i64> @sextload_nxv8i8_nxv8i64(<vscale x 8 x i8>* %x) {
; CHECK-LABEL: sextload_nxv8i8_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl1r.v v16, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vsext.vf8 v8, v16
; CHECK-NEXT:    ret
  %y = load <vscale x 8 x i8>, <vscale x 8 x i8>* %x
  %z = sext <vscale x 8 x i8> %y to <vscale x 8 x i64>
  ret <vscale x 8 x i64> %z
}

define <vscale x 8 x i64> @zextload_nxv8i8_nxv8i64(<vscale x 8 x i8>* %x) {
; CHECK-LABEL: zextload_nxv8i8_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl1r.v v16, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vzext.vf8 v8, v16
; CHECK-NEXT:    ret
  %y = load <vscale x 8 x i8>, <vscale x 8 x i8>* %x
  %z = zext <vscale x 8 x i8> %y to <vscale x 8 x i64>
  ret <vscale x 8 x i64> %z
}

define <vscale x 16 x i16> @sextload_nxv16i8_nxv16i16(<vscale x 16 x i8>* %x) {
; CHECK-LABEL: sextload_nxv16i8_nxv16i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl2r.v v12, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vsext.vf2 v8, v12
; CHECK-NEXT:    ret
  %y = load <vscale x 16 x i8>, <vscale x 16 x i8>* %x
  %z = sext <vscale x 16 x i8> %y to <vscale x 16 x i16>
  ret <vscale x 16 x i16> %z
}

define <vscale x 16 x i16> @zextload_nxv16i8_nxv16i16(<vscale x 16 x i8>* %x) {
; CHECK-LABEL: zextload_nxv16i8_nxv16i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl2r.v v12, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vzext.vf2 v8, v12
; CHECK-NEXT:    ret
  %y = load <vscale x 16 x i8>, <vscale x 16 x i8>* %x
  %z = zext <vscale x 16 x i8> %y to <vscale x 16 x i16>
  ret <vscale x 16 x i16> %z
}

define <vscale x 16 x i32> @sextload_nxv16i8_nxv16i32(<vscale x 16 x i8>* %x) {
; CHECK-LABEL: sextload_nxv16i8_nxv16i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl2r.v v16, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vsext.vf4 v8, v16
; CHECK-NEXT:    ret
  %y = load <vscale x 16 x i8>, <vscale x 16 x i8>* %x
  %z = sext <vscale x 16 x i8> %y to <vscale x 16 x i32>
  ret <vscale x 16 x i32> %z
}

define <vscale x 16 x i32> @zextload_nxv16i8_nxv16i32(<vscale x 16 x i8>* %x) {
; CHECK-LABEL: zextload_nxv16i8_nxv16i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl2r.v v16, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vzext.vf4 v8, v16
; CHECK-NEXT:    ret
  %y = load <vscale x 16 x i8>, <vscale x 16 x i8>* %x
  %z = zext <vscale x 16 x i8> %y to <vscale x 16 x i32>
  ret <vscale x 16 x i32> %z
}

define <vscale x 32 x i16> @sextload_nxv32i8_nxv32i16(<vscale x 32 x i8>* %x) {
; CHECK-LABEL: sextload_nxv32i8_nxv32i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl4r.v v16, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-NEXT:    vsext.vf2 v8, v16
; CHECK-NEXT:    ret
  %y = load <vscale x 32 x i8>, <vscale x 32 x i8>* %x
  %z = sext <vscale x 32 x i8> %y to <vscale x 32 x i16>
  ret <vscale x 32 x i16> %z
}

define <vscale x 32 x i16> @zextload_nxv32i8_nxv32i16(<vscale x 32 x i8>* %x) {
; CHECK-LABEL: zextload_nxv32i8_nxv32i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl4r.v v16, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e16, m8, ta, ma
; CHECK-NEXT:    vzext.vf2 v8, v16
; CHECK-NEXT:    ret
  %y = load <vscale x 32 x i8>, <vscale x 32 x i8>* %x
  %z = zext <vscale x 32 x i8> %y to <vscale x 32 x i16>
  ret <vscale x 32 x i16> %z
}

define void @truncstore_nxv1i8_nxv1i1(<vscale x 1 x i8> %x, <vscale x 1 x i1> *%z) {
; CHECK-LABEL: truncstore_nxv1i8_nxv1i1:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vand.vi v8, v8, 1
; CHECK-NEXT:    vmsne.vi v8, v8, 0
; CHECK-NEXT:    vsm.v v8, (a0)
; CHECK-NEXT:    ret
  %y = trunc <vscale x 1 x i8> %x to <vscale x 1 x i1>
  store <vscale x 1 x i1> %y, <vscale x 1 x i1>* %z
  ret void
}

define void @truncstore_nxv1i16_nxv1i8(<vscale x 1 x i16> %x, <vscale x 1 x i8>* %z) {
; CHECK-LABEL: truncstore_nxv1i16_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-NEXT:    vse8.v v8, (a0)
; CHECK-NEXT:    ret
  %y = trunc <vscale x 1 x i16> %x to <vscale x 1 x i8>
  store <vscale x 1 x i8> %y, <vscale x 1 x i8>* %z
  ret void
}

define <vscale x 1 x i32> @sextload_nxv1i16_nxv1i32(<vscale x 1 x i16>* %x) {
; CHECK-LABEL: sextload_nxv1i16_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vle16.v v9, (a0)
; CHECK-NEXT:    vsext.vf2 v8, v9
; CHECK-NEXT:    ret
  %y = load <vscale x 1 x i16>, <vscale x 1 x i16>* %x
  %z = sext <vscale x 1 x i16> %y to <vscale x 1 x i32>
  ret <vscale x 1 x i32> %z
}

define <vscale x 1 x i32> @zextload_nxv1i16_nxv1i32(<vscale x 1 x i16>* %x) {
; CHECK-LABEL: zextload_nxv1i16_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vle16.v v9, (a0)
; CHECK-NEXT:    vzext.vf2 v8, v9
; CHECK-NEXT:    ret
  %y = load <vscale x 1 x i16>, <vscale x 1 x i16>* %x
  %z = zext <vscale x 1 x i16> %y to <vscale x 1 x i32>
  ret <vscale x 1 x i32> %z
}

define <vscale x 1 x i64> @sextload_nxv1i16_nxv1i64(<vscale x 1 x i16>* %x) {
; CHECK-LABEL: sextload_nxv1i16_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; CHECK-NEXT:    vle16.v v9, (a0)
; CHECK-NEXT:    vsext.vf4 v8, v9
; CHECK-NEXT:    ret
  %y = load <vscale x 1 x i16>, <vscale x 1 x i16>* %x
  %z = sext <vscale x 1 x i16> %y to <vscale x 1 x i64>
  ret <vscale x 1 x i64> %z
}

define <vscale x 1 x i64> @zextload_nxv1i16_nxv1i64(<vscale x 1 x i16>* %x) {
; CHECK-LABEL: zextload_nxv1i16_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; CHECK-NEXT:    vle16.v v9, (a0)
; CHECK-NEXT:    vzext.vf4 v8, v9
; CHECK-NEXT:    ret
  %y = load <vscale x 1 x i16>, <vscale x 1 x i16>* %x
  %z = zext <vscale x 1 x i16> %y to <vscale x 1 x i64>
  ret <vscale x 1 x i64> %z
}

define void @truncstore_nxv2i16_nxv2i8(<vscale x 2 x i16> %x, <vscale x 2 x i8>* %z) {
; CHECK-LABEL: truncstore_nxv2i16_nxv2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-NEXT:    vse8.v v8, (a0)
; CHECK-NEXT:    ret
  %y = trunc <vscale x 2 x i16> %x to <vscale x 2 x i8>
  store <vscale x 2 x i8> %y, <vscale x 2 x i8>* %z
  ret void
}

define <vscale x 2 x i32> @sextload_nxv2i16_nxv2i32(<vscale x 2 x i16>* %x) {
; CHECK-LABEL: sextload_nxv2i16_nxv2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-NEXT:    vle16.v v9, (a0)
; CHECK-NEXT:    vsext.vf2 v8, v9
; CHECK-NEXT:    ret
  %y = load <vscale x 2 x i16>, <vscale x 2 x i16>* %x
  %z = sext <vscale x 2 x i16> %y to <vscale x 2 x i32>
  ret <vscale x 2 x i32> %z
}

define <vscale x 2 x i32> @zextload_nxv2i16_nxv2i32(<vscale x 2 x i16>* %x) {
; CHECK-LABEL: zextload_nxv2i16_nxv2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-NEXT:    vle16.v v9, (a0)
; CHECK-NEXT:    vzext.vf2 v8, v9
; CHECK-NEXT:    ret
  %y = load <vscale x 2 x i16>, <vscale x 2 x i16>* %x
  %z = zext <vscale x 2 x i16> %y to <vscale x 2 x i32>
  ret <vscale x 2 x i32> %z
}

define <vscale x 2 x i64> @sextload_nxv2i16_nxv2i64(<vscale x 2 x i16>* %x) {
; CHECK-LABEL: sextload_nxv2i16_nxv2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e64, m2, ta, ma
; CHECK-NEXT:    vle16.v v10, (a0)
; CHECK-NEXT:    vsext.vf4 v8, v10
; CHECK-NEXT:    ret
  %y = load <vscale x 2 x i16>, <vscale x 2 x i16>* %x
  %z = sext <vscale x 2 x i16> %y to <vscale x 2 x i64>
  ret <vscale x 2 x i64> %z
}

define <vscale x 2 x i64> @zextload_nxv2i16_nxv2i64(<vscale x 2 x i16>* %x) {
; CHECK-LABEL: zextload_nxv2i16_nxv2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e64, m2, ta, ma
; CHECK-NEXT:    vle16.v v10, (a0)
; CHECK-NEXT:    vzext.vf4 v8, v10
; CHECK-NEXT:    ret
  %y = load <vscale x 2 x i16>, <vscale x 2 x i16>* %x
  %z = zext <vscale x 2 x i16> %y to <vscale x 2 x i64>
  ret <vscale x 2 x i64> %z
}

define void @truncstore_nxv4i16_nxv4i8(<vscale x 4 x i16> %x, <vscale x 4 x i8>* %z) {
; CHECK-LABEL: truncstore_nxv4i16_nxv4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-NEXT:    vse8.v v8, (a0)
; CHECK-NEXT:    ret
  %y = trunc <vscale x 4 x i16> %x to <vscale x 4 x i8>
  store <vscale x 4 x i8> %y, <vscale x 4 x i8>* %z
  ret void
}

define <vscale x 4 x i32> @sextload_nxv4i16_nxv4i32(<vscale x 4 x i16>* %x) {
; CHECK-LABEL: sextload_nxv4i16_nxv4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl1re16.v v10, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vsext.vf2 v8, v10
; CHECK-NEXT:    ret
  %y = load <vscale x 4 x i16>, <vscale x 4 x i16>* %x
  %z = sext <vscale x 4 x i16> %y to <vscale x 4 x i32>
  ret <vscale x 4 x i32> %z
}

define <vscale x 4 x i32> @zextload_nxv4i16_nxv4i32(<vscale x 4 x i16>* %x) {
; CHECK-LABEL: zextload_nxv4i16_nxv4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl1re16.v v10, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v8, v10
; CHECK-NEXT:    ret
  %y = load <vscale x 4 x i16>, <vscale x 4 x i16>* %x
  %z = zext <vscale x 4 x i16> %y to <vscale x 4 x i32>
  ret <vscale x 4 x i32> %z
}

define <vscale x 4 x i64> @sextload_nxv4i16_nxv4i64(<vscale x 4 x i16>* %x) {
; CHECK-LABEL: sextload_nxv4i16_nxv4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl1re16.v v12, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vsext.vf4 v8, v12
; CHECK-NEXT:    ret
  %y = load <vscale x 4 x i16>, <vscale x 4 x i16>* %x
  %z = sext <vscale x 4 x i16> %y to <vscale x 4 x i64>
  ret <vscale x 4 x i64> %z
}

define <vscale x 4 x i64> @zextload_nxv4i16_nxv4i64(<vscale x 4 x i16>* %x) {
; CHECK-LABEL: zextload_nxv4i16_nxv4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl1re16.v v12, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vzext.vf4 v8, v12
; CHECK-NEXT:    ret
  %y = load <vscale x 4 x i16>, <vscale x 4 x i16>* %x
  %z = zext <vscale x 4 x i16> %y to <vscale x 4 x i64>
  ret <vscale x 4 x i64> %z
}

define void @truncstore_nxv8i16_nxv8i8(<vscale x 8 x i16> %x, <vscale x 8 x i8>* %z) {
; CHECK-LABEL: truncstore_nxv8i16_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, m1, ta, ma
; CHECK-NEXT:    vnsrl.wi v10, v8, 0
; CHECK-NEXT:    vs1r.v v10, (a0)
; CHECK-NEXT:    ret
  %y = trunc <vscale x 8 x i16> %x to <vscale x 8 x i8>
  store <vscale x 8 x i8> %y, <vscale x 8 x i8>* %z
  ret void
}

define <vscale x 8 x i32> @sextload_nxv8i16_nxv8i32(<vscale x 8 x i16>* %x) {
; CHECK-LABEL: sextload_nxv8i16_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl2re16.v v12, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vsext.vf2 v8, v12
; CHECK-NEXT:    ret
  %y = load <vscale x 8 x i16>, <vscale x 8 x i16>* %x
  %z = sext <vscale x 8 x i16> %y to <vscale x 8 x i32>
  ret <vscale x 8 x i32> %z
}

define <vscale x 8 x i32> @zextload_nxv8i16_nxv8i32(<vscale x 8 x i16>* %x) {
; CHECK-LABEL: zextload_nxv8i16_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl2re16.v v12, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vzext.vf2 v8, v12
; CHECK-NEXT:    ret
  %y = load <vscale x 8 x i16>, <vscale x 8 x i16>* %x
  %z = zext <vscale x 8 x i16> %y to <vscale x 8 x i32>
  ret <vscale x 8 x i32> %z
}

define <vscale x 8 x i64> @sextload_nxv8i16_nxv8i64(<vscale x 8 x i16>* %x) {
; CHECK-LABEL: sextload_nxv8i16_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl2re16.v v16, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vsext.vf4 v8, v16
; CHECK-NEXT:    ret
  %y = load <vscale x 8 x i16>, <vscale x 8 x i16>* %x
  %z = sext <vscale x 8 x i16> %y to <vscale x 8 x i64>
  ret <vscale x 8 x i64> %z
}

define <vscale x 8 x i64> @zextload_nxv8i16_nxv8i64(<vscale x 8 x i16>* %x) {
; CHECK-LABEL: zextload_nxv8i16_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl2re16.v v16, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vzext.vf4 v8, v16
; CHECK-NEXT:    ret
  %y = load <vscale x 8 x i16>, <vscale x 8 x i16>* %x
  %z = zext <vscale x 8 x i16> %y to <vscale x 8 x i64>
  ret <vscale x 8 x i64> %z
}

define void @truncstore_nxv16i16_nxv16i8(<vscale x 16 x i16> %x, <vscale x 16 x i8>* %z) {
; CHECK-LABEL: truncstore_nxv16i16_nxv16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, m2, ta, ma
; CHECK-NEXT:    vnsrl.wi v12, v8, 0
; CHECK-NEXT:    vs2r.v v12, (a0)
; CHECK-NEXT:    ret
  %y = trunc <vscale x 16 x i16> %x to <vscale x 16 x i8>
  store <vscale x 16 x i8> %y, <vscale x 16 x i8>* %z
  ret void
}

define <vscale x 16 x i32> @sextload_nxv16i16_nxv16i32(<vscale x 16 x i16>* %x) {
; CHECK-LABEL: sextload_nxv16i16_nxv16i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl4re16.v v16, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vsext.vf2 v8, v16
; CHECK-NEXT:    ret
  %y = load <vscale x 16 x i16>, <vscale x 16 x i16>* %x
  %z = sext <vscale x 16 x i16> %y to <vscale x 16 x i32>
  ret <vscale x 16 x i32> %z
}

define <vscale x 16 x i32> @zextload_nxv16i16_nxv16i32(<vscale x 16 x i16>* %x) {
; CHECK-LABEL: zextload_nxv16i16_nxv16i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl4re16.v v16, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e32, m8, ta, ma
; CHECK-NEXT:    vzext.vf2 v8, v16
; CHECK-NEXT:    ret
  %y = load <vscale x 16 x i16>, <vscale x 16 x i16>* %x
  %z = zext <vscale x 16 x i16> %y to <vscale x 16 x i32>
  ret <vscale x 16 x i32> %z
}

define void @truncstore_nxv32i16_nxv32i8(<vscale x 32 x i16> %x, <vscale x 32 x i8>* %z) {
; CHECK-LABEL: truncstore_nxv32i16_nxv32i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e8, m4, ta, ma
; CHECK-NEXT:    vnsrl.wi v16, v8, 0
; CHECK-NEXT:    vs4r.v v16, (a0)
; CHECK-NEXT:    ret
  %y = trunc <vscale x 32 x i16> %x to <vscale x 32 x i8>
  store <vscale x 32 x i8> %y, <vscale x 32 x i8>* %z
  ret void
}

define void @truncstore_nxv1i32_nxv1i8(<vscale x 1 x i32> %x, <vscale x 1 x i8>* %z) {
; CHECK-LABEL: truncstore_nxv1i32_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-NEXT:    vsetvli zero, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-NEXT:    vse8.v v8, (a0)
; CHECK-NEXT:    ret
  %y = trunc <vscale x 1 x i32> %x to <vscale x 1 x i8>
  store <vscale x 1 x i8> %y, <vscale x 1 x i8>* %z
  ret void
}

define void @truncstore_nxv1i32_nxv1i16(<vscale x 1 x i32> %x, <vscale x 1 x i16>* %z) {
; CHECK-LABEL: truncstore_nxv1i32_nxv1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %y = trunc <vscale x 1 x i32> %x to <vscale x 1 x i16>
  store <vscale x 1 x i16> %y, <vscale x 1 x i16>* %z
  ret void
}

define <vscale x 1 x i64> @sextload_nxv1i32_nxv1i64(<vscale x 1 x i32>* %x) {
; CHECK-LABEL: sextload_nxv1i32_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; CHECK-NEXT:    vle32.v v9, (a0)
; CHECK-NEXT:    vsext.vf2 v8, v9
; CHECK-NEXT:    ret
  %y = load <vscale x 1 x i32>, <vscale x 1 x i32>* %x
  %z = sext <vscale x 1 x i32> %y to <vscale x 1 x i64>
  ret <vscale x 1 x i64> %z
}

define <vscale x 1 x i64> @zextload_nxv1i32_nxv1i64(<vscale x 1 x i32>* %x) {
; CHECK-LABEL: zextload_nxv1i32_nxv1i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e64, m1, ta, ma
; CHECK-NEXT:    vle32.v v9, (a0)
; CHECK-NEXT:    vzext.vf2 v8, v9
; CHECK-NEXT:    ret
  %y = load <vscale x 1 x i32>, <vscale x 1 x i32>* %x
  %z = zext <vscale x 1 x i32> %y to <vscale x 1 x i64>
  ret <vscale x 1 x i64> %z
}

define void @truncstore_nxv2i32_nxv2i8(<vscale x 2 x i32> %x, <vscale x 2 x i8>* %z) {
; CHECK-LABEL: truncstore_nxv2i32_nxv2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-NEXT:    vsetvli zero, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-NEXT:    vse8.v v8, (a0)
; CHECK-NEXT:    ret
  %y = trunc <vscale x 2 x i32> %x to <vscale x 2 x i8>
  store <vscale x 2 x i8> %y, <vscale x 2 x i8>* %z
  ret void
}

define void @truncstore_nxv2i32_nxv2i16(<vscale x 2 x i32> %x, <vscale x 2 x i16>* %z) {
; CHECK-LABEL: truncstore_nxv2i32_nxv2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %y = trunc <vscale x 2 x i32> %x to <vscale x 2 x i16>
  store <vscale x 2 x i16> %y, <vscale x 2 x i16>* %z
  ret void
}

define <vscale x 2 x i64> @sextload_nxv2i32_nxv2i64(<vscale x 2 x i32>* %x) {
; CHECK-LABEL: sextload_nxv2i32_nxv2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl1re32.v v10, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vsext.vf2 v8, v10
; CHECK-NEXT:    ret
  %y = load <vscale x 2 x i32>, <vscale x 2 x i32>* %x
  %z = sext <vscale x 2 x i32> %y to <vscale x 2 x i64>
  ret <vscale x 2 x i64> %z
}

define <vscale x 2 x i64> @zextload_nxv2i32_nxv2i64(<vscale x 2 x i32>* %x) {
; CHECK-LABEL: zextload_nxv2i32_nxv2i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl1re32.v v10, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e64, m2, ta, ma
; CHECK-NEXT:    vzext.vf2 v8, v10
; CHECK-NEXT:    ret
  %y = load <vscale x 2 x i32>, <vscale x 2 x i32>* %x
  %z = zext <vscale x 2 x i32> %y to <vscale x 2 x i64>
  ret <vscale x 2 x i64> %z
}

define void @truncstore_nxv4i32_nxv4i8(<vscale x 4 x i32> %x, <vscale x 4 x i8>* %z) {
; CHECK-LABEL: truncstore_nxv4i32_nxv4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; CHECK-NEXT:    vnsrl.wi v10, v8, 0
; CHECK-NEXT:    vsetvli zero, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v10, 0
; CHECK-NEXT:    vse8.v v8, (a0)
; CHECK-NEXT:    ret
  %y = trunc <vscale x 4 x i32> %x to <vscale x 4 x i8>
  store <vscale x 4 x i8> %y, <vscale x 4 x i8>* %z
  ret void
}

define void @truncstore_nxv4i32_nxv4i16(<vscale x 4 x i32> %x, <vscale x 4 x i16>* %z) {
; CHECK-LABEL: truncstore_nxv4i32_nxv4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; CHECK-NEXT:    vnsrl.wi v10, v8, 0
; CHECK-NEXT:    vs1r.v v10, (a0)
; CHECK-NEXT:    ret
  %y = trunc <vscale x 4 x i32> %x to <vscale x 4 x i16>
  store <vscale x 4 x i16> %y, <vscale x 4 x i16>* %z
  ret void
}

define <vscale x 4 x i64> @sextload_nxv4i32_nxv4i64(<vscale x 4 x i32>* %x) {
; CHECK-LABEL: sextload_nxv4i32_nxv4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl2re32.v v12, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vsext.vf2 v8, v12
; CHECK-NEXT:    ret
  %y = load <vscale x 4 x i32>, <vscale x 4 x i32>* %x
  %z = sext <vscale x 4 x i32> %y to <vscale x 4 x i64>
  ret <vscale x 4 x i64> %z
}

define <vscale x 4 x i64> @zextload_nxv4i32_nxv4i64(<vscale x 4 x i32>* %x) {
; CHECK-LABEL: zextload_nxv4i32_nxv4i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl2re32.v v12, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e64, m4, ta, ma
; CHECK-NEXT:    vzext.vf2 v8, v12
; CHECK-NEXT:    ret
  %y = load <vscale x 4 x i32>, <vscale x 4 x i32>* %x
  %z = zext <vscale x 4 x i32> %y to <vscale x 4 x i64>
  ret <vscale x 4 x i64> %z
}

define void @truncstore_nxv8i32_nxv8i8(<vscale x 8 x i32> %x, <vscale x 8 x i8>* %z) {
; CHECK-LABEL: truncstore_nxv8i32_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; CHECK-NEXT:    vnsrl.wi v12, v8, 0
; CHECK-NEXT:    vsetvli zero, zero, e8, m1, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v12, 0
; CHECK-NEXT:    vs1r.v v8, (a0)
; CHECK-NEXT:    ret
  %y = trunc <vscale x 8 x i32> %x to <vscale x 8 x i8>
  store <vscale x 8 x i8> %y, <vscale x 8 x i8>* %z
  ret void
}

define void @truncstore_nxv8i32_nxv8i16(<vscale x 8 x i32> %x, <vscale x 8 x i16>* %z) {
; CHECK-LABEL: truncstore_nxv8i32_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; CHECK-NEXT:    vnsrl.wi v12, v8, 0
; CHECK-NEXT:    vs2r.v v12, (a0)
; CHECK-NEXT:    ret
  %y = trunc <vscale x 8 x i32> %x to <vscale x 8 x i16>
  store <vscale x 8 x i16> %y, <vscale x 8 x i16>* %z
  ret void
}

define <vscale x 8 x i64> @sextload_nxv8i32_nxv8i64(<vscale x 8 x i32>* %x) {
; CHECK-LABEL: sextload_nxv8i32_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl4re32.v v16, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vsext.vf2 v8, v16
; CHECK-NEXT:    ret
  %y = load <vscale x 8 x i32>, <vscale x 8 x i32>* %x
  %z = sext <vscale x 8 x i32> %y to <vscale x 8 x i64>
  ret <vscale x 8 x i64> %z
}

define <vscale x 8 x i64> @zextload_nxv8i32_nxv8i64(<vscale x 8 x i32>* %x) {
; CHECK-LABEL: zextload_nxv8i32_nxv8i64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl4re32.v v16, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e64, m8, ta, ma
; CHECK-NEXT:    vzext.vf2 v8, v16
; CHECK-NEXT:    ret
  %y = load <vscale x 8 x i32>, <vscale x 8 x i32>* %x
  %z = zext <vscale x 8 x i32> %y to <vscale x 8 x i64>
  ret <vscale x 8 x i64> %z
}

define void @truncstore_nxv16i32_nxv16i8(<vscale x 16 x i32> %x, <vscale x 16 x i8>* %z) {
; CHECK-LABEL: truncstore_nxv16i32_nxv16i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, m4, ta, ma
; CHECK-NEXT:    vnsrl.wi v16, v8, 0
; CHECK-NEXT:    vsetvli zero, zero, e8, m2, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v16, 0
; CHECK-NEXT:    vs2r.v v8, (a0)
; CHECK-NEXT:    ret
  %y = trunc <vscale x 16 x i32> %x to <vscale x 16 x i8>
  store <vscale x 16 x i8> %y, <vscale x 16 x i8>* %z
  ret void
}

define void @truncstore_nxv16i32_nxv16i16(<vscale x 16 x i32> %x, <vscale x 16 x i16>* %z) {
; CHECK-LABEL: truncstore_nxv16i32_nxv16i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, m4, ta, ma
; CHECK-NEXT:    vnsrl.wi v16, v8, 0
; CHECK-NEXT:    vs4r.v v16, (a0)
; CHECK-NEXT:    ret
  %y = trunc <vscale x 16 x i32> %x to <vscale x 16 x i16>
  store <vscale x 16 x i16> %y, <vscale x 16 x i16>* %z
  ret void
}

define void @truncstore_nxv1i64_nxv1i8(<vscale x 1 x i64> %x, <vscale x 1 x i8>* %z) {
; CHECK-LABEL: truncstore_nxv1i64_nxv1i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-NEXT:    vsetvli zero, zero, e8, mf8, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-NEXT:    vse8.v v8, (a0)
; CHECK-NEXT:    ret
  %y = trunc <vscale x 1 x i64> %x to <vscale x 1 x i8>
  store <vscale x 1 x i8> %y, <vscale x 1 x i8>* %z
  ret void
}

define void @truncstore_nxv1i64_nxv1i16(<vscale x 1 x i64> %x, <vscale x 1 x i16>* %z) {
; CHECK-LABEL: truncstore_nxv1i64_nxv1i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %y = trunc <vscale x 1 x i64> %x to <vscale x 1 x i16>
  store <vscale x 1 x i16> %y, <vscale x 1 x i16>* %z
  ret void
}

define void @truncstore_nxv1i64_nxv1i32(<vscale x 1 x i64> %x, <vscale x 1 x i32>* %z) {
; CHECK-LABEL: truncstore_nxv1i64_nxv1i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-NEXT:    vse32.v v8, (a0)
; CHECK-NEXT:    ret
  %y = trunc <vscale x 1 x i64> %x to <vscale x 1 x i32>
  store <vscale x 1 x i32> %y, <vscale x 1 x i32>* %z
  ret void
}

define void @truncstore_nxv2i64_nxv2i8(<vscale x 2 x i64> %x, <vscale x 2 x i8>* %z) {
; CHECK-LABEL: truncstore_nxv2i64_nxv2i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-NEXT:    vnsrl.wi v10, v8, 0
; CHECK-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v10, 0
; CHECK-NEXT:    vsetvli zero, zero, e8, mf4, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-NEXT:    vse8.v v8, (a0)
; CHECK-NEXT:    ret
  %y = trunc <vscale x 2 x i64> %x to <vscale x 2 x i8>
  store <vscale x 2 x i8> %y, <vscale x 2 x i8>* %z
  ret void
}

define void @truncstore_nxv2i64_nxv2i16(<vscale x 2 x i64> %x, <vscale x 2 x i16>* %z) {
; CHECK-LABEL: truncstore_nxv2i64_nxv2i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-NEXT:    vnsrl.wi v10, v8, 0
; CHECK-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v10, 0
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %y = trunc <vscale x 2 x i64> %x to <vscale x 2 x i16>
  store <vscale x 2 x i16> %y, <vscale x 2 x i16>* %z
  ret void
}

define void @truncstore_nxv2i64_nxv2i32(<vscale x 2 x i64> %x, <vscale x 2 x i32>* %z) {
; CHECK-LABEL: truncstore_nxv2i64_nxv2i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-NEXT:    vnsrl.wi v10, v8, 0
; CHECK-NEXT:    vs1r.v v10, (a0)
; CHECK-NEXT:    ret
  %y = trunc <vscale x 2 x i64> %x to <vscale x 2 x i32>
  store <vscale x 2 x i32> %y, <vscale x 2 x i32>* %z
  ret void
}

define void @truncstore_nxv4i64_nxv4i8(<vscale x 4 x i64> %x, <vscale x 4 x i8>* %z) {
; CHECK-LABEL: truncstore_nxv4i64_nxv4i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; CHECK-NEXT:    vnsrl.wi v12, v8, 0
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v12, 0
; CHECK-NEXT:    vsetvli zero, zero, e8, mf2, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v8, 0
; CHECK-NEXT:    vse8.v v8, (a0)
; CHECK-NEXT:    ret
  %y = trunc <vscale x 4 x i64> %x to <vscale x 4 x i8>
  store <vscale x 4 x i8> %y, <vscale x 4 x i8>* %z
  ret void
}

define void @truncstore_nxv4i64_nxv4i16(<vscale x 4 x i64> %x, <vscale x 4 x i16>* %z) {
; CHECK-LABEL: truncstore_nxv4i64_nxv4i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; CHECK-NEXT:    vnsrl.wi v12, v8, 0
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v12, 0
; CHECK-NEXT:    vs1r.v v8, (a0)
; CHECK-NEXT:    ret
  %y = trunc <vscale x 4 x i64> %x to <vscale x 4 x i16>
  store <vscale x 4 x i16> %y, <vscale x 4 x i16>* %z
  ret void
}

define void @truncstore_nxv4i64_nxv4i32(<vscale x 4 x i64> %x, <vscale x 4 x i32>* %z) {
; CHECK-LABEL: truncstore_nxv4i64_nxv4i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; CHECK-NEXT:    vnsrl.wi v12, v8, 0
; CHECK-NEXT:    vs2r.v v12, (a0)
; CHECK-NEXT:    ret
  %y = trunc <vscale x 4 x i64> %x to <vscale x 4 x i32>
  store <vscale x 4 x i32> %y, <vscale x 4 x i32>* %z
  ret void
}

define void @truncstore_nxv8i64_nxv8i8(<vscale x 8 x i64> %x, <vscale x 8 x i8>* %z) {
; CHECK-LABEL: truncstore_nxv8i64_nxv8i8:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; CHECK-NEXT:    vnsrl.wi v16, v8, 0
; CHECK-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v16, 0
; CHECK-NEXT:    vsetvli zero, zero, e8, m1, ta, ma
; CHECK-NEXT:    vnsrl.wi v10, v8, 0
; CHECK-NEXT:    vs1r.v v10, (a0)
; CHECK-NEXT:    ret
  %y = trunc <vscale x 8 x i64> %x to <vscale x 8 x i8>
  store <vscale x 8 x i8> %y, <vscale x 8 x i8>* %z
  ret void
}

define void @truncstore_nxv8i64_nxv8i16(<vscale x 8 x i64> %x, <vscale x 8 x i16>* %z) {
; CHECK-LABEL: truncstore_nxv8i64_nxv8i16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; CHECK-NEXT:    vnsrl.wi v16, v8, 0
; CHECK-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; CHECK-NEXT:    vnsrl.wi v8, v16, 0
; CHECK-NEXT:    vs2r.v v8, (a0)
; CHECK-NEXT:    ret
  %y = trunc <vscale x 8 x i64> %x to <vscale x 8 x i16>
  store <vscale x 8 x i16> %y, <vscale x 8 x i16>* %z
  ret void
}

define void @truncstore_nxv8i64_nxv8i32(<vscale x 8 x i64> %x, <vscale x 8 x i32>* %z) {
; CHECK-LABEL: truncstore_nxv8i64_nxv8i32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; CHECK-NEXT:    vnsrl.wi v16, v8, 0
; CHECK-NEXT:    vs4r.v v16, (a0)
; CHECK-NEXT:    ret
  %y = trunc <vscale x 8 x i64> %x to <vscale x 8 x i32>
  store <vscale x 8 x i32> %y, <vscale x 8 x i32>* %z
  ret void
}

define <vscale x 1 x float> @extload_nxv1f16_nxv1f32(<vscale x 1 x half>* %x) {
; CHECK-LABEL: extload_nxv1f16_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vle16.v v9, (a0)
; CHECK-NEXT:    vfwcvt.f.f.v v8, v9
; CHECK-NEXT:    ret
  %y = load <vscale x 1 x half>, <vscale x 1 x half>* %x
  %z = fpext <vscale x 1 x half> %y to <vscale x 1 x float>
  ret <vscale x 1 x float> %z
}

define <vscale x 1 x double> @extload_nxv1f16_nxv1f64(<vscale x 1 x half>* %x) {
; CHECK-LABEL: extload_nxv1f16_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfwcvt.f.f.v v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v8, v9
; CHECK-NEXT:    ret
  %y = load <vscale x 1 x half>, <vscale x 1 x half>* %x
  %z = fpext <vscale x 1 x half> %y to <vscale x 1 x double>
  ret <vscale x 1 x double> %z
}

define <vscale x 2 x float> @extload_nxv2f16_nxv2f32(<vscale x 2 x half>* %x) {
; CHECK-LABEL: extload_nxv2f16_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vle16.v v9, (a0)
; CHECK-NEXT:    vfwcvt.f.f.v v8, v9
; CHECK-NEXT:    ret
  %y = load <vscale x 2 x half>, <vscale x 2 x half>* %x
  %z = fpext <vscale x 2 x half> %y to <vscale x 2 x float>
  ret <vscale x 2 x float> %z
}

define <vscale x 2 x double> @extload_nxv2f16_nxv2f64(<vscale x 2 x half>* %x) {
; CHECK-LABEL: extload_nxv2f16_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vle16.v v8, (a0)
; CHECK-NEXT:    vfwcvt.f.f.v v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v8, v10
; CHECK-NEXT:    ret
  %y = load <vscale x 2 x half>, <vscale x 2 x half>* %x
  %z = fpext <vscale x 2 x half> %y to <vscale x 2 x double>
  ret <vscale x 2 x double> %z
}

define <vscale x 4 x float> @extload_nxv4f16_nxv4f32(<vscale x 4 x half>* %x) {
; CHECK-LABEL: extload_nxv4f16_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl1re16.v v10, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v8, v10
; CHECK-NEXT:    ret
  %y = load <vscale x 4 x half>, <vscale x 4 x half>* %x
  %z = fpext <vscale x 4 x half> %y to <vscale x 4 x float>
  ret <vscale x 4 x float> %z
}

define <vscale x 4 x double> @extload_nxv4f16_nxv4f64(<vscale x 4 x half>* %x) {
; CHECK-LABEL: extload_nxv4f16_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl1re16.v v8, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v8, v12
; CHECK-NEXT:    ret
  %y = load <vscale x 4 x half>, <vscale x 4 x half>* %x
  %z = fpext <vscale x 4 x half> %y to <vscale x 4 x double>
  ret <vscale x 4 x double> %z
}

define <vscale x 8 x float> @extload_nxv8f16_nxv8f32(<vscale x 8 x half>* %x) {
; CHECK-LABEL: extload_nxv8f16_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl2re16.v v12, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v8, v12
; CHECK-NEXT:    ret
  %y = load <vscale x 8 x half>, <vscale x 8 x half>* %x
  %z = fpext <vscale x 8 x half> %y to <vscale x 8 x float>
  ret <vscale x 8 x float> %z
}

define <vscale x 8 x double> @extload_nxv8f16_nxv8f64(<vscale x 8 x half>* %x) {
; CHECK-LABEL: extload_nxv8f16_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl2re16.v v8, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v16, v8
; CHECK-NEXT:    vsetvli zero, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v8, v16
; CHECK-NEXT:    ret
  %y = load <vscale x 8 x half>, <vscale x 8 x half>* %x
  %z = fpext <vscale x 8 x half> %y to <vscale x 8 x double>
  ret <vscale x 8 x double> %z
}

define <vscale x 16 x float> @extload_nxv16f16_nxv16f32(<vscale x 16 x half>* %x) {
; CHECK-LABEL: extload_nxv16f16_nxv16f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl4re16.v v16, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e16, m4, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v8, v16
; CHECK-NEXT:    ret
  %y = load <vscale x 16 x half>, <vscale x 16 x half>* %x
  %z = fpext <vscale x 16 x half> %y to <vscale x 16 x float>
  ret <vscale x 16 x float> %z
}

define void @truncstore_nxv1f32_nxv1f16(<vscale x 1 x float> %x, <vscale x 1 x half>* %z) {
; CHECK-LABEL: truncstore_nxv1f32_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfncvt.f.f.w v9, v8
; CHECK-NEXT:    vse16.v v9, (a0)
; CHECK-NEXT:    ret
  %y = fptrunc <vscale x 1 x float> %x to <vscale x 1 x half>
  store <vscale x 1 x half> %y, <vscale x 1 x half>* %z
  ret void
}

define <vscale x 1 x double> @extload_nxv1f32_nxv1f64(<vscale x 1 x float>* %x) {
; CHECK-LABEL: extload_nxv1f32_nxv1f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vle32.v v9, (a0)
; CHECK-NEXT:    vfwcvt.f.f.v v8, v9
; CHECK-NEXT:    ret
  %y = load <vscale x 1 x float>, <vscale x 1 x float>* %x
  %z = fpext <vscale x 1 x float> %y to <vscale x 1 x double>
  ret <vscale x 1 x double> %z
}

define void @truncstore_nxv2f32_nxv2f16(<vscale x 2 x float> %x, <vscale x 2 x half>* %z) {
; CHECK-LABEL: truncstore_nxv2f32_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vfncvt.f.f.w v9, v8
; CHECK-NEXT:    vse16.v v9, (a0)
; CHECK-NEXT:    ret
  %y = fptrunc <vscale x 2 x float> %x to <vscale x 2 x half>
  store <vscale x 2 x half> %y, <vscale x 2 x half>* %z
  ret void
}

define <vscale x 2 x double> @extload_nxv2f32_nxv2f64(<vscale x 2 x float>* %x) {
; CHECK-LABEL: extload_nxv2f32_nxv2f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl1re32.v v10, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v8, v10
; CHECK-NEXT:    ret
  %y = load <vscale x 2 x float>, <vscale x 2 x float>* %x
  %z = fpext <vscale x 2 x float> %y to <vscale x 2 x double>
  ret <vscale x 2 x double> %z
}

define void @truncstore_nxv4f32_nxv4f16(<vscale x 4 x float> %x, <vscale x 4 x half>* %z) {
; CHECK-LABEL: truncstore_nxv4f32_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvt.f.f.w v10, v8
; CHECK-NEXT:    vs1r.v v10, (a0)
; CHECK-NEXT:    ret
  %y = fptrunc <vscale x 4 x float> %x to <vscale x 4 x half>
  store <vscale x 4 x half> %y, <vscale x 4 x half>* %z
  ret void
}

define <vscale x 4 x double> @extload_nxv4f32_nxv4f64(<vscale x 4 x float>* %x) {
; CHECK-LABEL: extload_nxv4f32_nxv4f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl2re32.v v12, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v8, v12
; CHECK-NEXT:    ret
  %y = load <vscale x 4 x float>, <vscale x 4 x float>* %x
  %z = fpext <vscale x 4 x float> %y to <vscale x 4 x double>
  ret <vscale x 4 x double> %z
}

define void @truncstore_nxv8f32_nxv8f16(<vscale x 8 x float> %x, <vscale x 8 x half>* %z) {
; CHECK-LABEL: truncstore_nxv8f32_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfncvt.f.f.w v12, v8
; CHECK-NEXT:    vs2r.v v12, (a0)
; CHECK-NEXT:    ret
  %y = fptrunc <vscale x 8 x float> %x to <vscale x 8 x half>
  store <vscale x 8 x half> %y, <vscale x 8 x half>* %z
  ret void
}

define <vscale x 8 x double> @extload_nxv8f32_nxv8f64(<vscale x 8 x float>* %x) {
; CHECK-LABEL: extload_nxv8f32_nxv8f64:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vl4re32.v v16, (a0)
; CHECK-NEXT:    vsetvli a0, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfwcvt.f.f.v v8, v16
; CHECK-NEXT:    ret
  %y = load <vscale x 8 x float>, <vscale x 8 x float>* %x
  %z = fpext <vscale x 8 x float> %y to <vscale x 8 x double>
  ret <vscale x 8 x double> %z
}

define void @truncstore_nxv16f32_nxv16f16(<vscale x 16 x float> %x, <vscale x 16 x half>* %z) {
; CHECK-LABEL: truncstore_nxv16f32_nxv16f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e16, m4, ta, ma
; CHECK-NEXT:    vfncvt.f.f.w v16, v8
; CHECK-NEXT:    vs4r.v v16, (a0)
; CHECK-NEXT:    ret
  %y = fptrunc <vscale x 16 x float> %x to <vscale x 16 x half>
  store <vscale x 16 x half> %y, <vscale x 16 x half>* %z
  ret void
}

define void @truncstore_nxv1f64_nxv1f16(<vscale x 1 x double> %x, <vscale x 1 x half>* %z) {
; CHECK-LABEL: truncstore_nxv1f64_nxv1f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfncvt.rod.f.f.w v9, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, mf4, ta, ma
; CHECK-NEXT:    vfncvt.f.f.w v8, v9
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %y = fptrunc <vscale x 1 x double> %x to <vscale x 1 x half>
  store <vscale x 1 x half> %y, <vscale x 1 x half>* %z
  ret void
}

define void @truncstore_nxv1f64_nxv1f32(<vscale x 1 x double> %x, <vscale x 1 x float>* %z) {
; CHECK-LABEL: truncstore_nxv1f64_nxv1f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, mf2, ta, ma
; CHECK-NEXT:    vfncvt.f.f.w v9, v8
; CHECK-NEXT:    vse32.v v9, (a0)
; CHECK-NEXT:    ret
  %y = fptrunc <vscale x 1 x double> %x to <vscale x 1 x float>
  store <vscale x 1 x float> %y, <vscale x 1 x float>* %z
  ret void
}

define void @truncstore_nxv2f64_nxv2f16(<vscale x 2 x double> %x, <vscale x 2 x half>* %z) {
; CHECK-LABEL: truncstore_nxv2f64_nxv2f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfncvt.rod.f.f.w v10, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, mf2, ta, ma
; CHECK-NEXT:    vfncvt.f.f.w v8, v10
; CHECK-NEXT:    vse16.v v8, (a0)
; CHECK-NEXT:    ret
  %y = fptrunc <vscale x 2 x double> %x to <vscale x 2 x half>
  store <vscale x 2 x half> %y, <vscale x 2 x half>* %z
  ret void
}

define void @truncstore_nxv2f64_nxv2f32(<vscale x 2 x double> %x, <vscale x 2 x float>* %z) {
; CHECK-LABEL: truncstore_nxv2f64_nxv2f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m1, ta, ma
; CHECK-NEXT:    vfncvt.f.f.w v10, v8
; CHECK-NEXT:    vs1r.v v10, (a0)
; CHECK-NEXT:    ret
  %y = fptrunc <vscale x 2 x double> %x to <vscale x 2 x float>
  store <vscale x 2 x float> %y, <vscale x 2 x float>* %z
  ret void
}

define void @truncstore_nxv4f64_nxv4f16(<vscale x 4 x double> %x, <vscale x 4 x half>* %z) {
; CHECK-LABEL: truncstore_nxv4f64_nxv4f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfncvt.rod.f.f.w v12, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m1, ta, ma
; CHECK-NEXT:    vfncvt.f.f.w v8, v12
; CHECK-NEXT:    vs1r.v v8, (a0)
; CHECK-NEXT:    ret
  %y = fptrunc <vscale x 4 x double> %x to <vscale x 4 x half>
  store <vscale x 4 x half> %y, <vscale x 4 x half>* %z
  ret void
}

define void @truncstore_nxv4f64_nxv4f32(<vscale x 4 x double> %x, <vscale x 4 x float>* %z) {
; CHECK-LABEL: truncstore_nxv4f64_nxv4f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m2, ta, ma
; CHECK-NEXT:    vfncvt.f.f.w v12, v8
; CHECK-NEXT:    vs2r.v v12, (a0)
; CHECK-NEXT:    ret
  %y = fptrunc <vscale x 4 x double> %x to <vscale x 4 x float>
  store <vscale x 4 x float> %y, <vscale x 4 x float>* %z
  ret void
}

define void @truncstore_nxv8f64_nxv8f16(<vscale x 8 x double> %x, <vscale x 8 x half>* %z) {
; CHECK-LABEL: truncstore_nxv8f64_nxv8f16:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfncvt.rod.f.f.w v16, v8
; CHECK-NEXT:    vsetvli zero, zero, e16, m2, ta, ma
; CHECK-NEXT:    vfncvt.f.f.w v8, v16
; CHECK-NEXT:    vs2r.v v8, (a0)
; CHECK-NEXT:    ret
  %y = fptrunc <vscale x 8 x double> %x to <vscale x 8 x half>
  store <vscale x 8 x half> %y, <vscale x 8 x half>* %z
  ret void
}

define void @truncstore_nxv8f64_nxv8f32(<vscale x 8 x double> %x, <vscale x 8 x float>* %z) {
; CHECK-LABEL: truncstore_nxv8f64_nxv8f32:
; CHECK:       # %bb.0:
; CHECK-NEXT:    vsetvli a1, zero, e32, m4, ta, ma
; CHECK-NEXT:    vfncvt.f.f.w v16, v8
; CHECK-NEXT:    vs4r.v v16, (a0)
; CHECK-NEXT:    ret
  %y = fptrunc <vscale x 8 x double> %x to <vscale x 8 x float>
  store <vscale x 8 x float> %y, <vscale x 8 x float>* %z
  ret void
}
