// Code generated by smithy-go-codegen DO NOT EDIT.

package networkfirewall

import (
	"bytes"
	"context"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/service/networkfirewall/types"
	smithy "github.com/aws/smithy-go"
	"github.com/aws/smithy-go/encoding/httpbinding"
	smithyjson "github.com/aws/smithy-go/encoding/json"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"path"
)

type awsAwsjson10_serializeOpAssociateFirewallPolicy struct {
}

func (*awsAwsjson10_serializeOpAssociateFirewallPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpAssociateFirewallPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AssociateFirewallPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("NetworkFirewall_20201112.AssociateFirewallPolicy")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentAssociateFirewallPolicyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpAssociateSubnets struct {
}

func (*awsAwsjson10_serializeOpAssociateSubnets) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpAssociateSubnets) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*AssociateSubnetsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("NetworkFirewall_20201112.AssociateSubnets")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentAssociateSubnetsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpCreateFirewall struct {
}

func (*awsAwsjson10_serializeOpCreateFirewall) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpCreateFirewall) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateFirewallInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("NetworkFirewall_20201112.CreateFirewall")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentCreateFirewallInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpCreateFirewallPolicy struct {
}

func (*awsAwsjson10_serializeOpCreateFirewallPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpCreateFirewallPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateFirewallPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("NetworkFirewall_20201112.CreateFirewallPolicy")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentCreateFirewallPolicyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpCreateRuleGroup struct {
}

func (*awsAwsjson10_serializeOpCreateRuleGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpCreateRuleGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateRuleGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("NetworkFirewall_20201112.CreateRuleGroup")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentCreateRuleGroupInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpCreateTLSInspectionConfiguration struct {
}

func (*awsAwsjson10_serializeOpCreateTLSInspectionConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpCreateTLSInspectionConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*CreateTLSInspectionConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("NetworkFirewall_20201112.CreateTLSInspectionConfiguration")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentCreateTLSInspectionConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpDeleteFirewall struct {
}

func (*awsAwsjson10_serializeOpDeleteFirewall) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpDeleteFirewall) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteFirewallInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("NetworkFirewall_20201112.DeleteFirewall")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentDeleteFirewallInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpDeleteFirewallPolicy struct {
}

func (*awsAwsjson10_serializeOpDeleteFirewallPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpDeleteFirewallPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteFirewallPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("NetworkFirewall_20201112.DeleteFirewallPolicy")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentDeleteFirewallPolicyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpDeleteResourcePolicy struct {
}

func (*awsAwsjson10_serializeOpDeleteResourcePolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpDeleteResourcePolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteResourcePolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("NetworkFirewall_20201112.DeleteResourcePolicy")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentDeleteResourcePolicyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpDeleteRuleGroup struct {
}

func (*awsAwsjson10_serializeOpDeleteRuleGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpDeleteRuleGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteRuleGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("NetworkFirewall_20201112.DeleteRuleGroup")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentDeleteRuleGroupInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpDeleteTLSInspectionConfiguration struct {
}

func (*awsAwsjson10_serializeOpDeleteTLSInspectionConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpDeleteTLSInspectionConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DeleteTLSInspectionConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("NetworkFirewall_20201112.DeleteTLSInspectionConfiguration")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentDeleteTLSInspectionConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpDescribeFirewall struct {
}

func (*awsAwsjson10_serializeOpDescribeFirewall) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpDescribeFirewall) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeFirewallInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("NetworkFirewall_20201112.DescribeFirewall")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentDescribeFirewallInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpDescribeFirewallPolicy struct {
}

func (*awsAwsjson10_serializeOpDescribeFirewallPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpDescribeFirewallPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeFirewallPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("NetworkFirewall_20201112.DescribeFirewallPolicy")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentDescribeFirewallPolicyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpDescribeLoggingConfiguration struct {
}

func (*awsAwsjson10_serializeOpDescribeLoggingConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpDescribeLoggingConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeLoggingConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("NetworkFirewall_20201112.DescribeLoggingConfiguration")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentDescribeLoggingConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpDescribeResourcePolicy struct {
}

func (*awsAwsjson10_serializeOpDescribeResourcePolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpDescribeResourcePolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeResourcePolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("NetworkFirewall_20201112.DescribeResourcePolicy")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentDescribeResourcePolicyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpDescribeRuleGroup struct {
}

func (*awsAwsjson10_serializeOpDescribeRuleGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpDescribeRuleGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeRuleGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("NetworkFirewall_20201112.DescribeRuleGroup")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentDescribeRuleGroupInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpDescribeRuleGroupMetadata struct {
}

func (*awsAwsjson10_serializeOpDescribeRuleGroupMetadata) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpDescribeRuleGroupMetadata) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeRuleGroupMetadataInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("NetworkFirewall_20201112.DescribeRuleGroupMetadata")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentDescribeRuleGroupMetadataInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpDescribeTLSInspectionConfiguration struct {
}

func (*awsAwsjson10_serializeOpDescribeTLSInspectionConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpDescribeTLSInspectionConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DescribeTLSInspectionConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("NetworkFirewall_20201112.DescribeTLSInspectionConfiguration")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentDescribeTLSInspectionConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpDisassociateSubnets struct {
}

func (*awsAwsjson10_serializeOpDisassociateSubnets) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpDisassociateSubnets) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*DisassociateSubnetsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("NetworkFirewall_20201112.DisassociateSubnets")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentDisassociateSubnetsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpListFirewallPolicies struct {
}

func (*awsAwsjson10_serializeOpListFirewallPolicies) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpListFirewallPolicies) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListFirewallPoliciesInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("NetworkFirewall_20201112.ListFirewallPolicies")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentListFirewallPoliciesInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpListFirewalls struct {
}

func (*awsAwsjson10_serializeOpListFirewalls) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpListFirewalls) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListFirewallsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("NetworkFirewall_20201112.ListFirewalls")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentListFirewallsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpListRuleGroups struct {
}

func (*awsAwsjson10_serializeOpListRuleGroups) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpListRuleGroups) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListRuleGroupsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("NetworkFirewall_20201112.ListRuleGroups")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentListRuleGroupsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpListTagsForResource struct {
}

func (*awsAwsjson10_serializeOpListTagsForResource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpListTagsForResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTagsForResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("NetworkFirewall_20201112.ListTagsForResource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentListTagsForResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpListTLSInspectionConfigurations struct {
}

func (*awsAwsjson10_serializeOpListTLSInspectionConfigurations) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpListTLSInspectionConfigurations) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*ListTLSInspectionConfigurationsInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("NetworkFirewall_20201112.ListTLSInspectionConfigurations")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentListTLSInspectionConfigurationsInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpPutResourcePolicy struct {
}

func (*awsAwsjson10_serializeOpPutResourcePolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpPutResourcePolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*PutResourcePolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("NetworkFirewall_20201112.PutResourcePolicy")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentPutResourcePolicyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpTagResource struct {
}

func (*awsAwsjson10_serializeOpTagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpTagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*TagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("NetworkFirewall_20201112.TagResource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentTagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpUntagResource struct {
}

func (*awsAwsjson10_serializeOpUntagResource) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpUntagResource) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UntagResourceInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("NetworkFirewall_20201112.UntagResource")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentUntagResourceInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpUpdateFirewallDeleteProtection struct {
}

func (*awsAwsjson10_serializeOpUpdateFirewallDeleteProtection) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpUpdateFirewallDeleteProtection) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateFirewallDeleteProtectionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("NetworkFirewall_20201112.UpdateFirewallDeleteProtection")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentUpdateFirewallDeleteProtectionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpUpdateFirewallDescription struct {
}

func (*awsAwsjson10_serializeOpUpdateFirewallDescription) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpUpdateFirewallDescription) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateFirewallDescriptionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("NetworkFirewall_20201112.UpdateFirewallDescription")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentUpdateFirewallDescriptionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpUpdateFirewallEncryptionConfiguration struct {
}

func (*awsAwsjson10_serializeOpUpdateFirewallEncryptionConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpUpdateFirewallEncryptionConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateFirewallEncryptionConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("NetworkFirewall_20201112.UpdateFirewallEncryptionConfiguration")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentUpdateFirewallEncryptionConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpUpdateFirewallPolicy struct {
}

func (*awsAwsjson10_serializeOpUpdateFirewallPolicy) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpUpdateFirewallPolicy) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateFirewallPolicyInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("NetworkFirewall_20201112.UpdateFirewallPolicy")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentUpdateFirewallPolicyInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpUpdateFirewallPolicyChangeProtection struct {
}

func (*awsAwsjson10_serializeOpUpdateFirewallPolicyChangeProtection) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpUpdateFirewallPolicyChangeProtection) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateFirewallPolicyChangeProtectionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("NetworkFirewall_20201112.UpdateFirewallPolicyChangeProtection")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentUpdateFirewallPolicyChangeProtectionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpUpdateLoggingConfiguration struct {
}

func (*awsAwsjson10_serializeOpUpdateLoggingConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpUpdateLoggingConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateLoggingConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("NetworkFirewall_20201112.UpdateLoggingConfiguration")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentUpdateLoggingConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpUpdateRuleGroup struct {
}

func (*awsAwsjson10_serializeOpUpdateRuleGroup) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpUpdateRuleGroup) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateRuleGroupInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("NetworkFirewall_20201112.UpdateRuleGroup")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentUpdateRuleGroupInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpUpdateSubnetChangeProtection struct {
}

func (*awsAwsjson10_serializeOpUpdateSubnetChangeProtection) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpUpdateSubnetChangeProtection) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateSubnetChangeProtectionInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("NetworkFirewall_20201112.UpdateSubnetChangeProtection")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentUpdateSubnetChangeProtectionInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}

type awsAwsjson10_serializeOpUpdateTLSInspectionConfiguration struct {
}

func (*awsAwsjson10_serializeOpUpdateTLSInspectionConfiguration) ID() string {
	return "OperationSerializer"
}

func (m *awsAwsjson10_serializeOpUpdateTLSInspectionConfiguration) HandleSerialize(ctx context.Context, in middleware.SerializeInput, next middleware.SerializeHandler) (
	out middleware.SerializeOutput, metadata middleware.Metadata, err error,
) {
	request, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown transport type %T", in.Request)}
	}

	input, ok := in.Parameters.(*UpdateTLSInspectionConfigurationInput)
	_ = input
	if !ok {
		return out, metadata, &smithy.SerializationError{Err: fmt.Errorf("unknown input parameters type %T", in.Parameters)}
	}

	operationPath := "/"
	if len(request.Request.URL.Path) == 0 {
		request.Request.URL.Path = operationPath
	} else {
		request.Request.URL.Path = path.Join(request.Request.URL.Path, operationPath)
		if request.Request.URL.Path != "/" && operationPath[len(operationPath)-1] == '/' {
			request.Request.URL.Path += "/"
		}
	}
	request.Request.Method = "POST"
	httpBindingEncoder, err := httpbinding.NewEncoder(request.URL.Path, request.URL.RawQuery, request.Header)
	if err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	httpBindingEncoder.SetHeader("Content-Type").String("application/x-amz-json-1.0")
	httpBindingEncoder.SetHeader("X-Amz-Target").String("NetworkFirewall_20201112.UpdateTLSInspectionConfiguration")

	jsonEncoder := smithyjson.NewEncoder()
	if err := awsAwsjson10_serializeOpDocumentUpdateTLSInspectionConfigurationInput(input, jsonEncoder.Value); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request, err = request.SetStream(bytes.NewReader(jsonEncoder.Bytes())); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}

	if request.Request, err = httpBindingEncoder.Encode(request.Request); err != nil {
		return out, metadata, &smithy.SerializationError{Err: err}
	}
	in.Request = request

	return next.HandleSerialize(ctx, in)
}
func awsAwsjson10_serializeDocumentActionDefinition(v *types.ActionDefinition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PublishMetricAction != nil {
		ok := object.Key("PublishMetricAction")
		if err := awsAwsjson10_serializeDocumentPublishMetricAction(v.PublishMetricAction, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeDocumentAddress(v *types.Address, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AddressDefinition != nil {
		ok := object.Key("AddressDefinition")
		ok.String(*v.AddressDefinition)
	}

	return nil
}

func awsAwsjson10_serializeDocumentAddresses(v []types.Address, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson10_serializeDocumentAddress(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson10_serializeDocumentAzSubnets(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson10_serializeDocumentCheckCertificateRevocationStatusActions(v *types.CheckCertificateRevocationStatusActions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.RevokedStatusAction) > 0 {
		ok := object.Key("RevokedStatusAction")
		ok.String(string(v.RevokedStatusAction))
	}

	if len(v.UnknownStatusAction) > 0 {
		ok := object.Key("UnknownStatusAction")
		ok.String(string(v.UnknownStatusAction))
	}

	return nil
}

func awsAwsjson10_serializeDocumentCustomAction(v *types.CustomAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ActionDefinition != nil {
		ok := object.Key("ActionDefinition")
		if err := awsAwsjson10_serializeDocumentActionDefinition(v.ActionDefinition, ok); err != nil {
			return err
		}
	}

	if v.ActionName != nil {
		ok := object.Key("ActionName")
		ok.String(*v.ActionName)
	}

	return nil
}

func awsAwsjson10_serializeDocumentCustomActions(v []types.CustomAction, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson10_serializeDocumentCustomAction(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson10_serializeDocumentDimension(v *types.Dimension, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsAwsjson10_serializeDocumentDimensions(v []types.Dimension, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson10_serializeDocumentDimension(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson10_serializeDocumentEncryptionConfiguration(v *types.EncryptionConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.KeyId != nil {
		ok := object.Key("KeyId")
		ok.String(*v.KeyId)
	}

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsAwsjson10_serializeDocumentFirewallPolicy(v *types.FirewallPolicy, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.PolicyVariables != nil {
		ok := object.Key("PolicyVariables")
		if err := awsAwsjson10_serializeDocumentPolicyVariables(v.PolicyVariables, ok); err != nil {
			return err
		}
	}

	if v.StatefulDefaultActions != nil {
		ok := object.Key("StatefulDefaultActions")
		if err := awsAwsjson10_serializeDocumentStatefulActions(v.StatefulDefaultActions, ok); err != nil {
			return err
		}
	}

	if v.StatefulEngineOptions != nil {
		ok := object.Key("StatefulEngineOptions")
		if err := awsAwsjson10_serializeDocumentStatefulEngineOptions(v.StatefulEngineOptions, ok); err != nil {
			return err
		}
	}

	if v.StatefulRuleGroupReferences != nil {
		ok := object.Key("StatefulRuleGroupReferences")
		if err := awsAwsjson10_serializeDocumentStatefulRuleGroupReferences(v.StatefulRuleGroupReferences, ok); err != nil {
			return err
		}
	}

	if v.StatelessCustomActions != nil {
		ok := object.Key("StatelessCustomActions")
		if err := awsAwsjson10_serializeDocumentCustomActions(v.StatelessCustomActions, ok); err != nil {
			return err
		}
	}

	if v.StatelessDefaultActions != nil {
		ok := object.Key("StatelessDefaultActions")
		if err := awsAwsjson10_serializeDocumentStatelessActions(v.StatelessDefaultActions, ok); err != nil {
			return err
		}
	}

	if v.StatelessFragmentDefaultActions != nil {
		ok := object.Key("StatelessFragmentDefaultActions")
		if err := awsAwsjson10_serializeDocumentStatelessActions(v.StatelessFragmentDefaultActions, ok); err != nil {
			return err
		}
	}

	if v.StatelessRuleGroupReferences != nil {
		ok := object.Key("StatelessRuleGroupReferences")
		if err := awsAwsjson10_serializeDocumentStatelessRuleGroupReferences(v.StatelessRuleGroupReferences, ok); err != nil {
			return err
		}
	}

	if v.TLSInspectionConfigurationArn != nil {
		ok := object.Key("TLSInspectionConfigurationArn")
		ok.String(*v.TLSInspectionConfigurationArn)
	}

	return nil
}

func awsAwsjson10_serializeDocumentFlags(v []types.TCPFlag, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsjson10_serializeDocumentHeader(v *types.Header, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Destination != nil {
		ok := object.Key("Destination")
		ok.String(*v.Destination)
	}

	if v.DestinationPort != nil {
		ok := object.Key("DestinationPort")
		ok.String(*v.DestinationPort)
	}

	if len(v.Direction) > 0 {
		ok := object.Key("Direction")
		ok.String(string(v.Direction))
	}

	if len(v.Protocol) > 0 {
		ok := object.Key("Protocol")
		ok.String(string(v.Protocol))
	}

	if v.Source != nil {
		ok := object.Key("Source")
		ok.String(*v.Source)
	}

	if v.SourcePort != nil {
		ok := object.Key("SourcePort")
		ok.String(*v.SourcePort)
	}

	return nil
}

func awsAwsjson10_serializeDocumentIPSet(v *types.IPSet, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Definition != nil {
		ok := object.Key("Definition")
		if err := awsAwsjson10_serializeDocumentVariableDefinitionList(v.Definition, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeDocumentIPSetReference(v *types.IPSetReference, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ReferenceArn != nil {
		ok := object.Key("ReferenceArn")
		ok.String(*v.ReferenceArn)
	}

	return nil
}

func awsAwsjson10_serializeDocumentIPSetReferenceMap(v map[string]types.IPSetReference, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsAwsjson10_serializeDocumentIPSetReference(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson10_serializeDocumentIPSets(v map[string]types.IPSet, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsAwsjson10_serializeDocumentIPSet(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson10_serializeDocumentLogDestinationConfig(v *types.LogDestinationConfig, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LogDestination != nil {
		ok := object.Key("LogDestination")
		if err := awsAwsjson10_serializeDocumentLogDestinationMap(v.LogDestination, ok); err != nil {
			return err
		}
	}

	if len(v.LogDestinationType) > 0 {
		ok := object.Key("LogDestinationType")
		ok.String(string(v.LogDestinationType))
	}

	if len(v.LogType) > 0 {
		ok := object.Key("LogType")
		ok.String(string(v.LogType))
	}

	return nil
}

func awsAwsjson10_serializeDocumentLogDestinationConfigs(v []types.LogDestinationConfig, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson10_serializeDocumentLogDestinationConfig(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson10_serializeDocumentLogDestinationMap(v map[string]string, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		om.String(v[key])
	}
	return nil
}

func awsAwsjson10_serializeDocumentLoggingConfiguration(v *types.LoggingConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.LogDestinationConfigs != nil {
		ok := object.Key("LogDestinationConfigs")
		if err := awsAwsjson10_serializeDocumentLogDestinationConfigs(v.LogDestinationConfigs, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeDocumentMatchAttributes(v *types.MatchAttributes, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DestinationPorts != nil {
		ok := object.Key("DestinationPorts")
		if err := awsAwsjson10_serializeDocumentPortRanges(v.DestinationPorts, ok); err != nil {
			return err
		}
	}

	if v.Destinations != nil {
		ok := object.Key("Destinations")
		if err := awsAwsjson10_serializeDocumentAddresses(v.Destinations, ok); err != nil {
			return err
		}
	}

	if v.Protocols != nil {
		ok := object.Key("Protocols")
		if err := awsAwsjson10_serializeDocumentProtocolNumbers(v.Protocols, ok); err != nil {
			return err
		}
	}

	if v.SourcePorts != nil {
		ok := object.Key("SourcePorts")
		if err := awsAwsjson10_serializeDocumentPortRanges(v.SourcePorts, ok); err != nil {
			return err
		}
	}

	if v.Sources != nil {
		ok := object.Key("Sources")
		if err := awsAwsjson10_serializeDocumentAddresses(v.Sources, ok); err != nil {
			return err
		}
	}

	if v.TCPFlags != nil {
		ok := object.Key("TCPFlags")
		if err := awsAwsjson10_serializeDocumentTCPFlags(v.TCPFlags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeDocumentPolicyVariables(v *types.PolicyVariables, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RuleVariables != nil {
		ok := object.Key("RuleVariables")
		if err := awsAwsjson10_serializeDocumentIPSets(v.RuleVariables, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeDocumentPortRange(v *types.PortRange, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("FromPort")
		ok.Integer(v.FromPort)
	}

	{
		ok := object.Key("ToPort")
		ok.Integer(v.ToPort)
	}

	return nil
}

func awsAwsjson10_serializeDocumentPortRanges(v []types.PortRange, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson10_serializeDocumentPortRange(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson10_serializeDocumentPortSet(v *types.PortSet, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Definition != nil {
		ok := object.Key("Definition")
		if err := awsAwsjson10_serializeDocumentVariableDefinitionList(v.Definition, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeDocumentPortSets(v map[string]types.PortSet, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	for key := range v {
		om := object.Key(key)
		mapVar := v[key]
		if err := awsAwsjson10_serializeDocumentPortSet(&mapVar, om); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson10_serializeDocumentProtocolNumbers(v []int32, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.Integer(v[i])
	}
	return nil
}

func awsAwsjson10_serializeDocumentPublishMetricAction(v *types.PublishMetricAction, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Dimensions != nil {
		ok := object.Key("Dimensions")
		if err := awsAwsjson10_serializeDocumentDimensions(v.Dimensions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeDocumentReferenceSets(v *types.ReferenceSets, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IPSetReferences != nil {
		ok := object.Key("IPSetReferences")
		if err := awsAwsjson10_serializeDocumentIPSetReferenceMap(v.IPSetReferences, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeDocumentRuleDefinition(v *types.RuleDefinition, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Actions != nil {
		ok := object.Key("Actions")
		if err := awsAwsjson10_serializeDocumentStatelessActions(v.Actions, ok); err != nil {
			return err
		}
	}

	if v.MatchAttributes != nil {
		ok := object.Key("MatchAttributes")
		if err := awsAwsjson10_serializeDocumentMatchAttributes(v.MatchAttributes, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeDocumentRuleGroup(v *types.RuleGroup, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ReferenceSets != nil {
		ok := object.Key("ReferenceSets")
		if err := awsAwsjson10_serializeDocumentReferenceSets(v.ReferenceSets, ok); err != nil {
			return err
		}
	}

	if v.RulesSource != nil {
		ok := object.Key("RulesSource")
		if err := awsAwsjson10_serializeDocumentRulesSource(v.RulesSource, ok); err != nil {
			return err
		}
	}

	if v.RuleVariables != nil {
		ok := object.Key("RuleVariables")
		if err := awsAwsjson10_serializeDocumentRuleVariables(v.RuleVariables, ok); err != nil {
			return err
		}
	}

	if v.StatefulRuleOptions != nil {
		ok := object.Key("StatefulRuleOptions")
		if err := awsAwsjson10_serializeDocumentStatefulRuleOptions(v.StatefulRuleOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeDocumentRuleOption(v *types.RuleOption, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Keyword != nil {
		ok := object.Key("Keyword")
		ok.String(*v.Keyword)
	}

	if v.Settings != nil {
		ok := object.Key("Settings")
		if err := awsAwsjson10_serializeDocumentSettings(v.Settings, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeDocumentRuleOptions(v []types.RuleOption, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson10_serializeDocumentRuleOption(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson10_serializeDocumentRulesSource(v *types.RulesSource, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RulesSourceList != nil {
		ok := object.Key("RulesSourceList")
		if err := awsAwsjson10_serializeDocumentRulesSourceList(v.RulesSourceList, ok); err != nil {
			return err
		}
	}

	if v.RulesString != nil {
		ok := object.Key("RulesString")
		ok.String(*v.RulesString)
	}

	if v.StatefulRules != nil {
		ok := object.Key("StatefulRules")
		if err := awsAwsjson10_serializeDocumentStatefulRules(v.StatefulRules, ok); err != nil {
			return err
		}
	}

	if v.StatelessRulesAndCustomActions != nil {
		ok := object.Key("StatelessRulesAndCustomActions")
		if err := awsAwsjson10_serializeDocumentStatelessRulesAndCustomActions(v.StatelessRulesAndCustomActions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeDocumentRulesSourceList(v *types.RulesSourceList, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.GeneratedRulesType) > 0 {
		ok := object.Key("GeneratedRulesType")
		ok.String(string(v.GeneratedRulesType))
	}

	if v.Targets != nil {
		ok := object.Key("Targets")
		if err := awsAwsjson10_serializeDocumentRuleTargets(v.Targets, ok); err != nil {
			return err
		}
	}

	if v.TargetTypes != nil {
		ok := object.Key("TargetTypes")
		if err := awsAwsjson10_serializeDocumentTargetTypes(v.TargetTypes, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeDocumentRuleTargets(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson10_serializeDocumentRuleVariables(v *types.RuleVariables, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.IPSets != nil {
		ok := object.Key("IPSets")
		if err := awsAwsjson10_serializeDocumentIPSets(v.IPSets, ok); err != nil {
			return err
		}
	}

	if v.PortSets != nil {
		ok := object.Key("PortSets")
		if err := awsAwsjson10_serializeDocumentPortSets(v.PortSets, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeDocumentServerCertificate(v *types.ServerCertificate, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceArn != nil {
		ok := object.Key("ResourceArn")
		ok.String(*v.ResourceArn)
	}

	return nil
}

func awsAwsjson10_serializeDocumentServerCertificateConfiguration(v *types.ServerCertificateConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CertificateAuthorityArn != nil {
		ok := object.Key("CertificateAuthorityArn")
		ok.String(*v.CertificateAuthorityArn)
	}

	if v.CheckCertificateRevocationStatus != nil {
		ok := object.Key("CheckCertificateRevocationStatus")
		if err := awsAwsjson10_serializeDocumentCheckCertificateRevocationStatusActions(v.CheckCertificateRevocationStatus, ok); err != nil {
			return err
		}
	}

	if v.Scopes != nil {
		ok := object.Key("Scopes")
		if err := awsAwsjson10_serializeDocumentServerCertificateScopes(v.Scopes, ok); err != nil {
			return err
		}
	}

	if v.ServerCertificates != nil {
		ok := object.Key("ServerCertificates")
		if err := awsAwsjson10_serializeDocumentServerCertificates(v.ServerCertificates, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeDocumentServerCertificateConfigurations(v []types.ServerCertificateConfiguration, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson10_serializeDocumentServerCertificateConfiguration(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson10_serializeDocumentServerCertificates(v []types.ServerCertificate, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson10_serializeDocumentServerCertificate(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson10_serializeDocumentServerCertificateScope(v *types.ServerCertificateScope, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DestinationPorts != nil {
		ok := object.Key("DestinationPorts")
		if err := awsAwsjson10_serializeDocumentPortRanges(v.DestinationPorts, ok); err != nil {
			return err
		}
	}

	if v.Destinations != nil {
		ok := object.Key("Destinations")
		if err := awsAwsjson10_serializeDocumentAddresses(v.Destinations, ok); err != nil {
			return err
		}
	}

	if v.Protocols != nil {
		ok := object.Key("Protocols")
		if err := awsAwsjson10_serializeDocumentProtocolNumbers(v.Protocols, ok); err != nil {
			return err
		}
	}

	if v.SourcePorts != nil {
		ok := object.Key("SourcePorts")
		if err := awsAwsjson10_serializeDocumentPortRanges(v.SourcePorts, ok); err != nil {
			return err
		}
	}

	if v.Sources != nil {
		ok := object.Key("Sources")
		if err := awsAwsjson10_serializeDocumentAddresses(v.Sources, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeDocumentServerCertificateScopes(v []types.ServerCertificateScope, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson10_serializeDocumentServerCertificateScope(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson10_serializeDocumentSettings(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson10_serializeDocumentSourceMetadata(v *types.SourceMetadata, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.SourceArn != nil {
		ok := object.Key("SourceArn")
		ok.String(*v.SourceArn)
	}

	if v.SourceUpdateToken != nil {
		ok := object.Key("SourceUpdateToken")
		ok.String(*v.SourceUpdateToken)
	}

	return nil
}

func awsAwsjson10_serializeDocumentStatefulActions(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson10_serializeDocumentStatefulEngineOptions(v *types.StatefulEngineOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.RuleOrder) > 0 {
		ok := object.Key("RuleOrder")
		ok.String(string(v.RuleOrder))
	}

	if len(v.StreamExceptionPolicy) > 0 {
		ok := object.Key("StreamExceptionPolicy")
		ok.String(string(v.StreamExceptionPolicy))
	}

	return nil
}

func awsAwsjson10_serializeDocumentStatefulRule(v *types.StatefulRule, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Action) > 0 {
		ok := object.Key("Action")
		ok.String(string(v.Action))
	}

	if v.Header != nil {
		ok := object.Key("Header")
		if err := awsAwsjson10_serializeDocumentHeader(v.Header, ok); err != nil {
			return err
		}
	}

	if v.RuleOptions != nil {
		ok := object.Key("RuleOptions")
		if err := awsAwsjson10_serializeDocumentRuleOptions(v.RuleOptions, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeDocumentStatefulRuleGroupOverride(v *types.StatefulRuleGroupOverride, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.Action) > 0 {
		ok := object.Key("Action")
		ok.String(string(v.Action))
	}

	return nil
}

func awsAwsjson10_serializeDocumentStatefulRuleGroupReference(v *types.StatefulRuleGroupReference, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Override != nil {
		ok := object.Key("Override")
		if err := awsAwsjson10_serializeDocumentStatefulRuleGroupOverride(v.Override, ok); err != nil {
			return err
		}
	}

	if v.Priority != nil {
		ok := object.Key("Priority")
		ok.Integer(*v.Priority)
	}

	if v.ResourceArn != nil {
		ok := object.Key("ResourceArn")
		ok.String(*v.ResourceArn)
	}

	return nil
}

func awsAwsjson10_serializeDocumentStatefulRuleGroupReferences(v []types.StatefulRuleGroupReference, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson10_serializeDocumentStatefulRuleGroupReference(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson10_serializeDocumentStatefulRuleOptions(v *types.StatefulRuleOptions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.RuleOrder) > 0 {
		ok := object.Key("RuleOrder")
		ok.String(string(v.RuleOrder))
	}

	return nil
}

func awsAwsjson10_serializeDocumentStatefulRules(v []types.StatefulRule, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson10_serializeDocumentStatefulRule(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson10_serializeDocumentStatelessActions(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson10_serializeDocumentStatelessRule(v *types.StatelessRule, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Priority != nil {
		ok := object.Key("Priority")
		ok.Integer(*v.Priority)
	}

	if v.RuleDefinition != nil {
		ok := object.Key("RuleDefinition")
		if err := awsAwsjson10_serializeDocumentRuleDefinition(v.RuleDefinition, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeDocumentStatelessRuleGroupReference(v *types.StatelessRuleGroupReference, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Priority != nil {
		ok := object.Key("Priority")
		ok.Integer(*v.Priority)
	}

	if v.ResourceArn != nil {
		ok := object.Key("ResourceArn")
		ok.String(*v.ResourceArn)
	}

	return nil
}

func awsAwsjson10_serializeDocumentStatelessRuleGroupReferences(v []types.StatelessRuleGroupReference, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson10_serializeDocumentStatelessRuleGroupReference(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson10_serializeDocumentStatelessRules(v []types.StatelessRule, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson10_serializeDocumentStatelessRule(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson10_serializeDocumentStatelessRulesAndCustomActions(v *types.StatelessRulesAndCustomActions, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.CustomActions != nil {
		ok := object.Key("CustomActions")
		if err := awsAwsjson10_serializeDocumentCustomActions(v.CustomActions, ok); err != nil {
			return err
		}
	}

	if v.StatelessRules != nil {
		ok := object.Key("StatelessRules")
		if err := awsAwsjson10_serializeDocumentStatelessRules(v.StatelessRules, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeDocumentSubnetMapping(v *types.SubnetMapping, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.IPAddressType) > 0 {
		ok := object.Key("IPAddressType")
		ok.String(string(v.IPAddressType))
	}

	if v.SubnetId != nil {
		ok := object.Key("SubnetId")
		ok.String(*v.SubnetId)
	}

	return nil
}

func awsAwsjson10_serializeDocumentSubnetMappings(v []types.SubnetMapping, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson10_serializeDocumentSubnetMapping(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson10_serializeDocumentTag(v *types.Tag, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Key != nil {
		ok := object.Key("Key")
		ok.String(*v.Key)
	}

	if v.Value != nil {
		ok := object.Key("Value")
		ok.String(*v.Value)
	}

	return nil
}

func awsAwsjson10_serializeDocumentTagKeyList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson10_serializeDocumentTagList(v []types.Tag, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson10_serializeDocumentTag(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson10_serializeDocumentTargetTypes(v []types.TargetType, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(string(v[i]))
	}
	return nil
}

func awsAwsjson10_serializeDocumentTCPFlagField(v *types.TCPFlagField, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Flags != nil {
		ok := object.Key("Flags")
		if err := awsAwsjson10_serializeDocumentFlags(v.Flags, ok); err != nil {
			return err
		}
	}

	if v.Masks != nil {
		ok := object.Key("Masks")
		if err := awsAwsjson10_serializeDocumentFlags(v.Masks, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeDocumentTCPFlags(v []types.TCPFlagField, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		if err := awsAwsjson10_serializeDocumentTCPFlagField(&v[i], av); err != nil {
			return err
		}
	}
	return nil
}

func awsAwsjson10_serializeDocumentTLSInspectionConfiguration(v *types.TLSInspectionConfiguration, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ServerCertificateConfigurations != nil {
		ok := object.Key("ServerCertificateConfigurations")
		if err := awsAwsjson10_serializeDocumentServerCertificateConfigurations(v.ServerCertificateConfigurations, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeDocumentVariableDefinitionList(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson10_serializeDocumentVpcIds(v []string, value smithyjson.Value) error {
	array := value.Array()
	defer array.Close()

	for i := range v {
		av := array.Value()
		av.String(v[i])
	}
	return nil
}

func awsAwsjson10_serializeOpDocumentAssociateFirewallPolicyInput(v *AssociateFirewallPolicyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FirewallArn != nil {
		ok := object.Key("FirewallArn")
		ok.String(*v.FirewallArn)
	}

	if v.FirewallName != nil {
		ok := object.Key("FirewallName")
		ok.String(*v.FirewallName)
	}

	if v.FirewallPolicyArn != nil {
		ok := object.Key("FirewallPolicyArn")
		ok.String(*v.FirewallPolicyArn)
	}

	if v.UpdateToken != nil {
		ok := object.Key("UpdateToken")
		ok.String(*v.UpdateToken)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentAssociateSubnetsInput(v *AssociateSubnetsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FirewallArn != nil {
		ok := object.Key("FirewallArn")
		ok.String(*v.FirewallArn)
	}

	if v.FirewallName != nil {
		ok := object.Key("FirewallName")
		ok.String(*v.FirewallName)
	}

	if v.SubnetMappings != nil {
		ok := object.Key("SubnetMappings")
		if err := awsAwsjson10_serializeDocumentSubnetMappings(v.SubnetMappings, ok); err != nil {
			return err
		}
	}

	if v.UpdateToken != nil {
		ok := object.Key("UpdateToken")
		ok.String(*v.UpdateToken)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentCreateFirewallInput(v *CreateFirewallInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.DeleteProtection {
		ok := object.Key("DeleteProtection")
		ok.Boolean(v.DeleteProtection)
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.EncryptionConfiguration != nil {
		ok := object.Key("EncryptionConfiguration")
		if err := awsAwsjson10_serializeDocumentEncryptionConfiguration(v.EncryptionConfiguration, ok); err != nil {
			return err
		}
	}

	if v.FirewallName != nil {
		ok := object.Key("FirewallName")
		ok.String(*v.FirewallName)
	}

	if v.FirewallPolicyArn != nil {
		ok := object.Key("FirewallPolicyArn")
		ok.String(*v.FirewallPolicyArn)
	}

	if v.FirewallPolicyChangeProtection {
		ok := object.Key("FirewallPolicyChangeProtection")
		ok.Boolean(v.FirewallPolicyChangeProtection)
	}

	if v.SubnetChangeProtection {
		ok := object.Key("SubnetChangeProtection")
		ok.Boolean(v.SubnetChangeProtection)
	}

	if v.SubnetMappings != nil {
		ok := object.Key("SubnetMappings")
		if err := awsAwsjson10_serializeDocumentSubnetMappings(v.SubnetMappings, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson10_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.VpcId != nil {
		ok := object.Key("VpcId")
		ok.String(*v.VpcId)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentCreateFirewallPolicyInput(v *CreateFirewallPolicyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.DryRun {
		ok := object.Key("DryRun")
		ok.Boolean(v.DryRun)
	}

	if v.EncryptionConfiguration != nil {
		ok := object.Key("EncryptionConfiguration")
		if err := awsAwsjson10_serializeDocumentEncryptionConfiguration(v.EncryptionConfiguration, ok); err != nil {
			return err
		}
	}

	if v.FirewallPolicy != nil {
		ok := object.Key("FirewallPolicy")
		if err := awsAwsjson10_serializeDocumentFirewallPolicy(v.FirewallPolicy, ok); err != nil {
			return err
		}
	}

	if v.FirewallPolicyName != nil {
		ok := object.Key("FirewallPolicyName")
		ok.String(*v.FirewallPolicyName)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson10_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentCreateRuleGroupInput(v *CreateRuleGroupInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AnalyzeRuleGroup {
		ok := object.Key("AnalyzeRuleGroup")
		ok.Boolean(v.AnalyzeRuleGroup)
	}

	if v.Capacity != nil {
		ok := object.Key("Capacity")
		ok.Integer(*v.Capacity)
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.DryRun {
		ok := object.Key("DryRun")
		ok.Boolean(v.DryRun)
	}

	if v.EncryptionConfiguration != nil {
		ok := object.Key("EncryptionConfiguration")
		if err := awsAwsjson10_serializeDocumentEncryptionConfiguration(v.EncryptionConfiguration, ok); err != nil {
			return err
		}
	}

	if v.RuleGroup != nil {
		ok := object.Key("RuleGroup")
		if err := awsAwsjson10_serializeDocumentRuleGroup(v.RuleGroup, ok); err != nil {
			return err
		}
	}

	if v.RuleGroupName != nil {
		ok := object.Key("RuleGroupName")
		ok.String(*v.RuleGroupName)
	}

	if v.Rules != nil {
		ok := object.Key("Rules")
		ok.String(*v.Rules)
	}

	if v.SourceMetadata != nil {
		ok := object.Key("SourceMetadata")
		if err := awsAwsjson10_serializeDocumentSourceMetadata(v.SourceMetadata, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson10_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentCreateTLSInspectionConfigurationInput(v *CreateTLSInspectionConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.EncryptionConfiguration != nil {
		ok := object.Key("EncryptionConfiguration")
		if err := awsAwsjson10_serializeDocumentEncryptionConfiguration(v.EncryptionConfiguration, ok); err != nil {
			return err
		}
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson10_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	if v.TLSInspectionConfiguration != nil {
		ok := object.Key("TLSInspectionConfiguration")
		if err := awsAwsjson10_serializeDocumentTLSInspectionConfiguration(v.TLSInspectionConfiguration, ok); err != nil {
			return err
		}
	}

	if v.TLSInspectionConfigurationName != nil {
		ok := object.Key("TLSInspectionConfigurationName")
		ok.String(*v.TLSInspectionConfigurationName)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentDeleteFirewallInput(v *DeleteFirewallInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FirewallArn != nil {
		ok := object.Key("FirewallArn")
		ok.String(*v.FirewallArn)
	}

	if v.FirewallName != nil {
		ok := object.Key("FirewallName")
		ok.String(*v.FirewallName)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentDeleteFirewallPolicyInput(v *DeleteFirewallPolicyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FirewallPolicyArn != nil {
		ok := object.Key("FirewallPolicyArn")
		ok.String(*v.FirewallPolicyArn)
	}

	if v.FirewallPolicyName != nil {
		ok := object.Key("FirewallPolicyName")
		ok.String(*v.FirewallPolicyName)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentDeleteResourcePolicyInput(v *DeleteResourcePolicyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceArn != nil {
		ok := object.Key("ResourceArn")
		ok.String(*v.ResourceArn)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentDeleteRuleGroupInput(v *DeleteRuleGroupInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RuleGroupArn != nil {
		ok := object.Key("RuleGroupArn")
		ok.String(*v.RuleGroupArn)
	}

	if v.RuleGroupName != nil {
		ok := object.Key("RuleGroupName")
		ok.String(*v.RuleGroupName)
	}

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentDeleteTLSInspectionConfigurationInput(v *DeleteTLSInspectionConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TLSInspectionConfigurationArn != nil {
		ok := object.Key("TLSInspectionConfigurationArn")
		ok.String(*v.TLSInspectionConfigurationArn)
	}

	if v.TLSInspectionConfigurationName != nil {
		ok := object.Key("TLSInspectionConfigurationName")
		ok.String(*v.TLSInspectionConfigurationName)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentDescribeFirewallInput(v *DescribeFirewallInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FirewallArn != nil {
		ok := object.Key("FirewallArn")
		ok.String(*v.FirewallArn)
	}

	if v.FirewallName != nil {
		ok := object.Key("FirewallName")
		ok.String(*v.FirewallName)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentDescribeFirewallPolicyInput(v *DescribeFirewallPolicyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FirewallPolicyArn != nil {
		ok := object.Key("FirewallPolicyArn")
		ok.String(*v.FirewallPolicyArn)
	}

	if v.FirewallPolicyName != nil {
		ok := object.Key("FirewallPolicyName")
		ok.String(*v.FirewallPolicyName)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentDescribeLoggingConfigurationInput(v *DescribeLoggingConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FirewallArn != nil {
		ok := object.Key("FirewallArn")
		ok.String(*v.FirewallArn)
	}

	if v.FirewallName != nil {
		ok := object.Key("FirewallName")
		ok.String(*v.FirewallName)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentDescribeResourcePolicyInput(v *DescribeResourcePolicyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceArn != nil {
		ok := object.Key("ResourceArn")
		ok.String(*v.ResourceArn)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentDescribeRuleGroupInput(v *DescribeRuleGroupInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AnalyzeRuleGroup {
		ok := object.Key("AnalyzeRuleGroup")
		ok.Boolean(v.AnalyzeRuleGroup)
	}

	if v.RuleGroupArn != nil {
		ok := object.Key("RuleGroupArn")
		ok.String(*v.RuleGroupArn)
	}

	if v.RuleGroupName != nil {
		ok := object.Key("RuleGroupName")
		ok.String(*v.RuleGroupName)
	}

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentDescribeRuleGroupMetadataInput(v *DescribeRuleGroupMetadataInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.RuleGroupArn != nil {
		ok := object.Key("RuleGroupArn")
		ok.String(*v.RuleGroupArn)
	}

	if v.RuleGroupName != nil {
		ok := object.Key("RuleGroupName")
		ok.String(*v.RuleGroupName)
	}

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentDescribeTLSInspectionConfigurationInput(v *DescribeTLSInspectionConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.TLSInspectionConfigurationArn != nil {
		ok := object.Key("TLSInspectionConfigurationArn")
		ok.String(*v.TLSInspectionConfigurationArn)
	}

	if v.TLSInspectionConfigurationName != nil {
		ok := object.Key("TLSInspectionConfigurationName")
		ok.String(*v.TLSInspectionConfigurationName)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentDisassociateSubnetsInput(v *DisassociateSubnetsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FirewallArn != nil {
		ok := object.Key("FirewallArn")
		ok.String(*v.FirewallArn)
	}

	if v.FirewallName != nil {
		ok := object.Key("FirewallName")
		ok.String(*v.FirewallName)
	}

	if v.SubnetIds != nil {
		ok := object.Key("SubnetIds")
		if err := awsAwsjson10_serializeDocumentAzSubnets(v.SubnetIds, ok); err != nil {
			return err
		}
	}

	if v.UpdateToken != nil {
		ok := object.Key("UpdateToken")
		ok.String(*v.UpdateToken)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentListFirewallPoliciesInput(v *ListFirewallPoliciesInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentListFirewallsInput(v *ListFirewallsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.VpcIds != nil {
		ok := object.Key("VpcIds")
		if err := awsAwsjson10_serializeDocumentVpcIds(v.VpcIds, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentListRuleGroupsInput(v *ListRuleGroupsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if len(v.ManagedType) > 0 {
		ok := object.Key("ManagedType")
		ok.String(string(v.ManagedType))
	}

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if len(v.Scope) > 0 {
		ok := object.Key("Scope")
		ok.String(string(v.Scope))
	}

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentListTagsForResourceInput(v *ListTagsForResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	if v.ResourceArn != nil {
		ok := object.Key("ResourceArn")
		ok.String(*v.ResourceArn)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentListTLSInspectionConfigurationsInput(v *ListTLSInspectionConfigurationsInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.MaxResults != nil {
		ok := object.Key("MaxResults")
		ok.Integer(*v.MaxResults)
	}

	if v.NextToken != nil {
		ok := object.Key("NextToken")
		ok.String(*v.NextToken)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentPutResourcePolicyInput(v *PutResourcePolicyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Policy != nil {
		ok := object.Key("Policy")
		ok.String(*v.Policy)
	}

	if v.ResourceArn != nil {
		ok := object.Key("ResourceArn")
		ok.String(*v.ResourceArn)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentTagResourceInput(v *TagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceArn != nil {
		ok := object.Key("ResourceArn")
		ok.String(*v.ResourceArn)
	}

	if v.Tags != nil {
		ok := object.Key("Tags")
		if err := awsAwsjson10_serializeDocumentTagList(v.Tags, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentUntagResourceInput(v *UntagResourceInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.ResourceArn != nil {
		ok := object.Key("ResourceArn")
		ok.String(*v.ResourceArn)
	}

	if v.TagKeys != nil {
		ok := object.Key("TagKeys")
		if err := awsAwsjson10_serializeDocumentTagKeyList(v.TagKeys, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentUpdateFirewallDeleteProtectionInput(v *UpdateFirewallDeleteProtectionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	{
		ok := object.Key("DeleteProtection")
		ok.Boolean(v.DeleteProtection)
	}

	if v.FirewallArn != nil {
		ok := object.Key("FirewallArn")
		ok.String(*v.FirewallArn)
	}

	if v.FirewallName != nil {
		ok := object.Key("FirewallName")
		ok.String(*v.FirewallName)
	}

	if v.UpdateToken != nil {
		ok := object.Key("UpdateToken")
		ok.String(*v.UpdateToken)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentUpdateFirewallDescriptionInput(v *UpdateFirewallDescriptionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.FirewallArn != nil {
		ok := object.Key("FirewallArn")
		ok.String(*v.FirewallArn)
	}

	if v.FirewallName != nil {
		ok := object.Key("FirewallName")
		ok.String(*v.FirewallName)
	}

	if v.UpdateToken != nil {
		ok := object.Key("UpdateToken")
		ok.String(*v.UpdateToken)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentUpdateFirewallEncryptionConfigurationInput(v *UpdateFirewallEncryptionConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.EncryptionConfiguration != nil {
		ok := object.Key("EncryptionConfiguration")
		if err := awsAwsjson10_serializeDocumentEncryptionConfiguration(v.EncryptionConfiguration, ok); err != nil {
			return err
		}
	}

	if v.FirewallArn != nil {
		ok := object.Key("FirewallArn")
		ok.String(*v.FirewallArn)
	}

	if v.FirewallName != nil {
		ok := object.Key("FirewallName")
		ok.String(*v.FirewallName)
	}

	if v.UpdateToken != nil {
		ok := object.Key("UpdateToken")
		ok.String(*v.UpdateToken)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentUpdateFirewallPolicyChangeProtectionInput(v *UpdateFirewallPolicyChangeProtectionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FirewallArn != nil {
		ok := object.Key("FirewallArn")
		ok.String(*v.FirewallArn)
	}

	if v.FirewallName != nil {
		ok := object.Key("FirewallName")
		ok.String(*v.FirewallName)
	}

	{
		ok := object.Key("FirewallPolicyChangeProtection")
		ok.Boolean(v.FirewallPolicyChangeProtection)
	}

	if v.UpdateToken != nil {
		ok := object.Key("UpdateToken")
		ok.String(*v.UpdateToken)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentUpdateFirewallPolicyInput(v *UpdateFirewallPolicyInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.DryRun {
		ok := object.Key("DryRun")
		ok.Boolean(v.DryRun)
	}

	if v.EncryptionConfiguration != nil {
		ok := object.Key("EncryptionConfiguration")
		if err := awsAwsjson10_serializeDocumentEncryptionConfiguration(v.EncryptionConfiguration, ok); err != nil {
			return err
		}
	}

	if v.FirewallPolicy != nil {
		ok := object.Key("FirewallPolicy")
		if err := awsAwsjson10_serializeDocumentFirewallPolicy(v.FirewallPolicy, ok); err != nil {
			return err
		}
	}

	if v.FirewallPolicyArn != nil {
		ok := object.Key("FirewallPolicyArn")
		ok.String(*v.FirewallPolicyArn)
	}

	if v.FirewallPolicyName != nil {
		ok := object.Key("FirewallPolicyName")
		ok.String(*v.FirewallPolicyName)
	}

	if v.UpdateToken != nil {
		ok := object.Key("UpdateToken")
		ok.String(*v.UpdateToken)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentUpdateLoggingConfigurationInput(v *UpdateLoggingConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FirewallArn != nil {
		ok := object.Key("FirewallArn")
		ok.String(*v.FirewallArn)
	}

	if v.FirewallName != nil {
		ok := object.Key("FirewallName")
		ok.String(*v.FirewallName)
	}

	if v.LoggingConfiguration != nil {
		ok := object.Key("LoggingConfiguration")
		if err := awsAwsjson10_serializeDocumentLoggingConfiguration(v.LoggingConfiguration, ok); err != nil {
			return err
		}
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentUpdateRuleGroupInput(v *UpdateRuleGroupInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.AnalyzeRuleGroup {
		ok := object.Key("AnalyzeRuleGroup")
		ok.Boolean(v.AnalyzeRuleGroup)
	}

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.DryRun {
		ok := object.Key("DryRun")
		ok.Boolean(v.DryRun)
	}

	if v.EncryptionConfiguration != nil {
		ok := object.Key("EncryptionConfiguration")
		if err := awsAwsjson10_serializeDocumentEncryptionConfiguration(v.EncryptionConfiguration, ok); err != nil {
			return err
		}
	}

	if v.RuleGroup != nil {
		ok := object.Key("RuleGroup")
		if err := awsAwsjson10_serializeDocumentRuleGroup(v.RuleGroup, ok); err != nil {
			return err
		}
	}

	if v.RuleGroupArn != nil {
		ok := object.Key("RuleGroupArn")
		ok.String(*v.RuleGroupArn)
	}

	if v.RuleGroupName != nil {
		ok := object.Key("RuleGroupName")
		ok.String(*v.RuleGroupName)
	}

	if v.Rules != nil {
		ok := object.Key("Rules")
		ok.String(*v.Rules)
	}

	if v.SourceMetadata != nil {
		ok := object.Key("SourceMetadata")
		if err := awsAwsjson10_serializeDocumentSourceMetadata(v.SourceMetadata, ok); err != nil {
			return err
		}
	}

	if len(v.Type) > 0 {
		ok := object.Key("Type")
		ok.String(string(v.Type))
	}

	if v.UpdateToken != nil {
		ok := object.Key("UpdateToken")
		ok.String(*v.UpdateToken)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentUpdateSubnetChangeProtectionInput(v *UpdateSubnetChangeProtectionInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.FirewallArn != nil {
		ok := object.Key("FirewallArn")
		ok.String(*v.FirewallArn)
	}

	if v.FirewallName != nil {
		ok := object.Key("FirewallName")
		ok.String(*v.FirewallName)
	}

	{
		ok := object.Key("SubnetChangeProtection")
		ok.Boolean(v.SubnetChangeProtection)
	}

	if v.UpdateToken != nil {
		ok := object.Key("UpdateToken")
		ok.String(*v.UpdateToken)
	}

	return nil
}

func awsAwsjson10_serializeOpDocumentUpdateTLSInspectionConfigurationInput(v *UpdateTLSInspectionConfigurationInput, value smithyjson.Value) error {
	object := value.Object()
	defer object.Close()

	if v.Description != nil {
		ok := object.Key("Description")
		ok.String(*v.Description)
	}

	if v.EncryptionConfiguration != nil {
		ok := object.Key("EncryptionConfiguration")
		if err := awsAwsjson10_serializeDocumentEncryptionConfiguration(v.EncryptionConfiguration, ok); err != nil {
			return err
		}
	}

	if v.TLSInspectionConfiguration != nil {
		ok := object.Key("TLSInspectionConfiguration")
		if err := awsAwsjson10_serializeDocumentTLSInspectionConfiguration(v.TLSInspectionConfiguration, ok); err != nil {
			return err
		}
	}

	if v.TLSInspectionConfigurationArn != nil {
		ok := object.Key("TLSInspectionConfigurationArn")
		ok.String(*v.TLSInspectionConfigurationArn)
	}

	if v.TLSInspectionConfigurationName != nil {
		ok := object.Key("TLSInspectionConfigurationName")
		ok.String(*v.TLSInspectionConfigurationName)
	}

	if v.UpdateToken != nil {
		ok := object.Key("UpdateToken")
		ok.String(*v.UpdateToken)
	}

	return nil
}
