import { __assign, __awaiter, __extends, __generator } from "tslib";
import { BaseClient } from '@sentry/core';
import { logger, SyncPromise } from '@sentry/utils';
import { MainBackend } from './backend';
import { addEventDefaults } from './context';
import { normalizeEvent } from './normalize';
/** Frontend implementation for Electron renderer backends. */
var MainClient = /** @class */ (function (_super) {
    __extends(MainClient, _super);
    /**
     * Creates a new Electron SDK instance.
     * @param options Configuration options for this SDK.
     */
    function MainClient(options) {
        return _super.call(this, MainBackend, options) || this;
    }
    /**
     * Uploads a native crash dump (Minidump) to Sentry.
     *
     * @param path The relative or absolute path to the minidump.
     * @param event Optional event payload to attach to the minidump.
     * @param scope Optional SDK scope used to upload.
     */
    MainClient.prototype.captureMinidump = function (path, event, scope) {
        var _this = this;
        if (event === void 0) { event = {}; }
        var eventId;
        this._processing += 1;
        event.tags = __assign({ event_type: 'native' }, event.tags);
        // We are not calling _processEvent here since we do not have beforeSend for minidump crashes
        this._prepareEvent(event, scope, undefined).then(function (finalEvent) {
            if (finalEvent) {
                eventId = finalEvent && finalEvent.event_id;
                _this._getBackend().uploadMinidump(path, finalEvent);
            }
            _this._processing -= 1;
        }, function (reason) {
            logger.error(reason);
            _this._processing -= 1;
        });
        return eventId;
    };
    /**
     * @inheritDoc
     */
    MainClient.prototype.captureEvent = function (event, hint, scope) {
        event.tags = __assign({ event_type: 'javascript' }, event.tags);
        return _super.prototype.captureEvent.call(this, event, hint, scope);
    };
    /**
     * Does nothing in main/node
     */
    MainClient.prototype.showReportDialog = function (_) {
        // noop
    };
    /**
     * @inheritDoc
     */
    MainClient.prototype._prepareEvent = function (event, scope, hint) {
        var _this = this;
        event.platform = event.platform || 'node';
        return _super.prototype._prepareEvent.call(this, event, scope, hint).then(function (filledEvent) {
            return new SyncPromise(function (resolve) { return __awaiter(_this, void 0, void 0, function () {
                var _a, _b;
                return __generator(this, function (_c) {
                    switch (_c.label) {
                        case 0:
                            if (!filledEvent) return [3 /*break*/, 2];
                            _a = resolve;
                            _b = normalizeEvent;
                            return [4 /*yield*/, addEventDefaults(this._options.appName, filledEvent)];
                        case 1:
                            _a.apply(void 0, [_b.apply(void 0, [_c.sent()])]);
                            return [3 /*break*/, 3];
                        case 2:
                            resolve(filledEvent);
                            _c.label = 3;
                        case 3: return [2 /*return*/];
                    }
                });
            }); }).then(function (e) { return e; });
        });
    };
    return MainClient;
}(BaseClient));
export { MainClient };
//# sourceMappingURL=client.js.map