Object.defineProperty(exports, "__esModule", { value: true });
exports.getIntegrations = exports.specificInit = exports.ElectronClient = void 0;
var tslib_1 = require("tslib");
var utils_1 = require("@sentry/utils");
/**
 * The Sentry Electron SDK Frontend.
 *
 * @see ElectronOptions for documentation on configuration options.
 */
var ElectronClient = /** @class */ (function () {
    /**
     * Creates a new Electron SDK instance.
     *
     * This constructor automatically chooses the right implementation for the
     * process type (`browser` or `renderer`).
     *
     * @param options Configuration options for this SDK.
     */
    function ElectronClient(options) {
        // We dynamically load the frontend implementation for the current process
        // type. In frontend bundlers such as webpack or rollup, those requires are
        // resolved statically. For this reason, we use `dynamicRequire` for the
        // main implementation here, which is only defined in the main process. The
        // renderer implementation must use the default `require`.
        // In case `process.type` is not defined, dispatch defaults to the renderer
        // implementation, which should be fine for most cases. False positives of
        // this would be running `@sentry/electron` in a bare node process, which is
        // acceptable.
        var clientClass = 
        // eslint-disable-next-line @typescript-eslint/no-unsafe-member-access
        process.type === 'browser' ? utils_1.dynamicRequire(module, './main').MainClient : require('./renderer').RendererClient;
        this._inner = new clientClass(options);
    }
    /**
     * @inheritDoc
     */
    ElectronClient.prototype.captureMinidump = function (path, event, scope) {
        return this._inner.captureMinidump(path, event, scope);
    };
    /**
     * @inheritDoc
     */
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    ElectronClient.prototype.captureException = function (exception, hint, scope) {
        return this._inner.captureException(exception, hint, scope);
    };
    /**
     * @inheritDoc
     */
    ElectronClient.prototype.captureMessage = function (message, level, hint, scope) {
        return this._inner.captureMessage(message, level, hint, scope);
    };
    /**
     * @inheritDoc
     */
    ElectronClient.prototype.captureEvent = function (event, hint, scope) {
        return this._inner.captureEvent(event, hint, scope);
    };
    /**
     * @inheritDoc
     */
    ElectronClient.prototype.getDsn = function () {
        return this._inner.getDsn();
    };
    /**
     * @inheritDoc
     */
    ElectronClient.prototype.getOptions = function () {
        return this._inner.getOptions();
    };
    /**
     * @inheritDoc
     */
    ElectronClient.prototype.close = function (timeout) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            return tslib_1.__generator(this, function (_a) {
                return [2 /*return*/, this._inner.close(timeout)];
            });
        });
    };
    /**
     * @inheritDoc
     */
    ElectronClient.prototype.flush = function (timeout) {
        return tslib_1.__awaiter(this, void 0, void 0, function () {
            return tslib_1.__generator(this, function (_a) {
                return [2 /*return*/, this._inner.flush(timeout)];
            });
        });
    };
    /**
     * @inheritDoc
     */
    // eslint-disable-next-line @typescript-eslint/explicit-module-boundary-types
    ElectronClient.prototype.showReportDialog = function (options) {
        this._inner.showReportDialog(options);
    };
    /**
     * @inheritDoc
     */
    ElectronClient.prototype.getIntegration = function (integration) {
        return this._inner.getIntegration(integration);
    };
    /**
     * @inheritDoc
     */
    ElectronClient.prototype.setupIntegrations = function () {
        this._inner.setupIntegrations();
    };
    return ElectronClient;
}());
exports.ElectronClient = ElectronClient;
/**
 * This either calls init on main with node interations or renderer
 * with browser integrations.
 *
 * @param options Options
 */
function specificInit(options) {
    // eslint-disable-next-line @typescript-eslint/no-unused-expressions, @typescript-eslint/no-unsafe-member-access
    process.type === 'browser' ? utils_1.dynamicRequire(module, './main').init(options) : require('./renderer').init(options);
}
exports.specificInit = specificInit;
/** Return all integrations depending if running in browser or renderer. */
function getIntegrations() {
    /* eslint-disable @typescript-eslint/no-unsafe-member-access */
    return process.type === 'browser'
        ? {
            electron: utils_1.dynamicRequire(module, './main').ElectronIntegrations,
            node: utils_1.dynamicRequire(module, './main').NodeIntegrations,
        }
        : { browser: require('./renderer').BrowserIntegrations };
    /* eslint-enable @typescript-eslint/no-unsafe-member-access */
}
exports.getIntegrations = getIntegrations;
//# sourceMappingURL=dispatch.js.map