(function (global, factory) {
    typeof exports === 'object' && typeof module !== 'undefined' ? factory(exports, require('react')) :
    typeof define === 'function' && define.amd ? define(['exports', 'react'], factory) :
    (global = typeof globalThis !== 'undefined' ? globalThis : global || self, factory(global.PosthogReact = {}, global.React));
}(this, (function (exports, React) { 'use strict';

    function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

    var React__default = /*#__PURE__*/_interopDefaultLegacy(React);

    var cache = new Map();
    function getPostHogContext() {
        var context = cache.get(React__default['default'].createContext);
        if (!context) {
            context = React__default['default'].createContext({});
            cache.set(React__default['default'].createContext, context);
        }
        return context;
    }
    function usePostHogContext() {
        var context = React.useContext(getPostHogContext());
        if (!context.client) {
            throw new Error('No PostHog client instance can be found. ' +
                'Please ensure that your application is wrapped by `PostHogProvider`.');
        }
        return context;
    }

    /*! *****************************************************************************
    Copyright (c) Microsoft Corporation.

    Permission to use, copy, modify, and/or distribute this software for any
    purpose with or without fee is hereby granted.

    THE SOFTWARE IS PROVIDED "AS IS" AND THE AUTHOR DISCLAIMS ALL WARRANTIES WITH
    REGARD TO THIS SOFTWARE INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY
    AND FITNESS. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY SPECIAL, DIRECT,
    INDIRECT, OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM
    LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR
    OTHER TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
    PERFORMANCE OF THIS SOFTWARE.
    ***************************************************************************** */

    var __assign = function() {
        __assign = Object.assign || function __assign(t) {
            for (var s, i = 1, n = arguments.length; i < n; i++) {
                s = arguments[i];
                for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
            }
            return t;
        };
        return __assign.apply(this, arguments);
    };

    var PostHogProvider = function (_a) {
        var client = _a.client, children = _a.children;
        var PostHogContext = getPostHogContext();
        var _b = React.useState({ enabled: {} }), featureFlags = _b[0], setFeatureFlags = _b[1];
        return (React__default['default'].createElement(PostHogContext.Consumer, null, function (context) {
            if (client && context.client !== client) {
                context = Object.assign({}, context, { client: client });
            }
            if (!context.client) {
                throw new Error('PostHogProvider was not passed a client instance. ' +
                    'Make sure you pass in your PostHog client via the "client" prop.');
            }
            var value = __assign(__assign({}, context), { featureFlags: featureFlags, setFeatureFlags: setFeatureFlags });
            return React__default['default'].createElement(PostHogContext.Provider, { value: value }, children);
        }));
    };

    function useFeatureFlags(props) {
        if (props === void 0) { props = {}; }
        var _a = props.refreshInterval, refreshInterval = _a === void 0 ? 0 : _a, _b = props.sendEvent, sendEvent = _b === void 0 ? true : _b;
        var _c = usePostHogContext(), posthog = _c.client, featureFlags = _c.featureFlags, setFeatureFlags = _c.setFeatureFlags;
        var getEnabledFlags = React.useCallback(function (flags) {
            var enabled = flags.reduce(function (result, flag) {
                result[flag] = !!(posthog === null || posthog === void 0 ? void 0 : posthog.isFeatureEnabled(flag, {
                    send_event: sendEvent,
                }));
                return result;
            }, {});
            setFeatureFlags({ active: flags, enabled: enabled });
        }, [posthog, sendEvent, setFeatureFlags]);
        React.useEffect(function () {
            if (posthog && refreshInterval > 0) {
                var interval_1 = setInterval(function () {
                    posthog === null || posthog === void 0 ? void 0 : posthog.featureFlags.reloadFeatureFlags();
                }, refreshInterval * 1000);
                return function () { return clearInterval(interval_1); };
            }
        }, [posthog, refreshInterval, getEnabledFlags]);
        React.useEffect(function () {
            posthog === null || posthog === void 0 ? void 0 : posthog.onFeatureFlags(getEnabledFlags);
        }, [posthog, getEnabledFlags]);
        return featureFlags;
    }

    exports.PostHogProvider = PostHogProvider;
    exports.getPostHogContext = getPostHogContext;
    exports.useFeatureFlags = useFeatureFlags;
    exports.usePostHogContext = usePostHogContext;

})));
