import { ReportDialogOptions } from '@sentry/browser';
import { BaseClient, Scope } from '@sentry/core';
import { Event, EventHint } from '@sentry/types';
import { ElectronClient, ElectronOptions } from '../common';
import { RendererBackend } from './backend';
/** Frontend implementation for Electron renderer backends. */
export declare class RendererClient extends BaseClient<RendererBackend, ElectronOptions> implements ElectronClient {
    /**
     * Creates a new Electron SDK instance.
     * @param options Configuration options for this SDK.
     */
    constructor(options: ElectronOptions);
    /**
     * Uploads a native crash dump (Minidump) to Sentry.
     *
     * @param path The relative or absolute path to the minidump.
     * @param event Optional event payload to attach to the minidump.
     * @param scope The SDK scope used to upload.
     */
    captureMinidump(): string | undefined;
    /**
     * Basically calling {@link BrowserClient.showReportDialog}
     * @inheritdoc
     */
    showReportDialog(options?: ReportDialogOptions): void;
    /**
     * @inheritDoc
     */
    protected _prepareEvent(event: Event, scope?: Scope, hint?: EventHint): PromiseLike<Event | null>;
}
//# sourceMappingURL=client.d.ts.map