/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.shading;

import java.awt.PaintContext;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.ColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.EOFException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.common.PDRange;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingResources;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingType6;
import org.apache.pdfbox.pdmodel.graphics.shading.Patch;
import org.apache.pdfbox.pdmodel.graphics.shading.TriangleBasedShadingContext;
import org.apache.pdfbox.util.Matrix;

abstract class PatchMeshesShadingContext
extends TriangleBasedShadingContext
implements PaintContext {
    private static final Log LOG = LogFactory.getLog(PatchMeshesShadingContext.class);
    protected float[] background;
    protected int rgbBackground;
    protected final PDShadingResources patchMeshesShadingType;
    protected ArrayList<Patch> patchList;
    protected int bitsPerFlag;
    protected HashMap<Point, Integer> pixelTable;

    protected PatchMeshesShadingContext(PDShadingResources shading, ColorModel colorModel, AffineTransform xform, Matrix ctm, int pageHeight, Rectangle dBounds) throws IOException {
        super(shading, colorModel, xform, ctm, pageHeight, dBounds);
        this.patchMeshesShadingType = shading;
        this.bitsPerFlag = ((PDShadingType6)shading).getBitsPerFlag();
        this.patchList = new ArrayList();
        COSArray bg = shading.getBackground();
        if (bg != null) {
            this.background = bg.toFloatArray();
            this.rgbBackground = this.convertToRGB(this.background);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected ArrayList<Patch> getPatchList(AffineTransform xform, Matrix ctm, COSDictionary cosDictionary, PDRange rangeX, PDRange rangeY, PDRange[] colRange, int numP) throws IOException {
        ArrayList<Patch> list = new ArrayList<Patch>();
        long maxSrcCoord = (long)Math.pow(2.0, this.bitsPerCoordinate) - 1L;
        long maxSrcColor = (long)Math.pow(2.0, this.bitsPerColorComponent) - 1L;
        COSStream cosStream = (COSStream)cosDictionary;
        MemoryCacheImageInputStream mciis = new MemoryCacheImageInputStream(cosStream.getUnfilteredStream());
        Point2D[] implicitEdge = new Point2D[4];
        float[][] implicitCornerColor = new float[2][this.numberOfColorComponents];
        byte flag = 0;
        try {
            flag = (byte)(mciis.readBits(this.bitsPerFlag) & 3L);
        }
        catch (EOFException ex) {
            LOG.error((Object)ex);
        }
        try {
            boolean isFree;
            Patch current;
            block10: while ((current = this.readPatch(mciis, isFree = flag == 0, implicitEdge, implicitCornerColor, maxSrcCoord, maxSrcColor, rangeX, rangeY, colRange, ctm, xform, numP)) != null) {
                list.add(current);
                flag = (byte)(mciis.readBits(this.bitsPerFlag) & 3L);
                switch (flag) {
                    case 0: {
                        continue block10;
                    }
                    case 1: {
                        implicitEdge = current.getFlag1Edge();
                        implicitCornerColor = current.getFlag1Color();
                        continue block10;
                    }
                    case 2: {
                        implicitEdge = current.getFlag2Edge();
                        implicitCornerColor = current.getFlag2Color();
                        continue block10;
                    }
                    case 3: {
                        implicitEdge = current.getFlag3Edge();
                        implicitCornerColor = current.getFlag3Color();
                        continue block10;
                    }
                }
                LOG.warn((Object)("bad flag: " + flag));
            }
        }
        catch (EOFException ex) {
            // empty catch block
        }
        mciis.close();
        return list;
    }

    protected Patch readPatch(ImageInputStream input, boolean isFree, Point2D[] implicitEdge, float[][] implicitCornerColor, long maxSrcCoord, long maxSrcColor, PDRange rangeX, PDRange rangeY, PDRange[] colRange, Matrix ctm, AffineTransform xform, int numP) throws IOException {
        int i;
        float[][] color = new float[4][this.numberOfColorComponents];
        Point2D[] points = new Point2D[numP];
        int pStart = 4;
        int cStart = 2;
        if (isFree) {
            pStart = 0;
            cStart = 0;
        } else {
            points[0] = implicitEdge[0];
            points[1] = implicitEdge[1];
            points[2] = implicitEdge[2];
            points[3] = implicitEdge[3];
            for (i = 0; i < this.numberOfColorComponents; ++i) {
                color[0][i] = implicitCornerColor[0][i];
                color[1][i] = implicitCornerColor[1][i];
            }
        }
        try {
            for (i = pStart; i < numP; ++i) {
                long x = input.readBits(this.bitsPerCoordinate);
                long y = input.readBits(this.bitsPerCoordinate);
                double px = this.interpolate(x, maxSrcCoord, rangeX.getMin(), rangeX.getMax());
                double py = this.interpolate(y, maxSrcCoord, rangeY.getMin(), rangeY.getMax());
                Point2D.Double tmp = new Point2D.Double(px, py);
                this.transformPoint(tmp, ctm, xform);
                points[i] = tmp;
            }
            for (i = cStart; i < 4; ++i) {
                for (int j = 0; j < this.numberOfColorComponents; ++j) {
                    long c = input.readBits(this.bitsPerColorComponent);
                    color[i][j] = (float)this.interpolate(c, maxSrcColor, colRange[j].getMin(), colRange[j].getMax());
                }
            }
        }
        catch (EOFException ex) {
            LOG.debug((Object)"EOF");
            return null;
        }
        return this.generatePatch(points, color);
    }

    abstract Patch generatePatch(Point2D[] var1, float[][] var2);

    private double interpolate(double x, long maxValue, float rangeMin, float rangeMax) {
        return (double)rangeMin + x / (double)maxValue * (double)(rangeMax - rangeMin);
    }

    protected HashMap<Point, Integer> calcPixelTable() {
        HashMap<Point, Integer> map = new HashMap<Point, Integer>();
        for (Patch it : this.patchList) {
            super.calcPixelTable(it.listOfTriangles, map);
        }
        return map;
    }

    @Override
    public void dispose() {
        this.patchList = null;
        this.outputColorModel = null;
        this.shadingColorSpace = null;
        this.shadingTinttransform = null;
    }

    @Override
    public final ColorModel getColorModel() {
        return this.outputColorModel;
    }

    @Override
    public final Raster getRaster(int x, int y, int w, int h) {
        WritableRaster raster = this.getColorModel().createCompatibleWritableRaster(w, h);
        int[] data = new int[w * h * 4];
        if (!this.patchList.isEmpty() || this.background != null) {
            for (int row = 0; row < h; ++row) {
                int currentY = y + row;
                if (this.bboxRect != null && ((float)currentY < this.minBBoxY || (float)currentY > this.maxBBoxY)) continue;
                for (int col = 0; col < w; ++col) {
                    int value;
                    int currentX = x + col;
                    if (this.bboxRect != null && ((float)currentX < this.minBBoxX || (float)currentX > this.maxBBoxX)) continue;
                    Point p = new Point(x + col, y + row);
                    if (this.pixelTable.containsKey(p)) {
                        value = this.pixelTable.get(p);
                    } else {
                        if (this.background == null) continue;
                        value = this.rgbBackground;
                    }
                    int index = (row * w + col) * 4;
                    data[index] = value & 0xFF;
                    data[index + 1] = (value >>= 8) & 0xFF;
                    data[index + 2] = (value >>= 8) & 0xFF;
                    data[index + 3] = 255;
                }
            }
        }
        raster.setPixels(0, 0, w, h, data);
        return raster;
    }
}

