/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bibgls.bib2gls;

import com.dickimawbooks.bibgls.bib2gls.Bib2GlsEntry;
import com.dickimawbooks.bibgls.bib2gls.Conditional;
import com.dickimawbooks.bibgls.bib2gls.FieldValueList;
import com.dickimawbooks.bibgls.common.Bib2GlsException;
import com.dickimawbooks.texparserlib.bib.BibValue;
import java.io.IOException;

public class FieldEvaluation {
    private FieldValueList valueList;
    private Conditional condition;

    public FieldEvaluation(FieldValueList fieldValueList, Conditional conditional) {
        if (fieldValueList == null) {
            throw new NullPointerException();
        }
        this.valueList = fieldValueList;
        this.condition = conditional;
    }

    public BibValue getValue(Bib2GlsEntry bib2GlsEntry) throws Bib2GlsException, IOException {
        bib2GlsEntry.getResource().setLastMatch(null);
        if (this.condition != null && !this.condition.booleanValue(bib2GlsEntry)) {
            return null;
        }
        return this.valueList.getValue(bib2GlsEntry);
    }

    public String getStringValue(Bib2GlsEntry bib2GlsEntry) throws Bib2GlsException, IOException {
        if (this.condition != null && !this.condition.booleanValue(bib2GlsEntry)) {
            return null;
        }
        return this.valueList.getStringValue(bib2GlsEntry);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.valueList.size(); ++i) {
            if (i > 0) {
                stringBuilder.append(" + ");
            }
            stringBuilder.append(this.valueList.get(i));
        }
        if (this.condition != null) {
            stringBuilder.append(" [ ");
            stringBuilder.append(this.condition);
            stringBuilder.append(" ] ");
        }
        return stringBuilder.toString();
    }
}

