/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.api;

import com.puppycrawl.tools.checkstyle.api.SeverityLevel;
import java.text.MessageFormat;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;

public final class LocalizedMessage
implements Comparable {
    private static final int HASH_MULT = 29;
    private static Locale sLocale = Locale.getDefault();
    private static final Map BUNDLE_CACHE = Collections.synchronizedMap(new HashMap());
    private final int mLineNo;
    private final int mColNo;
    private final SeverityLevel mSeverityLevel;
    private final String mModuleId;
    private static final SeverityLevel DEFAULT_SEVERITY = SeverityLevel.ERROR;
    private final String mKey;
    private final Object[] mArgs;
    private final String mBundle;
    private final Class mSourceClass;

    public boolean equals(Object aObject) {
        if (this == aObject) {
            return true;
        }
        if (!(aObject instanceof LocalizedMessage)) {
            return false;
        }
        LocalizedMessage localizedMessage = (LocalizedMessage)aObject;
        if (this.mColNo != localizedMessage.mColNo) {
            return false;
        }
        if (this.mLineNo != localizedMessage.mLineNo) {
            return false;
        }
        if (!this.mKey.equals(localizedMessage.mKey)) {
            return false;
        }
        return Arrays.equals(this.mArgs, localizedMessage.mArgs);
    }

    public int hashCode() {
        int result = this.mLineNo;
        result = 29 * result + this.mColNo;
        result = 29 * result + this.mKey.hashCode();
        for (int i = 0; i < this.mArgs.length; ++i) {
            result = 29 * result + this.mArgs[i].hashCode();
        }
        return result;
    }

    public LocalizedMessage(int aLineNo, int aColNo, String aBundle, String aKey, Object[] aArgs, SeverityLevel aSeverityLevel, String aModuleId, Class aSourceClass) {
        this.mLineNo = aLineNo;
        this.mColNo = aColNo;
        this.mKey = aKey;
        this.mArgs = aArgs;
        this.mBundle = aBundle;
        this.mSeverityLevel = aSeverityLevel;
        this.mModuleId = aModuleId;
        this.mSourceClass = aSourceClass;
    }

    public LocalizedMessage(int aLineNo, int aColNo, String aBundle, String aKey, Object[] aArgs, String aModuleId, Class aSourceClass) {
        this(aLineNo, aColNo, aBundle, aKey, aArgs, DEFAULT_SEVERITY, aModuleId, aSourceClass);
    }

    public LocalizedMessage(int aLineNo, String aBundle, String aKey, Object[] aArgs, SeverityLevel aSeverityLevel, String aModuleId, Class aSourceClass) {
        this(aLineNo, 0, aBundle, aKey, aArgs, aSeverityLevel, aModuleId, aSourceClass);
    }

    public LocalizedMessage(int aLineNo, String aBundle, String aKey, Object[] aArgs, String aModuleId, Class aSourceClass) {
        this(aLineNo, 0, aBundle, aKey, aArgs, DEFAULT_SEVERITY, aModuleId, aSourceClass);
    }

    public String getMessage() {
        try {
            ResourceBundle bundle = this.getBundle(this.mBundle);
            String pattern = bundle.getString(this.mKey);
            return MessageFormat.format(pattern, this.mArgs);
        }
        catch (MissingResourceException ex) {
            return MessageFormat.format(this.mKey, this.mArgs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResourceBundle getBundle(String aBundleName) {
        Map map = BUNDLE_CACHE;
        synchronized (map) {
            ResourceBundle bundle = (ResourceBundle)BUNDLE_CACHE.get(aBundleName);
            if (bundle == null) {
                bundle = ResourceBundle.getBundle(aBundleName, sLocale, this.mSourceClass.getClassLoader());
                BUNDLE_CACHE.put(aBundleName, bundle);
            }
            return bundle;
        }
    }

    public int getLineNo() {
        return this.mLineNo;
    }

    public int getColumnNo() {
        return this.mColNo;
    }

    public SeverityLevel getSeverityLevel() {
        return this.mSeverityLevel;
    }

    public String getModuleId() {
        return this.mModuleId;
    }

    public String getKey() {
        return this.mKey;
    }

    public String getSourceName() {
        return this.mSourceClass.getName();
    }

    public static void setLocale(Locale aLocale) {
        sLocale = aLocale;
    }

    public int compareTo(Object aOther) {
        LocalizedMessage lt = (LocalizedMessage)aOther;
        if (this.getLineNo() == lt.getLineNo()) {
            if (this.getColumnNo() == lt.getColumnNo()) {
                return this.getMessage().compareTo(lt.getMessage());
            }
            return this.getColumnNo() < lt.getColumnNo() ? -1 : 1;
        }
        return this.getLineNo() < lt.getLineNo() ? -1 : 1;
    }
}

