/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.codehaus.plexus;

import java.io.File;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import javax.inject.Provider;
import org.jetbrains.kotlin.com.google.inject.Binder;
import org.jetbrains.kotlin.com.google.inject.Guice;
import org.jetbrains.kotlin.com.google.inject.Injector;
import org.jetbrains.kotlin.com.google.inject.Key;
import org.jetbrains.kotlin.com.google.inject.Module;
import org.jetbrains.kotlin.com.google.inject.TypeLiteral;
import org.jetbrains.kotlin.com.google.inject.name.Names;
import org.jetbrains.kotlin.com.google.inject.util.Providers;
import org.jetbrains.kotlin.org.codehaus.plexus.ContainerConfiguration;
import org.jetbrains.kotlin.org.codehaus.plexus.DefaultContainerConfiguration;
import org.jetbrains.kotlin.org.codehaus.plexus.MutablePlexusContainer;
import org.jetbrains.kotlin.org.codehaus.plexus.PlexusContainer;
import org.jetbrains.kotlin.org.codehaus.plexus.PlexusContainerException;
import org.jetbrains.kotlin.org.codehaus.plexus.classworlds.ClassWorld;
import org.jetbrains.kotlin.org.codehaus.plexus.classworlds.realm.ClassRealm;
import org.jetbrains.kotlin.org.codehaus.plexus.classworlds.realm.NoSuchRealmException;
import org.jetbrains.kotlin.org.codehaus.plexus.component.repository.ComponentDescriptor;
import org.jetbrains.kotlin.org.codehaus.plexus.component.repository.exception.ComponentLookupException;
import org.jetbrains.kotlin.org.codehaus.plexus.context.Context;
import org.jetbrains.kotlin.org.codehaus.plexus.context.ContextMapAdapter;
import org.jetbrains.kotlin.org.codehaus.plexus.context.DefaultContext;
import org.jetbrains.kotlin.org.codehaus.plexus.logging.Logger;
import org.jetbrains.kotlin.org.codehaus.plexus.logging.LoggerManager;
import org.jetbrains.kotlin.org.codehaus.plexus.logging.console.ConsoleLoggerManager;
import org.jetbrains.kotlin.org.eclipse.sisu.bean.BeanManager;
import org.jetbrains.kotlin.org.eclipse.sisu.bean.LifecycleManager;
import org.jetbrains.kotlin.org.eclipse.sisu.inject.DefaultBeanLocator;
import org.jetbrains.kotlin.org.eclipse.sisu.inject.DefaultRankingFunction;
import org.jetbrains.kotlin.org.eclipse.sisu.inject.DeferredClass;
import org.jetbrains.kotlin.org.eclipse.sisu.inject.DeferredProvider;
import org.jetbrains.kotlin.org.eclipse.sisu.inject.MutableBeanLocator;
import org.jetbrains.kotlin.org.eclipse.sisu.inject.RankingFunction;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.DefaultPlexusBeanLocator;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.Hints;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.PlexusAnnotatedBeanModule;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.PlexusBean;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.PlexusBeanConverter;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.PlexusBeanLocator;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.PlexusBeanModule;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.PlexusBindingModule;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.PlexusDateTypeConverter;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.PlexusLifecycleManager;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.PlexusXmlBeanConverter;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.PlexusXmlBeanModule;
import org.jetbrains.kotlin.org.eclipse.sisu.plexus.RealmManager;
import org.jetbrains.kotlin.org.eclipse.sisu.space.BeanScanning;
import org.jetbrains.kotlin.org.eclipse.sisu.space.LoadedClass;
import org.jetbrains.kotlin.org.eclipse.sisu.space.URLClassSpace;
import org.jetbrains.kotlin.org.eclipse.sisu.wire.MergedModule;
import org.jetbrains.kotlin.org.eclipse.sisu.wire.ParameterKeys;
import org.jetbrains.kotlin.org.eclipse.sisu.wire.WireModule;
import org.slf4j.ILoggerFactory;

public final class DefaultPlexusContainer
implements MutablePlexusContainer {
    private static final Module[] NO_CUSTOM_MODULES;
    final AtomicInteger plexusRank = new AtomicInteger();
    final Map<ClassRealm, List<ComponentDescriptor<?>>> descriptorMap = new IdentityHashMap();
    final ThreadLocal<ClassRealm> lookupRealm = new ThreadLocal();
    final LoggerManagerProvider loggerManagerProvider = new LoggerManagerProvider();
    final MutableBeanLocator qualifiedBeanLocator = new DefaultBeanLocator();
    final Context context;
    final Map<?, ?> variables;
    final ClassRealm containerRealm;
    final RealmManager realmManager;
    final PlexusBeanLocator plexusBeanLocator;
    final BeanManager plexusBeanManager;
    private final String componentVisibility;
    private final boolean isAutoWiringEnabled;
    private final BeanScanning scanning;
    private final Module containerModule = new ContainerModule();
    private final Module defaultsModule = new DefaultsModule();
    private LoggerManager loggerManager = new ConsoleLoggerManager();
    private Logger logger;
    private boolean disposing;

    public DefaultPlexusContainer() throws PlexusContainerException {
        this(new DefaultContainerConfiguration());
    }

    public DefaultPlexusContainer(ContainerConfiguration configuration) throws PlexusContainerException {
        this(configuration, NO_CUSTOM_MODULES);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DefaultPlexusContainer(ContainerConfiguration configuration, Module ... customModules) throws PlexusContainerException {
        URL plexusXml = this.lookupPlexusXml(configuration);
        this.context = DefaultPlexusContainer.getContextComponent(configuration);
        this.context.put("plexus", this);
        this.variables = new ContextMapAdapter(this.context);
        this.containerRealm = DefaultPlexusContainer.lookupContainerRealm(configuration);
        this.realmManager = new RealmManager(this.qualifiedBeanLocator);
        this.containerRealm.getWorld().addListener(this.realmManager);
        this.componentVisibility = configuration.getComponentVisibility();
        this.isAutoWiringEnabled = configuration.getAutoWiring();
        this.scanning = DefaultPlexusContainer.parseScanningOption(configuration.getClassPathScanning());
        this.plexusBeanLocator = new DefaultPlexusBeanLocator(this.qualifiedBeanLocator, this.realmManager, this.componentVisibility);
        LifecycleManager jsr250Lifecycle = configuration.getJSR250Lifecycle() ? new LifecycleManager() : null;
        this.plexusBeanManager = new PlexusLifecycleManager(Providers.of(this.context), this.loggerManagerProvider, new SLF4JLoggerFactoryProvider(), jsr250Lifecycle);
        this.setLookupRealm(this.containerRealm);
        ArrayList<PlexusBeanModule> beanModules = new ArrayList<PlexusBeanModule>();
        URLClassSpace space = new URLClassSpace(this.containerRealm);
        beanModules.add(new PlexusXmlBeanModule(space, this.variables, plexusXml));
        BeanScanning global = BeanScanning.INDEX == this.scanning ? BeanScanning.GLOBAL_INDEX : this.scanning;
        beanModules.add(new PlexusAnnotatedBeanModule(space, this.variables, global, configuration.getStrictClassPathScanning()));
        try {
            this.addPlexusInjector(beanModules, new BootModule(customModules));
        }
        catch (RuntimeException e) {
            try {
                this.dispose();
            }
            finally {
                throw e;
            }
        }
    }

    @Override
    public <T> T lookup(Class<T> role, String hint) throws ComponentLookupException {
        return this.lookup(role, null, hint);
    }

    public <T> T lookup(Class<T> type, String role, String hint) throws ComponentLookupException {
        try {
            return (T)this.locate(role, type, hint).iterator().next().getValue();
        }
        catch (RuntimeException e) {
            throw new ComponentLookupException(e, null != type ? type.getName() : role, hint);
        }
    }

    public Injector addPlexusInjector(List<? extends PlexusBeanModule> beanModules, Module ... customModules) {
        ArrayList<Module> modules = new ArrayList<Module>();
        modules.add(this.containerModule);
        Collections.addAll(modules, customModules);
        modules.add(new PlexusBindingModule(this.plexusBeanManager, beanModules));
        modules.add(this.defaultsModule);
        return Guice.createInjector(this.isAutoWiringEnabled ? new WireModule(modules) : new MergedModule(modules));
    }

    public ClassWorld getClassWorld() {
        return this.containerRealm.getWorld();
    }

    @Override
    public ClassRealm getContainerRealm() {
        return this.containerRealm;
    }

    public ClassRealm setLookupRealm(ClassRealm realm) {
        ClassRealm oldRealm = this.lookupRealm.get();
        this.lookupRealm.set(realm);
        return oldRealm;
    }

    @Override
    public ClassRealm getLookupRealm() {
        return this.lookupRealm.get();
    }

    public synchronized LoggerManager getLoggerManager() {
        return this.loggerManager;
    }

    public synchronized Logger getLogger() {
        if (null == this.logger) {
            this.logger = this.loggerManager.getLoggerForComponent(PlexusContainer.class.getName(), null);
        }
        return this.logger;
    }

    @Override
    public void release(Object component) {
        this.plexusBeanManager.unmanage(component);
    }

    public void dispose() {
        this.disposing = true;
        this.plexusBeanManager.unmanage();
        this.containerRealm.setParentRealm(null);
        this.qualifiedBeanLocator.clear();
        this.lookupRealm.remove();
        this.containerRealm.getWorld().removeListener(this.realmManager);
    }

    private static BeanScanning parseScanningOption(String scanning) {
        for (BeanScanning option : BeanScanning.values()) {
            if (!option.name().equalsIgnoreCase(scanning)) continue;
            return option;
        }
        return BeanScanning.OFF;
    }

    private static ClassRealm lookupContainerRealm(ContainerConfiguration configuration) throws PlexusContainerException {
        ClassRealm realm;
        block5: {
            realm = configuration.getRealm();
            if (null == realm) {
                ClassWorld world = configuration.getClassWorld();
                if (null == world) {
                    world = new ClassWorld("plexus.core", Thread.currentThread().getContextClassLoader());
                }
                try {
                    realm = world.getRealm("plexus.core");
                }
                catch (NoSuchRealmException e) {
                    Iterator<ClassRealm> realmIterator = world.getRealms().iterator();
                    if (!realmIterator.hasNext()) break block5;
                    realm = realmIterator.next();
                }
            }
        }
        if (null == realm) {
            throw new PlexusContainerException("Missing container class realm: plexus.core");
        }
        return realm;
    }

    private URL lookupPlexusXml(ContainerConfiguration configuration) {
        String configurationPath;
        URL url = configuration.getContainerConfigurationURL();
        if (null == url && null != (configurationPath = configuration.getContainerConfiguration())) {
            File file;
            int index;
            for (index = 0; index < configurationPath.length() && configurationPath.charAt(index) == '/'; ++index) {
            }
            url = this.getClass().getClassLoader().getResource(configurationPath.substring(index));
            if (null == url && (file = new File(configurationPath)).isFile()) {
                try {
                    url = file.toURI().toURL();
                }
                catch (MalformedURLException malformedURLException) {
                    // empty catch block
                }
            }
            if (null == url) {
                this.getLogger().debug("Missing container configuration: " + configurationPath);
            }
        }
        return url;
    }

    private static Context getContextComponent(ContainerConfiguration configuration) {
        Map<Object, Object> contextData = configuration.getContext();
        Context contextComponent = configuration.getContextComponent();
        if (null == contextComponent) {
            return new DefaultContext(contextData);
        }
        if (null != contextData) {
            for (Map.Entry<Object, Object> entry : contextData.entrySet()) {
                contextComponent.put(entry.getKey(), entry.getValue());
            }
        }
        return contextComponent;
    }

    private <T> Iterable<PlexusBean<T>> locate(String role, Class<T> type, String ... hints) {
        if (this.disposing) {
            return Collections.EMPTY_SET;
        }
        String[] canonicalHints = Hints.canonicalHints(hints);
        if (null == role || null != type && type.getName().equals(role)) {
            return this.plexusBeanLocator.locate(TypeLiteral.get(type), canonicalHints);
        }
        HashSet candidates = new HashSet();
        for (ClassRealm realm : this.getVisibleRealms()) {
            try {
                Iterable<PlexusBean<T>> beans;
                Class<?> clazz = realm.loadClass(role);
                if (!candidates.add(clazz) || !DefaultPlexusContainer.hasPlexusBeans(beans = this.plexusBeanLocator.locate(TypeLiteral.get(clazz), canonicalHints))) continue;
                return beans;
            }
            catch (Exception exception) {
            }
            catch (LinkageError linkageError) {
            }
        }
        return Collections.EMPTY_SET;
    }

    private Collection<ClassRealm> getVisibleRealms() {
        Set<String> realmNames;
        ClassRealm threadContextRealm;
        Object[] realms = this.getClassWorld().getRealms().toArray();
        LinkedHashSet<ClassRealm> visibleRealms = new LinkedHashSet<ClassRealm>(realms.length);
        ClassRealm currentLookupRealm = this.getLookupRealm();
        if (null != currentLookupRealm) {
            visibleRealms.add(currentLookupRealm);
        }
        if (null != (threadContextRealm = RealmManager.contextRealm())) {
            visibleRealms.add(threadContextRealm);
        }
        if ("realm".equalsIgnoreCase(this.componentVisibility) && null != (realmNames = this.realmManager.visibleRealmNames(threadContextRealm)) && realmNames.size() > 0) {
            for (int i = realms.length - 1; i >= 0; --i) {
                ClassRealm r = (ClassRealm)realms[i];
                if (!realmNames.contains(r.toString())) continue;
                visibleRealms.add(r);
            }
            return visibleRealms;
        }
        for (int i = realms.length - 1; i >= 0; --i) {
            visibleRealms.add((ClassRealm)realms[i]);
        }
        return visibleRealms;
    }

    private static <T> boolean hasPlexusBeans(Iterable<PlexusBean<T>> beans) {
        Iterator<PlexusBean<T>> i = beans.iterator();
        return i.hasNext() && i.next().getImplementationClass() != null;
    }

    static {
        System.setProperty("guice.disable.misplaced.annotation.check", "true");
        NO_CUSTOM_MODULES = new Module[0];
    }

    final class LoggerManagerProvider
    implements DeferredProvider<LoggerManager> {
        LoggerManagerProvider() {
        }

        @Override
        public LoggerManager get() {
            return DefaultPlexusContainer.this.getLoggerManager();
        }

        @Override
        public DeferredClass<LoggerManager> getImplementationClass() {
            return new LoadedClass<LoggerManager>(this.get().getClass());
        }
    }

    final class ContainerModule
    implements Module {
        ContainerModule() {
        }

        @Override
        public void configure(Binder binder) {
            binder.bind(Context.class).toInstance(DefaultPlexusContainer.this.context);
            binder.bind(ParameterKeys.PROPERTIES).toInstance(DefaultPlexusContainer.this.context.getContextData());
            binder.bind(MutableBeanLocator.class).toInstance(DefaultPlexusContainer.this.qualifiedBeanLocator);
            binder.bind(PlexusBeanLocator.class).toInstance(DefaultPlexusContainer.this.plexusBeanLocator);
            binder.bind(BeanManager.class).toInstance(DefaultPlexusContainer.this.plexusBeanManager);
            binder.bind(PlexusContainer.class).to(MutablePlexusContainer.class);
            binder.bind(MutablePlexusContainer.class).to(DefaultPlexusContainer.class);
            binder.bind(DefaultPlexusContainer.class).toProvider(Providers.of(DefaultPlexusContainer.this));
        }
    }

    final class DefaultsModule
    implements Module {
        private final LoggerProvider loggerProvider;
        private final PlexusDateTypeConverter dateConverter;

        DefaultsModule() {
            this.loggerProvider = new LoggerProvider();
            this.dateConverter = new PlexusDateTypeConverter();
        }

        @Override
        public void configure(Binder binder) {
            binder.bind(LoggerManager.class).toProvider(DefaultPlexusContainer.this.loggerManagerProvider);
            binder.bind(Logger.class).toProvider(this.loggerProvider);
            Key<RankingFunction> plexusRankingKey = Key.get(RankingFunction.class, (Annotation)Names.named("plexus"));
            binder.bind(plexusRankingKey).toInstance(new DefaultRankingFunction(DefaultPlexusContainer.this.plexusRank.incrementAndGet()));
            binder.bind(RankingFunction.class).to(plexusRankingKey);
            binder.install(this.dateConverter);
            binder.bind(PlexusBeanConverter.class).to(PlexusXmlBeanConverter.class);
        }
    }

    final class SLF4JLoggerFactoryProvider
    implements Provider<Object> {
        SLF4JLoggerFactoryProvider() {
        }

        @Override
        public Object get() {
            return DefaultPlexusContainer.this.plexusBeanLocator.locate(TypeLiteral.get(ILoggerFactory.class), new String[0]).iterator().next().getValue();
        }
    }

    final class BootModule
    implements Module {
        private final Module[] customBootModules;

        BootModule(Module[] customBootModules) {
            this.customBootModules = customBootModules;
        }

        @Override
        public void configure(Binder binder) {
            binder.requestInjection(DefaultPlexusContainer.this);
            for (Module m : this.customBootModules) {
                binder.install(m);
            }
        }
    }

    final class LoggerProvider
    implements DeferredProvider<Logger> {
        LoggerProvider() {
        }

        @Override
        public Logger get() {
            return DefaultPlexusContainer.this.getLogger();
        }

        @Override
        public DeferredClass<Logger> getImplementationClass() {
            return new LoadedClass<Logger>(this.get().getClass());
        }
    }
}

