/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.org.eclipse.sisu.plexus;

import java.security.SecureClassLoader;
import java.util.ArrayDeque;
import java.util.Deque;
import javax.inject.Provider;
import org.jetbrains.kotlin.com.google.inject.Binder;
import org.jetbrains.kotlin.com.google.inject.Module;
import org.jetbrains.kotlin.org.codehaus.plexus.context.Context;
import org.jetbrains.kotlin.org.codehaus.plexus.logging.LogEnabled;
import org.jetbrains.kotlin.org.codehaus.plexus.logging.Logger;
import org.jetbrains.kotlin.org.codehaus.plexus.logging.LoggerManager;
import org.jetbrains.kotlin.org.codehaus.plexus.logging.console.ConsoleLogger;
import org.jetbrains.kotlin.org.codehaus.plexus.personality.plexus.lifecycle.phase.Contextualizable;
import org.jetbrains.kotlin.org.codehaus.plexus.personality.plexus.lifecycle.phase.Disposable;
import org.jetbrains.kotlin.org.codehaus.plexus.personality.plexus.lifecycle.phase.Initializable;
import org.jetbrains.kotlin.org.codehaus.plexus.personality.plexus.lifecycle.phase.Startable;
import org.jetbrains.kotlin.org.eclipse.sisu.bean.BeanManager;
import org.jetbrains.kotlin.org.eclipse.sisu.bean.BeanProperty;
import org.jetbrains.kotlin.org.eclipse.sisu.bean.BeanScheduler;
import org.jetbrains.kotlin.org.eclipse.sisu.bean.PropertyBinding;
import org.jetbrains.kotlin.org.eclipse.sisu.inject.Logs;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;

public final class PlexusLifecycleManager
extends BeanScheduler
implements Module,
BeanManager {
    private static final Class<?>[] LIFECYCLE_TYPES = new Class[]{LogEnabled.class, Contextualizable.class, Initializable.class, Startable.class, Disposable.class};
    private final Deque<Startable> startableBeans = new ArrayDeque<Startable>();
    private final Deque<Disposable> disposableBeans = new ArrayDeque<Disposable>();
    private final Logger consoleLogger = new ConsoleLogger();
    private final Provider<Context> plexusContextProvider;
    private final Provider<LoggerManager> plexusLoggerManagerProvider;
    private final Provider<?> slf4jLoggerFactoryProvider;
    private final BeanManager delegate;

    public PlexusLifecycleManager(Provider<Context> plexusContextProvider, Provider<LoggerManager> plexusLoggerManagerProvider, Provider<?> slf4jLoggerFactoryProvider, BeanManager delegate) {
        this.plexusContextProvider = plexusContextProvider;
        this.plexusLoggerManagerProvider = plexusLoggerManagerProvider;
        this.slf4jLoggerFactoryProvider = slf4jLoggerFactoryProvider;
        this.delegate = delegate;
    }

    @Override
    public void configure(Binder binder) {
        BeanScheduler.MODULE.configure(binder);
    }

    @Override
    public boolean manage(Class<?> clazz) {
        for (Class<?> lifecycleType : LIFECYCLE_TYPES) {
            if (!lifecycleType.isAssignableFrom(clazz)) continue;
            return true;
        }
        return null != this.delegate ? this.delegate.manage(clazz) : false;
    }

    public PropertyBinding manage(final BeanProperty property) {
        Class clazz = property.getType().getRawType();
        if ("org.slf4j.Logger".equals(clazz.getName())) {
            return new PropertyBinding(){

                @Override
                public <B> void injectProperty(B bean) {
                    property.set(bean, PlexusLifecycleManager.this.getSLF4JLogger(bean));
                }
            };
        }
        if (Logger.class.equals(clazz)) {
            return new PropertyBinding(){

                @Override
                public <B> void injectProperty(B bean) {
                    property.set(bean, PlexusLifecycleManager.this.getPlexusLogger(bean));
                }
            };
        }
        return null != this.delegate ? this.delegate.manage(property) : null;
    }

    @Override
    public boolean manage(Object bean) {
        if (bean instanceof Disposable) {
            PlexusLifecycleManager.synchronizedPush(this.disposableBeans, (Disposable)bean);
        }
        if (bean instanceof LogEnabled) {
            ((LogEnabled)bean).enableLogging(this.getPlexusLogger(bean));
        }
        if (bean instanceof Contextualizable || bean instanceof Initializable || bean instanceof Startable) {
            this.schedule(bean);
        }
        return null != this.delegate ? this.delegate.manage(bean) : true;
    }

    @Override
    public boolean unmanage(Object bean) {
        if (PlexusLifecycleManager.synchronizedRemove(this.startableBeans, bean)) {
            this.stop((Startable)bean);
        }
        if (PlexusLifecycleManager.synchronizedRemove(this.disposableBeans, bean)) {
            this.dispose((Disposable)bean);
        }
        return null != this.delegate ? this.delegate.unmanage(bean) : true;
    }

    @Override
    public boolean unmanage() {
        Object bean;
        while ((bean = PlexusLifecycleManager.synchronizedPop(this.startableBeans)) != null) {
            this.stop((Startable)bean);
        }
        while ((bean = PlexusLifecycleManager.synchronizedPop(this.disposableBeans)) != null) {
            this.dispose((Disposable)bean);
        }
        return null != this.delegate ? this.delegate.unmanage() : true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void activate(Object bean) {
        ClassLoader tccl = Thread.currentThread().getContextClassLoader();
        try {
            for (Class<?> clazz = bean.getClass(); clazz != null; clazz = clazz.getSuperclass()) {
                ClassLoader loader = clazz.getClassLoader();
                if (!(loader instanceof SecureClassLoader)) continue;
                Thread.currentThread().setContextClassLoader(loader);
                break;
            }
            if (bean instanceof Contextualizable) {
                this.contextualize((Contextualizable)bean);
            }
            if (bean instanceof Initializable) {
                this.initialize((Initializable)bean);
            }
            if (bean instanceof Startable) {
                Startable startableBean = (Startable)bean;
                PlexusLifecycleManager.synchronizedPush(this.startableBeans, startableBean);
                this.start(startableBean);
            }
        }
        finally {
            Thread.currentThread().setContextClassLoader(tccl);
        }
    }

    Logger getPlexusLogger(Object bean) {
        String name = bean.getClass().getName();
        try {
            return this.plexusLoggerManagerProvider.get().getLoggerForComponent(name, null);
        }
        catch (RuntimeException e) {
            return this.consoleLogger;
        }
    }

    Object getSLF4JLogger(Object bean) {
        String name = bean.getClass().getName();
        try {
            return ((ILoggerFactory)this.slf4jLoggerFactoryProvider.get()).getLogger(name);
        }
        catch (RuntimeException e) {
            return LoggerFactory.getLogger(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> void synchronizedPush(Deque<T> deque, T element) {
        Deque<T> deque2 = deque;
        synchronized (deque2) {
            deque.addLast(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean synchronizedRemove(Deque<?> deque, Object element) {
        Deque<?> deque2 = deque;
        synchronized (deque2) {
            return deque.remove(element);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T synchronizedPop(Deque<T> deque) {
        Deque<T> deque2 = deque;
        synchronized (deque2) {
            return deque.pollLast();
        }
    }

    private void contextualize(Contextualizable bean) {
        Logs.trace("Contextualize: <>", bean, null);
        try {
            bean.contextualize(this.plexusContextProvider.get());
        }
        catch (Throwable e) {
            Logs.catchThrowable(e);
            try {
                this.getPlexusLogger(this).warn("Error contextualizing: " + Logs.identityToString(bean), e);
            }
            finally {
                Logs.throwUnchecked(e);
            }
        }
    }

    private void initialize(Initializable bean) {
        Logs.trace("Initialize: <>", bean, null);
        try {
            bean.initialize();
        }
        catch (Throwable e) {
            Logs.catchThrowable(e);
            try {
                this.getPlexusLogger(this).warn("Error initializing: " + Logs.identityToString(bean), e);
            }
            finally {
                Logs.throwUnchecked(e);
            }
        }
    }

    private void start(Startable bean) {
        Logs.trace("Start: <>", bean, null);
        try {
            bean.start();
        }
        catch (Throwable e) {
            Logs.catchThrowable(e);
            try {
                this.getPlexusLogger(this).warn("Error starting: " + Logs.identityToString(bean), e);
            }
            finally {
                Logs.throwUnchecked(e);
            }
        }
    }

    private void stop(Startable bean) {
        Logs.trace("Stop: <>", bean, null);
        try {
            bean.stop();
        }
        catch (Throwable e) {
            Logs.catchThrowable(e);
            try {
                this.getPlexusLogger(this).warn("Problem stopping: " + Logs.identityToString(bean), e);
                return;
            }
            catch (Throwable throwable) {
                return;
            }
        }
    }

    private void dispose(Disposable bean) {
        Logs.trace("Dispose: <>", bean, null);
        try {
            bean.dispose();
        }
        catch (Throwable e) {
            Logs.catchThrowable(e);
            try {
                this.getPlexusLogger(this).warn("Problem disposing: " + Logs.identityToString(bean), e);
                return;
            }
            catch (Throwable throwable) {
                return;
            }
        }
    }
}

