/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.analysis.low.level.api.fir.stubBased.deserialization;

import com.intellij.openapi.vfs.VirtualFile;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.analysis.low.level.api.fir.stubBased.deserialization.DeserializedContainerSourceProvider;
import org.jetbrains.kotlin.analysis.low.level.api.fir.stubBased.deserialization.JvmStubDeserializedContainerSource;
import org.jetbrains.kotlin.analysis.low.level.api.fir.stubBased.deserialization.JvmStubDeserializedFacadeContainerSource;
import org.jetbrains.kotlin.fir.declarations.FirDeclarationOrigin;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.FqName;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.psi.KtFile;
import org.jetbrains.kotlin.psi.stubs.impl.KotlinStubOrigin;
import org.jetbrains.kotlin.resolve.jvm.JvmClassName;
import org.jetbrains.kotlin.serialization.deserialization.descriptors.DeserializedContainerSource;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u00c0\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\"\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000bH\u0016J\u0012\u0010\f\u001a\u0004\u0018\u00010\u00052\u0006\u0010\r\u001a\u00020\u000eH\u0016\u00a8\u0006\u000f"}, d2={"Lorg/jetbrains/kotlin/analysis/low/level/api/fir/stubBased/deserialization/JvmDeserializedContainerSourceProvider;", "Lorg/jetbrains/kotlin/analysis/low/level/api/fir/stubBased/deserialization/DeserializedContainerSourceProvider;", "<init>", "()V", "getFacadeContainerSource", "Lorg/jetbrains/kotlin/serialization/deserialization/descriptors/DeserializedContainerSource;", "file", "Lorg/jetbrains/kotlin/psi/KtFile;", "stubOrigin", "Lorg/jetbrains/kotlin/psi/stubs/impl/KotlinStubOrigin;", "declarationOrigin", "Lorg/jetbrains/kotlin/fir/declarations/FirDeclarationOrigin;", "getClassContainerSource", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "low-level-api-fir"})
public final class JvmDeserializedContainerSourceProvider
implements DeserializedContainerSourceProvider {
    @NotNull
    public static final JvmDeserializedContainerSourceProvider INSTANCE = new JvmDeserializedContainerSourceProvider();

    private JvmDeserializedContainerSourceProvider() {
    }

    @Override
    @NotNull
    public DeserializedContainerSource getFacadeContainerSource(@NotNull KtFile file, @Nullable KotlinStubOrigin stubOrigin, @NotNull FirDeclarationOrigin declarationOrigin) {
        DeserializedContainerSource deserializedContainerSource;
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        Intrinsics.checkNotNullParameter((Object)declarationOrigin, (String)"declarationOrigin");
        KotlinStubOrigin kotlinStubOrigin = stubOrigin;
        if (kotlinStubOrigin instanceof KotlinStubOrigin.Facade) {
            JvmClassName jvmClassName = JvmClassName.byInternalName((String)((KotlinStubOrigin.Facade)stubOrigin).getClassName());
            Intrinsics.checkNotNullExpressionValue((Object)jvmClassName, (String)"byInternalName(...)");
            JvmClassName className = jvmClassName;
            deserializedContainerSource = new JvmStubDeserializedFacadeContainerSource(className, null);
        } else if (kotlinStubOrigin instanceof KotlinStubOrigin.MultiFileFacade) {
            JvmClassName jvmClassName = JvmClassName.byInternalName((String)((KotlinStubOrigin.MultiFileFacade)stubOrigin).getClassName());
            Intrinsics.checkNotNullExpressionValue((Object)jvmClassName, (String)"byInternalName(...)");
            JvmClassName className = jvmClassName;
            JvmClassName jvmClassName2 = JvmClassName.byInternalName((String)((KotlinStubOrigin.MultiFileFacade)stubOrigin).getFacadeClassName());
            Intrinsics.checkNotNullExpressionValue((Object)jvmClassName2, (String)"byInternalName(...)");
            JvmClassName facadeClassName = jvmClassName2;
            deserializedContainerSource = new JvmStubDeserializedFacadeContainerSource(className, facadeClassName);
        } else {
            VirtualFile virtualFile = file.getVirtualFile();
            FqName fqName = file.getPackageFqName();
            Name name = Name.identifier((String)virtualFile.getNameWithoutExtension());
            Intrinsics.checkNotNullExpressionValue((Object)name, (String)"identifier(...)");
            ClassId classId = new ClassId(fqName, name);
            JvmClassName jvmClassName = JvmClassName.byClassId((ClassId)classId);
            Intrinsics.checkNotNullExpressionValue((Object)jvmClassName, (String)"byClassId(...)");
            JvmClassName className = jvmClassName;
            deserializedContainerSource = new JvmStubDeserializedFacadeContainerSource(className, null);
        }
        return deserializedContainerSource;
    }

    @Override
    @Nullable
    public DeserializedContainerSource getClassContainerSource(@NotNull ClassId classId) {
        Intrinsics.checkNotNullParameter((Object)classId, (String)"classId");
        return new JvmStubDeserializedContainerSource(classId);
    }
}

