/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.upload;

import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.Http;
import org.jreleaser.model.api.JReleaserContext;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.upload.HttpUploader;
import org.jreleaser.model.internal.validation.common.HttpValidator;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.CollectionUtils;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class HttpUploaderValidator {
    private HttpUploaderValidator() {
    }

    public static void validateHttpUploader(JReleaserContext context, JReleaserContext.Mode mode, Errors errors) {
        Map<String, HttpUploader> http = context.getModel().getUpload().getHttp();
        if (!http.isEmpty()) {
            context.getLogger().debug("upload.http");
        }
        for (Map.Entry<String, HttpUploader> e : http.entrySet()) {
            e.getValue().setName(e.getKey());
            if (!mode.validateConfig()) continue;
            Errors incoming = new Errors();
            HttpUploaderValidator.validateHttp(context, e.getValue(), incoming);
            Validator.mergeErrors(context, errors, incoming, e.getValue());
        }
    }

    private static void validateHttp(JReleaserContext context, HttpUploader uploader, Errors errors) {
        context.getLogger().debug("upload.http.{}", new Object[]{uploader.getName()});
        Validator.resolveActivatable(context, (Activatable)uploader, CollectionUtils.listOf((Object[])new String[]{"upload.http." + uploader.getName(), "upload.http"}), "NEVER");
        if (!uploader.resolveEnabledWithSnapshot(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        if (!(uploader.isArtifacts() || uploader.isFiles() || uploader.isSignatures())) {
            errors.warning(RB.$((String)"WARNING.validation.uploader.no.artifacts", (Object[])new Object[]{uploader.getType(), uploader.getName()}));
            context.getLogger().debug(RB.$((String)"validation.disabled.no.artifacts", (Object[])new Object[0]));
            uploader.disable();
            return;
        }
        if (StringUtils.isBlank((String)uploader.getUploadUrl())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"upload.http." + uploader.getName() + ".uploadUrl"}));
        }
        if (StringUtils.isBlank((String)uploader.getDownloadUrl())) {
            uploader.setDownloadUrl(uploader.getUploadUrl());
        }
        if (null == uploader.getMethod()) {
            uploader.setMethod(Http.Method.PUT);
        }
        HttpValidator.validateHttp(context, uploader, "upload", uploader.getName(), errors);
        Validator.validateTimeout(uploader);
    }
}

