/*
 * Decompiled with CFR 0.152.
 */
package org.jreleaser.model.internal.validation.hooks;

import java.util.Map;
import org.jreleaser.bundle.RB;
import org.jreleaser.model.internal.JReleaserContext;
import org.jreleaser.model.internal.common.AbstractActivatable;
import org.jreleaser.model.internal.common.Activatable;
import org.jreleaser.model.internal.common.MatrixAware;
import org.jreleaser.model.internal.hooks.JbangHook;
import org.jreleaser.model.internal.hooks.JbangHooks;
import org.jreleaser.model.internal.hooks.NamedJbangHooks;
import org.jreleaser.model.internal.validation.common.MatrixValidator;
import org.jreleaser.model.internal.validation.common.Validator;
import org.jreleaser.util.Errors;
import org.jreleaser.util.StringUtils;

public final class JbangHooksValidator {
    private JbangHooksValidator() {
    }

    public static void validateJbangHooks(JReleaserContext context, Errors errors) {
        JbangHook hook;
        int i;
        context.getLogger().debug("hooks.jbang");
        JbangHooks hooks = context.getModel().getHooks().getJbang();
        boolean activeSet = hooks.isActiveSet();
        Validator.resolveActivatable(context, (Activatable)hooks, "hooks.jbang", "ALWAYS");
        hooks.resolveEnabled(context.getModel().getProject());
        if (hooks.getMatrix().isEmpty()) {
            hooks.setMatrix(context.getModel().getHooks().getMatrix());
        }
        if (hooks.isApplyDefaultMatrix()) {
            hooks.setMatrix(context.getModel().getMatrix());
        }
        MatrixValidator.validateMatrix(context, hooks.getMatrix(), "hooks.jbang.matrix", errors);
        for (i = 0; i < hooks.getBefore().size(); ++i) {
            hook = hooks.getBefore().get(i);
            if (StringUtils.isBlank((String)hook.getVersion())) {
                hook.setVersion(hooks.getVersion());
            }
            JbangHooksValidator.validateJbangHook(context, hooks, hook, "before", i, errors);
        }
        for (i = 0; i < hooks.getSuccess().size(); ++i) {
            hook = hooks.getSuccess().get(i);
            if (StringUtils.isBlank((String)hook.getVersion())) {
                hook.setVersion(hooks.getVersion());
            }
            JbangHooksValidator.validateJbangHook(context, hooks, hook, "success", i, errors);
        }
        for (i = 0; i < hooks.getFailure().size(); ++i) {
            hook = hooks.getFailure().get(i);
            if (StringUtils.isBlank((String)hook.getVersion())) {
                hook.setVersion(hooks.getVersion());
            }
            JbangHooksValidator.validateJbangHook(context, hooks, hook, "failure", i, errors);
        }
        for (Map.Entry<String, NamedJbangHooks> e : hooks.getGroups().entrySet()) {
            NamedJbangHooks namedHooks = e.getValue();
            namedHooks.setName(e.getKey());
            if (StringUtils.isBlank((String)namedHooks.getVersion())) {
                namedHooks.setVersion(hooks.getVersion());
            }
            JbangHooksValidator.validateNamedJbangHooks(context, hooks, namedHooks, errors);
        }
        if (hooks.isEnabled()) {
            boolean enabled;
            boolean bl = enabled = hooks.getBefore().stream().anyMatch(AbstractActivatable::isEnabled) || hooks.getSuccess().stream().anyMatch(AbstractActivatable::isEnabled) || hooks.getFailure().stream().anyMatch(AbstractActivatable::isEnabled) || hooks.getGroups().values().stream().anyMatch(AbstractActivatable::isEnabled);
            if (!activeSet && !enabled) {
                context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
                hooks.disable();
            }
        }
    }

    private static void validateNamedJbangHooks(JReleaserContext context, JbangHooks parentHooks, NamedJbangHooks hooks, Errors errors) {
        JbangHook hook;
        int i;
        context.getLogger().debug("hooks.jbang." + hooks.getName());
        boolean activeSet = hooks.isActiveSet();
        Validator.resolveActivatable(context, (Activatable)hooks, "hooks.jbang." + hooks.getName(), "ALWAYS");
        hooks.resolveEnabled(context.getModel().getProject());
        if (hooks.getMatrix().isEmpty()) {
            hooks.setMatrix(parentHooks.getMatrix());
        }
        if (hooks.isApplyDefaultMatrix()) {
            hooks.setMatrix(context.getModel().getMatrix());
        }
        MatrixValidator.validateMatrix(context, hooks.getMatrix(), "hooks.jbang.matrix", errors);
        for (i = 0; i < hooks.getBefore().size(); ++i) {
            hook = hooks.getBefore().get(i);
            hook.setName(hooks.getName());
            if (StringUtils.isBlank((String)hook.getVersion())) {
                hook.setVersion(hooks.getVersion());
            }
            if (StringUtils.isBlank((String)hook.getScript())) {
                hook.setScript(hooks.getScript());
            }
            JbangHooksValidator.validateJbangHook(context, hooks, hook, hooks.getName() + ".before", i, errors);
        }
        for (i = 0; i < hooks.getSuccess().size(); ++i) {
            hook = hooks.getSuccess().get(i);
            hook.setName(hooks.getName());
            if (StringUtils.isBlank((String)hook.getVersion())) {
                hook.setVersion(hooks.getVersion());
            }
            if (StringUtils.isBlank((String)hook.getScript())) {
                hook.setScript(hooks.getScript());
            }
            JbangHooksValidator.validateJbangHook(context, hooks, hook, hooks.getName() + ".success", i, errors);
        }
        for (i = 0; i < hooks.getFailure().size(); ++i) {
            hook = hooks.getFailure().get(i);
            hook.setName(hooks.getName());
            if (StringUtils.isBlank((String)hook.getVersion())) {
                hook.setVersion(hooks.getVersion());
            }
            if (StringUtils.isBlank((String)hook.getScript())) {
                hook.setScript(hooks.getScript());
            }
            JbangHooksValidator.validateJbangHook(context, hooks, hook, hooks.getName() + ".failure", i, errors);
        }
        if (hooks.isEnabled()) {
            boolean enabled;
            boolean bl = enabled = hooks.getBefore().stream().anyMatch(AbstractActivatable::isEnabled) || hooks.getSuccess().stream().anyMatch(AbstractActivatable::isEnabled) || hooks.getFailure().stream().anyMatch(AbstractActivatable::isEnabled);
            if (!activeSet && !enabled) {
                context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
                hooks.disable();
            }
        }
    }

    private static void validateJbangHook(JReleaserContext context, MatrixAware matrixProvider, JbangHook hook, String type, int index, Errors errors) {
        context.getLogger().debug("hooks.jbang.{}[{}]", new Object[]{type, index});
        Validator.resolveActivatable(context, (Activatable)hook, "hooks.jbang." + type + "." + index, "ALWAYS");
        if (!hook.resolveEnabled(context.getModel().getProject())) {
            context.getLogger().debug(RB.$((String)"validation.disabled", (Object[])new Object[0]));
            return;
        }
        if (hook.getMatrix().isEmpty()) {
            hook.setMatrix(matrixProvider.getMatrix());
        }
        if (hook.isApplyDefaultMatrix()) {
            hook.setMatrix(context.getModel().getMatrix());
        }
        MatrixValidator.validateMatrix(context, hook.getMatrix(), "hooks.jbang." + type + "[" + index + "].matrix", errors);
        if (StringUtils.isBlank((String)hook.getScript())) {
            errors.configuration(RB.$((String)"validation_must_not_be_blank", (Object[])new Object[]{"hook.script"}));
        }
    }
}

