/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.com.intellij.util;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.function.Function;
import java.util.function.Supplier;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.util.ExceptionUtilRt;
import org.jetbrains.kotlin.com.intellij.util.ThrowableRunnable;
import org.jetbrains.kotlin.com.intellij.util.containers.ContainerUtil;

public final class ExceptionUtil
extends ExceptionUtilRt {
    @NotNull
    public static Throwable getRootCause(@NotNull Throwable e2) {
        if (e2 == null) {
            ExceptionUtil.$$$reportNull$$$0(0);
        }
        while (true) {
            if (e2.getCause() == null) {
                Throwable throwable = e2;
                if (throwable == null) {
                    ExceptionUtil.$$$reportNull$$$0(1);
                }
                return throwable;
            }
            e2 = e2.getCause();
        }
    }

    public static <T> List<T> findCauseAndSuppressed(@NotNull Throwable error, @NotNull Class<T> klass) {
        if (error == null) {
            ExceptionUtil.$$$reportNull$$$0(2);
        }
        if (klass == null) {
            ExceptionUtil.$$$reportNull$$$0(3);
        }
        LinkedHashSet<Throwable> allThrowables = new LinkedHashSet<Throwable>();
        ArrayDeque<Throwable> deque = new ArrayDeque<Throwable>();
        deque.add(error);
        while (!deque.isEmpty()) {
            Throwable t2 = (Throwable)deque.removeFirst();
            if (!allThrowables.add(t2)) continue;
            for (Throwable cause = t2.getCause(); cause != null; cause = cause.getCause()) {
                deque.addLast(cause);
            }
            for (Throwable s2 : t2.getSuppressed()) {
                deque.addLast(s2);
            }
        }
        return ContainerUtil.filterIsInstance(allThrowables, klass);
    }

    @NotNull
    public static Throwable makeStackTraceRelative(@NotNull Throwable th, @NotNull Throwable relativeTo) {
        if (th == null) {
            ExceptionUtil.$$$reportNull$$$0(4);
        }
        if (relativeTo == null) {
            ExceptionUtil.$$$reportNull$$$0(5);
        }
        StackTraceElement[] trace = th.getStackTrace();
        StackTraceElement[] rootTrace = relativeTo.getStackTrace();
        int len = Math.min(trace.length, rootTrace.length);
        for (int i2 = 0; i2 < len; ++i2) {
            if (trace[trace.length - i2 - 1].equals(rootTrace[rootTrace.length - i2 - 1])) continue;
            int newDepth = trace.length - i2;
            th.setStackTrace(Arrays.copyOf(trace, newDepth));
            break;
        }
        Throwable throwable = th;
        if (throwable == null) {
            ExceptionUtil.$$$reportNull$$$0(6);
        }
        return throwable;
    }

    @NotNull
    public static String currentStackTrace() {
        return ExceptionUtil.getThrowableText(new Throwable());
    }

    @NotNull
    public static String getThrowableText(@NotNull Throwable t2) {
        if (t2 == null) {
            ExceptionUtil.$$$reportNull$$$0(7);
        }
        StringWriter writer = new StringWriter();
        t2.printStackTrace(new PrintWriter(writer));
        String string = writer.getBuffer().toString();
        if (string == null) {
            ExceptionUtil.$$$reportNull$$$0(8);
        }
        return string;
    }

    @Nullable
    public static String getMessage(@NotNull Throwable e2) {
        if (e2 == null) {
            ExceptionUtil.$$$reportNull$$$0(15);
        }
        String result2 = e2.getMessage();
        String exceptionPattern = "Exception: ";
        String errorPattern = "Error: ";
        while (e2.getCause() != null && (result2 == null || result2.contains(exceptionPattern) || result2.contains(errorPattern))) {
            e2 = e2.getCause();
            result2 = e2.getMessage();
        }
        if (result2 != null) {
            result2 = ExceptionUtil.extractMessage(result2, exceptionPattern);
            result2 = ExceptionUtil.extractMessage(result2, errorPattern);
        }
        return result2;
    }

    @NotNull
    private static String extractMessage(@NotNull String result2, @NotNull String errorPattern) {
        if (result2 == null) {
            ExceptionUtil.$$$reportNull$$$0(16);
        }
        if (errorPattern == null) {
            ExceptionUtil.$$$reportNull$$$0(17);
        }
        if (result2.lastIndexOf(errorPattern) >= 0) {
            result2 = result2.substring(result2.lastIndexOf(errorPattern) + errorPattern.length());
        }
        String string = result2;
        if (string == null) {
            ExceptionUtil.$$$reportNull$$$0(18);
        }
        return string;
    }

    public static void rethrowUnchecked(@Nullable Throwable t2) throws RuntimeException, Error {
        ExceptionUtilRt.rethrowUnchecked(t2);
    }

    @Contract(value="_->fail")
    public static void rethrow(@Nullable Throwable throwable) throws RuntimeException, Error {
        ExceptionUtil.rethrowUnchecked(throwable);
        throw new RuntimeException(throwable);
    }

    @Contract(value="!null->fail")
    public static void rethrowAllAsUnchecked(@Nullable Throwable t2) throws RuntimeException, Error {
        if (t2 != null) {
            ExceptionUtil.rethrow(t2);
        }
    }

    @Nullable
    public static Exception runAndCatch(@NotNull ThrowableRunnable<? extends Exception> runnable) {
        if (runnable == null) {
            ExceptionUtil.$$$reportNull$$$0(22);
        }
        try {
            runnable.run();
            return null;
        }
        catch (Exception e2) {
            return e2;
        }
    }

    @SafeVarargs
    public static <E extends Exception> void runAllAndRethrowAllExceptions(@NotNull Class<? extends E> exampleClass, @NotNull Supplier<E> exampleSupplier, ThrowableRunnable<? extends Exception> ... potentiallyFailingTasks) throws E {
        if (exampleClass == null) {
            ExceptionUtil.$$$reportNull$$$0(23);
        }
        if (exampleSupplier == null) {
            ExceptionUtil.$$$reportNull$$$0(24);
        }
        if (potentiallyFailingTasks == null) {
            ExceptionUtil.$$$reportNull$$$0(25);
        }
        Function<List, Exception> combiner = exceptions -> {
            Throwable exception = null;
            for (Throwable e2 : exceptions) {
                if (exception == null) {
                    if (exampleClass.isAssignableFrom(e2.getClass())) {
                        exception = (Exception)e2;
                        continue;
                    }
                    exception = (Exception)exampleSupplier.get();
                    exception.addSuppressed(e2);
                    continue;
                }
                exception.addSuppressed(e2);
            }
            return exception;
        };
        ExceptionUtil.runAllAndRethrowAllExceptions(combiner, potentiallyFailingTasks);
    }

    @SafeVarargs
    @ApiStatus.Internal
    public static <E extends Exception> void runAllAndRethrowAllExceptions(@NotNull Function<List<? extends Throwable>, E> exceptionsCombiner, ThrowableRunnable<? extends Exception> ... potentiallyFailingTasks) throws E {
        if (exceptionsCombiner == null) {
            ExceptionUtil.$$$reportNull$$$0(26);
        }
        if (potentiallyFailingTasks == null) {
            ExceptionUtil.$$$reportNull$$$0(27);
        }
        ArrayList<Throwable> exceptions = null;
        for (ThrowableRunnable<? extends Exception> potentiallyFailingTask : potentiallyFailingTasks) {
            try {
                potentiallyFailingTask.run();
            }
            catch (Throwable e2) {
                if (exceptions == null) {
                    exceptions = new ArrayList<Throwable>();
                }
                exceptions.add(e2);
            }
        }
        if (exceptions != null) {
            throw (Exception)exceptionsCombiner.apply(exceptions);
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n2) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n3;
        String string;
        switch (n2) {
            default: {
                string = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 21: {
                string = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n2) {
            default: {
                n3 = 3;
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 21: {
                n3 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n3];
        switch (n2) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "e";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/com/intellij/util/ExceptionUtil";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "error";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "klass";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "th";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "relativeTo";
                break;
            }
            case 7: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "t";
                break;
            }
            case 9: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "aThrowable";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "stackFrameSkipPattern";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "errorPattern";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "defaultMessage";
                break;
            }
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "runnable";
                break;
            }
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exampleClass";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exampleSupplier";
                break;
            }
            case 25: 
            case 27: {
                objectArray2 = objectArray3;
                objectArray3[0] = "potentiallyFailingTasks";
                break;
            }
            case 26: {
                objectArray2 = objectArray3;
                objectArray3[0] = "exceptionsCombiner";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/com/intellij/util/ExceptionUtil";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootCause";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "makeStackTraceRelative";
                break;
            }
            case 8: 
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getThrowableText";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getUserStackTrace";
                break;
            }
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "extractMessage";
                break;
            }
            case 21: {
                objectArray = objectArray2;
                objectArray2[1] = "getNonEmptyMessage";
                break;
            }
        }
        switch (n2) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getRootCause";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 21: {
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "findCauseAndSuppressed";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "makeStackTraceRelative";
                break;
            }
            case 7: 
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getThrowableText";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getUserStackTrace";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "getMessage";
                break;
            }
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "extractMessage";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getNonEmptyMessage";
                break;
            }
            case 22: {
                objectArray = objectArray;
                objectArray[2] = "runAndCatch";
                break;
            }
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: {
                objectArray = objectArray;
                objectArray[2] = "runAllAndRethrowAllExceptions";
                break;
            }
        }
        String string2 = String.format(string, objectArray);
        switch (n2) {
            default: {
                runtimeException = new IllegalArgumentException(string2);
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 11: 
            case 13: 
            case 14: 
            case 18: 
            case 21: {
                runtimeException = new IllegalStateException(string2);
                break;
            }
        }
        throw runtimeException;
    }
}

