/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.cache.internal;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.util.Map;
import java.util.Properties;
import java.util.function.Consumer;
import org.apache.commons.io.FileUtils;
import org.gradle.cache.CacheCleanupStrategy;
import org.gradle.cache.FileLock;
import org.gradle.cache.FileLockManager;
import org.gradle.cache.LockOptions;
import org.gradle.cache.PersistentCache;
import org.gradle.cache.internal.CacheInitializationAction;
import org.gradle.cache.internal.DefaultPersistentDirectoryStore;
import org.gradle.cache.internal.ReferencablePersistentCache;
import org.gradle.internal.concurrent.ExecutorFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultPersistentDirectoryCache
extends DefaultPersistentDirectoryStore
implements ReferencablePersistentCache {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultPersistentDirectoryCache.class);
    private final Properties properties = new Properties();
    private final Consumer<? super PersistentCache> initAction;

    public DefaultPersistentDirectoryCache(File dir, String displayName, Map<String, ?> properties, LockOptions lockOptions, Consumer<? super PersistentCache> initAction, CacheCleanupStrategy cacheCleanupStrategy, FileLockManager lockManager, ExecutorFactory executorFactory) {
        super(dir, displayName, lockOptions, cacheCleanupStrategy, lockManager, executorFactory);
        this.initAction = initAction;
        this.properties.putAll(properties);
    }

    @Override
    protected CacheInitializationAction getInitAction() {
        return new Initializer();
    }

    public Properties getProperties() {
        return this.properties;
    }

    private class Initializer
    implements CacheInitializationAction {
        private Initializer() {
        }

        @Override
        public boolean requiresInitialization(FileLock lock) {
            if (!lock.getUnlockedCleanly()) {
                if (lock.getState().canDetectChanges() && !lock.getState().isInInitialState()) {
                    LOGGER.warn("Invalidating {} as it was not closed cleanly.", (Object)DefaultPersistentDirectoryCache.this);
                }
                return true;
            }
            if (!DefaultPersistentDirectoryCache.this.properties.isEmpty()) {
                if (!DefaultPersistentDirectoryCache.this.propertiesFile.exists()) {
                    LOGGER.debug("Invalidating {} as cache properties file {} is missing and cache properties are not empty.", (Object)DefaultPersistentDirectoryCache.this, (Object)DefaultPersistentDirectoryCache.this.propertiesFile.getAbsolutePath());
                    return true;
                }
                Properties cachedProperties = new Properties();
                try (FileInputStream propertiesInputStream = new FileInputStream(DefaultPersistentDirectoryCache.this.propertiesFile);){
                    cachedProperties.load(propertiesInputStream);
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
                for (Map.Entry<Object, Object> entry : DefaultPersistentDirectoryCache.this.properties.entrySet()) {
                    String previousValue = cachedProperties.getProperty(entry.getKey().toString());
                    String currentValue = entry.getValue().toString();
                    if (currentValue.equals(previousValue)) continue;
                    LOGGER.debug("Invalidating {} as cache property {} has changed from {} to {}.", new Object[]{DefaultPersistentDirectoryCache.this, entry.getKey(), previousValue, currentValue});
                    return true;
                }
            }
            return false;
        }

        @Override
        public void initialize(FileLock fileLock) {
            try {
                File[] files = DefaultPersistentDirectoryCache.this.getBaseDir().listFiles();
                if (files == null) {
                    throw new IOException("Cannot list files in " + DefaultPersistentDirectoryCache.this.getBaseDir());
                }
                for (File file : files) {
                    if (fileLock.isLockFile(file) || file.equals(DefaultPersistentDirectoryCache.this.propertiesFile)) continue;
                    FileUtils.forceDelete((File)file);
                }
                DefaultPersistentDirectoryCache.this.initAction.accept(DefaultPersistentDirectoryCache.this);
                try (FileOutputStream propertiesFileOutputStream = new FileOutputStream(DefaultPersistentDirectoryCache.this.propertiesFile);){
                    DefaultPersistentDirectoryCache.this.properties.store(propertiesFileOutputStream, null);
                }
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

