/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.tasks.javadoc;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nullable;
import javax.inject.Inject;
import org.gradle.api.InvalidUserDataException;
import org.gradle.api.UncheckedIOException;
import org.gradle.api.file.FileCollection;
import org.gradle.api.file.FileSystemOperations;
import org.gradle.api.file.FileTree;
import org.gradle.api.internal.file.temp.TemporaryFileProvider;
import org.gradle.api.internal.project.IsolatedAntBuilder;
import org.gradle.api.internal.tasks.AntGroovydoc;
import org.gradle.api.internal.tasks.GroovydocAntAction;
import org.gradle.api.logging.LogLevel;
import org.gradle.api.provider.Property;
import org.gradle.api.resources.TextResource;
import org.gradle.api.tasks.CacheableTask;
import org.gradle.api.tasks.Classpath;
import org.gradle.api.tasks.Input;
import org.gradle.api.tasks.Internal;
import org.gradle.api.tasks.Nested;
import org.gradle.api.tasks.Optional;
import org.gradle.api.tasks.OutputDirectory;
import org.gradle.api.tasks.PathSensitive;
import org.gradle.api.tasks.PathSensitivity;
import org.gradle.api.tasks.SourceTask;
import org.gradle.api.tasks.TaskAction;
import org.gradle.api.tasks.javadoc.GroovydocAccess;
import org.gradle.internal.deprecation.DeprecationLogger;
import org.gradle.internal.deprecation.DeprecationMessageBuilder;
import org.gradle.internal.file.Deleter;
import org.gradle.internal.instrumentation.api.annotations.NotToBeReplacedByLazyProperty;
import org.gradle.internal.instrumentation.api.annotations.ToBeReplacedByLazyProperty;
import org.gradle.workers.WorkerExecutor;

@CacheableTask
public abstract class Groovydoc
extends SourceTask {
    private FileCollection groovyClasspath;
    private FileCollection classpath;
    private File destinationDir;
    private AntGroovydoc antGroovydoc;
    private boolean use;
    private boolean noTimestamp = true;
    private boolean noVersionStamp = true;
    private String windowTitle;
    private String docTitle;
    private String header;
    private String footer;
    private TextResource overview;
    private Set<Link> links = new LinkedHashSet<Link>();
    private final Property<GroovydocAccess> access = this.getProject().getObjects().property(GroovydocAccess.class);
    private final Property<Boolean> includeAuthor = this.getProject().getObjects().property(Boolean.class);
    private final Property<Boolean> processScripts = this.getProject().getObjects().property(Boolean.class);
    private final Property<Boolean> includeMainForScripts = this.getProject().getObjects().property(Boolean.class);

    public Groovydoc() {
        this.getLogging().captureStandardOutput(LogLevel.INFO);
    }

    @Inject
    protected abstract WorkerExecutor getWorkerExecutor();

    @TaskAction
    protected void generate() {
        this.checkGroovyClasspathNonEmpty(this.getGroovyClasspath().getFiles());
        File destinationDir = this.getDestinationDir();
        try {
            this.getDeleter().ensureEmptyDirectory(destinationDir);
        }
        catch (IOException ex) {
            throw new UncheckedIOException((Throwable)ex);
        }
        FileSystemOperations fsOperations = (FileSystemOperations)this.getServices().get(FileSystemOperations.class);
        File tmpDir = this.getTemporaryDir();
        fsOperations.delete(spec -> spec.delete(new Object[]{tmpDir}));
        fsOperations.copy(spec -> spec.from(new Object[]{this.getSource()}).into((Object)tmpDir));
        this.getWorkerExecutor().classLoaderIsolation().submit(GroovydocAntAction.class, parameters -> {
            parameters.getAntLibraryClasspath().from(new Object[]{this.getClasspath()});
            parameters.getAntLibraryClasspath().from(new Object[]{this.getGroovyClasspath()});
            parameters.getSource().convention((Iterable)this.getSource());
            parameters.getDestinationDirectory().fileValue(destinationDir);
            parameters.getUse().convention((Object)this.isUse());
            parameters.getNoTimestamp().convention((Object)this.isNoTimestamp());
            parameters.getNoVersionStamp().convention((Object)this.isNoVersionStamp());
            parameters.getWindowTitle().convention((Object)this.getWindowTitle());
            parameters.getDocTitle().convention((Object)this.getDocTitle());
            parameters.getHeader().convention((Object)this.getHeader());
            parameters.getFooter().convention((Object)this.getFooter());
            parameters.getOverview().convention((Object)this.getPathToOverview());
            parameters.getAccess().convention(this.getAccess());
            parameters.getLinks().convention(this.getLinks());
            parameters.getTmpDir().fileValue(this.getTemporaryDir());
            parameters.getIncludeAuthor().convention(this.getIncludeAuthor());
            parameters.getProcessScripts().convention(this.getProcessScripts());
            parameters.getIncludeMainForScripts().convention(this.getIncludeMainForScripts());
        });
    }

    @Nullable
    private String getPathToOverview() {
        TextResource overview = this.getOverviewText();
        if (overview != null) {
            return overview.asFile().getAbsolutePath();
        }
        return null;
    }

    private void checkGroovyClasspathNonEmpty(Collection<File> classpath) {
        if (classpath.isEmpty()) {
            throw new InvalidUserDataException("You must assign a Groovy library to the groovy configuration!");
        }
    }

    @PathSensitive(value=PathSensitivity.RELATIVE)
    @ToBeReplacedByLazyProperty
    public FileTree getSource() {
        return super.getSource();
    }

    @OutputDirectory
    @ToBeReplacedByLazyProperty
    public File getDestinationDir() {
        return this.destinationDir;
    }

    public void setDestinationDir(File destinationDir) {
        this.destinationDir = destinationDir;
    }

    @Classpath
    @ToBeReplacedByLazyProperty
    public FileCollection getGroovyClasspath() {
        return this.groovyClasspath;
    }

    public void setGroovyClasspath(FileCollection groovyClasspath) {
        this.groovyClasspath = groovyClasspath;
    }

    @Classpath
    @ToBeReplacedByLazyProperty
    public FileCollection getClasspath() {
        return this.classpath;
    }

    public void setClasspath(FileCollection classpath) {
        this.classpath = classpath;
    }

    @Internal
    @Deprecated
    @NotToBeReplacedByLazyProperty(because="it's going to be removed")
    public AntGroovydoc getAntGroovydoc() {
        ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.deprecateMethod(Groovydoc.class, (String)"getAntGroovydoc()").willBeRemovedInGradle9().withUpgradeGuideSection(8, "antgroovydoc")).nagUser();
        if (this.antGroovydoc == null) {
            IsolatedAntBuilder antBuilder = (IsolatedAntBuilder)this.getServices().get(IsolatedAntBuilder.class);
            TemporaryFileProvider temporaryFileProvider = (TemporaryFileProvider)this.getServices().get(TemporaryFileProvider.class);
            this.antGroovydoc = new AntGroovydoc(antBuilder, temporaryFileProvider);
        }
        return this.antGroovydoc;
    }

    @Deprecated
    public void setAntGroovydoc(AntGroovydoc antGroovydoc) {
        ((DeprecationMessageBuilder.WithDocumentation)DeprecationLogger.deprecateMethod(((Object)((Object)this)).getClass(), (String)"setAntGroovydoc(AntGroovydoc)").willBeRemovedInGradle9().withUpgradeGuideSection(8, "antgroovydoc")).nagUser();
        this.antGroovydoc = antGroovydoc;
    }

    @Input
    @ToBeReplacedByLazyProperty
    public boolean isUse() {
        return this.use;
    }

    public void setUse(boolean use) {
        this.use = use;
    }

    @Input
    @ToBeReplacedByLazyProperty
    public boolean isNoTimestamp() {
        return this.noTimestamp;
    }

    public void setNoTimestamp(boolean noTimestamp) {
        this.noTimestamp = noTimestamp;
    }

    @Input
    @ToBeReplacedByLazyProperty
    public boolean isNoVersionStamp() {
        return this.noVersionStamp;
    }

    public void setNoVersionStamp(boolean noVersionStamp) {
        this.noVersionStamp = noVersionStamp;
    }

    @Nullable
    @Optional
    @Input
    @ToBeReplacedByLazyProperty
    public String getWindowTitle() {
        return this.windowTitle;
    }

    public void setWindowTitle(@Nullable String windowTitle) {
        this.windowTitle = windowTitle;
    }

    @Nullable
    @Optional
    @Input
    @ToBeReplacedByLazyProperty
    public String getDocTitle() {
        return this.docTitle;
    }

    public void setDocTitle(@Nullable String docTitle) {
        this.docTitle = docTitle;
    }

    @Nullable
    @Optional
    @Input
    @ToBeReplacedByLazyProperty
    public String getHeader() {
        return this.header;
    }

    public void setHeader(@Nullable String header) {
        this.header = header;
    }

    @Nullable
    @Optional
    @Input
    @ToBeReplacedByLazyProperty
    public String getFooter() {
        return this.footer;
    }

    public void setFooter(@Nullable String footer) {
        this.footer = footer;
    }

    @Nullable
    @Optional
    @Nested
    public TextResource getOverviewText() {
        return this.overview;
    }

    public void setOverviewText(@Nullable TextResource overviewText) {
        this.overview = overviewText;
    }

    @Input
    public Property<GroovydocAccess> getAccess() {
        return this.access;
    }

    @Input
    public Property<Boolean> getIncludeAuthor() {
        return this.includeAuthor;
    }

    @Input
    public Property<Boolean> getProcessScripts() {
        return this.processScripts;
    }

    @Input
    public Property<Boolean> getIncludeMainForScripts() {
        return this.includeMainForScripts;
    }

    @Input
    @ToBeReplacedByLazyProperty
    public Set<Link> getLinks() {
        return Collections.unmodifiableSet(this.links);
    }

    public void setLinks(Set<Link> links) {
        this.links = links;
    }

    public void link(String url, String ... packages) {
        this.links.add(new Link(url, packages));
    }

    @Inject
    protected Deleter getDeleter() {
        throw new UnsupportedOperationException("Decorator takes care of injection");
    }

    public static class Link
    implements Serializable {
        private List<String> packages = new ArrayList<String>();
        private String url;

        public Link(String url, String ... packages) {
            this.throwExceptionIfNull(url, "Url must not be null");
            if (packages.length == 0) {
                throw new InvalidUserDataException("You must specify at least one package!");
            }
            for (String aPackage : packages) {
                this.throwExceptionIfNull(aPackage, "A package must not be null");
            }
            this.packages = Arrays.asList(packages);
            this.url = url;
        }

        private void throwExceptionIfNull(String value, String message) {
            if (value == null) {
                throw new InvalidUserDataException(message);
            }
        }

        public List<String> getPackages() {
            return Collections.unmodifiableList(this.packages);
        }

        public String getUrl() {
            return this.url;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Link link = (Link)o;
            if (this.packages != null ? !this.packages.equals(link.packages) : link.packages != null) {
                return false;
            }
            return !(this.url != null ? !this.url.equals(link.url) : link.url != null);
        }

        public int hashCode() {
            int result = this.packages != null ? this.packages.hashCode() : 0;
            result = 31 * result + (this.url != null ? this.url.hashCode() : 0);
            return result;
        }
    }
}

