C
C   Copyright (c) 1997 Silvano Bonazzola
C
C    This file is part of LORENE.
C
C    LORENE is free software; you can redistribute it and/or modify
C    it under the terms of the GNU General Public License as published by
C    the Free Software Foundation; either version 2 of the License, or
C    (at your option) any later version.
C
C    LORENE is distributed in the hope that it will be useful,
C    but WITHOUT ANY WARRANTY; without even the implied warranty of
C    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
C    GNU General Public License for more details.
C
C    You should have received a copy of the GNU General Public License
C    along with LORENE; if not, write to the Free Software
C    Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
C
C
 	SUBROUTINE INECOS(N,NDIM,NEQ,ICON,CI,AA,BB,CC,DEN)

	IMPLICIT double PRECISION (A-H,O-Z)
C
C $Id: inecos.f,v 1.2 2012/03/30 12:12:43 j_novak Exp $
C $Log: inecos.f,v $
C Revision 1.2  2012/03/30 12:12:43  j_novak
C Cleaning of fortran files
C
C Revision 1.1.1.1  2001/11/20 15:19:30  e_gourgoulhon
C LORENE
C
c Revision 1.1  1997/10/30  14:21:41  novak
c Initial revision
c
C $Header: /cvsroot/Lorene/F77/Source/Poisson2d/inecos.f,v 1.2 2012/03/30 12:12:43 j_novak Exp $
C
C
	character*120 header
	data header/'$Header: /cvsroot/Lorene/F77/Source/Poisson2d/inecos.f,v 1.2 2012/03/30 12:12:43 j_novak Exp $'/

C
C## version du 01/07/96: correction ligne 1808
C	derniere dimension des tableaux avec *
C
C
C		ROUTINE POUR L'INVERSION DE L'OPERATEUR
C	
C	IDENTITE-COEF(12)*COEF(13)*{ [COEF(1)+X*COEF(2)+X**2*COEF(3)]*D2/dr2
C
C	                           +[COEF(4)+COEF(5)*X+
C				     COEF(6)/(COEF(10)+COEF(11)*X)]*D/dr
C
C				   +[COEF(7)+COEF(8)/(COEF(10)+COEF(11)*X)+ 	
C       
C			            COEF(9)/(COEF(10)+COEF(11)*X)**2]*IDENTITE }
C	
C			OU r EST LA VARIABLE r=COEF(10)+COEF(11)*X
C
C		LA ROUTINE INVERSE UN NOMBRE D'EQUATION NEQ SIMULTANEMENT.
C		LES CONDITIONS AUX LIMITES SONT LES SUIVANTES:
C		A GAUCHE DE L'INTERVALLE 
C		
C		CI(LEQ,1)+CI(LEQ,2)*D/dX = CI(LEQ,3)
C
C		A DROITE DE L'INTERVALLE
C			
C		CI(LEQ,4)+CI(LEQ,5)*D/dx = CI(LEQ,6)
C
C		OU LEQ EST L'INDICE QUI NUMEROTE LES NEQ SOLUTIONS.
C
C		SI CI(2,1)=0, CI(2,2)=0,CI(2,4)=0,CI(2,5)=0 CELA SIGNIFIE
C		QUE  LES COEFFICICIENTS CI(LEQ,1),CI(LEQ,2),CI(LEQ,4)
C		CI(LEQ,5) NE DEPENDENT PAS DE LEQ. CELA PERMET UNE ECONOMIE
C		DE TEMPS CALCUL.
C
C		CETTE ROUTINE EST PAR CONSEQUENT ADAPTEE' A RESOUDRE 
C		LES PROBLEMES EN COORDONNEES SPHERIQUES DANS UNE COQUILLE 
C		DE RAYON INTERNE=COEF(10) ET RAYON EXTERNE=COEF(10)+2*COEF(11)
C		DANS LE CAS R2=0, LA ROUTINE TRAITE LE PROBLEME PLAN DU 1ER
C		ET 2ME ORDRE.
C
C	 LA MATRICE DE L'OPERATEUR EST CALCULEE AVEC LES ROUTINES MAECOS
C	 ET MTECOS. LA ROUTINE MAECOS EST COMPLETEMENT TRANSPARENTE POUR
C	 L'UTILISATEUR QUI NE DEVRA PAR CONSEQUENT QU'APPELER MTECOS AVANT
C	 D'APPELER LA PRESENTE ROUTINE.
C
C		LE TEST DES DIMENSIONS A ETE EXECUTE. (VOIR MAIN TECOQM)
C
C	ARGUMENTS DE LA ROUTINE:
C
C		N	=NOMBRE DES DEGRES DE LIBERTE-1
C		NDIM	=DIMENSION DES TABLEAUX COMME DECLAREES DANS LE
C			 PROGRAMME APPELANT.
C		NEQ	=NOMBRE DES EQUATIONS A RESOUDRE SIMULTANEMENT.
C		ICON	=DRAPEAU:
C
C			 ICON=0  LA ROUTINE CALCULE UNE SOLUTION DU SYSTEME
C				 SANS AUCUNE CONDITION AU CONTOUR.   
C			 ICON=1  LA ROUTINE CALCULE UNE SOLUTION DU SYSTEME
C				 SATISFAISANT A UNE CONDITION AU CONTOUR
C				 A GAUCHE DE L INTERVALLE.
C		         ICON=2	 COMME POUR ICON=1, MAIS SATISFAISANT
C				 UNE CONDITION AU CONTOUR A DROITE DE
C			         L'INTERVALLE.
C                        ICON=3  LA SOLUTION SATISFAIT LES CONDITIONS
C				 A GAUCHE ET A DROITE.
C			 ICON=4  LA ROUTINE CALCULE UNE SOLUTION PARTI-
C				 CULIERE ET UNE SOLUTION LIBRE DU SYSTEME.
C				 CETTE DERNIERE PEUT ETRE UTILISEE
C				 POUR SATISFAIRE A UNE CONDITION AUX LIMITES
C			         PLUS GENERALE QUE CELLES INDIQUEES PLUS
C				 HAUT.
C			 ICON=5	 LA ROUTINE CALCULE UNE SOLUTION
C				 PARTICULIERE DU SYSTEME ET 2 SOLUTIONS
C				 LIBRES. CES DEUX DERNIERES PEUVENT ETRE
C				 UTILISEES POUR SATISFAIRE A DES
C				 CONDITIONS AU CONTOUR A GAUCHE EST A 
C				 DROITE DE L'INTERVALLE
C
C				
C		CI(LEQ,I) COEFFICIENTS DES CONDITIONS AUX LIMITES.
C			  LES CONDITIONS AUX LIMITES SONT DU TYPE:
C			  POUR LES CONDITIONS A GAUCHE DE L'INTERVALLE
C
C		         CI(LEQ,1)*DEN(LEQ,0)+CI(LEQ,2)*D/drDEN(LEQ,0)
C			 =CI(LEQ,3) 	
C
C			  ET 
C
C		         CI(LEQ,4)*DEN(LEQ,2)+CI(LEQ,5)*D/drDEN(LEQ,2)
C			 =CI(LEQ,6) 	
C
C			 POUR LES CONDITIONS A DROITE DE L'INTERVALLE
C
C		AA	=TABLEAU DE TRAVAIL: DIMENSIONS MINIMES AA(N1,9)
C		BB	=TABLEAU CONTENANT LA MATRICE DE L'OPERATEUR.
C			 CE TABLEAU EST FOURNI PAR LA ROUTINE MAECOS.
C		         DIMENSION MINIMES BB(N1+4,21) DANS LE CAS LE
C			 PLUS DEFAVORABLE (CAS DE LA COQUILLE AVEC 2
C			 CONDITIONS AU CONTOUR ET BB(N1+4,6) DANS LE CAS
C			 LE PLUS FAVORABLE (CAS PLAT SENS CONDITIONS AU
C			 CONTOUR. POUR PLUS DE DETAILS VOIR ROUTINE
C			 INECOS
C
C		CC	=TABLEAU INPUT. DIMENSIONS MINIMES CC(N1+4,NEQ+2)
C		DEN	=TABLEAU OUTPUT. MEMES DIMENSIONS QUE CC
C
C
	DIMENSION AA(NDIM,*),BB(NDIM,*),CC(NDIM,*),DEN(NDIM,*),CI(NDIM,*)
	DIMENSION CIC(4)
C
C
	DATA ICONC,JCONC,JBCC,NCON,CIC /-1,-1,0,0,0,0,0,0/
C##
	SAVE CIC,X0,XSC,X1,ICONC,JCONC,JBCC,NCON
C
	N1=N+1
C
	IF(N.LT.8) THEN
	PRINT*,'LE NOMBRE MINIMUM DES DEGRES DE LIBERTE EST 9, N1=',N1
	CALL EXIT
	ENDIF
C
	IF(ICON.LT.0.OR.ICON.GT.5) THEN
	PRINT*,'ROUTINE INECOS'
	PRINT*,' LE DRAPEAU ICON EST OUT OF RANGE: ICON=',ICON
	CALL EXIT
	ENDIF
C	
	IF(N.NE.NCON) THEN
C
C		ON DETERMINE SI LA ROUTINE TRAVAILLE EN SIMPLE
C		OU DOUBLE PRECISION
C
	IF(NCON.EQ.0) THEN
	X0=0
	X1=1
	XSC=1.E-12
	IF(1+XSC.EQ.X1) XSC=1.E-06 
	ENDIF
C
	JOB=0
	NCON=N
C
	IF(NDIM.LT.N1+4.AND.NDIM.LT.NEQ+2) THEN
	PRINT*,'ROUTINE INECOS: LES DIMENSIONS DES TABLEAUX CC,DEN'
	PRINT*,'BB NE SONT PAS SUFFISANTES'
	CALL EXIT
	ENDIF
	ENDIF
C
C		CALCUL DES PARAMETRES NECESSAIRES A LA SOLUTION DU SYSTEME
C
	JCON=ICON
	IF(ICON.EQ.3) JCON=4
	IF(ICON.EQ.4) JCON=3
	IDEG=BB(N1+1,1)
	JOB=BB(N1+1,2)
	IDEL=BB(N1+1,6)
C
	IF(IDEG.GT.310.AND.IDEG.LE.320) GO TO 700
	PRINT 101
	PRINT*,' ROUTINE INECOS'
	PRINT*,'LA ROUTINE MAECOS N''A PAS ETE APPELE AVANT'
	PRINT*,' L''APPEL DE CETTE ROUTINE'
	CALL EXIT
  700	CONTINUE
C
	IF(IDEG.LT.313) THEN
	PRINT*,'ROUTINE INECOS: LES CAS IDEG=311,312 NE SONT PAS ENCORE'
	PRINT*,'IMPLEMENTES, IDEG=',IDEG
	CALL EXIT
	ENDIF
C
C		TEST POUR DETERMINER SI TOUS LES COEFFICIENTS DES
C		CONDITIONS AU CONTOUR SONT IDENTIQUES.
C
	JBC=0
C
	IF(CI(2,1).EQ.X0.AND.CI(2,2).EQ.X0) JBC=1
C
	R1=BB(N1+1,4)
	R2=BB(N1+1,5)
C
C		JOB,JOB2,JOB3 SONT DES DRAPEAUX: JOB EST = 0 LORSQUE ON
C		APPELE LA ROUTINE POUR LA PREMIERE FOIS APRES AVOIR
C		APPELE LA ROUTINE MTECOS. CE DRAPEAU EST UTILISE' DANS
C		LA ROUTINE LEQTL1S. SI JOB=0 LA MATRICE DE L'OPERATEUR
C		EST MISE SOUS FORME TRIANGULAIRE. SI JOB =2 LA DECOMPOSI-
C		TION DE LA MATRICE EST SUPPOSEE ETRE DEJA EXECUTEE.
C
C		JOB2 ET JOB3 SONT DES DRAPEAUX UTILISEES DANS LA ROUTINE
C		QUI UTILISE LES SOLUTIONS LIBRES POUR SATISFAIRE AUX
C		CONDITIONS AU CONTOUR. SI JOB3=2, ON SUPPOSE L'EXISTENCE
C		DES SOLUTIONS LIBRES DANS LA MATRICE BB. SI JOB2=0
C		LES SOLUTIONS LIBRES SONT COMBINEES DE TELLE FACON QUE
C		LEUR UTILISISATION POUR SATISFAIRE LES CONDITIONS AU 
C		CONTOUR DEMANDE UN NOMBRE MINIMALE D'OPERATIONS LORSQUE
C		LA ROUTINE SERA APPELE LA FOIS SUIVANTE.
C
	JOB2=JOB
	JOB3=JOB
C
	IF(JBCC.NE.JBC) THEN
	JBCC=JBC
	JOB3=0
	JOB2=0
	ENDIF
C
C		TEST POUR SAVOIR SI LE COTE DE L'INTERVALLE OU LE CONDITIONS
C		SONT IMPOSEES A CHANGE DEPUIS LE PRECEDENT APPEL DE LA ROUTINE.
C			
	IF(ICONC.EQ.ICON.OR.JCONC.EQ.-1) GO TO 888
	JOB2=0
	MJ1=0
	IF(JCON.GT.3.AND.JCONC.LE.3) MJ1=1
	IF(JCON.LE.3.AND.JCONC.GT.3) MJ1=1
C
	IF(ICON.EQ.0) MJ1=1
C
	IF(IDEL.EQ.0.AND.JOB.NE.0) THEN
	IF(MJ1.EQ.1) THEN
	PRINT*,'CHANGEMENT DE ICON,IL FAUT APPELER PREALABLEMENT MTECOS'
	PRINT*,'ANCIENNE VALEUR DE ICON=',ICONC,ICON
	CALL EXIT
	ENDIF
	ENDIF
C
	IF(ICONC.EQ.5.AND.ICON.EQ.3) MJ1=1
	IF(ICONC.EQ.4.AND.ICON.LT.3) MJ1=1
	IF(MJ1.EQ.1.OR.ICONC.EQ.0) JOB3=0
  888	CONTINUE
	ICONC=ICON
	JCONC=JCON
C
C		TEST POUR DETECTER UN CHANGEMENT DANS LE COEFFICIENTS
C		DES CONDITIONS AU CONTOUR DEPUIS LE DERNIER APPEL.(CAS
C		OU LES COEFFICIENTS SONT IDENTIQUES POUR LES NEQ EQUATIONS)
C
	IF(JBC.EQ.1) THEN
C
	SOM=ABS(CIC(1)-CI(1,1))+ABS(CIC(2)-CI(1,2))+ABS(CIC(3)-CI(1,4))
     1  +ABS(CIC(4)-CI(1,5))
C
	IF(SOM.GT.XSC) THEN
	CIC(1)=CI(1,1)
	CIC(2)=CI(1,2)
	CIC(3)=CI(1,4)
	CIC(4)=CI(1,5)
	JOB2=0
	JOB3=0
	ENDIF
	ENDIF
C
C		CALCUL DE LA SOLUTION DU SYSTEME DANS LES CAS PARTICULIERS
C
C   PPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPPP
C
	IF(IDEG.EQ.314) THEN
C
C		SYSTEME 1ER ORDRE GEOMETRIE PLANE
C
C		NJ3 EST L'INDICE DU TABLEAU DES DONNES INPUT NECESSAIRE
C		POUR EXECUTER UNE COMBINAISON LINEAIRE DES COEFFICIENTS 
C		DU SYTEME
C
	NJ3=BB(N1+1,7)
C
C		IDEL EST UN DRAPEAU QUI INDIQUE SI DELTA EST TRES PETIT
C		(IDEL=14142) OU GRANND (IDEL)=0)
C
	IDEL=BB(N1+1,6)
C
	NEQ1=NEQ
	NEQ2=NEQ
C
C		PREPARATION DE L'INPUT DE LEQT1S: COMBINAISONS LINEAIRES
C		DES COEFFICIENTS DU 2EME MEMBRE
C
 	DO 1 LEQ=1,NEQ2
	DO 2 L=1,N1-4
	DEN(L,LEQ)=CC(L+2,LEQ)-CC(L,LEQ)
   2	CONTINUE
   1	CONTINUE
C
	DO 3 LEQ=1,NEQ2
	DO 4 L=N1-3,N1
	DEN(L,LEQ)=CC(L,LEQ)
   4	CONTINUE
   3	CONTINUE
C	
	IF(NJ3.EQ.1) THEN
	N13=N1-3
	DO 5 LEQ=1,NEQ2
	DEN(N13,LEQ)=DEN(N13,LEQ)-DEN(N,LEQ)
   5	CONTINUE
	ENDIF
C
	IF(NJ3.GT.1) THEN
C
	RAP=BB(N1+1,5)
	N12=NJ3+1
	DO 6 LEQ=1,NEQ2
	DEN(NJ3,LEQ)=DEN(NJ3,LEQ)-DEN(N12,LEQ)*RAP
   6	CONTINUE
	ENDIF
C
C		CALCULS DES COEFFICIENTS DU 2EME MEMBRE DU SYSTEME EN VUE
C		DE DETERMINER DES SOLUTIONS PARTICULIERES EMPLOYEES
C		A SATISFAIRE DES CONDITIONS AU CONTOUR
C
	IF(ICON.EQ.0) GO TO 314
	IF(JOB3.EQ.0) THEN
	NEQ1=NEQ+1
	NEQ2=NEQ1
C
	DO 7 L=1,N
	DEN(L,NEQ1)=0
   7	CONTINUE
	DEN(N1,NEQ1)=1
	NEQ2=NEQ1
C
	IF(JCON.GT.3) THEN
C
	NEQ2=NEQ+2
	DO 8 L=1,N-1
	DEN(L,NEQ2)=0
   8	CONTINUE
	DEN(N,NEQ2)=1
	DEN(N1,NEQ2)=0
	ENDIF
	ENDIF
  314	CONTINUE
C
C
C		CAS N**3*DELTA < 1
C
	IF(IDEL.EQ.14142.OR.ICON.EQ.0) THEN
C
	IF(JOB.EQ.2) THEN
C
C		LA MATRICE DES PIVOTS EST RECUPEREE
C
	DO 9 L=1,N1
	DO 10 J=1,3
	AA(L,J)=BB(L,J+3)
   10	CONTINUE
   9	CONTINUE
	ENDIF
C
	CALL LEQT1S(BB,N1,0,2,NDIM,DEN,NEQ2,NDIM,JOB,AA,IE)
C
	IF(JOB.EQ.0) THEN
C
C		ON STOCKE LA MATRICE DES PIVOTS DANS BB
C
	DO 11 L=1,N1
	DO 12 J=1,3
	BB(L,J+3)=AA(L,J)
   12	CONTINUE
   11	CONTINUE
	JOB=2
	BB(N1+1,2)=2.1
	ENDIF
C
	DO 13 LEQ=1,NEQ2
	DEN(N1,LEQ)=DEN(N1,LEQ)*2
   13	CONTINUE
C
	IF(ICON.EQ.0.OR.ICON.GT.3) RETURN
C
	DO 14 LEQ=1,NEQ2
	DO 15 L=1,N1
	CC(L,LEQ)=DEN(L,LEQ)
   15	CONTINUE
   14	CONTINUE
	N8=7
	CALL BUNCOS(N,NDIM,NEQ,N8,ICON,JOB3,JOB2,CI,AA,BB,CC,DEN)
	RETURN
	ENDIF
C
C			CAS N**3*DELTA > 1
C
	IF(IDEL.EQ.0) THEN
C
	IF(ICON.EQ.1.OR.ICON.EQ.2.OR.ICON.EQ.4) THEN
C	
C		ON MODIFIE LA MATRICE POUR AVOIR UNE MATRICE BIEN CONDITION-
C		NEE
C
	IF(JOB.EQ.0) THEN
	DO 16 J=1,3
	DO 17 L=N,1,-1
	BB(L+1,J)=BB(L,J)
   17	CONTINUE
   16	CONTINUE
C
	DO 18 J=1,3
	BB(1,J)=0
   18	CONTINUE
C
	BB(1,2)=1
	ENDIF
C
	DO 19 LEQ=1,NEQ2
	CC(1,LEQ)=DEN(N1,LEQ)
   19	CONTINUE
C
	DO 20 LEQ=1,NEQ2
	DO 21 L=N,1,-1
	DEN(L+1,LEQ)=DEN(L,LEQ)
   21	CONTINUE
   20	CONTINUE
C
	DO 22 LEQ=1,NEQ2
	DEN(1,LEQ)=CC(1,LEQ)
   22	CONTINUE
C
	IF(JOB.EQ.2) THEN
	DO 23 J=1,3
	DO 24 L=1,N1
	AA(L,J)=BB(L,J+3)
   24	CONTINUE
   23	CONTINUE
	ENDIF
C
     	CALL LEQT1S(BB,N1,1,1,NDIM,DEN,NEQ2,NDIM,JOB,AA,IE)
C
	IF(JOB.EQ.0) THEN
C
C		ON STOCKE LA MATRICE DES PIVOTS DANS BB
C
	DO 26 J=1,3
	DO 27 L=1,N1
	BB(L,J+3)=AA(L,J)
   27	CONTINUE
   26	CONTINUE
	JOB=2
	BB(N1+1,2)=2.1
	ENDIF
C
	DO 28 LEQ=1,NEQ2
	DEN(N1,LEQ)=DEN(N1,LEQ)*2
   28	CONTINUE
	IF(ICON.GT.3) RETURN
C
C		ON EXECUTE UNE COMBINAISON LINEAIRE DE LA SOLUTION PARTICU-
C		LIERE AVEC LA SOLUTION LIBRE POUR AVOIR UNE SOLUTION
C		SATISFAISANTE LA CONDITION AU CONTOUR (A DROITE OU A GAUCHE)
C
	DO 29 LEQ=1,NEQ2
	DO 30 L=1,N1
	CC(L,LEQ)=DEN(L,LEQ)
  30	CONTINUE
  29	CONTINUE
	N8=7
	CALL BUNCOS(N,NDIM,NEQ,N8,ICON,JOB3,JOB2,CI,AA,BB,CC,DEN)
	RETURN
	ENDIF
C
	IF(JCON.GT.3) THEN
C	
C		ON TRANSFORME LA MATRICE DE L'OPERATEUR EN UNE MATRICE
C		BIEN CONDITIONNEE DANS LE CAS DE 2 CONDITIONS AU CONTOUR.
C
	IF(JOB.EQ.0) THEN
	DO 31 J=1,3
	DO 32 L=N1-2,1,-1
	BB(L+2,J)=BB(L,J)
   32	CONTINUE
   31	CONTINUE
C
	DO 33 J=1,3
	BB(1,J)=0
	BB(2,J)=0
   33	CONTINUE
C
	BB(1,3)=1
	BB(2,3)=1
	ENDIF
C
	DO 35 LEQ=1,NEQ2
	CC(1,LEQ)=DEN(N,LEQ)
	CC(2,LEQ)=DEN(N1,LEQ)
   35	CONTINUE
C	
	DO 36 LEQ=1,NEQ2
	DO 37 L=N1-2,1,-1
	DEN(L+2,LEQ)=DEN(L,LEQ)
   37	CONTINUE
   36	CONTINUE
C
	DO 38 LEQ=1,NEQ2
	DEN(1,LEQ)=CC(1,LEQ)
	DEN(2,LEQ)=CC(2,LEQ)
   38	CONTINUE
C
	IF(JOB.EQ.2) THEN
C
C		ON RECUPERE LA MATRICE DES PIVOTS QUI AVAIT ETE STOCKEE
C		PREABLEMENT DANS BB
C
	DO 39 J=1,3
	DO 40 L=1,N1
	AA(L,J)=BB(L,J+3)
   40	CONTINUE
   39	CONTINUE
	ENDIF
C
	CALL LEQT1S(BB,N1,2,0,NDIM,DEN,NEQ2,NDIM,JOB,AA,IE)
C
	IF(JOB.EQ.0) THEN
C
C		ON STOCKE LA MATRICE DES PIVOTS DANS BB
C
	DO 41 J=1,3
	DO 42 L=1,N1
	BB(L,J+3)=AA(L,J)
   42	CONTINUE
   41	CONTINUE
	JOB=2
	BB(N1+1,2)=2.1
	ENDIF
C
	DO 43 LEQ=1,NEQ2
	DEN(N1,LEQ)=DEN(N1,LEQ)*2
   43	CONTINUE
	IF(ICON.EQ.5) RETURN
C
	DO 44 LEQ=1,NEQ2
	DO 45 L=1,N1
	CC(L,LEQ)=DEN(L,LEQ)
   45	CONTINUE
   44	CONTINUE
C
	N8=7
C
C		ON EXECUTE UNE COMBINAISON LINEAIRE POUR SATISFAIRE LES
C		2 CONDITIONS AU CONTOUR
C
	CALL BUNCOS(N,NDIM,NEQ,N8,ICON,JOB3,JOB2,CI,AA,BB,CC,DEN)
	RETURN
	ENDIF
	ENDIF
	ENDIF
C
C		SISTEME DU 2EME ORDRE EN GEOMETRIE PLANE.
C		
C		N.B.
C               ---
C			PUISQUE LA STRUCTURE DES DIFFERENTS CAS TRAITES
C			EST PRESQUE LA MEME QUE POUR LE CAS PRECEDENT
C			LES COMMENTAIRES NE SONT PAS REPETES
C
	IF(IDEG.EQ.315) THEN
C
	NJ3=BB(N1+1,7)
C
C		NJ3 EST L'INDICE DU TABLEAU DES DONNEES INPUT NECESSAIRE
C		POUR EXECUTER UNE COMBINAISON LINEAIRE DES COEFFICIENTS 
C		DU SYTEME
C		IDEL EST UN DRAPEAU QUI INDIQUE SI DELTA EST TRES PETIT
C		(IDEL=14142) OU GRANND (IDEL)=0)
C
	NEQ1=NEQ
	NEQ2=NEQ
C
C		PREPARATION DE L'INPUT DE LEQT1S: COMBINAISONS LINEAIRES
C		DES COEFFICIENTS DU 2EME MEMBRE
C
 	DO 46 LEQ=1,NEQ2
	DO 47 L=1,N1-4
	CC(L,LEQ)=(CC(L+2,LEQ)-CC(L,LEQ))/L
   47	CONTINUE
C
	DO 48 L=1,N1-4
	DEN(L,LEQ)=CC(L+2,LEQ)-CC(L,LEQ)
   48	CONTINUE
	DO 49  L=N1-3,N1
	DEN(L,LEQ)=CC(L,LEQ)
   49	CONTINUE
   46	CONTINUE
C	
	IF(NJ3.GT.0) THEN
	N4=N-4
	RAP=BB(N1+1,5)
	DO 50 LEQ=1,NEQ2
	DEN(N4,LEQ)=DEN(N4,LEQ)-RAP*DEN(NJ3,LEQ)
   50	CONTINUE
	ENDIF
C
C		CALCULS DES COEFFICIENTS DU 2EME MEMBRE DU SYSTEME EN VUE
C		DE DETERMINER DES SOLUTIONS PARTICULIERES EMPLOYEES
C		A SATISFAIRE DES CONDITIONS AU CONTOUR
C
	IF(ICON.EQ.0) GO TO 315
	IF(JOB3.EQ.0) THEN
	NEQ1=NEQ+1
	NEQ2=NEQ1
C
	DO 51 L=1,N
	DEN(L,NEQ1)=0
   51	CONTINUE
	DEN(N1,NEQ1)=1
	NEQ2=NEQ1
C
	IF(ICON.EQ.3.OR.ICON.EQ.5) THEN
C
	NEQ2=NEQ+2
	DO 52 L=1,N-1
	DEN(L,NEQ2)=0
   52	CONTINUE
	DEN(N,NEQ2)=1
	DEN(N1,NEQ2)=0
	ENDIF
	ENDIF
  315	CONTINUE
C
C
C		CAS N**3*DELTA < 1
C
	IF(IDEL.EQ.14142.OR.ICON.EQ.0) THEN
C
	IF(JOB.EQ.2) THEN
	DO 53 L=1,N1
	DO 54 J=1,5
	AA(L,J)=BB(L,J+5)
   54	CONTINUE
   53	CONTINUE
	ENDIF
C
	CALL LEQT1S(BB,N1,0,4,NDIM,DEN,NEQ2,NDIM,JOB,AA,IE)
C
	IF(JOB.EQ.0) THEN
	DO 55 L=1,N1
	DO 56 J=1,5
	BB(L,J+5)=AA(L,J)
   56	CONTINUE
   55	CONTINUE
	JOB=2
	BB(N1+1,2)=2.1
	ENDIF
C
	DO 57 LEQ=1,NEQ2
	DEN(N1,LEQ)=DEN(N1,LEQ)*2
   57	CONTINUE
C
	IF(ICON.EQ.0.OR.ICON.GT.3) THEN
	RETURN
	ELSE
C
	DO 58 LEQ=1,NEQ2
	DO 59 L=1,N1
	CC(L,LEQ)=DEN(L,LEQ)
   59	CONTINUE
   58	CONTINUE
	N8=11
	CALL BUNCOS(N,NDIM,NEQ,N8,ICON,JOB3,JOB2,CI,AA,BB,CC,DEN)
	RETURN
	ENDIF
	ENDIF
C
C			CAS N**3*DELTA > 1
C	
	IF(IDEL.EQ.0) THEN
C
	IF(JCON.LT.4) THEN
C	
	IF(JOB.EQ.0) THEN
	DO 60 J=1,5
	DO 61 L=N,1,-1
	BB(L+1,J)=BB(L,J)
   61	CONTINUE
   60	CONTINUE
C
	DO 62 J=1,5
	BB(1,J)=0
   62	CONTINUE
C
	BB(1,2)=.5
	BB(1,3)=1
	BB(1,4)=1
	BB(1,5)=1	
	ENDIF
C
	DO 63 LEQ=1,NEQ2
	CC(1,LEQ)=DEN(N1,LEQ)
   63	CONTINUE
C	
	DO 64 LEQ=1,NEQ2
	DO 65 L=N,1,-1
	DEN(L+1,LEQ)=DEN(L,LEQ)
   65	CONTINUE
   64	CONTINUE
C
	DO 66 LEQ=1,NEQ2
	DEN(1,LEQ)=CC(1,LEQ)
   66	CONTINUE
C
	IF(JOB.EQ.2) THEN
	DO 67 J=1,5
	DO 68 L=1,N1
	AA(L,J)=BB(L,J+5)
   68	CONTINUE
   67	CONTINUE
	ENDIF
C
     	CALL LEQT1S(BB,N1,1,3,NDIM,DEN,NEQ2,NDIM,JOB,AA,IE)
C
	IF(JOB.EQ.0) THEN
	DO 69 J=1,5
	DO 70 L=1,N1
	BB(L,J+5)=AA(L,J)
   70	CONTINUE
   69	CONTINUE
	JOB=2
	BB(N1+1,2)=2.1
	ENDIF
C
	DO 71 LEQ=1,NEQ2
	DEN(N1,LEQ)=DEN(N1,LEQ)*2
   71	CONTINUE
	IF(ICON.GT.3) THEN
	RETURN
	ELSE
C
	DO 72 LEQ=1,NEQ2
	DO 73 L=1,N1
	CC(L,LEQ)=DEN(L,LEQ)
  73	CONTINUE
  72	CONTINUE
	N8=11
	CALL BUNCOS(N,NDIM,NEQ,N8,ICON,JOB3,JOB2,CI,AA,BB,CC,DEN)
	RETURN
	ENDIF
	ENDIF
C
	IF(JCON.GT.3) THEN
C	
	IF(JOB.EQ.0) THEN
	DO 74 J=1,5
	DO 75 L=N1-2,1,-1
	BB(L+2,J)=BB(L,J)
   75	CONTINUE
   74	CONTINUE
C
	DO 76 J=1,2
	BB(1,J)=0
	BB(2,J)=0
   76	CONTINUE
C
	BB(1,3)=.5
	BB(1,4)=1
	BB(1,5)=1
	BB(2,3)=.5
	BB(2,4)=-1
	BB(2,5)=1
	ENDIF
C
	DO 77 LEQ=1,NEQ2
	CC(1,LEQ)=DEN(N,LEQ)
	CC(2,LEQ)=DEN(N1,LEQ)
   77	CONTINUE
C	
	DO 78 LEQ=1,NEQ2
	DO 79 L=N1-2,1,-1
	DEN(L+2,LEQ)=DEN(L,LEQ)
   79	CONTINUE
   78	CONTINUE
C
	DO 80 LEQ=1,NEQ2
	DEN(1,LEQ)=CC(1,LEQ)
	DEN(2,LEQ)=CC(2,LEQ)
   80	CONTINUE
C
	IF(JOB.EQ.2) THEN
	DO 81 J=1,5
	DO 82 L=1,N1
	AA(L,J)=BB(L,J+5)
   82	CONTINUE
   81	CONTINUE
	ENDIF
C
	CALL LEQT1S(BB,N1,2,2,NDIM,DEN,NEQ2,NDIM,JOB,AA,IE)
C
	IF(JOB.EQ.0) THEN
	DO 83 J=1,5
	DO 84 L=1,N1
	BB(L,J+5)=AA(L,J)
   84	CONTINUE
   83	CONTINUE
	JOB=2
	BB(N1+1,2)=2.1
	ENDIF
C
	DO 85 LEQ=1,NEQ2
	DEN(N1,LEQ)=DEN(N1,LEQ)*2
   85	CONTINUE
	IF(ICON.EQ.5) RETURN
C
	DO 86 LEQ=1,NEQ2
	DO 87 L=1,N1
	CC(L,LEQ)=DEN(L,LEQ)
   87	CONTINUE
   86	CONTINUE
C
	N8=11
	CALL BUNCOS(N,NDIM,NEQ,N8,ICON,JOB3,JOB2,CI,AA,BB,CC,DEN)
	RETURN
	ENDIF
	ENDIF
	ENDIF
C
C
C		CAS COQUILLE EPAISSE : R2 > 0
C
C EEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEEE
C
	IF(IDEG.EQ.316) THEN
C
C		N.B.
C               ---
C			PUISQUE LA STRUCTURE DES DIFFERENTS CAS TRAITES
C			EST PRESQUE LA MEME QUE POUR LE PREMIER CAS
C			LES COMMENTAIRES NE SONT PAS REPETES
C
C		CAS COQUILLE EPAISSE DEGENEREE ANTISYMETRIQUE
C
	NJ3=BB(N1+1,7)
	RAP=BB(N1+1,3)
C
	IDEL=BB(N1+1,6)
C
	NEQ1=NEQ
	NEQ2=NEQ
C
C		PREPARATION DE L'INPUT DE LEQT1S: COMBINAISON LINEAIRE
C		DES COEFFICIENT DU 2EME MEMBRE DU SYSTEME
C
 	DO 200 LEQ=1,NEQ2
	DO 201 L=1,N1-6
	CC(L,LEQ)=(CC(L+2,LEQ)-CC(L,LEQ))/L
  201	CONTINUE
C
	DO 202 L=1,N1-6
	DEN(L,LEQ)=CC(L+2,LEQ)-CC(L,LEQ)
  202	CONTINUE
  200	CONTINUE
C
	DO 203 LEQ=1,NEQ2
	DO 204 L=N1-5,N1
	DEN(L,LEQ)=CC(L,LEQ)
  204	CONTINUE
  203	CONTINUE
C	
	X0=0
	IF(NJ3.GT.0) THEN
	N4=N-6
	DO 205 LEQ=1,NEQ2
	DEN(N4,LEQ)=DEN(N4,LEQ)-DEN(NJ3,LEQ)*RAP
  205	CONTINUE
	ENDIF
C
C		CALCUL DES COEFFICIENTS POUR DES SOLUTION PARTICULIERES 
C		DESTINEES A SATISFARE LES CONDITIONS AU CONTOUR
C
	IF(ICON.EQ.0) GO TO 316
C
	IF(JOB3.EQ.0) THEN
	NEQ1=NEQ+1
	NEQ2=NEQ1
C
	DO 207 L=1,N-1
	DEN(L,NEQ1)=0
  207	CONTINUE
C
	DEN(N,NEQ1)=1
	IF(ICON.EQ.3.OR.ICON.EQ.5) THEN
	NEQ2=NEQ+2
	DO 208 L=1,N
	DEN(L,NEQ2)=0
  208 	CONTINUE
	DEN(N-1,NEQ2)=1
	ENDIF
	ENDIF
  316	CONTINUE
C
C
C		CAS N**3*DELTA < 1
C
	IF(IDEL.EQ.14142.OR.ICON.EQ.0) THEN
C
	IF(JOB.EQ.2) THEN
	DO 209 L=1,N
	DO 210 J=1,7
	AA(L,J)=BB(L,J+7)
  210	CONTINUE
  209	CONTINUE
	ENDIF
C
	CALL LEQT1S(BB,N,1,5,NDIM,DEN,NEQ2,NDIM,JOB,AA,IE)
C
	IF(JOB.EQ.0) THEN
	DO 211 L=1,N
	DO 212 J=1,7
	BB(L,J+7)=AA(L,J)
  212	CONTINUE
  211	CONTINUE
	JOB=2
	ENDIF
C
	BB(N1+1,2)=2.1
C
	DO 213 LEQ=1,NEQ2
	DEN(N1,LEQ)=0
  213	CONTINUE
C
C		LE COEFFICIENTS AINSI TROUVES SONT LES COEFFICIENTS
C		DU DEVELOPPEMENT DE LA SOLUTION EN (R1+R2*x)*Tn(x)
C		IL FAUT PAR CONSEQUENT MULTIPLIER LA SOLUTION PAR
C		R1+R2*x
C
C		MULTIPLICATION PAR R1+R2*x
C
	CALL DIRM1S(N,NDIM,1,NEQ2,DEN,CC)
C
	IF(ICON.EQ.0.OR.ICON.GT.3) THEN
	DO 214 LEQ=1,NEQ2
	DO 215 L=1,N1
	DEN(L,LEQ)=R1*DEN(L,LEQ)+R2*CC(L,LEQ)
  215	CONTINUE
  214	CONTINUE
	RETURN
	ELSE
C
	DO 216 LEQ=1,NEQ2
	DO 217 L=1,N1
	CC(L,LEQ)=R1*DEN(L,LEQ)+R2*CC(L,LEQ)
  217	CONTINUE
  216	CONTINUE
	ENDIF
	N8=15
	CALL BUNCOS(N,NDIM,NEQ,N8,ICON,JOB3,JOB2,CI,AA,BB,CC,DEN)
	RETURN
	ENDIF
C
C			CAS N**3*DELTA > 1
C
	IF(IDEL.EQ.0) THEN
C
	IF(JCON.LT.4) THEN
C	
	IF(JOB.EQ.0) THEN
	DO 218 J=1,7
	DO 219 L=N-1,1,-1
	BB(L+1,J)=BB(L,J)
  219	CONTINUE
  218	CONTINUE
C
	DO 220 J=1,7
	BB(1,J)=0
  220	CONTINUE
C
	BB(1,3)=.5
	DO 221 L=4,7
	BB(1,L)=1
  221	CONTINUE
C
	ENDIF
C
	DO 223 LEQ=1,NEQ2
	CC(1,LEQ)=DEN(N,LEQ)
  223	CONTINUE
C	
	N0=N-1
	DO 224 LEQ=1,NEQ2
	DO 225 L=N0,1,-1
	DEN(L+1,LEQ)=DEN(L,LEQ)
  225	CONTINUE
  224	CONTINUE
C
	DO 226 LEQ=1,NEQ2
	DEN(1,LEQ)=CC(1,LEQ)
  226 	CONTINUE
C
	IF(JOB.EQ.2) THEN
	DO 227 J=1,7
	DO 228 L=1,N
	AA(L,J)=BB(L,J+7)
  228	CONTINUE
  227	CONTINUE
	ENDIF
C
     	CALL LEQT1S(BB,N,2,4,NDIM,DEN,NEQ2,NDIM,JOB,AA,IE)
C
	IF(JOB.EQ.0) THEN
	DO 229 J=1,7
	DO 230 L=1,N
	BB(L,J+7)=AA(L,J)
  230	CONTINUE
  229	CONTINUE
	ENDIF
	JOB=2
	BB(N1+1,2)=2.1
C
	DO 231 LEQ=1,NEQ2
	DEN(N1,LEQ)=0
  231	CONTINUE
C
C	    MULTIPLICATION PAR R1+R2*x
C
	CALL DIRM1S(N,NDIM,1,NEQ2,DEN,CC)
C
	IF(ICON.GT.3) THEN
	DO 232 LEQ=1,NEQ2
	DO 233 L=1,N1
	DEN(L,LEQ)=R1*DEN(L,LEQ)+R2*CC(L,LEQ)
  233	CONTINUE
  232	CONTINUE
	ELSE
	DO 234 LEQ=1,NEQ2
	DO 235 L=1,N1
	CC(L,LEQ)=R1*DEN(L,LEQ)+R2*CC(L,LEQ)
  235	CONTINUE
  234	CONTINUE
	ENDIF
	N8=15
	CALL BUNCOS(N,NDIM,NEQ,N8,ICON,JOB3,JOB2,CI,AA,BB,CC,DEN)
	RETURN
	ENDIF
C
	IF(ICON.EQ.3.OR.ICON.EQ.5) THEN
C	
	IF(JOB.EQ.0) THEN
	DO 236 J=1,7
	DO 237 L=N-2,1,-1
	BB(L+2,J)=BB(L,J)
  237	CONTINUE
  236	CONTINUE
C
	DO 238 J=1,7
	BB(1,J)=0
	BB(2,J)=0
  238	CONTINUE
C
	DO 239 L=5,7
	BB(1,L)=1
	BB(2,L)=1
  239	CONTINUE
C
	BB(2,5)=-1
	BB(2,7)=-1
	BB(1,4)=.5
	BB(2,4)=.5
C
	ENDIF
C
	DO 240 LEQ=1,NEQ2
	CC(1,LEQ)=DEN(N-1,LEQ)
	CC(2,LEQ)=DEN(N,LEQ)
  240	CONTINUE
C	
	N2=N-2
	DO 241 LEQ=1,NEQ2
	DO 242 L=N2,1,-1
	DEN(L+2,LEQ)=DEN(L,LEQ)
  242	CONTINUE
  241	CONTINUE
C
	DO 243 LEQ=1,NEQ2
	DEN(1,LEQ)=CC(1,LEQ)
	DEN(2,LEQ)=CC(2,LEQ)
  243	CONTINUE
C
	IF(JOB.EQ.2) THEN
	DO 244 J=1,7
	DO 245 L=1,N
	AA(L,J)=BB(L,J+7)
  245	CONTINUE
  244	CONTINUE
	ENDIF
C
	CALL LEQT1S(BB,N,3,3,NDIM,DEN,NEQ2,NDIM,JOB,AA,IE)
C
	IF(JOB.EQ.0) THEN
	DO 246 J=1,7
	DO 247 L=1,N
	BB(L,J+7)=AA(L,J)
  247	CONTINUE
  246	CONTINUE
	JOB=2
	BB(N1+1,2)=2.1
	ENDIF
C
C		MULTIPLICATION PAR (R1+R2*X)
C
	DO 248 LEQ=1,NEQ2
	DEN(N1,LEQ)=0
  248	CONTINUE
C
	CALL DIRM1S(N,NDIM,1,NEQ2,DEN,CC)
C
	IF(ICON.EQ.5) THEN
	DO 249 LEQ=1,NEQ2
	DO 250 L=1,N1
	DEN(L,LEQ)=R1*DEN(L,LEQ)+R2*CC(L,LEQ)
  250	CONTINUE
  249	CONTINUE
	RETURN
	ELSE
	DO 251 LEQ=1,NEQ2
	DO 252 L=1,N1
	CC(L,LEQ)=R1*DEN(L,LEQ)+R2*CC(L,LEQ)
  252	CONTINUE
  251	CONTINUE
	ENDIF
C
	N8=15
	CALL BUNCOS(N,NDIM,NEQ,N8,ICON,JOB3,JOB2,CI,AA,BB,CC,DEN)
	RETURN
	ENDIF
	ENDIF
	ENDIF
C
C
C		CAS NON DEGENERE  (COQUILLE EPAISSE)' (R2 > 0)
C
	IF(IDEG.EQ.317) THEN
C
C		N.B.
C               ---
C			PUISQUE LA STRUCTURE DES DIFFERENTS CAS TRAITES
C			EST PRESQUE LA MEME QUE POUR LE PREMIER CAS
C			LES COMMENTAIRES NE SONT PAS REPETES
C
	IDEL=BB(N1+1,6)
C
	NEQ1=NEQ
	NEQ2=NEQ
C
C		COMBINAISONS LINEAIRES DES COEFFICIENTS DU 2EME MEMBRE
C
 	DO 300 LEQ=1,NEQ2
	DO 301 L=1,N1-6
	CC(L,LEQ)=(CC(L+2,LEQ)-CC(L,LEQ))/L
  301	CONTINUE
C
	DO 302 L=1,N1-6
	DEN(L,LEQ)=CC(L+2,LEQ)-CC(L,LEQ)
  302	CONTINUE
  300	CONTINUE
C
	DO 303 LEQ=1,NEQ2
	DO 304 L=N1-5,N1
	DEN(L,LEQ)=CC(L,LEQ)
  304	CONTINUE
  303	CONTINUE
C
C		CALCUL DES COEFFICIENTS POUR DES SOLUTION PARTICULIERES 
C		DESTINEES A SATISFARE LES CONDITIONS AU CONTOUR
C
	IF(ICON.EQ.0) GO TO 317
	IF(JOB3.EQ.0) THEN
	NEQ1=NEQ+1
	NEQ2=NEQ1
C
	DO 305 L=1,N-2
	DEN(L,NEQ1)=0
  305	CONTINUE
	DEN(N-1,NEQ1)=1
C
	IF(JCON.GT.3) THEN
C
	NEQ2=NEQ+2
	DO 306 L=1,N-3
	DEN(L,NEQ2)=0
  306	CONTINUE
C
	DEN(N-2,NEQ2)=1
	DEN(N-1,NEQ2)=0
	ENDIF
	ENDIF
  317	CONTINUE
C
C		CAS N**3*DELTA < 1
C
	IF(IDEL.EQ.14142.OR.ICON.EQ.0) THEN
C
	IF(JOB.EQ.2) THEN
	DO 307 L=1,N-1
	DO 308 J=1,9
	AA(L,J)=BB(L,J+9)
  308	CONTINUE
  307	CONTINUE
	ENDIF
C
        NJ=N-1
	CALL LEQT1S(BB,NJ,2,6,NDIM,DEN,NEQ2,NDIM,JOB,AA,IE)
C
	IF(JOB.EQ.0) THEN
	DO 309 L=1,N-1
	DO 310 J=1,9
	BB(L,J+9)=AA(L,J)
  310	CONTINUE
  309	CONTINUE
	JOB=2
	BB(N1+1,2)=2.1
	ENDIF
C
C		PUISQE LA SOULTION EST UN DEVELOPPEMENT EN SERIE DE
C		(R1+R2*x)**2*Tn(x) LA SOLUTION DOIT ETRE 
C		MULTIPLIEE PAR (R1+R2*r)**2
C	
	DO 311 LEQ=1,NEQ2
	DO 312 L=N,N1
	DEN(L,LEQ)=0
  312	CONTINUE
  311	CONTINUE
C
C		MULTIPLICATION PAR (R1+R2*x)
C
	CALL DIRCMS(N,NDIM,NEQ2,0,R1,R2,DEN,CC)
C
C		MULTIPLICATION PAR x
C
	CALL DIRM1S(N,NDIM,1,NEQ2,CC,DEN)
C
	IF(ICON.EQ.0.OR.ICON.GT.3) THEN
	DO 386 LEQ=1,NEQ2
	DO 387 L=1,N1
	DEN(L,LEQ)=R1*CC(L,LEQ)+R2*DEN(L,LEQ)
  387	CONTINUE
  386	CONTINUE
	RETURN
        ELSE        
	DO 331 LEQ=1,NEQ2
	DO 332 L=1,N1
	CC(L,LEQ)=R1*CC(L,LEQ)+R2*DEN(L,LEQ)
  332	CONTINUE
  331	CONTINUE
	ENDIF
	N8=19
	CALL BUNCOS(N,NDIM,NEQ,N8,ICON,JOB3,JOB2,CI,AA,BB,CC,DEN)
	RETURN
	ENDIF
C
C			CAS N**3*DELTA > 1
C
	IF(IDEL.EQ.0) THEN
C
	IF(JCON.LT.4) THEN
C	
	IF(JOB.EQ.0) THEN
	DO 335 J=1,9
	DO 336 L=N-2,1,-1
	BB(L+1,J)=BB(L,J)
  336	CONTINUE
  335	CONTINUE
C
	DO 337 J=1,3
	BB(1,J)=0
  337	CONTINUE
C
	BB(1,4)=.5
	DO 338 J=5,9
	BB(1,J)=1
  338	CONTINUE
	ENDIF
C
	DO 339 LEQ=1,NEQ2
	CC(1,LEQ)=DEN(N-1,LEQ)
  339	CONTINUE
C	
	DO 340 LEQ=1,NEQ2
	DO 341 L=N-2,1,-1
	DEN(L+1,LEQ)=DEN(L,LEQ)
  341	CONTINUE
  340	CONTINUE
	DO 342 LEQ=1,NEQ2
	DEN(1,LEQ)=CC(1,LEQ)
  342	CONTINUE
C
	IF(JOB.EQ.2) THEN
	DO 343 J=1,9
	DO 344 L=1,N-1
	AA(L,J)=BB(L,J+9)
  344	CONTINUE
  343	CONTINUE
	ENDIF
C
        NJ=N-1
     	CALL LEQT1S(BB,NJ,3,5,NDIM,DEN,NEQ2,NDIM,JOB,AA,IE)
C
	IF(JOB.EQ.0) THEN
	DO 345 J=1,9
	DO 346 L=1,N-1
	BB(L,J+9)=AA(L,J)
  346	CONTINUE
  345	CONTINUE
	JOB=2
	BB(N1+1,2)=2.1
	ENDIF
C
	DO 347 LEQ=1,NEQ2
	DO 348 L=N,N1
	DEN(L,LEQ)=0
  348	CONTINUE
  347	CONTINUE
C
C		MULTIPLICATION PAR R1+R2*x
C
	CALL DIRCMS(N,NDIM,NEQ2,0,R1,R2,DEN,CC)
C	
C		MULTIPLICATION PAR x
C
	CALL DIRM1S(N,NDIM,1,NEQ2,CC,DEN)
	IF(ICON.GT.3) THEN
	DO 382 LEQ=1,NEQ2
	DO 383 L=1,N1
	DEN(L,LEQ)=R1*CC(L,LEQ)+R2*DEN(L,LEQ)
  383	CONTINUE
  382	CONTINUE	
	RETURN
	ELSE
	DO 349 LEQ=1,NEQ2
	DO 350 L=1,N1
	CC(L,LEQ)=R1*CC(L,LEQ)+R2*DEN(L,LEQ)
  350	CONTINUE
  349	CONTINUE
	ENDIF
	N8=19
	CALL BUNCOS(N,NDIM,NEQ,N8,ICON,JOB3,JOB2,CI,AA,BB,CC,DEN)
	RETURN
	ENDIF
C
CCB
	IF(JCON.GT.3) THEN
C	
	IF(JOB.EQ.0) THEN
	DO 351 J=1,9
	DO 352 L=N-3,1,-1
	BB(L+2,J)=BB(L,J)
  352	CONTINUE
  351	CONTINUE
C
	DO 354 J=1,4
	DO 353 L=1,2
	BB(L,J)=0
  353	CONTINUE
  354	CONTINUE
C
	DO 355 J=6,9
	DO 356 L=1,2
	BB(L,J)=1
  356	CONTINUE
  355	CONTINUE
C
	DO 357 L=6,9,2
	BB(2,L)=-1
  357	CONTINUE
	BB(1,5)=.5
	BB(2,5)=.5
	ENDIF
C
	DO 358 LEQ=1,NEQ2
	CC(1,LEQ)=DEN(N-2,LEQ)
	CC(2,LEQ)=DEN(N-1,LEQ)
  358	CONTINUE
C	
	DO 359 LEQ=1,NEQ2
	DO 360 L=N1-4,1,-1
	DEN(L+2,LEQ)=DEN(L,LEQ)
  360	CONTINUE
  359	CONTINUE
C
	DO 361 LEQ=1,NEQ2
	DEN(1,LEQ)=CC(1,LEQ)
	DEN(2,LEQ)=CC(2,LEQ)
  361	CONTINUE
C
	IF(JOB.EQ.2) THEN
	DO 362 J=1,9
	DO 363 L=1,N-1
	AA(L,J)=BB(L,J+9)
  363	CONTINUE
  362	CONTINUE
	ENDIF
C
	NJ=N-1
	CALL LEQT1S(BB,NJ,4,4,NDIM,DEN,NEQ2,NDIM,JOB,AA,IE)
C
	IF(JOB.EQ.0) THEN
	DO 364 J=1,9
	DO 365 L=1,N-1
	BB(L,J+9)=AA(L,J)
  365	CONTINUE
  364	CONTINUE
	JOB=2
	BB(N1+1,2)=2.1
	ENDIF
C
	DO 366 LEQ=1,NEQ2
	DO 367 L=N,N1
	DEN(L,LEQ)=0
  367	CONTINUE
  366	CONTINUE
C
C		MULTIPLICATION PAR (R1+R2*x)
C
	CALL DIRCMS(N,NDIM,NEQ2,0,R1,R2,DEN,CC)
C		
C		MULTIPLICATION PAR x
C
	CALL DIRM1S(N,NDIM,1,NEQ2,CC,DEN)
C
	IF(ICON.EQ.5) THEN
	DO 380 LEQ=1,NEQ2
	DO 381 L=1,N1
	DEN(L,LEQ)=R1*CC(L,LEQ)+R2*DEN(L,LEQ)
  381	CONTINUE
  380	CONTINUE
	RETURN
	ELSE
C
	DO 368 LEQ=1,NEQ2
	DO 369 L=1,N1
	CC(L,LEQ)=R1*CC(L,LEQ)+R2*DEN(L,LEQ)
  369	CONTINUE
  368	CONTINUE
	ENDIF
C
	N8=19
	CALL BUNCOS(N,NDIM,NEQ,N8,ICON,JOB3,JOB2,CI,AA,BB,CC,DEN)
	RETURN
	ENDIF
	ENDIF
	ENDIF
C
C
	IF(IDEG.EQ.318) THEN
C
C		CAS EQUIVALENT AU CAS SPHERIQUE SYMETRIQUE DEGENERE
C
C		N.B.
C               ---
C			PUISQUE LA STRUCTURE DES DIFFERENTS CAS TRAITES
C			EST PRESQUE LA MEME QUE POUR LE PREMIER CAS
C			LES COMMENTAIRES NE SONT PAS REPETES
C
	IDEL=BB(N1+1,6)
	NEQ1=NEQ
	NEQ2=NEQ
C
C		PREPARATION DE L'INPUT DE LEQT1S: COMBINAISON LINEAIRE
C		DES COEFFICIENT DU 2EME MEMBRE DU SYSTEME
C
 	DO 400 LEQ=1,NEQ2
	DO 401 L=1,N1-6
	CC(L,LEQ)=(CC(L+2,LEQ)-CC(L,LEQ))/L
  401	CONTINUE
C
	DO 402 L=1,N1-6
	DEN(L,LEQ)=CC(L+2,LEQ)-CC(L,LEQ)
  402	CONTINUE
C
	DO 403 L=N1-5,N1
	DEN(L,LEQ)=CC(L,LEQ)
  403	CONTINUE
  400	CONTINUE
C	
C		CALCUL DES COEFFICIENTS POUR DES SOLUTION PARTICULIERES 
C		DESTINEES A SATISFARE LES CONDITIONS AU CONTOUR
C
	IF(ICON.EQ.0) GO TO 318
	IF(JOB3.EQ.0) THEN
	NEQ1=NEQ+1
	NEQ2=NEQ1
C
	DO 404 L=1,N-1
	DEN(L,NEQ1)=0
  404 	CONTINUE
	DEN(N,NEQ1)=1
C
	IF(ICON.EQ.3.OR.ICON.EQ.5) THEN
	NEQ2=NEQ+2
C
	DO 405 L=1,N-2
	DEN(L,NEQ2)=0
  405	CONTINUE
C
	DEN(N-1,NEQ2)=1
	DEN(N,NEQ2)=0
	ENDIF
	ENDIF
  318	CONTINUE
C
C
C		CAS N**3*DELTA < 1
C
	IF(IDEL.EQ.14142.OR.ICON.EQ.0) THEN
C
	IF(JOB.EQ.2) THEN
	DO 420 J=1,9
	DO 419 L=1,N
	AA(L,J)=BB(L,J+9)
  419	CONTINUE
  420	CONTINUE
	ENDIF
C
	CALL LEQT1S(BB,N,1,7,NDIM,DEN,NEQ2,NDIM,JOB,AA,IE)
C
	IF(JOB.EQ.0) THEN
	DO 422 J=1,9
	DO 421 L=1,N
	BB(L,J+9)=AA(L,J)
  421	CONTINUE
  422	CONTINUE
	JOB=2
	ENDIF
C
	BB(N1+1,2)=2.1
C
C		LA SOLUTION EST APPROCHEE PAR UNE SERIE
C
C		Co + SOMME[ Cj*(R1+R2*x)**2*Tj(x) ]
C
C		OU LES COEFFICIENTS Cj SONT LA SOLUTION DU SYSTEME
C 		DANS CE QUI SUIT ON DETERMINE LES COEFFICIENTS DE
C		LA SOLUTION.
C		
	DO 423 LEQ=1,NEQ2
	DO 424 L=1,N-1
	CC(L,LEQ)=DEN(L+1,LEQ)
  424	CONTINUE
  423	CONTINUE
C
	DO 425 LEQ=1,NEQ2
	DO 426 L=N,N1
	CC(L,LEQ)=0
  426	CONTINUE
  425	CONTINUE
C
	N14=N1+4
	DO 427 LEQ=1,NEQ2
	CC(N14,LEQ)=DEN(1,LEQ)
  427	CONTINUE
C	
	CALL DIRCMS(N,NDIM,NEQ2,0,R1,R2,CC,DEN)
	CALL DIRM1S(N,NDIM,1,NEQ2,DEN,CC)
C
	IF(ICON.EQ.0.OR.ICON.GT.3) THEN
	DO 428 LEQ=1,NEQ2
	DO 429 L=1,N1
	DEN(L,LEQ)=R1*DEN(L,LEQ)+R2*CC(L,LEQ)
  429	CONTINUE
	DEN(1,LEQ)=DEN(1,LEQ)+CC(N14,LEQ)
  428	CONTINUE
	RETURN
	ELSE
C
	DO 430 LEQ=1,NEQ2
	DO 431 L=1,N1
	CC(L,LEQ)=R1*DEN(L,LEQ)+R2*CC(L,LEQ)
  431	CONTINUE
	CC(1,LEQ)=CC(1,LEQ)+CC(N14,LEQ)
  430	CONTINUE
	ENDIF
	N8=19
	CALL BUNCOS(N,NDIM,NEQ,N8,ICON,JOB3,JOB2,CI,AA,BB,CC,DEN)
	RETURN
	ENDIF
C
C			CAS N**3*DELTA > 1
C
	IF(IDEL.EQ.0) THEN
C
	IF(ICON.EQ.1.OR.ICON.EQ.2.OR.ICON.EQ.4) THEN
C	
	IF(JOB.EQ.0) THEN
	DO 432 J=1,9
	DO 433 L=N-1,1,-1
	BB(L+1,J)=BB(L,J)
  433	CONTINUE
  432	CONTINUE
C
	DO 434 J=1,9
  	BB(1,J)=0
  434	CONTINUE
C
	BB(1,3)=.5
	DO 435 L=4,9
	BB(1,L)=1
  435	CONTINUE
C
	ENDIF
C
	DO 436 LEQ=1,NEQ2
	CC(1,LEQ)=DEN(N,LEQ)
  436	CONTINUE
C	
	N0=N-1
	DO 437 LEQ=1,NEQ2
	DO 438 L=N0,1,-1
	DEN(L+1,LEQ)=DEN(L,LEQ)
  438	CONTINUE
  437	CONTINUE
C
	DO 439 LEQ=1,NEQ2
	DEN(1,LEQ)=CC(1,LEQ)
  439	CONTINUE
C
	IF(JOB.EQ.2) THEN
	DO 440 J=1,9
	DO 441 L=1,N
	AA(L,J)=BB(L,J+9)
  441	CONTINUE
  440	CONTINUE
	ENDIF
C
     	CALL LEQT1S(BB,N,2,6,NDIM,DEN,NEQ2,NDIM,JOB,AA,IE)
C
	IF(JOB.EQ.0) THEN
	DO 443 J=1,9
	DO 444 L=1,N
	BB(L,J+9)=AA(L,J)
  444	CONTINUE
  443	CONTINUE
	ENDIF
	JOB=2
	BB(N1+1,2)=2.1
C
C		MULTIPLICATION PAR R1+R2*x
C
	DO 445 LEQ=1,NEQ2
	DO 446 L=1,N-1
	CC(L,LEQ)=DEN(L+1,LEQ)
  446	CONTINUE
  445	CONTINUE
C
	DO 447 LEQ=1,NEQ2
	DO 448 L=N,N1
	CC(L,LEQ)=0
  448 	CONTINUE
  447	CONTINUE
C
	N14=N1+4
	DO 449 LEQ=1,NEQ2
	CC(N14,LEQ)=DEN(1,LEQ)
  449	CONTINUE
C	
	CALL DIRCMS(N,NDIM,NEQ2,0,R1,R2,CC,DEN)
C
	CALL DIRM1S(N,NDIM,1,NEQ2,DEN,CC)
C
	IF(ICON.EQ.0.OR.ICON.GT.3) THEN
	DO 450 LEQ=1,NEQ2
	DO 451 L=1,N1
	DEN(L,LEQ)=R1*DEN(L,LEQ)+R2*CC(L,LEQ)
  451	CONTINUE
	DEN(1,LEQ)=DEN(1,LEQ)+CC(N14,LEQ)
  450	CONTINUE
	ELSE
C
	DO 452 LEQ=1,NEQ2
	DO 453 L=1,N1
	CC(L,LEQ)=R1*DEN(L,LEQ)+R2*CC(L,LEQ)
  453	CONTINUE
	CC(1,LEQ)=CC(1,LEQ)+CC(N14,LEQ)
  452	CONTINUE
	ENDIF
	N8=19
	CALL BUNCOS(N,NDIM,NEQ,N8,ICON,JOB3,JOB2,CI,AA,BB,CC,DEN)
	RETURN
	ENDIF
C
	IF(ICON.EQ.3.OR.ICON.EQ.5) THEN
C	
	IF(JOB.EQ.0) THEN
	DO 454 J=1,9
	DO 455 L=N-2,1,-1
	BB(L+2,J)=BB(L,J)
  455	CONTINUE
  454	CONTINUE
C
	DO 456 J=1,3
	BB(1,J)=0
	BB(2,J)=0
  456	CONTINUE
C
	DO 457 L=5,9
	BB(1,L)=1
	BB(2,L)=1
  457	CONTINUE
C
	BB(2,5)=-1
	BB(2,7)=-1
	BB(2,9)=-1
	BB(1,4)=.5
	BB(2,4)=.5
C
	ENDIF
C
	DO 459 LEQ=1,NEQ2
	CC(1,LEQ)=DEN(N-1,LEQ)
	CC(2,LEQ)=DEN(N,LEQ)
  459	CONTINUE
C	
	DO 460 LEQ=1,NEQ2
	DO 461 L=N-2,1,-1
	DEN(L+2,LEQ)=DEN(L,LEQ)
  461	CONTINUE
  460	CONTINUE
C
	DO 462 LEQ=1,NEQ2
	DEN(1,LEQ)=CC(1,LEQ)
	DEN(2,LEQ)=CC(2,LEQ)
  462	CONTINUE
C
	IF(JOB.EQ.2) THEN
	DO 463 J=1,9
	DO 464 L=1,N
	AA(L,J)=BB(L,J+9)
  464	CONTINUE
  463	CONTINUE
	ENDIF
C
	CALL LEQT1S(BB,N,3,5,NDIM,DEN,NEQ2,NDIM,JOB,AA,IE)
C
	IF(JOB.EQ.0) THEN
	DO 465 J=1,9
	DO 466 L=1,N
	BB(L,J+9)=AA(L,J)
  466	CONTINUE
  465	CONTINUE
	JOB=2
	BB(N1+1,2)=2.1
	ENDIF
C
C		MULTIPLICATION PAR R1+R2*x
C
	DO 470 LEQ=1,NEQ2
	DO 467 L=1,N-1
	CC(L,LEQ)=DEN(L+1,LEQ)
  467	CONTINUE
  470	CONTINUE
C
	DO 468 LEQ=1,NEQ2
	DO 469 L=N,N1
	CC(L,LEQ)=0
  469	CONTINUE
  468	CONTINUE
C
	N14=N1+4
	DO 475 LEQ=1,NEQ2
	CC(N14,LEQ)=DEN(1,LEQ)
  475	CONTINUE
C	
	CALL DIRCMS(N,NDIM,NEQ2,0,R1,R2,CC,DEN)
C
	CALL DIRM1S(N,NDIM,1,NEQ2,DEN,CC)
C
	IF(ICON.EQ.0.OR.ICON.GT.3) THEN
	DO 471 LEQ=1,NEQ2
	DO 472 L=1,N1
	DEN(L,LEQ)=R1*DEN(L,LEQ)+R2*CC(L,LEQ)
  472	CONTINUE
	DEN(1,LEQ)=DEN(1,LEQ)+CC(N14,LEQ)
  471	CONTINUE
	ELSE
C
	DO 473 LEQ=1,NEQ2
	DO 474 L=1,N1
	CC(L,LEQ)=R1*DEN(L,LEQ)+R2*CC(L,LEQ)
  474	CONTINUE
	CC(1,LEQ)=CC(1,LEQ)+CC(N14,LEQ)
  473	CONTINUE
	ENDIF
C
	N8=19
	CALL BUNCOS(N,NDIM,NEQ,N8,ICON,JOB3,JOB2,CI,AA,BB,CC,DEN)
	RETURN
	ENDIF
	ENDIF
	ENDIF
C
C  MMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMMM
C
C		CAS COQUILLE MINCE: SOUS-CAS COEF(9)=0
C
C		N.B.
C               ---
C			PUISQUE LA STRUCTURE DES DIFFERENTS CAS TRAITES
C			EST PRESQUE LA MEME QUE POUR LE PREMIER CAS
C			LES COMMENTAIRES NE SONT PAS REPETES
C
	IF(IDEG.EQ.319) THEN
C	
	IDEL=BB(N1+1,6)
C
	NEQ1=NEQ
	NEQ2=NEQ
C
	DO 599 LEQ=1,NEQ
	CC(N1,LEQ)=0
  599	CONTINUE
C
C		L'OPRATEUR EST MULTIPLIE A GAUCHE EST A DROITE PAR
C		R1+R2*x. ON MULTIPLIE PAR CONSEQUENT LE 2EME MEMBRE
C		DU SYSTEME
C
	CALL DIRCMS(N,NDIM,NEQ2,0,R1,R2,CC,DEN)
	IF(ICON.EQ.0) THEN
	DO 505 LEQ=1,NEQ2
	DEN(N1,LEQ)=DEN(N1,LEQ)*.5
  505	CONTINUE
	ENDIF
C	
	DO 500 LEQ=1,NEQ2
	DO 501 L=1,N1-4
	DEN(L,LEQ)=(DEN(L+2,LEQ)-DEN(L,LEQ))/L
  501	CONTINUE
C
	DO 502 L=1,N1-4
	DEN(L,LEQ)=DEN(L+2,LEQ)-DEN(L,LEQ)
  502	CONTINUE
  500	CONTINUE
C
	IF(ICON.EQ.0) GO TO 319
	IF(JOB3.EQ.0) THEN
	NEQ1=NEQ+1
	NEQ2=NEQ1
C
	DO 504 L=1,N
	DEN(L,NEQ1)=0
  504	CONTINUE
	DEN(N1,NEQ1)=1
C
	IF(JCON.GT.3) THEN
	NEQ2=NEQ+2
	DO 508 L=1,N-1
	DEN(L,NEQ2)=0
  508	CONTINUE
	DEN(N,NEQ2)=1
	DEN(N1,NEQ2)=0
	ENDIF
	ENDIF	
  319	CONTINUE
C
C		CAS N**3*DELTA < 1 OU ICON=0
C
	IF(IDEL.EQ.14142.OR.ICON.EQ.0) THEN
C
	IF(JOB.EQ.2) THEN
	DO 506 J=1,7
	DO 507 L=1,N1
	AA(L,J)=BB(L,J+7)
  507	CONTINUE
  506	CONTINUE
	ENDIF
C
	CALL LEQT1S(BB,N1,1,5,NDIM,DEN,NEQ2,NDIM,JOB,AA,IE)
C
	IF(JOB.EQ.0) THEN
	DO 580 J=1,7
	DO 509 L=1,N1
	BB(L,J+7)=AA(L,J)
  509	CONTINUE
  580	CONTINUE
	JOB=2
	BB(N1+1,2)=2.1
	ENDIF
C
	DO 510 LEQ=1,NEQ2
	DEN(N1,LEQ)=DEN(N1,LEQ)*2
  510	CONTINUE
	IF(ICON.EQ.0.OR.ICON.GT.3) THEN
	RETURN
	ELSE
	DO 560 LEQ=1,NEQ2
	DO 561 L=1,N1
	CC(L,LEQ)=DEN(L,LEQ)
  561	CONTINUE
  560	CONTINUE
C	
	N8=15
	CALL BUNCOS(N,NDIM,NEQ,N8,ICON,JOB3,JOB2,CI,AA,BB,CC,DEN)
	RETURN
	ENDIF
	ENDIF
C
C			CAS N**3*DELTA > 1
C
	IF(IDEL.EQ.0) THEN
C
	IF(JCON.LT.4) THEN
C	
	IF(JOB.EQ.0) THEN
	DO 511 J=1,7
	DO 512 L=N,1,-1
	BB(L+1,J)=BB(L,J)
  512	CONTINUE
  511	CONTINUE
C
	DO 513 J=1,2
	BB(1,J)=0
  513	CONTINUE
C
	BB(1,3)=.5
	DO 514 J=4,7
	BB(1,J)=1
  514	CONTINUE
	ENDIF
C
	DO 515 LEQ=1,NEQ2
	CC(1,LEQ)=DEN(N1,LEQ)
  515	CONTINUE
C	
	DO 516 LEQ=1,NEQ2
	DO 517 L=N,1,-1
	DEN(L+1,LEQ)=DEN(L,LEQ)
  517	CONTINUE
  516	CONTINUE
C
	DO 518 LEQ=1,NEQ2
	DEN(1,LEQ)=CC(1,LEQ)
  518	CONTINUE
C
	IF(JOB.EQ.2) THEN
	DO 519 J=1,7
	DO 520 L=1,N1
	AA(L,J)=BB(L,J+7)
  520	CONTINUE
  519	CONTINUE
	ENDIF
C
     	CALL LEQT1S(BB,N1,2,4,NDIM,DEN,NEQ2,NDIM,JOB,AA,IE)
C
	IF(JOB.EQ.0) THEN
	DO 521 J=1,7
	DO 522 L=1,N1
	BB(L,J+7)=AA(L,J)
  522	CONTINUE
  521	CONTINUE
	ENDIF
	JOB=2
	BB(N1+1,2)=2.1
C
	DO 523 LEQ=1,NEQ2
  	DEN(N1,LEQ)=DEN(N1,LEQ)*2
  523	CONTINUE
	IF(ICON.GT.3) THEN
	RETURN
	ELSE
C
	DO 524 LEQ=1,NEQ2
	DO 525 L=1,N1
	CC(L,LEQ)=DEN(L,LEQ)
  525	CONTINUE
  524	CONTINUE
	N8=15
	CALL BUNCOS(N,NDIM,NEQ,N8,ICON,JOB3,JOB2,CI,AA,BB,CC,DEN)
	RETURN
	ENDIF
	ENDIF
C
	IF(JCON.GT.3) THEN
C	
	IF(JOB.EQ.0) THEN
	DO 526 J=1,7
	DO 527 L=N1-2,1,-1
	BB(L+2,J)=BB(L,J)
  527	CONTINUE
  526	CONTINUE
C
	DO 570 J=1,3
	BB(1,J)=0
	BB(2,J)=0
  570	CONTINUE
C
	BB(1,4)=.5
	BB(2,4)=.5
	DO 571 J=5,7
	BB(1,J)=1
	BB(2,J)=1
  571	CONTINUE
	BB(2,6)=-1	
	ENDIF
C
	DO 528 LEQ=1,NEQ2
	CC(1,LEQ)=DEN(N,LEQ)
	CC(2,LEQ)=DEN(N1,LEQ)
  528 	CONTINUE
C	
	DO 529 LEQ=1,NEQ2
	DO 530 L=N1-2,1,-1
	DEN(L+2,LEQ)=DEN(L,LEQ)
  530	CONTINUE
  529	CONTINUE
C
	DO 531 LEQ=1,NEQ2
	DEN(1,LEQ)=CC(1,LEQ)
	DEN(2,LEQ)=CC(2,LEQ)
  531	CONTINUE
C
	IF(JOB.EQ.2) THEN
	DO 532 J=1,7
	DO 533 L=1,N1
	AA(L,J)=BB(L,J+7)
  533	CONTINUE
  532	CONTINUE
	ENDIF
C
	CALL LEQT1S(BB,N1,3,3,NDIM,DEN,NEQ2,NDIM,JOB,AA,IE)
C
	IF(JOB.EQ.0) THEN
	DO 534 J=1,7
	DO 535 L=1,N1
	BB(L,J+7)=AA(L,J)
  535	CONTINUE
  534	CONTINUE
	ENDIF
	JOB=2
	BB(N1+1,2)=2.1
C
	ENDIF
C
	DO 536 LEQ=1,NEQ2
	DEN(N1,LEQ)=DEN(N1,LEQ)*2
  536	CONTINUE
	IF(ICON.EQ.5) THEN
	RETURN
	ELSE
C
	N8=15
	DO 537 LEQ=1,NEQ2
	DO 538 L=1,N1
	CC(L,LEQ)=DEN(L,LEQ)
  538	CONTINUE
  537	CONTINUE
C
	CALL BUNCOS(N,NDIM,NEQ,N8,ICON,JOB3,JOB2,CI,AA,BB,CC,DEN)
	RETURN
	ENDIF
        ENDIF
	ENDIF
C
C		CAS COQUILLE MINCE: CAS GENERALE COEF(9).NE.0
C
	IF(IDEG.EQ.320) THEN
C	
C		N.B.
C               ---
C			PUISQUE LA STRUCTURE DES DIFFERENTS CAS TRAITES
C			EST PRESQUE LA MEME QUE POUR LE PREMIER CAS
C			LES COMMENTAIRES NE SONT PAS REPETES
C
	IDEL=BB(N1+1,6)
C
	NEQ1=NEQ
	NEQ2=NEQ
C
	DO 539 LEQ=1,NEQ
	DO 540 L=N,N1
	CC(L,LEQ)=0
  540	CONTINUE
  539	CONTINUE
C	
C		L'OPERATEUR EST MULTIPLIE A GAUCHE EST ADOITE PAR
C		(R1+R2*x)**2. ON MULTIPLIE PAR CONSEQUENT LE 2EME
C		MEMBRE DU SYSTEME PAR (R1+R2*x)**2
C
	CALL DIRCMS(N,NDIM,NEQ,0,R1,R2,CC,DEN)
	CALL DIRCMS(N,NDIM,NEQ,0,R1,R2,DEN,CC)
C
	DO 541 LEQ=1,NEQ
	DO 542 L=1,N1-4
	CC(L,LEQ)=(CC(L+2,LEQ)-CC(L,LEQ))/L
  542   CONTINUE
  541	CONTINUE
C		
	DO 543 LEQ=1,NEQ
	DO 544 L=1,N1-4
	DEN(L,LEQ)=CC(L+2,LEQ)-CC(L,LEQ)
  544	CONTINUE
  543	CONTINUE
C
	DO 545 LEQ=1,NEQ
        DO 546 L=N1-3,N1
	DEN(L,LEQ)=CC(L,LEQ)
  546	CONTINUE
  545	CONTINUE
C	
	IF(ICON.EQ.0) THEN
	JOB3=0
C
	DO 547 LEQ=1,NEQ
	DEN(N1,LEQ)=DEN(N1,LEQ)*.5
  547	CONTINUE
	GO TO 320
	ENDIF
C
	IF(JOB3.EQ.0) THEN
	NEQ1=NEQ+1
	NEQ2=NEQ1
C
	DO 548 L=1,N
	DEN(L,NEQ1)=0
  548	CONTINUE
	DEN(N1,NEQ1)=1
C
	IF(JCON.GT.3) THEN
	NEQ2=NEQ+2
	DO 549 L=1,N-1
	DEN(L,NEQ2)=0	
  549	CONTINUE
	DEN(N,NEQ2)=1
	DEN(N1,NEQ2)=0
	ENDIF
	ENDIF
C
  320	CONTINUE
C
C		CAS N**3*DELTA < 1
C
	IF(IDEL.EQ.14142.OR.ICON.EQ.0) THEN
C
	IF(JOB.EQ.2) THEN
	DO 550 J=1,9
	DO 551 L=1,N1
	AA(L,J)=BB(L,J+9)
  551	CONTINUE
  550	CONTINUE
	ENDIF
C
	CALL LEQT1S(BB,N1,2,6,NDIM,DEN,NEQ2,NDIM,JOB,AA,IE)
C
	IF(JOB.EQ.0) THEN
	DO 552 J=1,9
	DO 553 L=1,N1
	BB(L,J+9)=AA(L,J)
  553	CONTINUE
  552	CONTINUE
	JOB=2
	BB(N1+1,2)=2.1
	ENDIF
C
	DO 554 LEQ=1,NEQ2
	DEN(N1,LEQ)=DEN(N1,LEQ)*2
  554	CONTINUE
C
	IF(ICON.EQ.0.OR.ICON.GT.3) THEN
	RETURN
C
	ELSE
	DO 555 LEQ=1,NEQ2
	DO 556 L=1,N1
	CC(L,LEQ)=DEN(L,LEQ)
  556	CONTINUE
  555	CONTINUE
C
	N8=19
	CALL BUNCOS(N,NDIM,NEQ,N8,ICON,JOB3,JOB2,CI,AA,BB,CC,DEN)
	RETURN
	ENDIF
	ENDIF
C
C			CAS N**3*DELTA > 1
C
	IF(IDEL.EQ.0) THEN
C
	IF(JCON.LT.4) THEN
C	
	IF(JOB.EQ.0) THEN
	DO 557 J=1,9
	DO 558 L=N,1,-1
	BB(L+1,J)=BB(L,J)
  558	CONTINUE
  557	CONTINUE
C
	DO 559 J=1,9
	BB(1,J)=0
  559	CONTINUE
C
	BB(1,4)=.5
	DO 590 J=5,9
	BB(1,J)=1
  590	CONTINUE
	ENDIF
C
	DO 591 LEQ=1,NEQ2
	CC(1,LEQ)=DEN(N1,LEQ)
  591	CONTINUE
C	
	DO 562 LEQ=1,NEQ2
	DO 563 L=N,1,-1
	DEN(L+1,LEQ)=DEN(L,LEQ)
  563	CONTINUE
  562	CONTINUE
C
	DO 564 LEQ=1,NEQ2
	DEN(1,LEQ)=CC(1,LEQ)
  564	CONTINUE
C
	IF(JOB.EQ.2) THEN
	DO 565 J=1,9
	DO 566 L=1,N1
	AA(L,J)=BB(L,J+9)
  566	CONTINUE
  565	CONTINUE
	ENDIF
C
     	CALL LEQT1S(BB,N1,3,5,NDIM,DEN,NEQ2,NDIM,JOB,AA,IE)
C
	IF(JOB.EQ.0) THEN
	DO 567 J=1,9
	DO 568 L=1,N1
	BB(L,J+9)=AA(L,J)
  568	CONTINUE
  567	CONTINUE
	JOB=2
	BB(N1+1,2)=2.1
	ENDIF
C
	DO 569 LEQ=1,NEQ2
	DEN(N1,LEQ)=DEN(N1,LEQ)*2
  569	CONTINUE
C
	IF(ICON.GT.3) THEN
	RETURN
	ELSE
C
	DO 592 LEQ=1,NEQ2
	DO 593 L=1,N1
	CC(L,LEQ)=DEN(L,LEQ)
  593	CONTINUE
  592	CONTINUE
C
	N8=19
	CALL BUNCOS(N,NDIM,NEQ,N8,ICON,JOB3,JOB2,CI,AA,BB,CC,DEN)
	RETURN
	ENDIF
	ENDIF
C
	IF(JCON.GT.3) THEN
C	
	IF(JOB.EQ.0) THEN
	DO 572 J=1,9
	DO 573 L=N1-2,1,-1
	BB(L+2,J)=BB(L,J)
  573	CONTINUE
  572	CONTINUE
C
	DO 574 J=1,9
	BB(1,J)=0
	BB(2,J)=0
  574	CONTINUE
C
	DO 575 L=6,9
	BB(1,L)=1
	BB(2,L)=1
  575	CONTINUE
C
	DO 576 L=6,9,2
	BB(2,L)=-1
  576	CONTINUE
	BB(1,5)=.5
	BB(2,5)=.5
	ENDIF
C
	DO 577 LEQ=1,NEQ2
	CC(1,LEQ)=DEN(N,LEQ)
	CC(2,LEQ)=DEN(N1,LEQ)
  577	CONTINUE
C	
	DO 578 LEQ=1,NEQ2
	DO 579 L=N1-2,1,-1
	DEN(L+2,LEQ)=DEN(L,LEQ)
  579	CONTINUE
  578	CONTINUE
C
	DO 594 LEQ=1,NEQ2
	DEN(1,LEQ)=CC(1,LEQ)
	DEN(2,LEQ)=CC(2,LEQ)
  594	CONTINUE
C
	IF(JOB.EQ.2) THEN
	DO 581 J=1,9
	DO 582 L=1,N1
	AA(L,J)=BB(L,J+9)
  582	CONTINUE
  581	CONTINUE
	ENDIF
C
	CALL LEQT1S(BB,N1,4,4,NDIM,DEN,NEQ2,NDIM,JOB,AA,IE)
C
	IF(JOB.EQ.0) THEN
	DO 583 J=1,9
	DO 584 L=1,N1
	BB(L,J+9)=AA(L,J)
  584	CONTINUE
  583	CONTINUE
	JOB=2
	BB(N1+1,2)=2.1
	ENDIF
C
	ENDIF
C
	DO 585 LEQ=1,NEQ2
	DEN(N1,LEQ)=DEN(N1,LEQ)*2
  585	CONTINUE
	IF(ICON.EQ.5) THEN
	RETURN
	ELSE
C
	DO 586 LEQ=1,NEQ2
	DO 587 L=1,N1
	CC(L,LEQ)=DEN(L,LEQ)
  587	CONTINUE
  586	CONTINUE
C
	N8=19
	CALL BUNCOS(N,NDIM,NEQ,N8,ICON,JOB3,JOB2,CI,AA,BB,CC,DEN)
	RETURN
	ENDIF
	ENDIF
	ENDIF
C
  100	FORMAT(1X,10E10.3)
  101	FORMAT(1X,' ')
  199	FORMAT(1X,8E15.8)
	RETURN
	END
