/** @file

Copyright (c) 2022, Intel Corporation. All rights reserved.<BR>

Redistribution and use in source and binary forms, with or without modification,
are permitted provided that the following conditions are met:

* Redistributions of source code must retain the above copyright notice, this
  list of conditions and the following disclaimer.
* Redistributions in binary form must reproduce the above copyright notice, this
  list of conditions and the following disclaimer in the documentation and/or
  other materials provided with the distribution.
* Neither the name of Intel Corporation nor the names of its contributors may
  be used to endorse or promote products derived from this software without
  specific prior written permission.

  THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
  AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
  IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
  ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR CONTRIBUTORS BE
  LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR
  CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF
  SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS
  INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN
  CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE)
  ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF
  THE POSSIBILITY OF SUCH DAMAGE.

  This file is automatically generated. Please do NOT modify !!!

**/

#ifndef __FSPMUPD_H__
#define __FSPMUPD_H__

#include <FspUpd.h>

#pragma pack(1)

#define MAX_CHANNEL 3       /* Maximum Number of Memory Channels */
#define MAX_DIMM 2          /* Maximum Number of DIMMs PER Memory Channel */
#define MAX_SPD_BYTES 512   /* Maximum Number of SPD bytes */
#define MAX_USB_PORTS 4

/*
* SMBIOS Memory Info structures.
*/
typedef struct {
  UINT8         DimmId;
  UINT32        SizeInMb;
  UINT16        MfgId;
  UINT8         ModulePartNum[20]; /* Module part number for DDR3 is 18 bytes however for DRR4 20 bytes as per JEDEC Spec, so reserving 20 bytes */
} DIMM_INFO;

typedef struct {
  UINT8         ChannelId;
  UINT8         DimmCount;
  DIMM_INFO     DimmInfo[MAX_DIMM];
} CHANNEL_INFO;

typedef struct {
  UINT8         Revision;
  UINT16        DataWidth;
  /** As defined in SMBIOS 3.0 spec
  Section 7.18.2 and Table 75
  **/
  UINT16        MemoryType;
  UINT16        MemoryFrequencyInMHz;
  /** As defined in SMBIOS 3.0 spec
  Section 7.17.3 and Table 72
  **/
  UINT8         ErrorCorrectionType;
  UINT8         ChannelCount;
  CHANNEL_INFO  ChannelInfo[MAX_CHANNEL];
} FSP_SMBIOS_MEMORY_INFO;

typedef struct {
  UINT32        PerfSig;
  UINT16        PerfLen;
  UINT16        Reserved4;
  UINT32        PerfIdx;
  UINT64        PerfData[32];
} FSP_PERF_INFO;

#define BL_MAX_FIA_LANES 24
#define BL_FIA_LANE_OVERRIDE_DISABLED  0xff
#define BL_FIA_LANE_DISABLED           0x0
#define BL_FIA_LANE_PCIE               0x1
#define BL_FIA_LANE_SATA               0x2
#define BL_FIA_LANE_XHCI               0x3
#define BL_FIA_LANE_PCIE_ROOT_PORT_LINK_WIDTH_SET_BY_BICTRL  0x0
#define BL_FIA_LANE_PCIE_ROOT_PORT_LINK_WIDTH_X1             0x1

typedef struct {
  UINT8 FiaLaneConfig[BL_MAX_FIA_LANES];
  UINT8 FiaLaneLinkWidth[BL_MAX_FIA_LANES];
} BL_HSIO_INFORMATION;

/**
  This structure holds the DLL configuration
  register values that will be programmed by RC.
  Those policies should be used by platform if default values
  provided by RC are not sufficient to provide stable operation
  at all supported speed modes. RC will blindly set the DLL values
  as provided in this structure.

  For help with obtaining valid DLL values for your platform please
  contact enabling support.
**/
typedef struct {
  UINT32  TxCmdDelayControl;      // Offset 820h: Tx CMD Delay Control
  UINT32  TxDataDelayControl1;    // Offset 824h: Tx Data Delay Control 1
  UINT32  TxDataDelayControl2;    // Offset 828h: Tx Data Delay Control 2
  UINT32  RxCmdDataDelayControl1; // Offset 82Ch: Rx CMD + Data Delay Control 1
  UINT32  RxCmdDataDelayControl2; // Offset 834h: Rx CMD + Data Delay Control 2
  UINT32  RxStrobeDelayControl;   // Offset 830h: Rx Strobe Delay Control, valid only for eMMC
} BL_SCS_SD_DLL;

/**
  Definition of FIA OVERRIDE STATUS HOB
  Get/Set Status are defined by their respective Get/Set MeFiaMuxConfig functions called in PeiFiaMuxConfigInitLib.

  FIA MUX configuration is based on platform design and generally set by soft straps.
  FIA MUX configuration can change the generic lane assignment through the FSP UPDs to increase flexibility.
  FIA_OVERRIDE_STATUS_HOB allows the FSP to provide the required feedback
    on the update of the FIA MUX configuration to the customer's bootloader.
**/
typedef struct {
  UINT32    FiaMuxConfigGetStatus;     // Status returned by MeFiaMuxConfigGet (MeFiaMuxLib)
  UINT32    FiaMuxConfigSetStatus;     // Status returned by MeFiaMuxConfigSet (MeFiaMuxLib)
  BOOLEAN   FiaMuxConfigSetRequired;   // Indicates that a set was required in the FIA lane assignment.
                                       //   FALSE = the requested config matched the existing one.
                                       //   TRUE  = the requested config did not match the existing one.
} BL_FIA_OVERRIDE_STATUS_HOB;


//
// Data Types
//
#ifndef UINT64_STRUCT_T
#define UINT64_STRUCT_T
typedef union {
  struct {
    UINT32  Low;
    UINT32  High;
  } Data32;
  UINT64 Data;
} BL_UINT64_STRUCT;
#endif // UINT64_STRUCT_T

///
/// RC version number structure.
///
typedef struct {
  UINT8   Major;
  UINT8   Minor;
  UINT8   Revision;
  UINT16  BuildNumber;
} BL_RC_VERSION;

#define BL_MAX_CHA_MAP                 4
#define BL_MAX_FW_KTI_PORTS            3
#define BL_MAX_SOCKET                  1
#define BL_NUMBER_PORTS_PER_SOCKET     9
#define BL_TYPE_MAX_MMIO_BAR           11
#define BL_MAX_IMC                     2
#define BL_MAX_CH                      2
#define BL_MAX_LOGIC_IIO_STACK         8
#define BL_MAX_IIO_STACK               6
#define BL_MaxIIO                      BL_MAX_SOCKET
#define BL_MC_MAX_NODE                 (BL_MAX_SOCKET * BL_MAX_IMC)


typedef struct {
  UINT8                     Valid;         // TRUE, if the link is valid (i.e reached normal operation)
  UINT8                     PeerSocId;     // Socket ID
  UINT8                     PeerSocType;   // Socket Type (0 - CPU; 1 - IIO)
  UINT8                     PeerPort;      // Port of the peer socket
}BL_QPI_PEER_DATA;

typedef struct {
  UINT8                     Valid;
  UINT32                    MmioBar[BL_TYPE_MAX_MMIO_BAR];
  UINT8                     PcieSegment;
  BL_UINT64_STRUCT          SegMmcfgBase;
  UINT16                    stackPresentBitmap;
  UINT16                    M2PciePresentBitmap;
  UINT8                     TotM3Kti;
  UINT8                     TotCha;
  UINT32                    ChaList[BL_MAX_CHA_MAP];
  UINT32                    SocId;
  BL_QPI_PEER_DATA          PeerInfo[BL_MAX_FW_KTI_PORTS];    // QPI LEP info
} BL_QPI_CPU_DATA;

typedef struct {
  UINT8                     Valid;
  UINT8                     SocId;
  BL_QPI_PEER_DATA          PeerInfo[BL_MAX_SOCKET];    // QPI LEP info
} BL_QPI_IIO_DATA;

typedef struct {
  UINT8       Device;
  UINT8       Function;
} BL_IIO_PORT_INFO;

typedef struct {
  BL_IIO_PORT_INFO        PortInfo[BL_NUMBER_PORTS_PER_SOCKET];
} BL_IIO_DMI_PCIE_INFO;

typedef struct _BL_STACK_RES {
  UINT8                   Personality;
  UINT8                   BusBase;
  UINT8                   BusLimit;
  UINT16                  PciResourceIoBase;
  UINT16                  PciResourceIoLimit;
  UINT32                  IoApicBase;
  UINT32                  IoApicLimit;
  UINT32                  Mmio32Base;            // Base of low MMIO configured for this stack in memory map
  UINT32                  Mmio32Limit;           // Limit of low MMIO configured for this stack in memory map
  UINT64                  Mmio64Base;            // Base of high MMIO configured for this stack in memory map
  UINT64                  Mmio64Limit;           // Limit of high MMIO configured for this stack in memory map
  UINT32                  PciResourceMem32Base;  // Base of low MMIO resource available for PCI devices
  UINT32                  PciResourceMem32Limit; // Limit of low MMIO resource available for PCI devices
  UINT64                  PciResourceMem64Base;  // Base of high MMIO resource available for PCI devices
  UINT64                  PciResourceMem64Limit; // Limit of high MMIO resource available for PCI devices
  UINT32                  VtdBarAddress;
  UINT32                  Mmio32MinSize;         // Minimum required size of MMIO32 resource needed for this stack
} BL_STACK_RES;

typedef struct {
  UINT8                   Valid;
  UINT8                   SocketID;            // Socket ID of the IIO (0..3)
  UINT8                   BusBase;
  UINT8                   BusLimit;
  UINT16                  PciResourceIoBase;
  UINT16                  PciResourceIoLimit;
  UINT32                  IoApicBase;
  UINT32                  IoApicLimit;
  UINT32                  Mmio32Base;          // Base of low MMIO configured for this socket in memory map
  UINT32                  Mmio32Limit;         // Limit of low MMIO configured for this socket in memory map
  UINT64                  Mmio64Base;          // Base of high MMIO configured for this socket in memory map
  UINT64                  Mmio64Limit;         // Limit of high MMIO configured for this socket in memory map
  BL_STACK_RES            StackRes[BL_MAX_LOGIC_IIO_STACK];
  UINT32                  RcBaseAddress;
  BL_IIO_DMI_PCIE_INFO    PcieInfo;
  UINT8                   DmaDeviceCount;
} BL_IIO_RESOURCE_INSTANCE;

typedef struct {
  UINT16                    PlatGlobalIoBase;       // Global IO Base
  UINT16                    PlatGlobalIoLimit;      // Global IO Limit
  UINT32                    PlatGlobalMmio32Base;   // Global Mmiol base
  UINT32                    PlatGlobalMmio32Limit;  // Global Mmiol limit
  UINT64                    PlatGlobalMmio64Base;   // Global Mmioh Base [43:0]
  UINT64                    PlatGlobalMmio64Limit;  // Global Mmioh Limit [43:0]
  BL_QPI_CPU_DATA           CpuQpiInfo[BL_MAX_SOCKET]; // QPI related info per CPU
  BL_QPI_IIO_DATA           IioQpiInfo[BL_MAX_SOCKET]; // QPI related info per IIO
  UINT32                    MemTsegSize;
  UINT32                    MemIedSize;
  UINT64                    PciExpressBase;
  UINT32                    PciExpressSize;
  UINT32                    MemTolm;
  BL_IIO_RESOURCE_INSTANCE  IIO_resource[BL_MAX_SOCKET];
  UINT8                     numofIIO;
  UINT8                     MaxBusNumber;
  UINT32                    packageBspApicID[BL_MAX_SOCKET]; // This data array is valid only for SBSP, not for non-SBSP CPUs. <AS> for CpuSv
  UINT8                     EVMode;
  UINT8                     Pci64BitResourceAllocation;
  UINT8                     SkuPersonality[BL_MAX_SOCKET];
  UINT8                     VMDStackEnable[BL_MaxIIO][BL_MAX_IIO_STACK];
  UINT16                    IoGranularity;
  UINT32                    MmiolGranularity;
  BL_UINT64_STRUCT          MmiohGranularity;
  UINT8                     RemoteRequestThreshold;  //5370389
  UINT32                    UboxMmioSize;
  UINT32                    MaxAddressBits;
} BL_PLATFORM_DATA;

typedef struct {
    UINT8                   CurrentUpiiLinkSpeed;// Current programmed UPI Link speed (Slow/Full speed mode)
    UINT8                   CurrentUpiLinkFrequency; // Current requested UPI Link frequency (in GT)
    UINT8                   OutKtiCpuSktHotPlugEn;            // 0 - Disabled, 1 - Enabled for PM X2APIC
    UINT32                  OutKtiPerLinkL1En[BL_MAX_SOCKET];    // output kti link enabled status for PM
    UINT8                   IsocEnable;
    UINT32                  meRequestedSize; // Size of the memory range requested by ME FW, in MB
    UINT32                  ieRequestedSize; // Size of the memory range requested by IE FW, in MB
    UINT8                   DmiVc1;
    UINT8                   DmiVcm;
    UINT32                  CpuPCPSInfo;
    UINT8                   cpuSubType;
    UINT8                   SystemRasType;
    UINT8                   numCpus;                                        // 1,..4. Total number of CPU packages installed and detected (1..4)by QPI RC
    UINT16                  tolmLimit;
    UINT32                  tohmLimit;
    BL_RC_VERSION           RcVersion;
    BOOLEAN                 MsrTraceEnable;
    UINT8                   DdrXoverMode;           // DDR 2.2 Mode
    // For RAS
    UINT8                   bootMode;
    UINT8                   OutClusterOnDieEn; // Whether RC enabled COD support
    UINT8                   OutSncEn;
    UINT8                   OutNumOfCluster;
    UINT8                   imcEnabled[BL_MAX_SOCKET][BL_MAX_IMC];
    UINT16                  LlcSizeReg;
    UINT8                   chEnabled[BL_MAX_SOCKET][BL_MAX_CH];
    UINT8                   memNode[BL_MC_MAX_NODE];
    UINT8                   IoDcMode;
    UINT8                   DfxRstCplBitsEn;
} BL_SYSTEM_STATUS;

typedef struct {
    BL_PLATFORM_DATA           PlatformData;
    BL_SYSTEM_STATUS           SystemStatus;
} BL_IIO_UDS;

//PCI MMIO and IO resource reconfiguration
typedef struct {
  UINT16                      IoBase;                              // Base of I/O range assigned to entity
  UINT16                      IoLimit;                             // Limit of I/O range assigned to entity
  UINT32                      LowMmioBase;                         // Base of low MMIO region for entity
  UINT32                      LowMmioLimit;                        // Limit of low MMIO region for entity
  UINT64                      HighMmioBase;                        // Base of high (64-bit) MMIO region for entity
  UINT64                      HighMmioLimit;                       // Limit of high (64-bit) MMIO region for entity
} BL_PCI_BASE_LIMITS;

typedef struct {
  BL_PCI_BASE_LIMITS          StackLimits[BL_MAX_LOGIC_IIO_STACK]; // Base and Limit of all PCIe resources for each stack of the socket
} BL_SOCKET_PCI_BASE_LIMITS;

typedef struct {
  BL_SOCKET_PCI_BASE_LIMITS   Socket[BL_MAX_SOCKET];               // Base and limit of all PCIe resources for each socket
} BL_SYSTEM_PCI_BASE_LIMITS;

typedef struct {
  UINT64   Key0[BL_MAX_SOCKET];
  UINT64   Key1[BL_MAX_SOCKET];
} BL_TME_INIT_DATA;


/** FSP-M Configuration
**/
typedef struct {

/** Offset 0x0040 - Enable BIOS SSA RMT
  Enables/Disables SSA RMT. Please refer to the Integration guide for RMT details.
  $EN_DIS
**/
  UINT8                       PcdEnableBiosSsaRMT;

/** Offset 0x0041 - Enable BIOS SSA RMT on Fast Cold Boot
  Enables/Disables SSA RMT on a Fast Cold Boot
  $EN_DIS
**/
  UINT8                       PcdEnableBiosSsaRMTonFCB;

/** Offset 0x0042 - Enable RMT per Bit Margining
  Enables/Disables Per Bit Margining
  $EN_DIS
**/
  UINT8                       PcdBiosSsaPerBitMargining;

/** Offset 0x0043 - Enable SSA Tables Display
  Enables/Disables displaying results as tables
  $EN_DIS
**/
  UINT8                       PcdBiosSsaDisplayTables;

/** Offset 0x0044 - Enable SSA Plot Display
  Enables/Disables the display of per bit results as plots
  $EN_DIS
**/
  UINT8                       PcdBiosSsaPerDisplayPlots;

/** Offset 0x0045 - Loop count for rank test
  Exponential loop count for a single rank test
**/
  UINT8                       PcdBiosSsaLoopCount;

/** Offset 0x0046 - Enable Backside Margining
  Enables/Disables margin test on the register or buffer backside
  $EN_DIS
**/
  UINT8                       PcdBiosSsaBacksideMargining;

/** Offset 0x0047 - Enable Early Read ID Margining
  Enables/Disables PMem Early Read Id Test
  $EN_DIS
**/
  UINT8                       PcdBiosSsaEarlyReadIdMargining;

/** Offset 0x0048 - Enable Step Size Override
  Enables/Disables overriding the default step sizes
  $EN_DIS
**/
  UINT8                       PcdBiosSsaStepSizeOverride;

/** Offset 0x0049 - Step size RxDqs
  Step size of RxDqs. Auto:1. Supported values : 1,2,4,8. This option is valid only
  if 'Enable Step size override' is Enabled
  1:1, 2:2, 4:4, 8:8
**/
  UINT8                       PcdBiosSsaRxDqs;

/** Offset 0x004A - Step size RxVrefs
  Step size of RxVrefs. Auto:1. Supported values : 1,2,4,8. This option is valid only
  if 'Enable Step size override' is Enabled
  1:1, 2:2, 4:4, 8:8
**/
  UINT8                       PcdBiosSsaRxVref;

/** Offset 0x004B - Step size TxDqs
  Step size of TxDqs. Auto:1. Supported values : 1,2,4,8. This option is valid only
  if 'Enable Step size override' is Enabled
  1:1, 2:2, 4:4, 8:8
**/
  UINT8                       PcdBiosSsaTxDq;

/** Offset 0x004C - Step size TxVrefs
  Step size of TxVrefs. Auto:1. Supported values : 1,2,4,8. This option is valid only
  if 'Enable Step size override' is Enabled
  1:1, 2:2, 4:4, 8:8
**/
  UINT8                       PcdBiosSsaTxVref;

/** Offset 0x004D - Step size CmdAll
  Step size of CmdAll. Auto:1. Supported values : 1,2,4,8. This option is valid only
  if 'Enable Step size override' is Enabled
  1:1, 2:2, 4:4, 8:8
**/
  UINT8                       PcdBiosSsaCmdAll;

/** Offset 0x004E - Step size CmdVref
  Step size of CmdVref. Auto:1. Supported values : 1,2,4,8. This option is valid only
  if 'Enable Step size override' is Enabled
  1:1, 2:2, 4:4, 8:8
**/
  UINT8                       PcdBiosSsaCmdVref;

/** Offset 0x004F - Step size CtlAll
  Step size of CtlAll. Auto:1. Supported values : 1,2,4,8. This option is valid only
  if 'Enable Step size override' is Enabled
  1:1, 2:2, 4:4, 8:8
**/
  UINT8                       PcdBiosSsaCtlAll;

/** Offset 0x0050 - Step size EridDelay
  Step size of EridDelay. Auto:1. Supported values : 1,2,4,8. This option is valid
  only if 'Enable Step size override' is Enabled
  1:1, 2:2, 4:4, 8:8
**/
  UINT8                       PcdBiosSsaEridDelay;

/** Offset 0x0051 - Step size EridVref
  Step size of EridVref. Auto:1. Supported values : 1,2,4,8. This option is valid
  only if 'Enable Step size override' is Enabled
  1:1, 2:2, 4:4, 8:8
**/
  UINT8                       PcdBiosSsaEridVref;

/** Offset 0x0052 - Enable SSA RMT Debug Message
  Enables the BSSA RMT debug messages
  2:Disable, 5:Enable
**/
  UINT8                       PcdBiosSsaDebugMessages;

/** Offset 0x0053 - TCC Enable
  Enable or Disable Intel® Time Coordinated Compute (TCC) features
  $EN_DIS
**/
  UINT8                       PcdTccEnable;

/** Offset 0x0054
**/
  UINT8                       UnusedUpdSpace0[12];

/** Offset 0x0060 - ECC Support
  Enable/disable ECC Support.
  $EN_DIS
**/
  UINT8                       PcdEccSupport;

/** Offset 0x0061 - Fast Boot
  Enable/Disable Fast Boot.
  0:Disabled,1:Enabled
**/
  UINT8                       PcdFastBoot;

/** Offset 0x0062 - Memory Test
  Enable/Disable Memory Test.
  $EN_DIS
**/
  UINT8                       PcdMemTest;

/** Offset 0x0063 - Memory Turnaround Time Optimization
  Enable/Disable Memory turnaround time optimization.
  $EN_DIS
**/
  UINT8                       PcdMemTurnaroundOpt;

/** Offset 0x0064 - Memory Frequency
  Set DDR Memory Frequency Limit
  0: AUTO, 13:2400, 15:2666, 17: 2933
**/
  UINT8                       PcdDdrFreq;

/** Offset 0x0065 - Memory Command Timing
  Select the desired memory controller command timing
  0:Auto, 1:1N, 2:2N, 3:3N
**/
  UINT8                       PcdCommandTiming;

/** Offset 0x0066 - Memory Custom Refresh Rate
  Set Desired rate in 0.1x units of the standard 7.8 usec interval. The valid range
  is 20 - 80(i.e. 2x to 8x)
**/
  UINT8                       PcdCustomRefreshRate;

/** Offset 0x0067
**/
  UINT8                       UnusedUpdSpace1[41];

/** Offset 0x0090 - HSUART Device
  Select the PCI High Speed UART Device for Serial Port.
  0:HSUART0, 1:HSUART1, 2:HSUART2
**/
  UINT8                       PcdHsuartDevice;

/** Offset 0x0091 - ME Heci Communication
  Enable/Disable ME Heci Communication.
  0:Disabled,1:Enabled
**/
  UINT8                       PcdHeciCommunication;

/** Offset 0x0092 - Virtualization Technology for Directed I/O
  Enable/Disable Virtualization Technology for Directed I/O.
  $EN_DIS
**/
  UINT8                       PcdVtdSupport;

/** Offset 0x0093 - Enable USB3 Ports
  Enable/Disable per USB3 Ports. One byte for each port, byte0 for port0, byte1 for
  port1 and so on.
**/
  UINT32                      PcdPchUsb3Port;

/** Offset 0x0097 - Enable USB2 Ports
  Enable/Disable per USB2 Ports. One byte for each port, byte0 for port0, byte1 for
  port1 and so on.
**/
  UINT32                      PcdPchUsb2Port;

/** Offset 0x009B - Enable USB3 Port Over Current Configuration
  Enable over current pin assignment per USB3 port. 0xFF mean skip over current pin.
  One byte for each port, byte0 for port0, byte1 for port1 and so on
**/
  UINT32                      PcdPchUsb3PortOc;

/** Offset 0x009F - Enable USB2 Port Over Current Configuration
  Enable over current pin assignment per USB2 port. 0xFF mean skip over current pin.
  One byte for each port, byte0 for port0, byte1 for port1 and so on
**/
  UINT32                      PcdPchUsb2PortOc;

/** Offset 0x00A3 - USB2 Per Port HS Pre-emphasis Bias
  USB2 Per Port HS Pre-emphasis Bias. 000b - 0mV, 001b - 11.25mV, 010b - 16.9mV, 011b
  - 28.15mV, 100b - 28.15mV, 101b - 39.35mV, 110b - 45mV, 111b - 56.3mV. One byte
  for each port.
**/
  UINT32                      PcdUsb2PeTxiSet;

/** Offset 0x00A7 - USB2 Per Port HS Transmitter Bias
  USB2 Per Port HS Transmitter Bias. 000b - 0mV, 001b - 11.25mV, 010b - 16.9mV, 011b
  - 28.15mV, 100b - 28.15mV, 101b - 39.35mV, 110b - 45mV, 111b - 56.3mV. One byte
  for each port.
**/
  UINT32                      PcdUsb2TxiSet;

/** Offset 0x00AB - USB2 Per Port HS Transmitter Emphasis
  USB2 Per Port HS Transmitter Emphasis. 00b - Emphasis OFF, 01b - De-emphasis ON,
  10b - Pre-emphasis ON, 11b - Pre-emphasis & De-emphasis ON. One byte for each port.
**/
  UINT32                      PcdUsb2PreDeEmp;

/** Offset 0x00AF - USB2 Per Port Half Bit Pre-emphasis
  USB2 Per Port Half Bit Pre-emphasis. 1b - half-bit pre-emphasis, 0b - full-bit pre-emphasis.
  One byte for each port.
**/
  UINT32                      PcdUsb2PreEmpHalfBit;

/** Offset 0x00B3 - IIO PCIe Port 1 Bifurcation
  IIO PCI Express port bifurcation for selected slot(s).
  0xFF:Auto, 0:X4X4X4X4, 1:X4X4X8, 2:X8X4X4, 3:X8X8, 4:X16
**/
  UINT8                       PcdIIOPciePortBifurcation;

/** Offset 0x00B4 - IIO PCIe R-Link DeEmphasis
  Desired DeEmphasis level for IIO PCIe R-Link
  0:6dB, 1:3.5dB
**/
  UINT8                       PcdIIoPcieRLinkDeEmphasis;

/** Offset 0x00B5 - IIO PCIe Port 1A DeEmphasis
  Desired DeEmphasis level for IIO PCIe Port 1A
  0:6dB, 1:3.5dB
**/
  UINT8                       PcdIIoPciePort1ADeEmphasis;

/** Offset 0x00B6 - IIO PCIe Port 1B DeEmphasis
  Desired DeEmphasis level for IIO PCIe Port 1B
  0:6dB, 1:3.5dB
**/
  UINT8                       PcdIIoPciePort1BDeEmphasis;

/** Offset 0x00B7 - IIO PCIe Port 1C DeEmphasis
  Desired DeEmphasis level for IIO PCIe Port 1C
  0:6dB, 1:3.5dB
**/
  UINT8                       PcdIIoPciePort1CDeEmphasis;

/** Offset 0x00B8 - IIO PCIe Port 1D DeEmphasis
  Desired DeEmphasis level for IIO PCIe Port 1D
  0:6dB, 1:3.5dB
**/
  UINT8                       PcdIIoPciePort1DDeEmphasis;

/** Offset 0x00B9 - IIO PCIe R-Link Link Speed
  Desired Link Speed for IIO PCIe R-Link
  0:Auto, 1:GEN1, 2:GEN2, 3:GEN3
**/
  UINT8                       PcdIIoPcieLinkSpeedRLink;

/** Offset 0x00BA - IIO PCIe Port 1A Link Speed
  Desired Link Speed for IIO PCIe Port 1A
  0:Auto, 1:GEN1, 2:GEN2, 3:GEN3, 4:GEN4
**/
  UINT8                       PcdIIoPciePort1ALinkSpeed;

/** Offset 0x00BB - IIO PCIe Port 1B Link Speed
  Desired Link Speed for IIO PCIe Port 1B
  0:Auto, 1:GEN1, 2:GEN2, 3:GEN3, 4:GEN4
**/
  UINT8                       PcdIIoPciePort1BLinkSpeed;

/** Offset 0x00BC - IIO PCIe Port 1C Link Speed
  Desired Link Speed for IIO PCIe Port 1C
  0:Auto, 1:GEN1, 2:GEN2, 3:GEN3, 4:GEN4
**/
  UINT8                       PcdIIoPciePort1CLinkSpeed;

/** Offset 0x00BD - IIO PCIe Port 1D Link Speed
  Desired Link Speed for IIO PCIe Port 1D
  0:Auto, 1:GEN1, 2:GEN2, 3:GEN3, 4:GEN4
**/
  UINT8                       PcdIIoPciePort1DLinkSpeed;

/** Offset 0x00BE - IIO PCIe R-Link Aspm
  Desired Active state power management settings for IIO PCIe R-Link
  0:Disabled,4:Auto
**/
  UINT8                       PcdIIoPcieRLinkAspm;

/** Offset 0x00BF - IIO PCIe Port 1A Aspm
  Desired Active state power management settings for IIO PCIe Port 1A
  0:Disabled,4:Auto
**/
  UINT8                       PcdIIoPciePort1AAspm;

/** Offset 0x00C0 - IIO PCIe Port 1B Aspm
  Desired Active state power management settings for IIO PCIe Port 1B
  0:Disabled,4:Auto
**/
  UINT8                       PcdIIoPciePort1BAspm;

/** Offset 0x00C1 - IIO PCIe Port 1C Aspm
  Desired Active state power management settings for IIO PCIe Port 1C
  0:Disabled,4:Auto
**/
  UINT8                       PcdIIoPciePort1CAspm;

/** Offset 0x00C2 - IIO PCIe Port 1D Aspm
  Desired Active state power management settings for IIO PCIe Port 1D
  0:Disabled,4:Auto
**/
  UINT8                       PcdIIoPciePort1DAspm;

/** Offset 0x00C3 - PCH PCIe Controller 0 Bifurcation
  Configure PCI Express controller 0 bifurcation.
  0: Auto, 5:4x2, 6:1x4 2x2, 7:2x2 1x4, 8:2x4, 9:1x8
**/
  UINT8                       PcdBifurcationPcie0;

/** Offset 0x00C4 - PCH PCIe Controller 2 Bifurcation
  Configure PCI Express controller 2 bifurcation.
  0: Auto, 5:4x2, 6:1x4 2x2, 7:2x2 1x4, 8:2x4, 9:1x8
**/
  UINT8                       PcdBifurcationPcie2;

/** Offset 0x00C5 - PCH PCIe Controller 1 Bifurcation
  Configure PCI Express controller 1 bifurcation.
  0: Auto, 5:4x2, 6:1x4 2x2, 7:2x2 1x4, 8:2x4, 9:1x8
**/
  UINT8                       PcdBifurcationPcie1;

/** Offset 0x00C6 - IIO PCIe Port 2 Bifurcation
  IIO PCI Express port bifurcation for selected slot(s). This Option is valid only
  for IVL HCC Platform.
  0xFF:Auto, 0:X4X4X4X4, 1:X4X4X8, 2:X8X4X4, 3:X8X8, 4:X16
**/
  UINT8                       PcdIIOPciePort2Bifurcation;

/** Offset 0x00C7 - IIO PCIe Port 2A DeEmphasis
  Desired DeEmphasis level for IIO PCIe Port 2A This Option is valid only for IVL
  HCC Platform.
  0:6dB, 1:3.5dB
**/
  UINT8                       PcdIIoPciePort2ADeEmphasis;

/** Offset 0x00C8 - IIO PCIe Port 2B DeEmphasis
  Desired DeEmphasis level for IIO PCIe Port 2B This Option is valid only for IVL
  HCC Platform.
  0:6dB, 1:3.5dB
**/
  UINT8                       PcdIIoPciePort2BDeEmphasis;

/** Offset 0x00C9 - IIO PCIe Port 2C DeEmphasis
  Desired DeEmphasis level for IIO PCIe Port 2C This Option is valid only for IVL
  HCC Platform.
  0:6dB, 1:3.5dB
**/
  UINT8                       PcdIIoPciePort2CDeEmphasis;

/** Offset 0x00CA - IIO PCIe Port 2D DeEmphasis
  Desired DeEmphasis level for IIO PCIe Port 2D This Option is valid only for IVL
  HCC Platform.
  0:6dB, 1:3.5dB
**/
  UINT8                       PcdIIoPciePort2DDeEmphasis;

/** Offset 0x00CB - IIO PCIe Port 2A Link Speed
  Desired Link Speed for IIO PCIe Port 2A This Option is valid only for IVL HCC Platform.
  0:Auto, 1:GEN1, 2:GEN2, 3:GEN3, 4:GEN4
**/
  UINT8                       PcdIIoPciePort2ALinkSpeed;

/** Offset 0x00CC - IIO PCIe Port 2B Link Speed
  Desired Link Speed for IIO PCIe Port 2B This Option is valid only for IVL HCC Platform.
  0:Auto, 1:GEN1, 2:GEN2, 3:GEN3, 4:GEN4
**/
  UINT8                       PcdIIoPciePort2BLinkSpeed;

/** Offset 0x00CD - IIO PCIe Port 2C Link Speed
  Desired Link Speed for IIO PCIe Port 2C This Option is valid only for IVL HCC Platform.
  0:Auto, 1:GEN1, 2:GEN2, 3:GEN3, 4:GEN4
**/
  UINT8                       PcdIIoPciePort2CLinkSpeed;

/** Offset 0x00CE - IIO PCIe Port 2D Link Speed
  Desired Link Speed for IIO PCIe Port 2D This Option is valid only for IVL HCC Platform.
  0:Auto, 1:GEN1, 2:GEN2, 3:GEN3, 4:GEN4
**/
  UINT8                       PcdIIoPciePort2DLinkSpeed;

/** Offset 0x00CF - IIO PCIe Port 2A Aspm
  Desired Active state power management settings for IIO PCIe Port 2A This Option
  is valid only for IVL HCC Platform.
  0:Disabled,4:Auto
**/
  UINT8                       PcdIIoPciePort2AAspm;

/** Offset 0x00D0 - IIO PCIe Port 2B Aspm
  Desired Active state power management settings for IIO PCIe Port 2B This Option
  is valid only for IVL HCC Platform.
  0:Disabled,4:Auto
**/
  UINT8                       PcdIIoPciePort2BAspm;

/** Offset 0x00D1 - IIO PCIe Port 2C Aspm
  Desired Active state power management settings for IIO PCIe Port 2C This Option
  is valid only for IVL HCC Platform.
  0:Disabled,4:Auto
**/
  UINT8                       PcdIIoPciePort2CAspm;

/** Offset 0x00D2 - IIO PCIe Port 2D Aspm
  Desired Active state power management settings for IIO PCIe Port 2D This Option
  is valid only for IVL HCC Platform.
  0:Disabled,4:Auto
**/
  UINT8                       PcdIIoPciePort2DAspm;

/** Offset 0x00D3 - IIO PCIe Port 2A Hot Plug Capable
  Hot Plug Capable for IIO PCIe Port 2A This Option is valid only for IVL HCC Platform.
  0:Disable, 1:Enable, 2:Auto
**/
  UINT8                       PcdIIoPciePort2AHPCapable;

/** Offset 0x00D4 - IIO PCIe Port 2B Hot Plug Capable
  Hot Plug Capable for IIO PCIe Port 2B This Option is valid only for IVL HCC Platform.
  0:Disable, 1:Enable, 2:Auto
**/
  UINT8                       PcdIIoPciePort2BHPCapable;

/** Offset 0x00D5 - IIO PCIe Port 2C Hot Plug Capable
  Hot Plug Capable for IIO PCIe Port 2C This Option is valid only for IVL HCC Platform.
  0:Disable, 1:Enable, 2:Auto
**/
  UINT8                       PcdIIoPciePort2CHPCapable;

/** Offset 0x00D6 - IIO PCIe Port 2D Hot Plug Capable
  Hot Plug Capable for IIO PCIe Port 2D This Option is valid only for IVL HCC Platform.
  0:Disable, 1:Enable, 2:Auto
**/
  UINT8                       PcdIIoPciePort2DHPCapable;

/** Offset 0x00D7 - IIO PCIe Port 2A Hot Plug Surprise
  Enable / Disable Hot Plug Capable Surprise for IIO PCIe Port 2A This Option is valid
  only for IVL HCC Platform.
  $EN_DIS
**/
  UINT8                       PcdIIoPciePort2AHPSurprise;

/** Offset 0x00D8 - IIO PCIe Port 2B Hot Plug Surprise
  Enable / Disable Hot Plug Capable Surprise for IIO PCIe Port 2B This Option is valid
  only for IVL HCC Platform.
  $EN_DIS
**/
  UINT8                       PcdIIoPciePort2BHPSurprise;

/** Offset 0x00D9 - IIO PCIe Port 2C Hot Plug Surprise
  Enable / Disable Hot Plug Capable Surprise for IIO PCIe Port 2C This Option is valid
  only for IVL HCC Platform.
  $EN_DIS
**/
  UINT8                       PcdIIoPciePort2CHPSurprise;

/** Offset 0x00DA - IIO PCIe Port 2D Hot Plug Surprise
  Enable / Disable Hot Plug Capable Surprise for IIO PCIe Port 2D This Option is valid
  only for IVL HCC Platform.
  $EN_DIS
**/
  UINT8                       PcdIIoPciePort2DHPSurprise;

/** Offset 0x00DB - Warm Reset Elimination Enable
  Warm Reset Elimination Enable or Disable.
  $EN_DIS
**/
  UINT8                       PcdDfxWarmResetEliminationEn;

/** Offset 0x00DC - Clock Generator Address
  Set SKU Clock generator address. Valid field should be set. Skip Clock Generator
  should be set to Disable.
**/
  UINT8                       PcdSkuClockGeneratorAddress;

/** Offset 0x00DD - SSC Secondary Smbus use
  Enable or Disable SSC Secondary Smbus use. Skip Clock Generator should be set to Disable.
  $EN_DIS
**/
  UINT8                       PcdSkuSSCSecondarySmbusUsed;

/** Offset 0x00DE - Skip Clock Generator
  Enable or Disable to skip clock generator configuration.
  $EN_DIS
**/
  UINT8                       PcdSkipClockGenerator;

/** Offset 0x00DF - SSC Enable for Host
  Enable Spread Spectrum Control for the Host(CPU) PCIe High-Speed Root Ports. Skip
  Clock Generator should be set to Disable.
  0:Disable, 1:Enable SSC with 0.25 spread, 2:Enable SSC with 0.5 spread
**/
  UINT8                       PcdEnableClockSpreadSpec;

/** Offset 0x00E0
**/
  UINT8                       UnusedUpdSpace2[57];

/** Offset 0x0119 - PCI-E port Clock Gating
  Enable / Disable PCI-E Clock Gating for each port First byte represents Clock gating
  for port 1A,Second byte for port 2A... respectively for each PCI-E Port. Each byte
  takes value 0x00(Disable)~0x01(Enable)
**/
  UINT8                       PcdPciePortClkGateEnable[21];

/** Offset 0x012E - Power Performance Tuning
  Options decides who Controls EPB. 0:In OS mode :IA32_ENERGY_PERF_BIAS is used (Option
  0 is valid only if PcdProcessorHWPMEnable is 0/1), 1:In BIOS mode:ENERGY_PERF_BIAS_CONFIG
  is used, 2:In PECI mode: PCS53 is used.
  0:OS Controls EPB, 1:BIOS Controls EPB , 2:PECI Controls EPB
**/
  UINT8                       PcdPwrPerfTuning;

/** Offset 0x012F - ENERGY_PERF_BIAS_CFG mode
  (Valid if Power Performance Tuning is set to 1:BIOS Controls EPB.) Use input from
  ENERGY_PERF_BIAS_CONFIG mode selection. PERF/Balanced Perf/Balanced Power/Power
  0:Performance, 7:Balanced Performance, 8:Balanced Power ,15:Power
**/
  UINT8                       PcdAltEngPerfBIAS;

/** Offset 0x0130 - Customer Revision
  The Customer can set this revision string for their own purpose.
**/
  UINT8                       PcdCustomerRevision[32];

/** Offset 0x0150 - Memory Thermal Throttling
  Enable/disable Memory Thermal Throttling
  0:Disabled,2:Enabled
**/
  UINT8                       PcdMemoryThermalThrottling;

/** Offset 0x0151 - FSP Debug Print Level
  Select the FSP debug print level.
  0:NO DEBUG, 1:MIN DEBUG, 2:MED DEBUG, 3:VERBOSE DEBUG
**/
  UINT8                       PcdFspDebugPrintErrorLevel;

/** Offset 0x0152
**/
  UINT8                       PcdFiaMuxOverride;

/** Offset 0x0153
**/
  UINT8                       FiaMuxCfgInvalidate;

/** Offset 0x0154 - DCI Enable
  Enable / Disable DCI . Refer to Integration guide
  $EN_DIS
**/
  UINT8                       PcdDciEn;

/** Offset 0x0155 - USB DbC Enable Mode
   USB Debug mode . Refer to Integration guide
  0:Disabled, 1:USB2, 2:USB3, 3:Both, 4:NoChange (default)
**/
  UINT8                       PcdDciDbcMode;

/** Offset 0x0156 - USB3 Type-C UFP2DFP Debug Support
  USB3 UFP2DFP Debug support. Refer to Integration guide
  0:Disabled, 1:Enabled, 2:No Change
**/
  UINT8                       PcdDciUsb3TypecUfpDbg;

/** Offset 0x0157 - PCH Trace Hub Enable Mode
  Select Host or Target for Trace Hub debugger tool. Refer to Integration guide.
  0:Disable, 1:Target debugger, 2:Host debugger
**/
  UINT8                       PcdPchTraceHubMode;

/** Offset 0x0158 - PCH TH Mem Buffer Size 0
  Select size of memory region 0 buffer. Refer to Integration guide.
  0:None/OS, 1:1 MB, 2:8 MB, 3:64 MB, 4:128 MB, 5:256 MB, 6:512 MB
**/
  UINT8                       PcdPchTraceHubMemReg0Size;

/** Offset 0x0159 - PCH TH Mem Buffer Size 1
  Select size of memory region 1 buffer. Refer to Integration guide
  0:None/OS, 1:1 MB, 2:8 MB, 3:64 MB, 4:128 MB, 5:256 MB, 6:512 MB
**/
  UINT8                       PcdPchTraceHubMemReg1Size;

/** Offset 0x015A
**/
  UINT8                       UnusedUpdSpace3;

/** Offset 0x015B - IMR3 Enable
  Enable/Disable IMR3 .Default is Disabled .Refer to Integration guide
  $EN_DIS
**/
  UINT8                       PcdEnableIMR3;

/** Offset 0x015C - Processor X2APIC Enable
  Enable / Disable Processor X2APIC. Refer to Integration guide
  $EN_DIS
**/
  UINT8                       PcdProcessorX2Apic;

/** Offset 0x015D - Hyper Threading Enable/Disable
  Enable or Disable Hyper Threading; 0: Disable; <b>1: Enable</b>
  $EN_DIS
**/
  UINT8                       PcdHyperThreading;

/** Offset 0x015E - PCIe Hot Plug Enable
  Enable / Disable PCIe Hot Plug.
  $EN_DIS
**/
  UINT8                       PcdPcieHotPlugEnable;

/** Offset 0x015F
**/
  UINT8                       UnusedUpdSpace4;

/** Offset 0x0160 - IIO PCIe R-Link Hot Plug Capable
  Hot Plug Capable for IIO PCIe R-Link
  0:Disable, 1:Enable, 2:Auto
**/
  UINT8                       PcdIIoPcieLinkHPCapable;

/** Offset 0x0161 - IIO PCIe Port 1A Hot Plug Capable
  Hot Plug Capable for IIO PCIe Port 1A
  0:Disable, 1:Enable, 2:Auto
**/
  UINT8                       PcdIIoPciePort1AHPCapable;

/** Offset 0x0162 - IIO PCIe Port 1B Hot Plug Capable
  Hot Plug Capable for IIO PCIe Port 1B
  0:Disable, 1:Enable, 2:Auto
**/
  UINT8                       PcdIIoPciePort1BHPCapable;

/** Offset 0x0163 - IIO PCIe Port 1C Hot Plug Capable
  Hot Plug Capable for IIO PCIe Port 1C
  0:Disable, 1:Enable, 2:Auto
**/
  UINT8                       PcdIIoPciePort1CHPCapable;

/** Offset 0x0164 - IIO PCIe Port 1D Hot Plug Capable
  Hot Plug Capable for IIO PCIe Port 1D
  0:Disable, 1:Enable, 2:Auto
**/
  UINT8                       PcdIIoPciePort1DHPCapable;

/** Offset 0x0165 - IIO PCIe R-Link Hot Plug Surprise
  Enable / Disable Hot Plug Capable Surprise for IIO PCIe R-Link
  $EN_DIS
**/
  UINT8                       PcdIIoPcieLinkHPSurprise;

/** Offset 0x0166 - IIO PCIe Port 1A Hot Plug Surprise
  Enable / Disable Hot Plug Capable Surprise for IIO PCIe Port 1A
  $EN_DIS
**/
  UINT8                       PcdIIoPciePort1AHPSurprise;

/** Offset 0x0167 - IIO PCIe Port 1B Hot Plug Surprise
  Enable / Disable Hot Plug Capable Surprise for IIO PCIe Port 1B
  $EN_DIS
**/
  UINT8                       PcdIIoPciePort1BHPSurprise;

/** Offset 0x0168 - IIO PCIe Port 1C Hot Plug Surprise
  Enable / Disable Hot Plug Capable Surprise for IIO PCIe Port 1C
  $EN_DIS
**/
  UINT8                       PcdIIoPciePort1CHPSurprise;

/** Offset 0x0169 - IIO PCIe Port 1D Hot Plug Surprise
  Enable / Disable Hot Plug Capable Surprise for IIO PCIe Port 1D
  $EN_DIS
**/
  UINT8                       PcdIIoPciePort1DHPSurprise;

/** Offset 0x016A - Speed Step (P-states)
  Enable / Disable EIST (P-States)
  $EN_DIS
**/
  UINT8                       PcdProcessorEistEnable;

/** Offset 0x016B - Boot performance mode
  Select Boot Performance State. EIST should be Enabled
  0:Max Performance, 1:Max Efficient, 2:Set by Intel Node Manager
**/
  UINT8                       PcdBootPState;

/** Offset 0x016C - Hardware P-States
  Select Hardware P-State control
  0:Disable, 1:Native Mode, 2:Out of Band Mode, 3:Native Mode with No Legacy Support
**/
  UINT8                       PcdProcessorHWPMEnable;

/** Offset 0x016D - Hardware PM Interrupt
  Enable / Disable Hardware PM Interrupt. Hardware P-States should be Native mode
  $EN_DIS
**/
  UINT8                       PcdProcessorHWPMInterrupt;

/** Offset 0x016E - EPP Enable
  Enable / Disable EPP. Hardware P-States should not be disabled
  $EN_DIS
**/
  UINT8                       PcdProcessorEPPEnable;

/** Offset 0x016F - EPP profile
  Select HWPM Profile (EPP). Hardware P-States should be OOB and EPP should be enabled
  0:Performance, 128:Balanced Performance, 192:Balanced Power, 255:Power
**/
  UINT8                       PcdProcessorEppProfile;

/** Offset 0x0170 - Package C State
  Package C State limit
  0:C0/C1 state, 1:C2 state, 2:C6(non Retention) state, 255:Auto
**/
  UINT8                       PcdPackageCState;

/** Offset 0x0171 - Enhanced Halt State (C1E)
  Enable / Disable Core C1E auto promotion Control
  $EN_DIS
**/
  UINT8                       PcdProcessorC1eEnable;

/** Offset 0x0172 - C2C3TT
  C2 to C3 Transition Timer. Default = 0, means [AUTO]
**/
  UINT8                       PcdC2C3TT;

/** Offset 0x0173 - CPU C3 report
  Enable/Disable CPU C3(ACPI C2) report to OS
  $EN_DIS
**/
  UINT8                       PcdC3Enable;

/** Offset 0x0174 - CPU C6 report
  Enable/Disable CPU C6(ACPI C3) report to OS
  0:Disable, 1:Enable, 255:Auto
**/
  UINT8                       PcdC6Enable;

/** Offset 0x0175 - Enable Monitor MWAIT
  Enable / Disable Monitor and MWAIT instructions
  $EN_DIS
**/
  UINT8                       PcdMonitorMWait;

/** Offset 0x0176 - C State Latency Control VALID[0]
  Enable / Disable validity of the Value field in this register
  $EN_DIS
**/
  UINT8                       PcdCStateLatencyCtrlValid0;

/** Offset 0x0177 - C State Latency Control MULTIPLIER[0]
  Indicates the unit of measurement that is defined for the Value field in this register.
  Valid field should be set
**/
  UINT8                       PcdCStateLatencyCtrlMultiplier0;

/** Offset 0x0178 - C State Latency Control VALUE[0]
  The Interrupt Response Time Limit is given in units defined in the Multiplier field
  of this register. Valid field should be set
**/
  UINT16                      PcdCStateLatencyCtrlValue0;

/** Offset 0x017A - C State Latency Control VALID[1]
  Enable / Disable validity of the Value field in this register
  $EN_DIS
**/
  UINT8                       PcdCStateLatencyCtrlValid1;

/** Offset 0x017B - C State Latency Control MULTIPLIER[1]
  Indicates the unit of measurement that is defined for the Value field in this register.
  Valid field should be set
**/
  UINT8                       PcdCStateLatencyCtrlMultiplier1;

/** Offset 0x017C - C State Latency Control VALUE[1]
  The Interrupt Response Time Limit is given in units defined in the Multiplier field
  of this register. Valid field should be set
**/
  UINT16                      PcdCStateLatencyCtrlValue1;

/** Offset 0x017E - C State Latency Control VALID[2]
  Enable / Disable validity of the Value field in this register
  $EN_DIS
**/
  UINT8                       PcdCStateLatencyCtrlValid2;

/** Offset 0x017F - C State Latency Control MULTIPLIER[2]
  Indicates the unit of measurement that is defined for the Value field in this register.
  Valid field should be set
**/
  UINT8                       PcdCStateLatencyCtrlMultiplier2;

/** Offset 0x0180 - C State Latency Control VALUE[2]
  The Interrupt Response Time Limit is given in units defined in the Multiplier field
  of this register. Valid field should be set
**/
  UINT16                      PcdCStateLatencyCtrlValue2;

/** Offset 0x0182 - Config TDP Lock
  Config TDP CONTROL Lock Bit. EIST should be enabled
  $EN_DIS
**/
  UINT8                       PcdConfigTdpLock;

/** Offset 0x0183 - AVX P1
  AVX P1 level selection. EIST should be enabled
  0:Normal, 1:Level 1, 2:Level 2
**/
  UINT8                       PcdConfigTdpLevel;

/** Offset 0x0184 - AVX Support
  Enable/Disable AVX/2/3 instructions. Applicable to only certain SKUs - OC and HEDT
  $EN_DIS
**/
  UINT8                       PcdAvxSupport;

/** Offset 0x0185 - AVX Licence Pre-Grant Override
  Enables AVX ICCP pre-grant level override
  $EN_DIS
**/
  UINT8                       PcdAvxLicensePreGrant;

/** Offset 0x0186 - AVX ICCP pre-grant level
  Pre-grants an AVX level to the core. Base frequency is not updated. AVX Licence
  Pre-Grant Override should be enabled
  1:128 Heavy, 2:256 Light, 3:256 Heavy, 4: 512 Light, 5: 512 Heavy
**/
  UINT8                       PcdAvxIccpLevel;

/** Offset 0x0187 - GPSS timer
  P-state change hysteresis time window
  0:0 us, 5:50 us, 50:500 us
**/
  UINT8                       PcdGpssTimer;

/** Offset 0x0188 - Software Controlled T-States
  Enable / Disable Software Controlled T-States
  $EN_DIS
**/
  UINT8                       PcdTStateEnable;

/** Offset 0x0189 - PROCHOT Modes
  When a processor thermal sensor trips, the PROCHOT# will be driven
  0:Output-only, 1:Disable, 2:Both Input and Output, 3:Input-only
**/
  UINT8                       PcdEnableProcHot;

/** Offset 0x018A - Thermal Monitor
  Enable / Disable Thermal Monitor
  $EN_DIS
**/
  UINT8                       PcdEnableThermalMonitor;

/** Offset 0x018B - AC Exception On Split Lock
  Enable or Disable AC (Alignment Check) Exception On Split Lock
  $EN_DIS
**/
  UINT8                       PcdAcExceptionOnSplitLockEnable;

/** Offset 0x018C - PCIe Allocating Write Flows
  Select Vc0/VCp write selection for all CPU PCIe ports
  0x00:Non-Allocating, 0x01:Allocating
**/
  UINT8                       PcdPcieAllocatingFlow;

/** Offset 0x018D - IIO LLC Ways [19:0](Hex)
  MSR CBO_SLICE0_CR_IIO_LLC_WAYS bitmask
**/
  UINT32                      PcdIioLlcWaysMask;

/** Offset 0x0191 - Enable/ Disable VMD
  Enable/Disable VMD in this Stack for socket0. First byte:Represents VMD config for
  PCH port(Stack 0) Second Byte:Represents VMD config for IOU 0(Stack1) Each byte
  takes value 0x00(Disable)~0x01(Enable)
**/
  UINT8                       PcdVMDEnabled[2];

/** Offset 0x0193 - PCH Root Port
  Configuration PCH root port:Enable-VMD ownership root port (Valid if PchRootPortIsAllowed
  for respective port) First byte represents PCH Root Port 0,Second byte is PCH Root
  Port 1,... PCH Root Port 11 respectively for each PCH Root Port. Each byte takes
  value 0x00(Disable)~0x01(Enable)
**/
  UINT8                       PcdVMDPchPortEnable[12];

/** Offset 0x019F - VMD port A
  Enable/Disable Intel® Volume Management Device Technology on specific root port
  $EN_DIS
**/
  UINT8                       PcdVMDPortEnableA;

/** Offset 0x01A0
**/
  UINT8                       UnusedUpdSpace5;

/** Offset 0x01A1 - VMD port B
  Enable/Disable Intel® Volume Management Device Technology on specific root port
  $EN_DIS
**/
  UINT8                       PcdVMDPortEnableB;

/** Offset 0x01A2 - VMD port C
  Enable/Disable Intel® Volume Management Device Technology on specific root port
  $EN_DIS
**/
  UINT8                       PcdVMDPortEnableC;

/** Offset 0x01A3 - VMD port D
  Enable/Disable Intel® Volume Management Device Technology on specific root port
  $EN_DIS
**/
  UINT8                       PcdVMDPortEnableD;

/** Offset 0x01A4 - Hot Plug Capable
  Enable/Disable Hot Plug for PCIe Root Ports. First Byte:Represents VMD Hot plug
  config for PCH port. Second Byte:Represents VMD Hot plug config for IOU 0 Each
  byte takes value 0(Disable)~1(Enable)
**/
  UINT8                       PcdVMDHotPlugEnable[2];

/** Offset 0x01A6 - CfgBar Size
  Setup VMD Config BAR size (in bits Min=0x14, Max=0x1B), ex: 0x14(20 bits)=1MB, 0x1B(27bits)=128MB
  First Byte:Represents VMD Config BAR size for PCH port. Second Byte:Represents
  VMD Config BAR size for IOU 0.
**/
  UINT8                       PcdVMDCfgBarSz[2];

/** Offset 0x01A8 - CfgBar attribute
  Set up VMD Config BAR attribute, like 64-bit or prefetchable. First Byte:Represents
  VMD Config BAR Attribute for PCH port. Second Byte:Represents VMD Config BAR Attribute
  for IOU 0  Each Byte takes value of 0x0:(32-bit non-prefetchable),0x1:(64-bit non-prefetchable),
  0x2:(64-bit prefetchable)
**/
  UINT8                       PcdVMDCfgBarAttr[2];

/** Offset 0x01AA - MemBar1 Size
  Setup VMD Memory BAR1 size (in bits Min=0x14,max=0x27), ex: 0x14(20 bits)=1MB  First
  Byte:Represents VMD Memory BAR1 size for PCH port  Second Byte:Represents VMD Memory
  BAR1 size for IOU 0
**/
  UINT8                       PcdVMDMemBarSz1[2];

/** Offset 0x01AC - MemBar1 attribute
  Set up VMD Memory BAR1 attribute, like 64-bit or prefetchable First Byte:Represents
  VMD Memory BAR1 attribute for PCH port  Second Byte:Represents VMD Memory BAR1
  attribute for IOU 0  Each Byte takes value of 0x0:(32-bit non-prefetchable),0x1:(64-bit
  non-prefetchable), 0x2:(64-bit prefetchable)
**/
  UINT8                       PcdVMDMemBar1Attr[2];

/** Offset 0x01AE - MemBar2 Size
  Setup VMD Memory BAR2 size (in bits Min=0x14,max = 0x27), ex: 0x14(20bits)=1MB,
  0x16(22bits)=4MB. First Byte:Represents VMD Memory BAR2 size for PCH port. Second
  Byte:Represents VMD Memory BAR2 size for IOU 0
**/
  UINT8                       PcdVMDMemBarSz2[2];

/** Offset 0x01B0 - MemBar2 attribute
  Set up VMD Memory BAR2 attribute, like 64-bit or prefetchable. First Byte:Represents
  VMD Memory BAR2 attribute for PCH port. Second Byte:Represents VMD Memory BAR2
  attribute for IOU 0  Each Byte takes value of 0x0:(32-bit non-prefetchable),0x1:(64-bit
  non-prefetchable), 0x2:(64-bit prefetchable)
**/
  UINT8                       PcdVMDMemBar2Attr[2];

/** Offset 0x01B2 - VMD for Direct Assign
  Enable/ Disable VMD for Direct Assign if VMD is enabled  First Byte:Represents VMD
  for Direct Assign for PCH port  Second Byte:Represents VMD for Direct Assign for
  IOU 0  Each byte takes value 0x00(Disable)~0x01(Enable)
**/
  UINT8                       PcdVMDDirectAssign[2];

/** Offset 0x01B4 - Power Limit 1 Enable
  Enable/Disable Power Limit 1
  $EN_DIS
**/
  UINT8                       PcdPowerLimit1Enable;

/** Offset 0x01B5 - Power Limit 2 Enable
  Enable/Disable Power Limit 2
  $EN_DIS
**/
  UINT8                       PcdPowerLimit2Enable;

/** Offset 0x01B6 - Turbo Mode
  Enable/Disable Turbo Mode
  $EN_DIS
**/
  UINT8                       PcdTurboMode;

/** Offset 0x01B7 - IIO PCIe Global ASPM
  Enable/Disable PCIe ASPM on all IIO PCIe root ports
  $EN_DIS
**/
  UINT8                       PcdPcieGlobalAspm;

/** Offset 0x01B8 - PCH Legacy IO Low Latency
  Enable/Disable low latency of legacy IO. Increase power consumption for lower latency.
  $EN_DIS
**/
  UINT8                       PcdPchLegacyIoLowLatency;

/** Offset 0x01B9 - PCH DMI ASPM
  Enable/Disable L1 ASPM for Rlink
  $EN_DIS
**/
  UINT8                       PcdPchDmiAspm;

/** Offset 0x01BA - DRAM RAPL
  Enable/Disable DRAM Rapl
  $EN_DIS
**/
  UINT8                       PcdDramRaplEnable;

/** Offset 0x01BB - PCH DMI ASPM
  Enable/Disable CKE Throttling
  $EN_DIS
**/
  UINT8                       PcdCkeProgramming;

/** Offset 0x01BC - PCH DMI ASPM
  Enable/Disable APD
  $EN_DIS
**/
  UINT8                       PcdApdEnable;

/** Offset 0x01BD - PCH DMI ASPM
  Enable/Disable PPD
  $EN_DIS
**/
  UINT8                       PcdPpdEnable;

/** Offset 0x01BE - Tcc Tuning enable/disable
  Tcc (Time Coordinated Computing) Tuning Enabled
  $EN_DIS
**/
  UINT8                       PcdTccDsoTuningEn;

/** Offset 0x01BF - Tcc Tuning enable/disable
  Tcc (Time Coordinated Computing) Tuning Enabled
  $EN_DIS
**/
  UINT8                       PcdTccSoftwareSramEn;

/** Offset 0x01C0 - Tcc Tuning enable/disable
  Tcc (Time Coordinated Computing) Tuning Enabled
  $EN_DIS
**/
  UINT8                       PcdTccErrorLogEn;

/** Offset 0x01C1 - Tcc BIOS Config File Base Address
  Tcc (Time Coordinated Computing) TCC BIOS Config File Base Address
**/
  UINT32                      PcdTccStreamCfgBasePreMem;

/** Offset 0x01C5 - Tcc BIOS Config File Size
  Tcc (Time Coordinated Computing) TCC BIOS Config File Size
**/
  UINT32                      PcdTccStreamCfgSizePreMem;

/** Offset 0x01C9 - Address of BL_TME_INIT_DATA table.
  The address of the table of BL_TME_INIT_DATA.
**/
  UINT32                      PcdTmePtr;

/** Offset 0x01CD - Tme Enable
  Enable or Disable TME
  $EN_DIS
**/
  UINT8                       PcdTmeEnable;

/** Offset 0x01CE - MkTme Enable
  Enable or Disable MKTME, Tme should be enabled before enabling MkTme. Cpu addressing
  is restricted to 46 bit by default. With MKTME normal adressing will be followed
  $EN_DIS
**/
  UINT8                       PcdMkTmeEnable;

/** Offset 0x01CF - IIO PCIe Multi VC Enable
  Enable or Disable IIO PCIe Multi Virtual Channels
  $EN_DIS
**/
  UINT8                       PcdIioPcieMultiVcEnable;

/** Offset 0x01D0
**/
  UINT32                      PcdIioResConfigPtr;

/** Offset 0x01D4
**/
  UINT32                      PcdFiaLaneConfigPtr;

/** Offset 0x01D8
**/
  UINT32                      PcdKtiBufferPtr;

/** Offset 0x01DC
**/
  UINT32                      PcdMemSpdPtr;

/** Offset 0x01E0 - Protect memory Range size
  Size of the PRMRR region
**/
  UINT64                      PcdPrmrrSize;

/** Offset 0x01E8 - SGX Enable
  Enable or Disable Software Guard Extensions
  $EN_DIS
**/
  UINT8                       PcdSgxEnable;

/** Offset 0x01E9 - SGX Auto registration
  Enable or Disable SGX auto registration
  $EN_DIS
**/
  UINT8                       PcdSgxAutoRegistrationAgent;

/** Offset 0x01EA - SGX Quality of Service
  Enable or Disable SGX QoS to use LLC cache for EPC
  $EN_DIS
**/
  UINT8                       PcdSgxQoS;

/** Offset 0x01EB - SGX Debug mode
  Enable or Disable SGX Debug mode
  $EN_DIS
**/
  UINT8                       PcdSgxDebugMode;

/** Offset 0x01EC - SGX Flexible Launch Control
  Enable or Disable SGX Flexible Launch Control
  $EN_DIS
**/
  UINT8                       PcdSgxLeWr;

/** Offset 0x01ED - SGX Flexible Launch Control public key Hash 0
  SGX flex launch control public key hash 0
**/
  UINT64                      PcdSgxLePubKeyHash0;

/** Offset 0x01F5 - SGX Flexible Launch Control public key Hash 1
  SGX flex launch control public key hash 1
**/
  UINT64                      PcdSgxLePubKeyHash1;

/** Offset 0x01FD - SGX Flexible Launch Control public key Hash 2
  SGX flex launch control public key hash 2
**/
  UINT64                      PcdSgxLePubKeyHash2;

/** Offset 0x0205 - SGX Flexible Launch Control public key Hash 3
  SGX flex launch control public key hash 3
**/
  UINT64                      PcdSgxLePubKeyHash3;

/** Offset 0x020D - PCI Express Root Port
  Enable/Disable PcieRootPort from 1 to 12, each bit represent a port(bit0-bit11)
  and last nibble is unusedFor example, bit0 0 controls PcieRootPortPort 1, bit1
  controls PcieRootPortPort 2...
**/
  UINT16                      PcdPcieRootPortEn;

/** Offset 0x020F
**/
  UINT8                       ReservedMemoryInitUpd[16];
} FSP_M_CONFIG;

/** Fsp M UPD Configuration
**/
typedef struct {

/** Offset 0x0000
**/
  FSP_UPD_HEADER              FspUpdHeader;

/** Offset 0x0020
**/
  FSPM_ARCH_UPD               FspmArchUpd;

/** Offset 0x0040
**/
  FSP_M_CONFIG                FspmConfig;

/** Offset 0x021F
**/
  UINT8                       UnusedUpdSpace6[13];

/** Offset 0x022C
**/
  UINT16                      UpdTerminator;
} FSPM_UPD;

#pragma pack()

#endif
