/* SPDX-License-Identifier: GPL-2.0-only */

#include <baseboard/variants.h>
#include <commonlib/helpers.h>

/* Pad configuration in ramstage*/
static const struct pad_config gpio_table[] = {
/*BT_RF_KILL_N*/
PAD_CFG_GPO(GPP_E11, 1, DEEP),

/*WIFI_RF_KILL_N*/
PAD_CFG_GPO(GPP_E10, 1, DEEP),

/*M.2_WLAN_PERST_N*/
PAD_CFG_GPO(GPD7, 1, PLTRST),

/*M.2_WLAN_SLP*/
PAD_CFG_GPO(GPD9, 1, PLTRST),

/*WIFI_WAKE_N*/
PAD_CFG_GPI_SCI(GPP_F4, UP_5K, DEEP, LEVEL, INVERT),

/*UART_BT_WAKE_N*/
PAD_CFG_GPI_SCI(GPP_F20, NONE, DEEP, LEVEL, INVERT),

/*ONBOARD_X4_PCIE_SLOT1_RESET_N*/
PAD_CFG_GPO(GPD11, 1, PLTRST),

/*ONBOARD_X4_PCIE_SLOT1_WAKE_N*/
PAD_CFG_GPI_SCI(GPP_E2, NONE, DEEP, LEVEL, INVERT),

/*M.2_WWAN_PWR_EN*/
PAD_CFG_GPO(GPP_F21, 1, PLTRST),

/*M.2_WWAN_RST_N*/
PAD_CFG_GPO(GPP_V13, 1, PLTRST),

/*M.2_WWAN_PE_RST_N*/
PAD_CFG_GPO(GPP_B14, 1, PLTRST),

/*M.2_WWAN_PE_WAKE_N*/
PAD_CFG_GPO(GPP_B17, 1, PLTRST),

/*M.2_WWAN_FCP_OFF_N*/
PAD_CFG_GPO(GPP_E0, 1, PLTRST),

/*M.2_SSD_SATA_DEVSLP_1*/
PAD_CFG_NF(GPP_E8, NONE, DEEP, NF2),

/*BC_PROCHOT_N*/
PAD_CFG_GPI_SCI(GPP_B2, NONE, PLTRST, EDGE_SINGLE, INVERT),

/*FPS_RST_N*/
PAD_CFG_GPO(GPP_V14, 1, PLTRST),

/*FPS_INT*/
PAD_CFG_GPI_APIC(GPP_V15, NONE, PLTRST, LEVEL, NONE),

/*CODEC_INT_N*/
PAD_CFG_GPI(GPP_B15, NONE, PLTRST),

/*TCH_PNL_PWR_EN*/
PAD_CFG_GPO(GPP_B16, 1, PLTRST),

/*THC0_SPI1_INT_N*/
PAD_CFG_GPI_APIC(GPP_E17, NONE, PLTRST, LEVEL, INVERT),

/*SPI_TPM_INT_N*/
PAD_CFG_GPI_APIC(GPP_G19, NONE, DEEP, LEVEL, NONE),

/*EMMC_CMD*/
PAD_CFG_NF(GPP_V0, UP_20K, DEEP, NF1),

/*EMMC_DATA0*/
PAD_CFG_NF(GPP_V1, UP_20K, DEEP, NF1),

/*EMMC_DATA1*/
PAD_CFG_NF(GPP_V2, UP_20K, DEEP, NF1),

/*EMMC_DATA2*/
PAD_CFG_NF(GPP_V3, UP_20K, DEEP, NF1),

/*EMMC_DATA3*/
PAD_CFG_NF(GPP_V4, UP_20K, DEEP, NF1),

/*EMMC_DATA4*/
PAD_CFG_NF(GPP_V5, UP_20K, DEEP, NF1),

/*EMMC_DATA5*/
PAD_CFG_NF(GPP_V6, UP_20K, DEEP, NF1),

/*EMMC_DATA6*/
PAD_CFG_NF(GPP_V7, UP_20K, DEEP, NF1),

/*EMMC_DATA7*/
PAD_CFG_NF(GPP_V8, UP_20K, DEEP, NF1),

/*EMMC_RCLK*/
PAD_CFG_NF(GPP_V9, DN_20K, DEEP, NF1),

/*EMMC_CLK*/
PAD_CFG_NF(GPP_V10, DN_20K, DEEP, NF1),

/*EMMC_RESET*/
PAD_CFG_NF(GPP_V11, UP_20K, DEEP, NF1),

/*ACPRESENT*/
PAD_CFG_NF(GPD1, NONE, PLTRST, NF1),

/*RGMII0_MDC*/
PAD_CFG_NF(GPP_C3, NONE, DEEP, NF1),

/*RGMII0_MDIO*/
PAD_CFG_NF(GPP_C4, NONE, DEEP, NF1),

/*RGMII0_INT*/
PAD_CFG_NF(GPP_T4, NONE, DEEP, NF1),

/*RGMII0_RESETB*/
PAD_CFG_GPO(GPP_T5, 1, DEEP),

/*RGMII0_AUXTS*/
PAD_CFG_NF(GPP_T6, NONE, DEEP, NF1),

/*RGMII0_PPS*/
PAD_CFG_NF(GPP_T7, NONE, DEEP, NF1),

/*RGMII0_PPS*/
PAD_CFG_NF(GPP_A0, NONE, DEEP, NF1),

/*RGMII0_PPS*/
PAD_CFG_NF(GPP_A1, NONE, DEEP, NF1),

/*RGMII0_PPS*/
PAD_CFG_NF(GPP_A2, NONE, DEEP, NF1),

/*RGMII0_PPS*/
PAD_CFG_NF(GPP_A3, NONE, DEEP, NF1),

/*RGMII0_PPS*/
PAD_CFG_NF(GPP_A4, NONE, DEEP, NF1),

/*RGMII0_PPS*/
PAD_CFG_NF(GPP_A5, NONE, DEEP, NF1),

/*RGMII0_PPS*/
PAD_CFG_NF(GPP_A6, NONE, DEEP, NF1),

/*RGMII0_PPS*/
PAD_CFG_NF(GPP_A7, NONE, DEEP, NF1),

/*RGMII0_PPS*/
PAD_CFG_NF(GPP_A8, NONE, DEEP, NF1),

/*RGMII0_PPS*/
PAD_CFG_NF(GPP_A9, NONE, DEEP, NF1),

/*RGMII0_PPS*/
PAD_CFG_NF(GPP_A10, NONE, DEEP, NF1),

/*RGMII0_PPS*/
PAD_CFG_NF(GPP_A23, NONE, DEEP, NF1),

/*RGMII1_MDC*/
PAD_CFG_NF(GPP_C6, NONE, DEEP, NF1),

/*RGMII1_MDIO*/
PAD_CFG_NF(GPP_C7, NONE, DEEP, NF1),

/*RGMII1_INT*/
PAD_CFG_NF(GPP_H0, NONE, DEEP, NF1),

/*RGMII1_RESETB*/
PAD_CFG_GPO(GPP_H1, 1, DEEP),

/*RGMII1_AUXTS*/
PAD_CFG_NF(GPP_H2, NONE, DEEP, NF1),

/*RGMII1_PPS*/
PAD_CFG_NF(GPP_H3, NONE, DEEP, NF1),

/*RGMII1_PPS*/
PAD_CFG_NF(GPP_A11, NONE, DEEP, NF1),

/*RGMII1_PPS*/
PAD_CFG_NF(GPP_A12, NONE, DEEP, NF1),

/*RGMII1_PPS*/
PAD_CFG_NF(GPP_A13, NONE, DEEP, NF1),

/*RGMII1_PPS*/
PAD_CFG_NF(GPP_A14, NONE, DEEP, NF1),

/*RGMII1_PPS*/
PAD_CFG_NF(GPP_A15, NONE, DEEP, NF1),

/*RGMII1_PPS*/
PAD_CFG_NF(GPP_A16, NONE, DEEP, NF1),

/*RGMII1_PPS*/
PAD_CFG_NF(GPP_A17, NONE, DEEP, NF1),

/*RGMII1_PPS*/
PAD_CFG_NF(GPP_A18, NONE, DEEP, NF1),

/*RGMII1_PPS*/
PAD_CFG_NF(GPP_A19, NONE, DEEP, NF1),

/*RGMII1_PPS*/
PAD_CFG_NF(GPP_A20, NONE, DEEP, NF1),

/*RGMII1_PPS*/
PAD_CFG_NF(GPP_A21, NONE, DEEP, NF1),

/*RGMII1_PPS*/
PAD_CFG_NF(GPP_A22, NONE, DEEP, NF1),

/*RGMII2_MDC*/
PAD_CFG_NF(GPP_C17, NONE, DEEP, NF1),

/*RGMII2_MDIO*/
PAD_CFG_NF(GPP_C16, NONE, DEEP, NF1),

/*RGMII2_INT*/
PAD_CFG_NF(GPP_U0, NONE, DEEP, NF1),

/*RGMII2_RESETB*/
PAD_CFG_GPO(GPP_U1, 1, DEEP),
};

/* Early pad configuration in bootblock */
static const struct pad_config early_gpio_table[] = {
/* UART1 RX */
PAD_CFG_NF(GPP_C12, NONE, DEEP, NF4),

/* UART1 TX */
PAD_CFG_NF(GPP_C13, NONE, DEEP, NF4),

/* UART2 RX */
PAD_CFG_NF(GPP_C20, NONE, DEEP, NF4),

/* UART2 TX */
PAD_CFG_NF(GPP_C21, NONE, DEEP, NF4),

/*WWAN_FCP_OFF_N*/
PAD_CFG_GPO(GPP_E0, 1, PLTRST),

/*WWAN_PWREN*/
PAD_CFG_GPO(GPP_F21, 1, PLTRST),

/*WWAN_PERST_N*/
PAD_CFG_GPO(GPP_B14, 0, PLTRST),

/*WWAN_RST_N*/
PAD_CFG_GPO(GPP_V13, 0, PLTRST),

/* LAN_WAKEB*/
PAD_CFG_GPI_SCI(GPD2, NONE, DEEP, EDGE_SINGLE, INVERT),

/*WWAN_RST_N*/
PAD_CFG_GPO(GPP_V13, 0, PWROK),

/*WWAN_PERST_N*/
PAD_CFG_GPO(GPP_B14, 0, PWROK),

/*WWAN_FCP_OFF_N*/
PAD_CFG_GPO(GPP_E0, 0, PWROK),
};

const struct pad_config *variant_gpio_table(size_t *num)
{
	*num = ARRAY_SIZE(gpio_table);
	return gpio_table;
}

const struct pad_config *variant_early_gpio_table(size_t *num)
{
	*num = ARRAY_SIZE(early_gpio_table);
	return early_gpio_table;
}
