/*
 * This file is part of the coreboot project.
 *
 * Copyright (C) 2009-2010 iWave Systems
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; version 2 of the License.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 */

#include <console/console.h>
#include <device/device.h>
#include <device/pci.h>
#include <device/pci_ids.h>
#include <arch/io.h>

static void usb_client_init(struct device *dev)
{
	u32 reg32;

	printk(BIOS_DEBUG, "USB Client: Setting up controller.. ");
	reg32 = pci_read_config32(dev, PCI_COMMAND);
	reg32 |= PCI_COMMAND_MASTER;
	reg32 |= PCI_COMMAND_MEMORY;
	pci_write_config32(dev, PCI_COMMAND, reg32);
	printk(BIOS_DEBUG, "done.\n");
}

static void usb_client_set_subsystem(device_t dev, unsigned vendor, unsigned device)
{
	if (!vendor || !device) {
		pci_write_config32(dev, PCI_SUBSYSTEM_VENDOR_ID,
				pci_read_config32(dev, PCI_VENDOR_ID));
	} else {
		pci_write_config32(dev, PCI_SUBSYSTEM_VENDOR_ID,
				((device & 0xffff) << 16) | (vendor & 0xffff));
	}
}

static struct pci_operations lops_pci = {
	.set_subsystem = &usb_client_set_subsystem,
};

static struct device_operations usb_client_ops = {
	.read_resources		= pci_dev_read_resources,
	.set_resources		= pci_dev_set_resources,
	.enable_resources	= pci_dev_enable_resources,
	.init			= usb_client_init,
	.scan_bus		= 0,
	.ops_pci		= &lops_pci,
};

static const struct pci_driver sch_usb_client __pci_driver = {
	.ops	= &usb_client_ops,
	.vendor	= PCI_VENDOR_ID_INTEL,
	.device	= 0x8118,
};
