#
# This file is part of the coreboot project.
#
# Copyright (C) 2012 Advanced Micro Devices, Inc.
#
# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; version 2 of the License.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA
#

romstage-y += fixme.c

ramstage-y += fixme.c
ramstage-y += chip_name.c
ramstage-y += model_16_init.c

AGESA_ROOT = ../../../../vendorcode/amd/agesa/f16kb

agesa_lib_src =
agesa_lib_src += $(AGESA_ROOT)/Legacy/Proc/agesaCallouts.c
agesa_lib_src += $(AGESA_ROOT)/Legacy/Proc/Dispatcher.c
agesa_lib_src += $(AGESA_ROOT)/Legacy/Proc/hobTransfer.c
agesa_lib_src += $(AGESA_ROOT)/Lib/amdlib.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Common/AmdInitEarly.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Common/AmdInitEnv.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Common/AmdInitLate.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Common/AmdInitMid.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Common/AmdInitPost.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Common/AmdInitReset.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Common/AmdInitResume.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Common/AmdLateRunApTask.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Common/AmdS3LateRestore.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Common/AmdS3Save.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Common/CommonInits.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Common/CommonReturns.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Common/CreateStruct.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Common/S3RestoreState.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Common/S3SaveState.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/cahaltasm.S
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/cahalt.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/cpuApicUtilities.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/cpuBist.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/cpuEarlyInit.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/cpuEventLog.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/cpuFamilyTranslation.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/cpuGeneralServices.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/cpuLateInit.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/cpuMicrocodePatch.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/cpuPostInit.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/cpuPowerMgmt.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/cpuPowerMgmtSingleSocket.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/cpuWarmReset.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x16/cpuF16Apm.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x16/cpuF16BrandId.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x16/cpuF16CacheDefaults.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x16/cpuF16Dmi.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x16/cpuF16MmioMap.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x16/cpuF16MsrUnknownTables.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x16/cpuF16PciUnknownTables.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x16/cpuF16Utilities.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x16/cpuF16WheaInitDataTables.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x16/KB/F16KbC6State.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x16/KB/F16KbCacheFlushOnHalt.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x16/KB/F16KbCoreAfterReset.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x16/KB/F16KbCpb.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x16/KB/F16KbDmi.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x16/KB/F16KbEquivalenceTable.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x16/KB/F16KbHtc.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x16/KB/F16KbInitEarlyTable.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x16/KB/F16KbIoCstate.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x16/KB/F16KbLogicalIdTables.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x16/KB/F16KbId7001MicrocodePatch.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x16/KB/F16KbMicrocodePatchTables.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x16/KB/F16KbMsrTables.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x16/KB/F16KbNbAfterReset.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x16/KB/F16KbPciTables.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x16/KB/F16KbPowerCheck.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x16/KB/F16KbPowerMgmtSystemTables.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x16/KB/F16KbPsi.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x16/KB/F16KbPstate.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x16/KB/F16KbSharedMsrTable.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Family/0x16/KB/F16KbUtilities.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Feature/cpuApm.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Feature/cpuC6State.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Feature/cpuCacheFlushOnHalt.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Feature/cpuCacheInit.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Feature/cpuCdit.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Feature/cpuCoreLeveling.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Feature/cpuCpb.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Feature/cpuCrat.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Feature/cpuDmi.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Feature/cpuFeatureLeveling.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Feature/cpuFeatures.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Feature/cpuHtc.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Feature/cpuIoCstate.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Feature/cpuPsi.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Feature/cpuPstateGather.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Feature/cpuPstateLeveling.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Feature/cpuPstateTables.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Feature/cpuSlit.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Feature/cpuSrat.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Feature/cpuWhea.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/heapManager.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/S3.c
agesa_lib_src += $(AGESA_ROOT)/Proc/CPU/Table.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Common/GnbLibFeatures.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/GnbInitAtEarly.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/GnbInitAtEnv.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/GnbInitAtLate.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/GnbInitAtMid.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/GnbInitAtPost.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/GnbInitAtReset.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/GnbInitAtS3Save.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbCommonLib/GnbLib.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbCommonLib/GnbLibCpuAcc.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbCommonLib/GnbLibHeap.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbCommonLib/GnbLibIoAcc.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbCommonLib/GnbLibMemAcc.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbCommonLib/GnbLibPciAcc.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbCommonLib/GnbLibPci.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbCommonLib/GnbTimerLib.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbFamTranslation/GnbPcieTranslation.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbFamTranslation/GnbTranslation.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbGfxConfig/GfxConfigEnv.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbGfxConfig/GfxConfigLib.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbGfxConfig/GfxConfigMid.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbGfxConfig/GfxConfigPost.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbGfxInitLibV1/GfxCardInfo.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbGfxInitLibV1/GfxEnumConnectors.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbGfxInitLibV1/GnbGfxInitLibV1.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbGfxIntTableV3/GfxIntegratedInfoTable.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbGfxIntTableV3/GfxLibV3.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbGfxIntTableV3/GfxPwrPlayTable.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbInitKB/AlibKB.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbInitKB/GfxEnvInitKB.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbInitKB/GfxGmcInitKB.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbInitKB/GfxIntegratedInfoTableKB.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbInitKB/GfxIntegratedInfoTableKB.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbInitKB/GfxLibKB.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbInitKB/GfxMidInitKB.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbInitKB/GfxPostInitKB.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbInitKB/GfxSamuInitKB.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbInitKB/GfxTablesKB.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbInitKB/GnbEarlyInitKB.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbInitKB/GnbEnvInitKB.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbInitKB/GnbF1TableKB.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbInitKB/GnbIommuTablesKB.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbInitKB/GnbMidInitKB.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbInitKB/GnbPostInitKB.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbInitKB/GnbRegisterAccKB.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbInitKB/GnbTablesKB.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbInitKB/GnbUraKB.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbInitKB/GnbUraKB.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbInitKB/GnbUraTokenMapKB.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbInitKB/PcieComplexDataKB.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbInitKB/PcieConfigKB.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbInitKB/PcieEarlyInitKB.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbInitKB/PcieEnvInitKB.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbInitKB/PcieLibKB.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbInitKB/PcieMidInitKB.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbInitKB/PciePostInitKB.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbInitKB/PcieTablesKB.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbIoapic/GnbIoapic.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbNbInitLibV4/GnbNbInitLibV4.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbNbInitLibV5/GnbNbInitLibV5.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbPcieAlibV2/PcieAlibV2.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbPcieAspm/PcieAspm.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbPcieClkPm/PcieClkPm.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbPcieConfig/GnbHandleLib.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbPcieConfig/PcieConfigData.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbPcieConfig/PcieConfigLib.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbPcieConfig/PcieInputParser.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbPcieConfig/PcieMapTopology.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbPcieInitLibV1/PcieAspmBlackList.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbPcieInitLibV1/PciePifServices.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbPcieInitLibV1/PciePortRegAcc.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbPcieInitLibV1/PciePortServices.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbPcieInitLibV1/PcieTimer.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbPcieInitLibV1/PcieTopologyServices.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbPcieInitLibV1/PcieUtilityLib.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbPcieInitLibV1/PcieWrapperRegAcc.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbPcieInitLibV4/PciePortServicesV4.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbPcieInitLibV4/PcieWrapperServicesV4.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbPcieInitLibV5/PciePhyServicesV5.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbPcieInitLibV5/PciePifServicesV5.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbPcieInitLibV5/PciePortServicesV5.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbPcieInitLibV5/PcieSiliconServicesV5.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbPcieInitLibV5/PcieTopologyServicesV5.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbPcieInitLibV5/PcieWrapperServicesV5.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbPcieMaxPayload/PcieMaxPayload.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbPcieTrainingV2/PcieTrainingV2.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbPcieTrainingV2/PcieWorkaroundsV2.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbSbLib/GnbSbLib.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbSbLib/GnbSbPcie.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbScsLibV1/GnbScsLibV1.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbSmuLibV7/GnbSmuInitLibV7.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbSSocketLib/GnbSSocketLib.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbSview/GnbSview.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbTable/GnbTable.c
agesa_lib_src += $(AGESA_ROOT)/Proc/GNB/Modules/GnbUraLibV1/GnbUraLibV1.c
agesa_lib_src += $(AGESA_ROOT)/Proc/HT/Fam16/htNbFam16.c
agesa_lib_src += $(AGESA_ROOT)/Proc/HT/Fam16/htNbUtilitiesFam16.c
agesa_lib_src += $(AGESA_ROOT)/Proc/HT/htFeat.c
agesa_lib_src += $(AGESA_ROOT)/Proc/HT/htInterface.c
agesa_lib_src += $(AGESA_ROOT)/Proc/HT/htInterfaceCoherent.c
agesa_lib_src += $(AGESA_ROOT)/Proc/HT/htInterfaceGeneral.c
agesa_lib_src += $(AGESA_ROOT)/Proc/HT/htInterfaceNonCoherent.c
agesa_lib_src += $(AGESA_ROOT)/Proc/HT/htMain.c
agesa_lib_src += $(AGESA_ROOT)/Proc/HT/htNb.c
agesa_lib_src += $(AGESA_ROOT)/Proc/HT/htNotify.c
agesa_lib_src += $(AGESA_ROOT)/Proc/IDS/Debug/IdsDebug.c
agesa_lib_src += $(AGESA_ROOT)/Proc/IDS/Debug/IdsDebugPrint.c
agesa_lib_src += $(AGESA_ROOT)/Proc/IDS/Debug/IdsDpHdtout.c
agesa_lib_src += $(AGESA_ROOT)/Proc/IDS/Debug/IdsDpSerial.c
agesa_lib_src += $(AGESA_ROOT)/Proc/IDS/Family/0x16/KB/IdsF16KbAllService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/IDS/Library/IdsLib.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Ardk/ma.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Feat/CSINTLV/mfcsi.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Feat/DMI/mfDMI.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Feat/ECC/mfecc.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Feat/ECC/mfemp.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Feat/EXCLUDIMM/mfdimmexclud.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Feat/IDENDIMM/mfidendimm.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Feat/LVDDR3/mflvddr3.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Feat/MEMCLR/mfmemclr.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Feat/ODTHERMAL/mfodthermal.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Feat/PARTRN/mfParallelTraining.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Feat/PARTRN/mfStandardTraining.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Feat/RDWR2DTRAINING/KB/mfRdWr2DKb.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Feat/RDWR2DTRAINING/mfRdDqs2DTraining.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Feat/RDWR2DTRAINING/mfRdWr2DEyeRimSearch.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Feat/RDWR2DTRAINING/mfRdWr2DPatternGeneration.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Feat/RDWR2DTRAINING/mfRdWr2DTraining.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Feat/S3/mfs3.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Feat/TABLE/mftds.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Main/KB/mmflowkb.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Main/mdef.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Main/merrhdl.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Main/minit.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Main/mm.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Main/mmConditionalPso.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Main/mmEcc.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Main/mmExcludeDimm.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Main/mmflow.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Main/mmLvDdr3.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Main/mmMemClr.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Main/mmMemRestore.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Main/mmNodeInterleave.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Main/mmOnlineSpare.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Main/mmParallelTraining.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Main/mmStandardTraining.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Main/mmUmaAlloc.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Main/mu.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Main/muc.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/NB/KB/mndctkb.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/NB/KB/mnflowkb.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/NB/KB/mnidendimmkb.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/NB/KB/mnkb.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/NB/KB/mnmctkb.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/NB/KB/mnotkb.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/NB/KB/mnphykb.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/NB/KB/mnregkb.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/NB/KB/mns3kb.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/NB/mn.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/NB/mndct.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/NB/mnfeat.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/NB/mnflow.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/NB/mnmct.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/NB/mnphy.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/NB/mnreg.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/NB/mnS3.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/NB/mntrain3.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Ps/KB/FT3/mpSkbft3.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Ps/KB/mpkb3.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Ps/KB/mpSkb3.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Ps/KB/mpUkb3.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Ps/mp.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Ps/mpmaxfreq.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Ps/mpmr0.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Ps/mpodtpat.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Ps/mprtt.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Ps/mps2d.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Ps/mpsao.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Tech/DDR3/mt3.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Tech/DDR3/mtot3.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Tech/DDR3/mtrci3.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Tech/DDR3/mtsdi3.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Tech/DDR3/mtspd3.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Tech/DDR3/mttecc3.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Tech/DDR3/mttwl3.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Tech/mt.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Tech/mthdi.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Tech/mttdimbt.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Tech/mttecc.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Tech/mttEdgeDetect.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Tech/mtthrc.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Tech/mtthrcSeedTrain.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Tech/mttml.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Tech/mttoptsrc.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Tech/mttRdDqs2DEyeRimSearch.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Tech/mttRdDqs2DTraining.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Mem/Tech/mttsrc.c

agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Azalia/AzaliaEnv.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Azalia/AzaliaLate.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Azalia/AzaliaMid.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Azalia/AzaliaReset.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Common/AcpiLib.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Common/FchCommon.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Common/FchLib.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Common/FchPeLib.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Common/MemLib.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Common/PciLib.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/HwAcpi/Family/Yangtze/YangtzeHwAcpiEnvService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/HwAcpi/Family/Yangtze/YangtzeHwAcpiLateService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/HwAcpi/Family/Yangtze/YangtzeHwAcpiMidService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/HwAcpi/Family/Yangtze/YangtzeSSService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/HwAcpi/HwAcpiEnv.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/HwAcpi/HwAcpiLate.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/HwAcpi/HwAcpiMid.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/HwAcpi/HwAcpiReset.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Hwm/Family/Yangtze/YangtzeHwmEnvService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Hwm/Family/Yangtze/YangtzeHwmLateService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Hwm/HwmLate.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Ide/IdeEnv.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Ide/IdeLate.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Ide/IdeMid.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Imc/Family/Yangtze/YangtzeImcService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Imc/FchEcEnv.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Imc/FchEcLate.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Imc/FchEcMid.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Imc/ImcEnv.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Imc/ImcLate.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Imc/ImcLib.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Imc/ImcMid.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Imc/ImcReset.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Interface/Family/Yangtze/EnvDefYangtze.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Interface/Family/Yangtze/ResetDefYangtze.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Interface/FchInitEnv.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Interface/FchInitLate.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Interface/FchInitMid.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Interface/FchInitReset.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Interface/FchInitS3.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Interface/FchTaskLauncher.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Interface/InitEnvDef.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Interface/InitResetDef.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Pcie/AbEnv.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Pcie/AbLate.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Pcie/AbMid.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Pcie/AbReset.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Pcie/Family/Yangtze/YangtzeAbEnvService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Pcie/Family/Yangtze/YangtzeAbResetService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Pcie/Family/Yangtze/YangtzeAbService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Pcie/PcieEnv.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Pcie/PcieEnv.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Pcie/PcieLate.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Pcie/PcieMid.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Pcie/PcieReset.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sata/AhciEnv.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sata/AhciLate.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sata/AhciLib.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sata/AhciMid.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sata/Family/Yangtze/YangtzeSataEnvService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sata/Family/Yangtze/YangtzeSataResetService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sata/Family/Yangtze/YangtzeSataService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sata/Ide2AhciEnv.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sata/Ide2AhciLate.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sata/Ide2AhciLib.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sata/Ide2AhciMid.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sata/RaidEnv.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sata/RaidLate.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sata/RaidLib.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sata/RaidMid.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sata/SataEnv.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sata/SataEnvLib.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sata/SataIdeEnv.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sata/SataIdeLate.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sata/SataIdeLib.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sata/SataIdeMid.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sata/SataLate.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sata/SataLib.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sata/SataMid.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sata/SataReset.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sd/Family/Yangtze/YangtzeSdEnvService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sd/Family/Yangtze/YangtzeSdResetService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sd/Family/Yangtze/YangtzeSdService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sd/SdEnv.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sd/SdLate.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Sd/SdMid.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Spi/Family/Yangtze/YangtzeLpcEnvService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Spi/Family/Yangtze/YangtzeLpcResetService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Spi/LpcEnv.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Spi/LpcLate.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Spi/LpcMid.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Spi/LpcReset.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Spi/SpiEnv.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Spi/SpiLate.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Spi/SpiMid.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Spi/SpiReset.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Usb/EhciEnv.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Usb/EhciLate.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Usb/EhciMid.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Usb/EhciReset.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Usb/Family/Yangtze/YangtzeEhciEnvService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Usb/Family/Yangtze/YangtzeEhciLateService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Usb/Family/Yangtze/YangtzeEhciMidService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Usb/Family/Yangtze/YangtzeOhciEnvService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Usb/Family/Yangtze/YangtzeOhciLateService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Usb/Family/Yangtze/YangtzeOhciMidService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Usb/Family/Yangtze/YangtzeXhciEnvService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Usb/Family/Yangtze/YangtzeXhciLateService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Usb/Family/Yangtze/YangtzeXhciMidService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Usb/Family/Yangtze/YangtzeXhciResetService.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Usb/OhciEnv.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Usb/OhciLate.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Usb/OhciMid.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Usb/OhciReset.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Usb/UsbEnv.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Usb/UsbLate.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Usb/UsbMid.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Usb/UsbReset.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Usb/XhciEnv.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Usb/XhciLate.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Usb/XhciMid.c
agesa_lib_src += $(AGESA_ROOT)/Proc/Fch/Usb/XhciReset.c


romstage-y += $(agesa_lib_src)
ramstage-y += $(agesa_lib_src)

subdirs-y += ../../mtrr
subdirs-y += ../../../x86/tsc
subdirs-y += ../../../x86/lapic
subdirs-y += ../../../x86/cache
subdirs-y += ../../../x86/mtrr
subdirs-y += ../../../x86/pae
subdirs-y += ../../../x86/smm
