#*****************************************************************************
#
# Copyright (c) 2012, Advanced Micro Devices, Inc.
# All rights reserved.
#
# Redistribution and use in source and binary forms, with or without
# modification, are permitted provided that the following conditions are met:
#     * Redistributions of source code must retain the above copyright
#       notice, this list of conditions and the following disclaimer.
#     * Redistributions in binary form must reproduce the above copyright
#       notice, this list of conditions and the following disclaimer in the
#       documentation and/or other materials provided with the distribution.
#     * Neither the name of Advanced Micro Devices, Inc. nor the names of
#       its contributors may be used to endorse or promote products derived
#       from this software without specific prior written permission.
#
# THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
# ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
# WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
# DISCLAIMED. IN NO EVENT SHALL ADVANCED MICRO DEVICES, INC. BE LIABLE FOR ANY
# DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
# (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
# LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
# ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
# (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
# SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
#
#*****************************************************************************

# AGESA V5 Files
AGESA_ROOT = src/vendorcode/amd/agesa/f15tn

AGESA_INC =  -Isrc/mainboard/$(MAINBOARDDIR)
AGESA_INC += -I$(AGESA_ROOT)
AGESA_INC += -I$(AGESA_ROOT)/../common
AGESA_INC += -I$(AGESA_ROOT)/Include
AGESA_INC += -I$(AGESA_ROOT)/Lib
AGESA_INC += -I$(AGESA_ROOT)/Legacy
AGESA_INC += -I$(AGESA_ROOT)/Proc/Common
AGESA_INC += -I$(AGESA_ROOT)/Proc/HT
AGESA_INC += -I$(AGESA_ROOT)/Proc/CPU
AGESA_INC += -I$(AGESA_ROOT)/Proc/CPU/Feature
AGESA_INC += -I$(AGESA_ROOT)/Proc/CPU/Family
AGESA_INC += -I$(AGESA_ROOT)/Proc/CPU/Family/0x15
AGESA_INC += -I$(AGESA_ROOT)/Proc/CPU/Family/0x15/TN
AGESA_INC += -I$(AGESA_ROOT)/Proc/Mem
AGESA_INC += -I$(AGESA_ROOT)/Proc/Mem/NB/TN
AGESA_INC += -I$(AGESA_ROOT)/Proc/IDS
AGESA_INC += -I$(AGESA_ROOT)/Proc/IDS/Family
AGESA_INC += -I$(AGESA_ROOT)/Proc/IDS/Family/0x15
AGESA_INC += -I$(AGESA_ROOT)/Proc/GNB
AGESA_INC += -I$(AGESA_ROOT)/Proc/GNB/Common
AGESA_INC += -I$(AGESA_ROOT)/Proc/GNB/Modules/GnbGfxConfig
AGESA_INC += -I$(AGESA_ROOT)/Proc/GNB/Modules/GnbPcieConfig
AGESA_INC += -I$(AGESA_ROOT)/Proc/GNB/Modules/GnbGfxInitLibV1
AGESA_INC += -I$(AGESA_ROOT)/Proc/GNB/Modules/GnbPcieInitLibV1
AGESA_INC += -I$(AGESA_ROOT)/Proc/GNB/Modules/GnbNbInitLibV1
AGESA_INC += -I$(AGESA_ROOT)/Proc/GNB/Modules/GnbInitTN
AGESA_INC += -I$(AGESA_ROOT)/Proc/GNB/Modules/GnbSbLib
AGESA_INC += -I$(AGESA_ROOT)/Proc/GNB/Modules/GnbPcieTrainingV1
AGESA_INC += -I$(AGESA_ROOT)/Proc/IDS/Family/0x15/TN
AGESA_INC += -I$(AGESA_ROOT)/Proc/GNB/Modules/GnbCommonLib
AGESA_INC += -I$(AGESA_ROOT)/Proc/Mem/Main
AGESA_INC += -I$(AGESA_ROOT)/Proc/IDS/Library
AGESA_INC += -I$(AGESA_ROOT)/Proc/GNB/Modules/GnbNbInitLibV4
AGESA_INC += -I$(AGESA_ROOT)/Proc/GNB/Modules/GnbIommuIvrs
AGESA_INC += -I$(AGESA_ROOT)/Proc/GNB/Modules/GnbIvrsLib
AGESA_INC += -I$(AGESA_ROOT)/Proc/GNB/Modules/GnbSbIommuLib
AGESA_INC += -I$(AGESA_ROOT)/Proc/GNB/Modules/GnbTable
AGESA_INC += -I$(AGESA_ROOT)/Proc/GNB/Modules/GnbPcieInitLibV4
AGESA_INC += -I$(AGESA_ROOT)/Proc/Fch
AGESA_INC += -I$(AGESA_ROOT)/Proc/Fch/Common
AGESA_INC += -I$(AGESA_ROOT)/Proc/IDS/Debug
AGESA_INC += -I$(AGESA_ROOT)/Proc/GNB/Modules/GnbPcieAspm
AGESA_INC += -I$(AGESA_ROOT)/Proc/GNB/Include/Library

AGESA_INC += -I$(src)/southbridge/amd/agesa/hudson

CFLAGS_x86_32 += -march=k8-sse3 -mtune=k8-sse3 -fno-zero-initialized-in-bss -fno-strict-aliasing

export AGESA_ROOT := $(AGESA_ROOT)
export AGESA_INC  := $(AGESA_INC)
CPPFLAGS_x86_32 += $(AGESA_INC)
#######################################################################

classes-y += libagesa

$(eval $(call create_class_compiler,libagesa,x86_32))

libagesa-y += Legacy/Proc/Dispatcher.c
libagesa-y += Legacy/Proc/agesaCallouts.c
libagesa-y += Legacy/Proc/hobTransfer.c
libagesa-y += Lib/amdlib.c
libagesa-y += Proc/CPU/Family/0x15/TN/F15TnC6State.c
libagesa-y += Proc/CPU/Family/0x15/TN/F15TnCpb.c
libagesa-y += Proc/CPU/Family/0x15/TN/F15TnEquivalenceTable.c
libagesa-y += Proc/CPU/Family/0x15/TN/F15TnInitEarlyTable.c
libagesa-y += Proc/CPU/Family/0x15/TN/F15TnIoCstate.c
libagesa-y += Proc/CPU/Family/0x15/TN/F15TnLogicalIdTables.c
libagesa-y += Proc/CPU/Family/0x15/TN/F15TnMicrocodePatch0600110F_Enc.c
libagesa-y += Proc/CPU/Family/0x15/TN/F15TnMicrocodePatchTables.c
libagesa-y += Proc/CPU/Family/0x15/TN/F15TnMsrTables.c
libagesa-y += Proc/CPU/Family/0x15/TN/F15TnPciTables.c
libagesa-y += Proc/CPU/Family/0x15/TN/F15TnPowerMgmtSystemTables.c
libagesa-y += Proc/CPU/Family/0x15/TN/F15TnPowerPlane.c
libagesa-y += Proc/CPU/Family/0x15/TN/F15TnSharedMsrTable.c
libagesa-y += Proc/CPU/Family/0x15/TN/F15TnUtilities.c
libagesa-y += Proc/CPU/Family/0x15/TN/cpuF15TnCacheFlushOnHalt.c
libagesa-y += Proc/CPU/Family/0x15/TN/cpuF15TnCoreAfterReset.c
libagesa-y += Proc/CPU/Family/0x15/TN/cpuF15TnDmi.c
libagesa-y += Proc/CPU/Family/0x15/TN/cpuF15TnHtc.c
libagesa-y += Proc/CPU/Family/0x15/TN/cpuF15TnNbAfterReset.c
libagesa-y += Proc/CPU/Family/0x15/TN/cpuF15TnPowerCheck.c
libagesa-y += Proc/CPU/Family/0x15/TN/cpuF15TnPsi.c
libagesa-y += Proc/CPU/Family/0x15/TN/cpuF15TnPstate.c
libagesa-y += Proc/CPU/Family/0x15/cpuCommonF15Utilities.c
libagesa-y += Proc/CPU/Family/0x15/cpuF15BrandId.c
libagesa-y += Proc/CPU/Family/0x15/cpuF15CacheDefaults.c
libagesa-y += Proc/CPU/Family/0x15/cpuF15Dmi.c
libagesa-y += Proc/CPU/Family/0x15/cpuF15MmioMap.c
libagesa-y += Proc/CPU/Family/0x15/cpuF15MsrTables.c
libagesa-y += Proc/CPU/Family/0x15/cpuF15PciTables.c
libagesa-y += Proc/CPU/Family/0x15/cpuF15PowerCheck.c
libagesa-y += Proc/CPU/Family/0x15/cpuF15Utilities.c
libagesa-y += Proc/CPU/Family/0x15/cpuF15WheaInitDataTables.c
libagesa-y += Proc/CPU/Feature/PreserveMailbox.c
libagesa-y += Proc/CPU/Feature/cpuC6State.c
libagesa-y += Proc/CPU/Feature/cpuCacheFlushOnHalt.c
libagesa-y += Proc/CPU/Feature/cpuCacheInit.c
libagesa-y += Proc/CPU/Feature/cpuCoreLeveling.c
libagesa-y += Proc/CPU/Feature/cpuCpb.c
libagesa-y += Proc/CPU/Feature/cpuDmi.c
libagesa-y += Proc/CPU/Feature/cpuFeatureLeveling.c
libagesa-y += Proc/CPU/Feature/cpuFeatures.c
libagesa-y += Proc/CPU/Feature/cpuHtc.c
libagesa-y += Proc/CPU/Feature/cpuHwC1e.c
libagesa-y += Proc/CPU/Feature/cpuIoCstate.c
libagesa-y += Proc/CPU/Feature/cpuPsi.c
libagesa-y += Proc/CPU/Feature/cpuPstateGather.c
libagesa-y += Proc/CPU/Feature/cpuPstateLeveling.c
libagesa-y += Proc/CPU/Feature/cpuPstateTables.c
libagesa-y += Proc/CPU/Feature/cpuSlit.c
libagesa-y += Proc/CPU/Feature/cpuSrat.c
libagesa-y += Proc/CPU/Feature/cpuWhea.c
libagesa-y += Proc/CPU/S3.c
libagesa-y += Proc/CPU/Table.c
libagesa-y += Proc/CPU/cahalt.c
libagesa-y += Proc/CPU/cahaltasm.S
libagesa-y += Proc/CPU/cpuApicUtilities.c
libagesa-y += Proc/CPU/cpuBist.c
libagesa-y += Proc/CPU/cpuBrandId.c
libagesa-y += Proc/CPU/cpuEarlyInit.c
libagesa-y += Proc/CPU/cpuEventLog.c
libagesa-y += Proc/CPU/cpuFamilyTranslation.c
libagesa-y += Proc/CPU/cpuGeneralServices.c
libagesa-y += Proc/CPU/cpuInitEarlyTable.c
libagesa-y += Proc/CPU/cpuLateInit.c
libagesa-y += Proc/CPU/cpuMicrocodePatch.c
libagesa-y += Proc/CPU/cpuPostInit.c
libagesa-y += Proc/CPU/cpuPowerMgmt.c
libagesa-y += Proc/CPU/cpuPowerMgmtMultiSocket.c
libagesa-y += Proc/CPU/cpuPowerMgmtSingleSocket.c
libagesa-y += Proc/CPU/cpuWarmReset.c
libagesa-y += Proc/CPU/heapManager.c
libagesa-y += Proc/Common/AmdInitEarly.c
libagesa-y += Proc/Common/AmdInitEnv.c
libagesa-y += Proc/Common/AmdInitLate.c
libagesa-y += Proc/Common/AmdInitMid.c
libagesa-y += Proc/Common/AmdInitPost.c
libagesa-y += Proc/Common/AmdInitReset.c
libagesa-y += Proc/Common/AmdInitResume.c
libagesa-y += Proc/Common/AmdLateRunApTask.c
libagesa-y += Proc/Common/AmdS3LateRestore.c
libagesa-y += Proc/Common/AmdS3Save.c
libagesa-y += Proc/Common/CommonInits.c
libagesa-y += Proc/Common/CommonReturns.c
libagesa-y += Proc/Common/CreateStruct.c
libagesa-y += Proc/Common/S3RestoreState.c
libagesa-y += Proc/Common/S3SaveState.c
libagesa-y += Proc/GNB/Common/GnbLibFeatures.c
libagesa-y += Proc/GNB/GnbInitAtEarly.c
libagesa-y += Proc/GNB/GnbInitAtEnv.c
libagesa-y += Proc/GNB/GnbInitAtLate.c
libagesa-y += Proc/GNB/GnbInitAtMid.c
libagesa-y += Proc/GNB/GnbInitAtPost.c
libagesa-y += Proc/GNB/GnbInitAtReset.c
libagesa-y += Proc/GNB/GnbInitAtS3Save.c
libagesa-y += Proc/GNB/Library/GnbTimerLibWrap0/GnbTimerLibWrap0.c
libagesa-y += Proc/GNB/Modules/GnbCommonLib/GnbLib.c
libagesa-y += Proc/GNB/Modules/GnbCommonLib/GnbLibCpuAcc.c
libagesa-y += Proc/GNB/Modules/GnbCommonLib/GnbLibHeap.c
libagesa-y += Proc/GNB/Modules/GnbCommonLib/GnbLibIoAcc.c
libagesa-y += Proc/GNB/Modules/GnbCommonLib/GnbLibMemAcc.c
libagesa-y += Proc/GNB/Modules/GnbCommonLib/GnbLibPci.c
libagesa-y += Proc/GNB/Modules/GnbCommonLib/GnbLibPciAcc.c
libagesa-y += Proc/GNB/Modules/GnbFamTranslation/GnbPcieTranslation.c
libagesa-y += Proc/GNB/Modules/GnbFamTranslation/GnbTranslation.c
libagesa-y += Proc/GNB/Modules/GnbGfxConfig/GfxConfigEnv.c
libagesa-y += Proc/GNB/Modules/GnbGfxConfig/GfxConfigLib.c
libagesa-y += Proc/GNB/Modules/GnbGfxConfig/GfxConfigMid.c
libagesa-y += Proc/GNB/Modules/GnbGfxConfig/GfxConfigPost.c
libagesa-y += Proc/GNB/Modules/GnbGfxInitLibV1/GfxCardInfo.c
libagesa-y += Proc/GNB/Modules/GnbGfxInitLibV1/GfxEnumConnectors.c
libagesa-y += Proc/GNB/Modules/GnbGfxInitLibV1/GfxPowerPlayTable.c
libagesa-y += Proc/GNB/Modules/GnbGfxInitLibV1/GnbGfxInitLibV1.c
libagesa-y += Proc/GNB/Modules/GnbInitTN/GfxEnvInitTN.c
libagesa-y += Proc/GNB/Modules/GnbInitTN/GfxGmcInitTN.c
libagesa-y += Proc/GNB/Modules/GnbInitTN/GfxIntegratedInfoTableTN.c
libagesa-y += Proc/GNB/Modules/GnbInitTN/GfxLibTN.c
libagesa-y += Proc/GNB/Modules/GnbInitTN/GfxMidInitTN.c
libagesa-y += Proc/GNB/Modules/GnbInitTN/GfxPostInitTN.c
libagesa-y += Proc/GNB/Modules/GnbInitTN/GfxTablesTN.c
libagesa-y += Proc/GNB/Modules/GnbInitTN/GnbBapmCoeffCalcTN.c
libagesa-y += Proc/GNB/Modules/GnbInitTN/GnbEarlyInitTN.c
libagesa-y += Proc/GNB/Modules/GnbInitTN/GnbEnvInitTN.c
libagesa-y += Proc/GNB/Modules/GnbInitTN/GnbFuseTableTN.c
libagesa-y += Proc/GNB/Modules/GnbInitTN/GnbIommuIvrsTN.c
libagesa-y += Proc/GNB/Modules/GnbInitTN/GnbMidInitTN.c
libagesa-y += Proc/GNB/Modules/GnbInitTN/GnbPostInitTN.c
libagesa-y += Proc/GNB/Modules/GnbInitTN/GnbRegisterAccTN.c
libagesa-y += Proc/GNB/Modules/GnbInitTN/GnbTablesTN.c
libagesa-y += Proc/GNB/Modules/GnbInitTN/PcieAlibTNFM2.c
libagesa-y += Proc/GNB/Modules/GnbInitTN/PcieAlibTNFS1.c
libagesa-y += Proc/GNB/Modules/GnbInitTN/PcieComplexDataTN.c
libagesa-y += Proc/GNB/Modules/GnbInitTN/PcieConfigTN.c
libagesa-y += Proc/GNB/Modules/GnbInitTN/PcieEarlyInitTN.c
libagesa-y += Proc/GNB/Modules/GnbInitTN/PcieEnvInitTN.c
libagesa-y += Proc/GNB/Modules/GnbInitTN/PcieLibTN.c
libagesa-y += Proc/GNB/Modules/GnbInitTN/PcieMidInitTN.c
libagesa-y += Proc/GNB/Modules/GnbInitTN/PciePostInitTN.c
libagesa-y += Proc/GNB/Modules/GnbInitTN/PciePowerGateTN.c
libagesa-y += Proc/GNB/Modules/GnbInitTN/PcieTablesTN.c
libagesa-y += Proc/GNB/Modules/GnbIommuScratch/GnbIommuScratch.c
libagesa-y += Proc/GNB/Modules/GnbIommuIvrs/GnbIommuIvrs.c
libagesa-y += Proc/GNB/Modules/GnbIvrsLib/GnbIvrsLib.c
libagesa-y += Proc/GNB/Modules/GnbMSocketLib/GnbMSocketLib.c
libagesa-y += Proc/GNB/Modules/GnbNbInitLibV1/GnbNbInitLibV1.c
libagesa-y += Proc/GNB/Modules/GnbNbInitLibV4/GnbNbInitLibV4.c
libagesa-y += Proc/GNB/Modules/GnbPcieAlibV1/PcieAlib.c
libagesa-y += Proc/GNB/Modules/GnbPcieAspm/PcieAspm.c
libagesa-y += Proc/GNB/Modules/GnbPcieClkPm/PcieClkPm.c
libagesa-y += Proc/GNB/Modules/GnbPcieConfig/GnbHandleLib.c
libagesa-y += Proc/GNB/Modules/GnbPcieConfig/PcieConfigData.c
libagesa-y += Proc/GNB/Modules/GnbPcieConfig/PcieConfigLib.c
libagesa-y += Proc/GNB/Modules/GnbPcieConfig/PcieInputParser.c
libagesa-y += Proc/GNB/Modules/GnbPcieConfig/PcieMapTopology.c
libagesa-y += Proc/GNB/Modules/GnbPcieInitLibV1/PcieAspmBlackList.c
libagesa-y += Proc/GNB/Modules/GnbPcieInitLibV1/PcieAspmExitLatency.c
libagesa-y += Proc/GNB/Modules/GnbPcieInitLibV1/PciePhyServices.c
libagesa-y += Proc/GNB/Modules/GnbPcieInitLibV1/PciePifServices.c
libagesa-y += Proc/GNB/Modules/GnbPcieInitLibV1/PciePortRegAcc.c
libagesa-y += Proc/GNB/Modules/GnbPcieInitLibV1/PciePortServices.c
libagesa-y += Proc/GNB/Modules/GnbPcieInitLibV1/PciePowerMgmt.c
libagesa-y += Proc/GNB/Modules/GnbPcieInitLibV1/PcieSiliconServices.c
libagesa-y += Proc/GNB/Modules/GnbPcieInitLibV1/PcieTimer.c
libagesa-y += Proc/GNB/Modules/GnbPcieInitLibV1/PcieTopologyServices.c
libagesa-y += Proc/GNB/Modules/GnbPcieInitLibV1/PcieUtilityLib.c
libagesa-y += Proc/GNB/Modules/GnbPcieInitLibV1/PcieWrapperRegAcc.c
libagesa-y += Proc/GNB/Modules/GnbPcieInitLibV4/PcieMaxPayloadV4.c
libagesa-y += Proc/GNB/Modules/GnbPcieInitLibV4/PciePortServicesV4.c
libagesa-y += Proc/GNB/Modules/GnbPcieInitLibV4/PciePowerMgmtV4.c
libagesa-y += Proc/GNB/Modules/GnbPcieInitLibV4/PcieWrapperServicesV4.c
libagesa-y += Proc/GNB/Modules/GnbPcieTrainingV1/PcieTraining.c
libagesa-y += Proc/GNB/Modules/GnbPcieTrainingV1/PcieWorkarounds.c
libagesa-y += Proc/GNB/Modules/GnbSbIommuLib/GnbSbIommuLib.c
libagesa-y += Proc/GNB/Modules/GnbSbLib/GnbSbLib.c
libagesa-y += Proc/GNB/Modules/GnbSbLib/GnbSbPcie.c
libagesa-y += Proc/GNB/Modules/GnbSview/GnbSview.c
libagesa-y += Proc/GNB/Modules/GnbTable/GnbTable.c
libagesa-y += Proc/HT/Fam15Mod1x/htNbFam15Mod1x.c
libagesa-y += Proc/HT/Fam15Mod1x/htNbUtilitiesFam15Mod1x.c
libagesa-y += Proc/HT/htFeat.c
libagesa-y += Proc/HT/htInterface.c
libagesa-y += Proc/HT/htInterfaceCoherent.c
libagesa-y += Proc/HT/htInterfaceGeneral.c
libagesa-y += Proc/HT/htInterfaceNonCoherent.c
libagesa-y += Proc/HT/htMain.c
libagesa-y += Proc/HT/htNb.c
libagesa-y += Proc/HT/htNotify.c
libagesa-y += Proc/IDS/Debug/IdsDebug.c
libagesa-y += Proc/IDS/Debug/IdsDebugPrint.c
libagesa-y += Proc/IDS/Debug/IdsDpSerial.c
libagesa-y += Proc/IDS/Family/0x15/TN/IdsF15TnAllService.c
libagesa-y += Proc/IDS/Library/IdsLib.c
libagesa-y += Proc/Mem/Ardk/ma.c
libagesa-y += Proc/Mem/Feat/CHINTLV/mfchi.c
libagesa-y += Proc/Mem/Feat/CSINTLV/mfcsi.c
libagesa-y += Proc/Mem/Feat/DMI/mfDMI.c
libagesa-y += Proc/Mem/Feat/ECC/mfecc.c
libagesa-y += Proc/Mem/Feat/ECC/mfemp.c
libagesa-y += Proc/Mem/Feat/EXCLUDIMM/mfdimmexclud.c
libagesa-y += Proc/Mem/Feat/IDENDIMM/mfidendimm.c
libagesa-y += Proc/Mem/Feat/INTLVRN/mfintlvrn.c
libagesa-y += Proc/Mem/Feat/LVDDR3/mflvddr3.c
libagesa-y += Proc/Mem/Feat/MEMCLR/mfmemclr.c
libagesa-y += Proc/Mem/Feat/ODTHERMAL/mfodthermal.c
libagesa-y += Proc/Mem/Feat/PARTRN/mfParallelTraining.c
libagesa-y += Proc/Mem/Feat/PARTRN/mfStandardTraining.c
libagesa-y += Proc/Mem/Feat/S3/mfs3.c
libagesa-y += Proc/Mem/Feat/TABLE/mftds.c
libagesa-y += Proc/Mem/Main/TN/mmflowtn.c
libagesa-y += Proc/Mem/Main/mdef.c
libagesa-y += Proc/Mem/Main/merrhdl.c
libagesa-y += Proc/Mem/Main/minit.c
libagesa-y += Proc/Mem/Main/mm.c
libagesa-y += Proc/Mem/Main/mmConditionalPso.c
libagesa-y += Proc/Mem/Main/mmEcc.c
libagesa-y += Proc/Mem/Main/mmExcludeDimm.c
libagesa-y += Proc/Mem/Main/mmLvDdr3.c
libagesa-y += Proc/Mem/Main/mmMemClr.c
libagesa-y += Proc/Mem/Main/mmMemRestore.c
libagesa-y += Proc/Mem/Main/mmNodeInterleave.c
libagesa-y += Proc/Mem/Main/mmOnlineSpare.c
libagesa-y += Proc/Mem/Main/mmParallelTraining.c
libagesa-y += Proc/Mem/Main/mmStandardTraining.c
libagesa-y += Proc/Mem/Main/mmUmaAlloc.c
libagesa-y += Proc/Mem/Main/mmflow.c
libagesa-y += Proc/Mem/Main/mu.c
libagesa-y += Proc/Mem/Main/muc.c
libagesa-y += Proc/Mem/NB/TN/mndcttn.c
libagesa-y += Proc/Mem/NB/TN/mnflowtn.c
libagesa-y += Proc/Mem/NB/TN/mnidendimmtn.c
libagesa-y += Proc/Mem/NB/TN/mnmcttn.c
libagesa-y += Proc/Mem/NB/TN/mnottn.c
libagesa-y += Proc/Mem/NB/TN/mnphytn.c
libagesa-y += Proc/Mem/NB/TN/mnregtn.c
libagesa-y += Proc/Mem/NB/TN/mns3tn.c
libagesa-y += Proc/Mem/NB/TN/mntn.c
libagesa-y += Proc/Mem/NB/mn.c
libagesa-y += Proc/Mem/NB/mnS3.c
libagesa-y += Proc/Mem/NB/mndct.c
libagesa-y += Proc/Mem/NB/mnfeat.c
libagesa-y += Proc/Mem/NB/mnflow.c
libagesa-y += Proc/Mem/NB/mnmct.c
libagesa-y += Proc/Mem/NB/mnphy.c
libagesa-y += Proc/Mem/NB/mnreg.c
libagesa-y += Proc/Mem/NB/mntrain3.c
libagesa-y += Proc/Mem/Ps/TN/FM2/mpUtnfm2.c
libagesa-y += Proc/Mem/Ps/TN/FP2/mpStnfp2.c
libagesa-y += Proc/Mem/Ps/TN/FS1/mpStnfs1.c
libagesa-y += Proc/Mem/Ps/TN/mpStn3.c
libagesa-y += Proc/Mem/Ps/TN/mpUtn3.c
libagesa-y += Proc/Mem/Ps/TN/mptn3.c
libagesa-y += Proc/Mem/Ps/mp.c
libagesa-y += Proc/Mem/Ps/mpmaxfreq.c
libagesa-y += Proc/Mem/Ps/mpmr0.c
libagesa-y += Proc/Mem/Ps/mpodtpat.c
libagesa-y += Proc/Mem/Ps/mprtt.c
libagesa-y += Proc/Mem/Ps/mpsao.c
libagesa-y += Proc/Mem/Tech/DDR3/mt3.c
libagesa-y += Proc/Mem/Tech/DDR3/mtot3.c
libagesa-y += Proc/Mem/Tech/DDR3/mtrci3.c
libagesa-y += Proc/Mem/Tech/DDR3/mtsdi3.c
libagesa-y += Proc/Mem/Tech/DDR3/mtspd3.c
libagesa-y += Proc/Mem/Tech/DDR3/mttecc3.c
libagesa-y += Proc/Mem/Tech/DDR3/mttwl3.c
libagesa-y += Proc/Mem/Tech/mt.c
libagesa-y += Proc/Mem/Tech/mthdi.c
libagesa-y += Proc/Mem/Tech/mttEdgeDetect.c
libagesa-y += Proc/Mem/Tech/mttdimbt.c
libagesa-y += Proc/Mem/Tech/mttecc.c
libagesa-y += Proc/Mem/Tech/mtthrc.c
libagesa-y += Proc/Mem/Tech/mtthrcSeedTrain.c
libagesa-y += Proc/Mem/Tech/mttml.c
libagesa-y += Proc/Mem/Tech/mttoptsrc.c
libagesa-y += Proc/Mem/Tech/mttsrc.c
libagesa-y += Proc/Fch/Azalia/AzaliaEnv.c
libagesa-y += Proc/Fch/Azalia/AzaliaLate.c
libagesa-y += Proc/Fch/Azalia/AzaliaMid.c
libagesa-y += Proc/Fch/Azalia/AzaliaReset.c
libagesa-y += Proc/Fch/Common/AcpiLib.c
libagesa-y += Proc/Fch/Common/FchCommon.c
libagesa-y += Proc/Fch/Common/FchLib.c
libagesa-y += Proc/Fch/Common/FchPeLib.c
libagesa-y += Proc/Fch/Common/MemLib.c
libagesa-y += Proc/Fch/Common/PciLib.c
libagesa-y += Proc/Fch/Gec/Family/Hudson2/Hudson2GecEnvService.c
libagesa-y += Proc/Fch/Gec/Family/Hudson2/Hudson2GecService.c
libagesa-y += Proc/Fch/Gec/GecEnv.c
libagesa-y += Proc/Fch/Gec/GecLate.c
libagesa-y += Proc/Fch/Gec/GecMid.c
libagesa-y += Proc/Fch/Gec/GecReset.c
libagesa-y += Proc/Fch/HwAcpi/Family/Hudson2/Hudson2HwAcpiEnvService.c
libagesa-y += Proc/Fch/HwAcpi/Family/Hudson2/Hudson2HwAcpiLateService.c
libagesa-y += Proc/Fch/HwAcpi/Family/Hudson2/Hudson2HwAcpiMidService.c
libagesa-y += Proc/Fch/HwAcpi/Family/Hudson2/Hudson2SSService.c
libagesa-y += Proc/Fch/HwAcpi/HwAcpiEnv.c
libagesa-y += Proc/Fch/HwAcpi/HwAcpiLate.c
libagesa-y += Proc/Fch/HwAcpi/HwAcpiMid.c
libagesa-y += Proc/Fch/HwAcpi/HwAcpiReset.c
libagesa-y += Proc/Fch/Hwm/Family/Hudson2/Hudson2HwmEnvService.c
libagesa-y += Proc/Fch/Hwm/Family/Hudson2/Hudson2HwmLateService.c
libagesa-y += Proc/Fch/Hwm/Family/Hudson2/Hudson2HwmMidService.c
libagesa-y += Proc/Fch/Hwm/HwmEnv.c
libagesa-y += Proc/Fch/Hwm/HwmLate.c
libagesa-y += Proc/Fch/Hwm/HwmMid.c
libagesa-y += Proc/Fch/Hwm/HwmReset.c
libagesa-y += Proc/Fch/Ide/IdeEnv.c
libagesa-y += Proc/Fch/Ide/IdeLate.c
libagesa-y += Proc/Fch/Ide/IdeMid.c
libagesa-y += Proc/Fch/Imc/Family/Hudson2/Hudson2ImcService.c
libagesa-y += Proc/Fch/Imc/FchEcEnv.c
libagesa-y += Proc/Fch/Imc/FchEcLate.c
libagesa-y += Proc/Fch/Imc/FchEcMid.c
libagesa-y += Proc/Fch/Imc/FchEcReset.c
libagesa-y += Proc/Fch/Imc/ImcEnv.c
libagesa-y += Proc/Fch/Imc/ImcLate.c
libagesa-y += Proc/Fch/Imc/ImcLib.c
libagesa-y += Proc/Fch/Imc/ImcMid.c
libagesa-y += Proc/Fch/Imc/ImcReset.c
libagesa-y += Proc/Fch/Interface/Family/Hudson2/EnvDefHudson2.c
libagesa-y += Proc/Fch/Interface/Family/Hudson2/ResetDefHudson2.c
libagesa-y += Proc/Fch/Interface/FchInitEnv.c
libagesa-y += Proc/Fch/Interface/FchInitLate.c
libagesa-y += Proc/Fch/Interface/FchInitMid.c
libagesa-y += Proc/Fch/Interface/FchInitReset.c
libagesa-y += Proc/Fch/Interface/FchInitS3.c
libagesa-y += Proc/Fch/Interface/FchTaskLauncher.c
libagesa-y += Proc/Fch/Interface/InitEnvDef.c
libagesa-y += Proc/Fch/Interface/InitResetDef.c
libagesa-y += Proc/Fch/Ir/IrEnv.c
libagesa-y += Proc/Fch/Ir/IrLate.c
libagesa-y += Proc/Fch/Ir/IrMid.c
libagesa-y += Proc/Fch/Pcib/PcibEnv.c
libagesa-y += Proc/Fch/Pcib/PcibLate.c
libagesa-y += Proc/Fch/Pcib/PcibMid.c
libagesa-y += Proc/Fch/Pcib/PcibReset.c
libagesa-y += Proc/Fch/Pcie/AbEnv.c
libagesa-y += Proc/Fch/Pcie/AbLate.c
libagesa-y += Proc/Fch/Pcie/AbMid.c
libagesa-y += Proc/Fch/Pcie/AbReset.c
libagesa-y += Proc/Fch/Pcie/Family/Hudson2/Hudson2AbEnvService.c
libagesa-y += Proc/Fch/Pcie/Family/Hudson2/Hudson2AbResetService.c
libagesa-y += Proc/Fch/Pcie/Family/Hudson2/Hudson2AbService.c
libagesa-y += Proc/Fch/Pcie/Family/Hudson2/Hudson2GppResetService.c
libagesa-y += Proc/Fch/Pcie/Family/Hudson2/Hudson2GppService.c
libagesa-y += Proc/Fch/Pcie/Family/Hudson2/Hudson2PcieEnvService.c
libagesa-y += Proc/Fch/Pcie/Family/Hudson2/Hudson2PcieService.c
libagesa-y += Proc/Fch/Pcie/GppEnv.c
libagesa-y += Proc/Fch/Pcie/GppHp.c
libagesa-y += Proc/Fch/Pcie/GppLate.c
libagesa-y += Proc/Fch/Pcie/GppLib.c
libagesa-y += Proc/Fch/Pcie/GppMid.c
libagesa-y += Proc/Fch/Pcie/GppPortInit.c
libagesa-y += Proc/Fch/Pcie/GppReset.c
libagesa-y += Proc/Fch/Pcie/PcieEnv.c
libagesa-y += Proc/Fch/Pcie/PcieLate.c
libagesa-y += Proc/Fch/Pcie/PcieMid.c
libagesa-y += Proc/Fch/Pcie/PcieReset.c
libagesa-y += Proc/Fch/Sata/AhciEnv.c
libagesa-y += Proc/Fch/Sata/AhciLate.c
libagesa-y += Proc/Fch/Sata/AhciLib.c
libagesa-y += Proc/Fch/Sata/AhciMid.c
libagesa-y += Proc/Fch/Sata/Family/Hudson2/Hudson2SataEnvService.c
libagesa-y += Proc/Fch/Sata/Family/Hudson2/Hudson2SataResetService.c
libagesa-y += Proc/Fch/Sata/Family/Hudson2/Hudson2SataService.c
libagesa-y += Proc/Fch/Sata/Ide2AhciEnv.c
libagesa-y += Proc/Fch/Sata/Ide2AhciLate.c
libagesa-y += Proc/Fch/Sata/Ide2AhciLib.c
libagesa-y += Proc/Fch/Sata/Ide2AhciMid.c
libagesa-y += Proc/Fch/Sata/RaidEnv.c
libagesa-y += Proc/Fch/Sata/RaidLate.c
libagesa-y += Proc/Fch/Sata/RaidLib.c
libagesa-y += Proc/Fch/Sata/RaidMid.c
libagesa-y += Proc/Fch/Sata/SataEnv.c
libagesa-y += Proc/Fch/Sata/SataEnvLib.c
libagesa-y += Proc/Fch/Sata/SataIdeEnv.c
libagesa-y += Proc/Fch/Sata/SataIdeLate.c
libagesa-y += Proc/Fch/Sata/SataIdeLib.c
libagesa-y += Proc/Fch/Sata/SataIdeMid.c
libagesa-y += Proc/Fch/Sata/SataLate.c
libagesa-y += Proc/Fch/Sata/SataLib.c
libagesa-y += Proc/Fch/Sata/SataMid.c
libagesa-y += Proc/Fch/Sata/SataReset.c
libagesa-y += Proc/Fch/Sd/Family/Hudson2/Hudson2SdEnvService.c
libagesa-y += Proc/Fch/Sd/Family/Hudson2/Hudson2SdResetService.c
libagesa-y += Proc/Fch/Sd/Family/Hudson2/Hudson2SdService.c
libagesa-y += Proc/Fch/Sd/SdEnv.c
libagesa-y += Proc/Fch/Sd/SdLate.c
libagesa-y += Proc/Fch/Sd/SdMid.c
libagesa-y += Proc/Fch/Spi/Family/Hudson2/Hudson2LpcEnvService.c
libagesa-y += Proc/Fch/Spi/Family/Hudson2/Hudson2LpcResetService.c
libagesa-y += Proc/Fch/Spi/LpcEnv.c
libagesa-y += Proc/Fch/Spi/LpcLate.c
libagesa-y += Proc/Fch/Spi/LpcMid.c
libagesa-y += Proc/Fch/Spi/LpcReset.c
libagesa-y += Proc/Fch/Spi/SpiEnv.c
libagesa-y += Proc/Fch/Spi/SpiLate.c
libagesa-y += Proc/Fch/Spi/SpiMid.c
libagesa-y += Proc/Fch/Spi/SpiReset.c
libagesa-y += Proc/Fch/Usb/EhciEnv.c
libagesa-y += Proc/Fch/Usb/EhciLate.c
libagesa-y += Proc/Fch/Usb/EhciMid.c
libagesa-y += Proc/Fch/Usb/EhciReset.c
libagesa-y += Proc/Fch/Usb/Family/Hudson2/Hudson2EhciEnvService.c
libagesa-y += Proc/Fch/Usb/Family/Hudson2/Hudson2EhciLateService.c
libagesa-y += Proc/Fch/Usb/Family/Hudson2/Hudson2EhciMidService.c
libagesa-y += Proc/Fch/Usb/Family/Hudson2/Hudson2OhciEnvService.c
libagesa-y += Proc/Fch/Usb/Family/Hudson2/Hudson2OhciLateService.c
libagesa-y += Proc/Fch/Usb/Family/Hudson2/Hudson2OhciMidService.c
libagesa-y += Proc/Fch/Usb/Family/Hudson2/Hudson2XhciEnvService.c
libagesa-y += Proc/Fch/Usb/Family/Hudson2/Hudson2XhciLateService.c
libagesa-y += Proc/Fch/Usb/Family/Hudson2/Hudson2XhciMidService.c
libagesa-y += Proc/Fch/Usb/Family/Hudson2/Hudson2XhciResetService.c
libagesa-y += Proc/Fch/Usb/OhciEnv.c
libagesa-y += Proc/Fch/Usb/OhciLate.c
libagesa-y += Proc/Fch/Usb/OhciMid.c
libagesa-y += Proc/Fch/Usb/OhciReset.c
libagesa-y += Proc/Fch/Usb/UsbEnv.c
libagesa-y += Proc/Fch/Usb/UsbLate.c
libagesa-y += Proc/Fch/Usb/UsbMid.c
libagesa-y += Proc/Fch/Usb/UsbReset.c
libagesa-y += Proc/Fch/Usb/XhciEnv.c
libagesa-y += Proc/Fch/Usb/XhciLate.c
libagesa-y += Proc/Fch/Usb/XhciMid.c
libagesa-y += Proc/Fch/Usb/XhciReset.c

$(obj)/libagesa.fam15tn.a: $$(libagesa-objs)
	@printf "    AGESA        $(subst $(obj)/,,$(@))\n"
	ar rcs $@ $+

romstage-libs  += $(obj)/libagesa.fam15tn.a
ramstage-libs  += $(obj)/libagesa.fam15tn.a
