/* $NoKeywords:$ */
/**
 * @file
 *
 * mpRorG3.c
 *
 * Platform specific settings for OR G34 DDR3 R-DIMM system
 *
 * @xrefitem bom "File Content Label" "Release Content"
 * @e project: AGESA
 * @e sub-project: (Mem/Ps/OR/G34)
 * @e \$Revision: 58716 $ @e \$Date: 2011-09-05 23:18:21 -0600 (Mon, 05 Sep 2011) $
 *
 **/
/*****************************************************************************
  *
 * Copyright (C) 2012 Advanced Micro Devices, Inc.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *     * Redistributions of source code must retain the above copyright
 *       notice, this list of conditions and the following disclaimer.
 *     * Redistributions in binary form must reproduce the above copyright
 *       notice, this list of conditions and the following disclaimer in the
 *       documentation and/or other materials provided with the distribution.
 *     * Neither the name of Advanced Micro Devices, Inc. nor the names of
 *       its contributors may be used to endorse or promote products derived
 *       from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL ADVANCED MICRO DEVICES, INC. BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 * SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
  *
  * ***************************************************************************
  *
 */

#include "AGESA.h"
#include "AdvancedApi.h"
#include "mport.h"
#include "ma.h"
#include "Ids.h"
#include "cpuFamRegisters.h"
#include "cpuRegisters.h"
#include "mm.h"
#include "mn.h"
#include "mp.h"
#include "mu.h"
#include "GeneralServices.h"
#include "OptionMemory.h"
#include "PlatformMemoryConfiguration.h"
#include "Filecode.h"
CODE_GROUP (G3_DXE)
RDATA_GROUP (G3_DXE)



#define FILECODE PROC_MEM_PS_OR_G34_MPRORG3_FILECODE
/*----------------------------------------------------------------------------
 *                          DEFINITIONS AND MACROS
 *
 *----------------------------------------------------------------------------
 */

/*----------------------------------------------------------------------------
 *                           TYPEDEFS AND STRUCTURES
 *
 *----------------------------------------------------------------------------
 */

/*----------------------------------------------------------------------------
 *                        PROTOTYPES OF LOCAL FUNCTIONS
 *
 *----------------------------------------------------------------------------
 */
/*
 *-----------------------------------------------------------------------------
 *                                EXPORTED FUNCTIONS
 *
 *-----------------------------------------------------------------------------
 */
// Slow mode, Address timing and Output drive compensation
// Format :
// DimmPerCh,   DDRrate,   VDDIO,   Dimm0,   Dimm1,   Dimm2,   SlowMode,   AddTmgCtl,   ODC
//
STATIC CONST PSCFG_SAO_ENTRY OrG34RDdr3SAO[] = {
  {1, DDR667, VOLT_ALL, DIMM_SR + DIMM_DR, NP, NP, 0, 0x00000000, 0x00112222},
  {1, DDR667, VOLT_ALL, DIMM_QR, NP, NP, 0, 0x00000000, 0x00222222},
  {1, DDR800, VOLT_ALL, DIMM_SR + DIMM_DR, NP, NP, 0, 0x00000000, 0x10112222},
  {1, DDR800, VOLT_ALL, DIMM_QR, NP, NP, 0, 0x00000000, 0x10222222},
  {1, DDR1066, VOLT_ALL, DIMM_SR + DIMM_DR, NP, NP, 0, 0x003C3C3C, 0x20112222},
  {1, DDR1066, VOLT_ALL, DIMM_QR, NP, NP, 0, 0x003C3C3C, 0x30222222},
  {1, DDR1333, VOLT_ALL, DIMM_SR + DIMM_DR, NP, NP, 0, 0x003A3A3A, 0x30112222},
  {1, DDR1333, V1_5 + V1_35, DIMM_QR, NP, NP, 0, 0x003A3A3A, 0x30222222},
  {1, DDR1600, V1_5 + V1_35, DIMM_SR + DIMM_DR, NP, NP, 0, 0x00393939, 0x30112222},
  {1, DDR1866, V1_5, DIMM_SR + DIMM_DR, NP, NP, 0, 0x00393939, 0x30332222},
  {2, DDR667, VOLT_ALL, NP, DIMM_SR + DIMM_DR, NP, 0, 0x00000000, 0x00112222},
  {2, DDR667, VOLT_ALL, NP, DIMM_QR, NP, 0, 0x00000000, 0x00222222},
  {2, DDR667, VOLT_ALL, DIMM_SR + DIMM_DR + DIMM_QR, DIMM_SR + DIMM_DR + DIMM_QR, NP, 0, 0x00000000, 0x10222222},
  {2, DDR800, VOLT_ALL, NP, DIMM_SR + DIMM_DR, NP, 0, 0x00000000, 0x10112222},
  {2, DDR800, VOLT_ALL, NP, DIMM_QR, NP, 0, 0x00000000, 0x10222222},
  {2, DDR800, VOLT_ALL, DIMM_SR + DIMM_DR + DIMM_QR, DIMM_SR + DIMM_DR + DIMM_QR, NP, 0, 0x00000000, 0x20222222},
  {2, DDR1066, VOLT_ALL, NP, DIMM_SR + DIMM_DR, NP, 0, 0x00393C39, 0x20112222},
  {2, DDR1066, VOLT_ALL, NP, DIMM_QR, NP, 0, 0x00393C39, 0x20222222},
  {2, DDR1066, V1_5, DIMM_SR + DIMM_DR + DIMM_QR, DIMM_SR + DIMM_DR + DIMM_QR, NP, 0, 0x003A3C3A, 0x30222222},
  {2, DDR1066, V1_35 + V1_25, DIMM_SR + DIMM_DR, DIMM_SR + DIMM_DR, NP, 0, 0x003A3C3A, 0x30222222},
  {2, DDR1333, VOLT_ALL, NP, DIMM_SR + DIMM_DR, NP, 0, 0x00373A37, 0x30112222},
  {2, DDR1333, V1_5, NP, DIMM_QR, NP, 0, 0x00373A37, 0x30222222},
  {2, DDR1333, V1_5 + V1_35, DIMM_SR + DIMM_DR, DIMM_SR + DIMM_DR, NP, 0, 0x00383A38, 0x30222222},
  {2, DDR1333, V1_25, DIMM_SR, DIMM_SR, NP, 0, 0x00383A38, 0x30222222},
  {2, DDR1600, V1_5, NP, DIMM_SR + DIMM_DR, NP, 0, 0x00363936, 0x30112222},
  {2, DDR1600, V1_5, DIMM_SR + DIMM_DR, DIMM_SR + DIMM_DR, NP, 0, 0x00353935, 0x30222222},
  {2, DDR1066, V1_35, DIMM_SR + DIMM_DR, DIMM_QR, NP, 0, 0x003A3C3A, 0x30222222},
  {2, DDR1066, V1_35, DIMM_QR, DIMM_SR + DIMM_DR + DIMM_QR, NP, 0, 0x003A3C3A, 0x30222222},
  {2, DDR1066, V1_25, DIMM_QR, DIMM_QR, NP, 0, 0x003A3C3A, 0x30222222},
  {2, DDR1333, V1_5, DIMM_SR + DIMM_DR, DIMM_QR, NP, 0, 0x00383A38, 0x30222222},
  {2, DDR1333, V1_5, DIMM_QR, DIMM_SR + DIMM_DR + DIMM_QR, NP, 0, 0x00383A38, 0x30222222},
  {2, DDR1333, V1_35, NP, DIMM_QR, NP, 0, 0x00373A37, 0x30222222},
  {3, DDR667, VOLT_ALL, NP, NP, DIMM_SR + DIMM_DR, 0, 0x00000000, 0x00332222},
  {3, DDR667, VOLT_ALL, NP, DIMM_QR, NP, 0, 0x00000000, 0x10222222},
  {3, DDR667, VOLT_ALL, NP, DIMM_QR, DIMM_SR + DIMM_DR, 0, 0x00000000, 0x20222222},
  {3, DDR667, VOLT_ALL, DIMM_SR + DIMM_DR, NP, DIMM_SR + DIMM_DR, 0, 0x00000000, 0x10222222},
  {3, DDR667, VOLT_ALL, DIMM_SR + DIMM_DR, DIMM_SR + DIMM_DR + DIMM_QR, DIMM_SR + DIMM_DR, 0, 0x00380038, 0x30112222},
  {3, DDR800, VOLT_ALL, NP, NP, DIMM_SR + DIMM_DR, 0, 0x00390039, 0x10332222},
  {3, DDR800, VOLT_ALL, NP, DIMM_QR, NP, 0, 0x00390039, 0x20222222},
  {3, DDR800, VOLT_ALL, NP, DIMM_QR, DIMM_SR + DIMM_DR, 0, 0x003A003A, 0x30222222},
  {3, DDR800, VOLT_ALL, DIMM_SR + DIMM_DR, NP, DIMM_SR + DIMM_DR, 0, 0x003A003A, 0x20222222},
  {3, DDR800, V1_5 + V1_35, DIMM_SR + DIMM_DR, DIMM_SR + DIMM_DR + DIMM_QR, DIMM_SR + DIMM_DR, 0, 0x00360036, 0x30112222},
  {3, DDR800, V1_25, DIMM_SR, DIMM_SR, DIMM_SR, 0, 0x00360036, 0x30112222},
  {3, DDR1066, VOLT_ALL, NP, NP, DIMM_SR + DIMM_DR, 0, 0x00373C37, 0x20332222},
  {3, DDR1066, V1_5 + V1_35, NP, DIMM_QR, NP, 0, 0x00373C37, 0x30222222},
  {3, DDR1066, VOLT_ALL, DIMM_SR + DIMM_DR, NP, DIMM_SR + DIMM_DR, 0, 0x00383C38, 0x30222222},
  {3, DDR1066, V1_5, DIMM_SR + DIMM_DR, DIMM_SR + DIMM_DR, DIMM_SR + DIMM_DR, 0, 0x00333C33, 0x30112222},
  {3, DDR1066, V1_35, DIMM_SR, DIMM_SR, DIMM_SR, 0, 0x00333C33, 0x30112222},
  {3, DDR1333, VOLT_ALL, NP, NP, DIMM_SR + DIMM_DR, 0, 0x00353A35, 0x30332222},
  {3, DDR1333, V1_5 + V1_35, DIMM_SR + DIMM_DR, NP, DIMM_SR + DIMM_DR, 0, 0x00363A36, 0x30222222},
  {3, DDR1333, V1_25, DIMM_SR, NP, DIMM_SR, 0, 0x00363A36, 0x30222222},
  {3, DDR1600, V1_5, NP, NP, DIMM_SR + DIMM_DR, 0, 0x00333933, 0x30332222},
  {3, DDR800, V1_25, DIMM_SR, DIMM_SR, DIMM_DR, 0, 0x00360036, 0x30112222},
  {3, DDR800, V1_25, DIMM_SR, DIMM_DR, DIMM_SR + DIMM_DR, 0, 0x00360036, 0x30112222},
  {3, DDR800, V1_25, DIMM_DR, DIMM_SR + DIMM_DR, DIMM_SR + DIMM_DR, 0, 0x00360036, 0x30112222},
  {3, DDR1066, V1_5 + V1_35, NP, DIMM_QR, DIMM_SR + DIMM_DR, 0, 0x00383C38, 0x30222222},
  {3, DDR1066, V1_5, DIMM_SR, DIMM_QR, DIMM_SR, 0, 0x00333C33, 0x30112222},
  {3, DDR1066, V1_5, DIMM_DR, DIMM_QR, DIMM_DR, 0, 0x00333C33, 0x30112222},
  {3, DDR1066, V1_35, DIMM_SR, DIMM_SR, DIMM_DR, 0, 0x00333C33, 0x30112222},
  {3, DDR1066, V1_35, DIMM_SR, DIMM_DR, DIMM_SR + DIMM_DR, 0, 0x00333C33, 0x30112222},
  {3, DDR1066, V1_35, DIMM_DR, DIMM_SR + DIMM_DR, DIMM_SR + DIMM_DR, 0, 0x00333C33, 0x30112222},
  {3, DDR1333, V1_5, NP, DIMM_QR, NP, 0, 0x00353A35, 0x30222222},
  {3, DDR1333, V1_5, DIMM_SR, DIMM_SR, DIMM_DR, 0, 0x00303A30, 0x30112222},
  {3, DDR1333, V1_5, DIMM_SR, DIMM_DR, DIMM_SR + DIMM_DR, 0, 0x00303A30, 0x30112222},
  {3, DDR1333, V1_5, DIMM_DR, DIMM_SR + DIMM_DR, DIMM_SR + DIMM_DR, 0, 0x00303A30, 0x30112222},
  {3, DDR1600, V1_5, DIMM_SR + DIMM_DR, NP, DIMM_SR + DIMM_DR, 0, 0x00343934, 0x30222222},
};
CONST PSC_TBL_ENTRY SAOTblEntRG34 = {
   {PSCFG_SAO, RDIMM_TYPE, NOD_DONT_CARE, {AMD_FAMILY_15_OR, AMD_F15_ALL}, OR_SOCKET_G34, DDR3_TECHNOLOGY},
   sizeof (OrG34RDdr3SAO) / sizeof (PSCFG_SAO_ENTRY),
   (VOID *)&OrG34RDdr3SAO
};

// training configuratrions
// Format :
// DimmPerCh,   DDRrate,   VDDIO,   Dimm0,   Dimm1,   Dimm2,   2D
//
STATIC CONST PSCFG_S___ENTRY OrG34RDdr3S__[] = {
// DimmPerCh,Frequency,VDDIO,DIMM0,DIMM1,DIMM2,Enable__Training
  {1, DDR667 + DDR800 + DDR1066, VOLT_ALL, DIMM_SR + DIMM_DR + DIMM_QR, NP, NP, 0},
  {1, DDR1333, V1_5 + V1_35, DIMM_SR + DIMM_DR + DIMM_QR, NP, NP, 0},
  {1, DDR1333, V1_25, DIMM_SR + DIMM_DR, NP, NP, 0},
  {1, DDR1600, V1_5 + V1_35, DIMM_SR + DIMM_DR, NP, NP, 0},
  {1, DDR1866, V1_5, DIMM_SR + DIMM_DR, NP, NP, 0},
  // DimmPerCh,Frequency,VDDIO,DIMM0,DIMM1,DIMM2,Enable__Training
  {2, DDR667 + DDR800, VOLT_ALL, NP + DIMM_SR + DIMM_DR + DIMM_QR, DIMM_SR + DIMM_DR + DIMM_QR, NP, 0},
  {2, DDR1066, V1_5, NP + DIMM_SR + DIMM_DR + DIMM_QR, DIMM_SR + DIMM_DR + DIMM_QR, NP, 0},
  {2, DDR1066, V1_35 + V1_25, NP, DIMM_SR + DIMM_DR + DIMM_QR, NP, 0},
  {2, DDR1066, V1_35 + V1_25, DIMM_SR + DIMM_DR, DIMM_SR + DIMM_DR, NP, 0},
  {2, DDR1333, V1_5, NP, DIMM_SR + DIMM_DR + DIMM_QR, NP, 0},
  {2, DDR1333, V1_5, DIMM_SR + DIMM_DR, DIMM_SR + DIMM_DR, NP, 0},
  {2, DDR1333, V1_35, NP + DIMM_SR + DIMM_DR, DIMM_SR + DIMM_DR, NP, 0},
  {2, DDR1333, V1_25, NP, DIMM_SR + DIMM_DR, NP, 0},
  {2, DDR1333, V1_25, DIMM_SR, DIMM_SR, NP, 0},
  {2, DDR1600, V1_5, NP, DIMM_SR + DIMM_DR, NP, 0},
  {2, DDR1600, V1_5, DIMM_SR, DIMM_SR, NP, 0},
  {2, DDR1066, V1_35, DIMM_SR + DIMM_DR, DIMM_QR, NP, 0},
  {2, DDR1066, V1_35, DIMM_QR, DIMM_SR + DIMM_DR + DIMM_QR, NP, 0},
  {2, DDR1066, V1_25, DIMM_QR, DIMM_QR, NP, 0},
  {2, DDR1333, V1_5, DIMM_SR + DIMM_DR, DIMM_QR, NP, 0},
  {2, DDR1333, V1_5, DIMM_QR, DIMM_SR + DIMM_DR + DIMM_QR, NP, 0},
  {2, DDR1333, V1_35, NP, DIMM_QR, NP, 0},
  {2, DDR1600, V1_5, DIMM_SR, DIMM_DR, NP, 0},
  {2, DDR1600, V1_5, DIMM_DR, DIMM_SR + DIMM_DR, NP, 0},
  // DimmPerCh,Frequency,VDDIO,DIMM0,DIMM1,DIMM2,Enable__Training
  {3, DDR667, VOLT_ALL, NP, NP, DIMM_SR + DIMM_DR, 1},
  {3, DDR667 + DDR800, VOLT_ALL, NP, DIMM_QR, NP + DIMM_SR + DIMM_DR, 1},
  {3, DDR667, VOLT_ALL, DIMM_SR + DIMM_DR, NP + DIMM_SR + DIMM_DR + DIMM_QR, DIMM_SR + DIMM_DR, 1},
  {3, DDR800, V1_5 + V1_35, NP, NP, DIMM_SR + DIMM_DR, 1},
  {3, DDR800, V1_5, DIMM_SR + DIMM_DR, NP + DIMM_SR + DIMM_DR + DIMM_QR, DIMM_SR + DIMM_DR, 1},
  {3, DDR800, V1_35, DIMM_SR + DIMM_DR, NP + DIMM_SR + DIMM_DR, DIMM_SR + DIMM_DR, 1},
  {3, DDR800, V1_25, NP + DIMM_SR + DIMM_DR, NP, DIMM_SR + DIMM_DR, 1},
  {3, DDR800, V1_25, DIMM_SR, DIMM_SR, DIMM_SR, 1},
  {3, DDR1066 + DDR1600, V1_5, NP, NP, DIMM_SR + DIMM_DR, 1},
  {3, DDR1066, V1_5 + V1_35, NP, DIMM_QR, NP, 1},
  {3, DDR1066, V1_5, DIMM_SR + DIMM_DR, NP + DIMM_SR + DIMM_DR, DIMM_SR + DIMM_DR, 1},
  {3, DDR1066, V1_35 + V1_25, NP + DIMM_SR + DIMM_DR, NP, DIMM_SR + DIMM_DR, 1},
  {3, DDR1066, V1_35, DIMM_SR, DIMM_SR, DIMM_SR, 1},
  {3, DDR1333, V1_5 + V1_35, NP + DIMM_SR + DIMM_DR, NP, DIMM_SR + DIMM_DR, 1},
  {3, DDR1333, V1_5, DIMM_SR, DIMM_SR, DIMM_SR, 1},
  {3, DDR1333, V1_25, NP, NP, DIMM_SR + DIMM_DR, 1},
  {3, DDR1333, V1_25, DIMM_SR, NP, DIMM_SR, 1},
  {3, DDR800, V1_35, DIMM_SR + DIMM_DR, DIMM_QR, DIMM_SR + DIMM_DR, 1},
  {3, DDR800, V1_25, DIMM_SR, DIMM_SR, DIMM_DR, 1},
  {3, DDR800, V1_25, DIMM_SR, DIMM_DR, DIMM_SR + DIMM_DR, 1},
  {3, DDR800, V1_25, DIMM_DR, DIMM_SR + DIMM_DR, DIMM_SR + DIMM_DR, 1},
  {3, DDR1066, V1_5 + V1_35, NP, DIMM_QR, DIMM_SR + DIMM_DR, 1},
  {3, DDR1066, V1_5, DIMM_SR, DIMM_QR, DIMM_SR, 1},
  {3, DDR1066, V1_5, DIMM_DR, DIMM_QR, DIMM_DR, 1},
  {3, DDR1066, V1_35, DIMM_SR, DIMM_SR, DIMM_DR, 1},
  {3, DDR1066, V1_35, DIMM_SR, DIMM_DR, DIMM_SR + DIMM_DR, 1},
  {3, DDR1066, V1_35, DIMM_DR, DIMM_SR + DIMM_DR, DIMM_SR + DIMM_DR, 1},
  {3, DDR1333, V1_5, NP, DIMM_QR, NP, 1},
  {3, DDR1333, V1_5, DIMM_SR, DIMM_SR, DIMM_DR, 1},
  {3, DDR1333, V1_5, DIMM_SR, DIMM_DR, DIMM_SR + DIMM_DR, 1},
  {3, DDR1333, V1_5, DIMM_DR, DIMM_SR + DIMM_DR, DIMM_SR + DIMM_DR, 1},
  {3, DDR1600, V1_5, DIMM_SR + DIMM_DR, NP, DIMM_SR + DIMM_DR, 1},
  };
CONST PSC_TBL_ENTRY S__TblEntRG34 = {
   {PSCFG_S__, RDIMM_TYPE, NOD_DONT_CARE, {AMD_FAMILY_15_OR, AMD_F15_ALL}, OR_SOCKET_G34, DDR3_TECHNOLOGY},
   sizeof (OrG34RDdr3S__) / sizeof (PSCFG_S___ENTRY),
   (VOID *)&OrG34RDdr3S__
};
// ODT pattern for 1 DPC
// Format:
//  Dimm0,   RdODTCSHigh,   RdODTCSLow,   WrODTCSHigh,   WrODTCSLow
//
STATIC CONST PSCFG_1D_ODTPAT_ENTRY Or1RDdr3OdtPat[] = {
  {DIMM_SR, 0x00000000, 0x00000000, 0x00000000, 0x00000001},
  {DIMM_DR, 0x00000000, 0x00000000, 0x00000000, 0x00000401},
  {DIMM_QR, 0x00000000, 0x00000000, 0x00000505, 0x00000505}
};
CONST PSC_TBL_ENTRY OdtPat1DTblEntRG34 = {
   {PSCFG_ODT_PAT_1D, RDIMM_TYPE, _1DIMM, {AMD_FAMILY_15_OR, AMD_F15_ALL}, OR_SOCKET_G34, DDR3_TECHNOLOGY},
   sizeof (Or1RDdr3OdtPat) / sizeof (PSCFG_1D_ODTPAT_ENTRY),
   (VOID *)&Or1RDdr3OdtPat
};

// ODT pattern for 2 DPC
// Format:
//  Dimm0,   Dimm1,   RdODTCSHigh,   RdODTCSLow,   WrODTCSHigh,   WrODTCSLow
//
STATIC CONST PSCFG____ODTPAT_ENTRY Or2RDdr3OdtPat[] = {
  {NP, DIMM_SR, 0x00000000, 0x00000000, 0x00000000, 0x00020000},
  {NP, DIMM_DR, 0x00000000, 0x00000000, 0x00000000, 0x08020000},
  {NP, DIMM_QR, 0x00000000, 0x00000000, 0x020A0000, 0x080A0000},
  {DIMM_SR + DIMM_DR, DIMM_SR + DIMM_DR, 0x00000000, 0x01010202, 0x00000000, 0x09030603},
  {DIMM_SR + DIMM_DR, DIMM_QR, 0x01010000, 0x01010A0A, 0x01090000, 0x01030E0B},
  {DIMM_QR, DIMM_SR + DIMM_DR, 0x00000202, 0x05050202, 0x00000206, 0x0D070203},
  {DIMM_QR, DIMM_QR, 0x05050A0A, 0x05050A0A, 0x050D0A0E, 0x05070A0B}
};
CONST PSC_TBL_ENTRY OdtPat2DTblEntRG34 = {
   {PSCFG_ODT_PAT___, RDIMM_TYPE, _2DIMM, {AMD_FAMILY_15_OR, AMD_F15_ALL}, OR_SOCKET_G34, DDR3_TECHNOLOGY},
   sizeof (Or2RDdr3OdtPat) / sizeof (PSCFG____ODTPAT_ENTRY),
   (VOID *)&Or2RDdr3OdtPat
};

// ODT pattern for 3 DPC
// Format:
//  Dimm0,   Dimm1,   Dimm2,   RdODTCSHigh,   RdODTCSLow,   WrODTCSHigh,   WrODTCSLow
//
STATIC CONST PSCFG_3D_ODTPAT_ENTRY Or3RDdr3OdtPat[] = {
  {NP, NP, DIMM_SR + DIMM_DR, 0x00000000, 0x00000000, 0x00000004, 0x00000000},
  {DIMM_SR + DIMM_DR, NP, DIMM_SR + DIMM_DR, 0x00000101, 0x00000404, 0x00000105, 0x0000405},
  {DIMM_SR + DIMM_DR, DIMM_SR + DIMM_DR, DIMM_SR + DIMM_DR, 0x00000303, 0x05050606, 0x00000307, 0x0D070607},
  {NP, DIMM_QR, NP, 0x00000000, 0x00000000, 0x020A0000, 0x080A0000},
  {NP, DIMM_QR, DIMM_SR + DIMM_DR, 0x04040A0A, 0x04040000, 0x040C0A0E, 0x04060000},
  {DIMM_SR + DIMM_DR, DIMM_QR, DIMM_SR + DIMM_DR, 0x05050B0B, 0x05050E0E, 0x050D0B0F, 0x05070E0F}
};
CONST PSC_TBL_ENTRY OdtPat3DTblEntRG34 = {
   {PSCFG_ODT_PAT_3D, RDIMM_TYPE, _3DIMM, {AMD_FAMILY_15_OR, AMD_F15_ALL}, OR_SOCKET_G34, DDR3_TECHNOLOGY},
   sizeof (Or3RDdr3OdtPat) / sizeof (PSCFG_3D_ODTPAT_ENTRY),
   (VOID *)&Or3RDdr3OdtPat
};

// Dram Term and Dynamic Dram Term
// Format :
// DimmPerCh,   DDRrate,   VDDIO,   Dimm0,   Dimm1,   Dimm2,   Dimm,   Rank,   RttNom,    RttWr
//
STATIC CONST PSCFG_RTT_ENTRY DramTermOrG34RDIMM[] = {
  {1, DDR667 + DDR800, VOLT_ALL, DIMM_SR, NP, NP, DIMM_SR, R0, 2, 0},
  {1, DDR667 + DDR800, VOLT_ALL, DIMM_DR, NP, NP, DIMM_DR, R0 + R1, 2, 0},
  {1, DDR667 + DDR800, VOLT_ALL, DIMM_QR, NP, NP, DIMM_QR, R0 + R2, 2, 2},
  {1, DDR667 + DDR800 + DDR1066, VOLT_ALL, DIMM_QR, NP, NP, DIMM_QR, R1 + R3, 0, 2},
  {1, DDR1066 + DDR1333, VOLT_ALL, DIMM_SR, NP, NP, DIMM_SR, R0, 1, 0},
  {1, DDR1066 + DDR1333, VOLT_ALL, DIMM_DR, NP, NP, DIMM_DR, R0 + R1, 1, 0},
  {1, DDR1066, VOLT_ALL, DIMM_QR, NP, NP, DIMM_QR, R0 + R2, 1, 2},
  {1, DDR1333, V1_5 + V1_35, DIMM_QR, NP, NP, DIMM_QR, R0 + R2, 3, 2},
  {1, DDR1333, V1_5 + V1_35, DIMM_QR, NP, NP, DIMM_QR, R1 + R3, 0, 2},
  {1, DDR1600, V1_5 + V1_35, DIMM_SR, NP, NP, DIMM_SR, R0, 3, 0},
  {1, DDR1600, V1_5 + V1_35, DIMM_DR, NP, NP, DIMM_DR, R0 + R1, 3, 0},
  {1, DDR1866, V1_5, DIMM_SR, NP, NP, DIMM_SR, R0, 3, 0},
  {1, DDR1866, V1_5, DIMM_DR, NP, NP, DIMM_DR, R0 + R1, 3, 0},
  {2, DDR667 + DDR800, VOLT_ALL, NP, DIMM_SR, NP, DIMM_SR, R0, 2, 0},
  {2, DDR667 + DDR800, VOLT_ALL, NP, DIMM_DR, NP, DIMM_DR, R0 + R1, 2, 0},
  {2, DDR667 + DDR800, VOLT_ALL, NP, DIMM_QR, NP, DIMM_QR, R0 + R2, 2, 2},
  {2, DDR667 + DDR800, VOLT_ALL, NP + DIMM_SR + DIMM_DR, DIMM_QR, NP, DIMM_QR, R1 + R3, 0, 2},
  {2, DDR667 + DDR800 + DDR1066, VOLT_ALL, DIMM_SR, DIMM_SR + DIMM_DR, NP, DIMM_SR, R0, 3, 2},
  {2, DDR667 + DDR800 + DDR1066, VOLT_ALL, DIMM_SR, DIMM_DR, NP, DIMM_DR, R0 + R1, 3, 2},
  {2, DDR667 + DDR800, VOLT_ALL, DIMM_SR, DIMM_QR, NP, DIMM_SR, R0, 5, 2},
  {2, DDR667 + DDR800, VOLT_ALL, DIMM_SR + DIMM_DR, DIMM_QR, NP, DIMM_QR, R0 + R2, 1, 2},
  {2, DDR667 + DDR800 + DDR1066, VOLT_ALL, DIMM_DR, DIMM_SR, NP, DIMM_SR, R0, 3, 2},
  {2, DDR667 + DDR800 + DDR1066, VOLT_ALL, DIMM_DR, DIMM_SR + DIMM_DR, NP, DIMM_DR, R0 + R1, 3, 2},
  {2, DDR667 + DDR800, VOLT_ALL, DIMM_DR, DIMM_QR, NP, DIMM_DR, R0 + R1, 5, 2},
  {2, DDR667 + DDR800, VOLT_ALL, DIMM_QR, DIMM_SR, NP, DIMM_SR, R0, 5, 2},
  {2, DDR667 + DDR800, VOLT_ALL, DIMM_QR, DIMM_SR + DIMM_DR + DIMM_QR, NP, DIMM_QR, R0 + R2, 1, 2},
  {2, DDR667 + DDR800, VOLT_ALL, DIMM_QR, DIMM_SR + DIMM_DR + DIMM_QR, NP, DIMM_QR, R1 + R3, 0, 2},
  {2, DDR667 + DDR800, VOLT_ALL, DIMM_QR, DIMM_DR, NP, DIMM_DR, R0 + R1, 5, 2},
  {2, DDR1066 + DDR1333, VOLT_ALL, NP, DIMM_SR, NP, DIMM_SR, R0, 1, 0},
  {2, DDR1066 + DDR1333, VOLT_ALL, NP, DIMM_DR, NP, DIMM_DR, R0 + R1, 1, 0},
  {2, DDR1066, VOLT_ALL, NP, DIMM_QR, NP, DIMM_QR, R0 + R2, 1, 2},
  {2, DDR1066, VOLT_ALL, NP, DIMM_QR, NP, DIMM_QR, R1 + R3, 0, 2},
  {2, DDR1066, V1_5, DIMM_SR, DIMM_QR, NP, DIMM_SR, R0, 5, 1},
  {2, DDR1066, V1_5, DIMM_SR + DIMM_DR, DIMM_QR, NP, DIMM_QR, R0 + R2, 1, 1},
  {2, DDR1066, V1_5, DIMM_SR + DIMM_DR, DIMM_QR, NP, DIMM_QR, R1 + R3, 0, 1},
  {2, DDR1066, V1_5, DIMM_DR, DIMM_QR, NP, DIMM_DR, R0 + R1, 5, 1},
  {2, DDR1066, V1_5, DIMM_QR, DIMM_SR, NP, DIMM_SR, R0, 5, 1},
  {2, DDR1066, V1_5, DIMM_QR, DIMM_SR + DIMM_DR + DIMM_QR, NP, DIMM_QR, R0 + R2, 1, 1},
  {2, DDR1066, V1_5, DIMM_QR, DIMM_SR + DIMM_DR + DIMM_QR, NP, DIMM_QR, R1 + R3, 0, 1},
  {2, DDR1066, V1_5, DIMM_QR, DIMM_DR, NP, DIMM_DR, R0 + R1, 5, 1},
  {2, DDR1333, V1_5, NP, DIMM_QR, NP, DIMM_QR, R0 + R2, 3, 2},
  {2, DDR1333, V1_5, NP, DIMM_QR, NP, DIMM_QR, R1 + R3, 0, 2},
  {2, DDR1333, V1_5 + V1_35, DIMM_SR, DIMM_SR + DIMM_DR, NP, DIMM_SR, R0, 5, 2},
  {2, DDR1333, V1_5 + V1_35, DIMM_SR, DIMM_DR, NP, DIMM_DR, R0 + R1, 5, 2},
  {2, DDR1333, V1_5 + V1_35, DIMM_DR, DIMM_SR, NP, DIMM_SR, R0, 5, 2},
  {2, DDR1333, V1_5 + V1_35, DIMM_DR, DIMM_SR + DIMM_DR, NP, DIMM_DR, R0 + R1, 5, 2},
  {2, DDR1333, V1_25, DIMM_SR, DIMM_SR, NP, DIMM_SR, R0, 5, 2},
  {2, DDR1600, V1_5, NP, DIMM_SR, NP, DIMM_SR, R0, 3, 0},
  {2, DDR1600, V1_5, NP, DIMM_DR, NP, DIMM_DR, R0 + R1, 3, 0},
  {2, DDR1600, V1_5, DIMM_SR, DIMM_SR + DIMM_DR, NP, DIMM_SR, R0, 4, 1},
  {2, DDR1600, V1_5, DIMM_SR, DIMM_DR, NP, DIMM_DR, R0 + R1, 4, 1},
  {2, DDR1600, V1_5, DIMM_DR, DIMM_SR, NP, DIMM_SR, R0, 4, 1},
  {2, DDR1600, V1_5, DIMM_DR, DIMM_SR + DIMM_DR, NP, DIMM_DR, R0 + R1, 4, 1},
  {2, DDR1066, V1_35, DIMM_SR, DIMM_QR, NP, DIMM_SR, R0, 5, 1},
  {2, DDR1066, V1_35, DIMM_SR + DIMM_DR, DIMM_QR, NP, DIMM_QR, R0 + R2, 1, 1},
  {2, DDR1066, V1_35, DIMM_SR + DIMM_DR, DIMM_QR, NP, DIMM_QR, R1 + R3, 0, 1},
  {2, DDR1066, V1_35, DIMM_DR, DIMM_QR, NP, DIMM_DR, R0 + R1, 5, 1},
  {2, DDR1066, V1_35, DIMM_QR, DIMM_SR, NP, DIMM_SR, R0, 5, 1},
  {2, DDR1066, V1_35, DIMM_QR, DIMM_SR + DIMM_DR + DIMM_QR, NP, DIMM_QR, R0 + R2, 1, 1},
  {2, DDR1066, V1_35, DIMM_QR, DIMM_SR + DIMM_DR + DIMM_QR, NP, DIMM_QR, R1 + R3, 0, 1},
  {2, DDR1066, V1_35, DIMM_QR, DIMM_DR, NP, DIMM_DR, R0 + R1, 5, 1},
  {2, DDR1066, V1_25, DIMM_QR, DIMM_QR, NP, DIMM_QR, R0 + R2, 1, 1},
  {2, DDR1066, V1_25, DIMM_QR, DIMM_QR, NP, DIMM_QR, R1 + R3, 0, 1},
  {2, DDR1333, V1_5, DIMM_SR, DIMM_QR, NP, DIMM_SR, R0, 5, 1},
  {2, DDR1333, V1_5, DIMM_SR + DIMM_DR, DIMM_QR, NP, DIMM_QR, R0 + R2, 1, 1},
  {2, DDR1333, V1_5, DIMM_SR + DIMM_DR, DIMM_QR, NP, DIMM_QR, R1 + R3, 0, 1},
  {2, DDR1333, V1_5, DIMM_DR, DIMM_QR, NP, DIMM_DR, R0 + R1, 5, 1},
  {2, DDR1333, V1_5, DIMM_QR, DIMM_SR, NP, DIMM_SR, R0, 5, 1},
  {2, DDR1333, V1_5, DIMM_QR, DIMM_SR + DIMM_DR + DIMM_QR, NP, DIMM_QR, R0 + R2, 1, 1},
  {2, DDR1333, V1_5, DIMM_QR, DIMM_SR + DIMM_DR + DIMM_QR, NP, DIMM_QR, R1 + R3, 0, 1},
  {2, DDR1333, V1_5, DIMM_QR, DIMM_DR, NP, DIMM_DR, R0 + R1, 5, 1},
  {2, DDR1333, V1_35, NP, DIMM_QR, NP, DIMM_QR, R0 + R2, 3, 2},
  {2, DDR1333, V1_35, NP, DIMM_QR, NP, DIMM_QR, R1 + R3, 0, 2},
  {3, DDR667 + DDR800, VOLT_ALL, NP, NP, DIMM_SR, DIMM_SR, R0, 0, 2},
  {3, DDR667 + DDR800, VOLT_ALL, NP, NP, DIMM_DR, DIMM_DR, R0 + R1, 0, 2},
  {3, DDR667, VOLT_ALL, NP, DIMM_QR, NP, DIMM_QR, R0 + R2, 2, 2},
  {3, DDR667 + DDR800, VOLT_ALL, NP, DIMM_QR, NP + DIMM_SR + DIMM_DR, DIMM_QR, R1 + R3, 0, 2},
  {3, DDR667, VOLT_ALL, NP + DIMM_SR, DIMM_QR, DIMM_SR, DIMM_SR, R0, 5, 2},
  {3, DDR667, VOLT_ALL, NP + DIMM_SR + DIMM_DR, DIMM_QR, DIMM_SR + DIMM_DR, DIMM_QR, R0 + R2, 1, 2},
  {3, DDR667, VOLT_ALL, NP + DIMM_DR, DIMM_QR, DIMM_DR, DIMM_DR, R0, 5, 2},
  {3, DDR667 + DDR800, VOLT_ALL, NP, DIMM_QR, DIMM_DR, DIMM_DR, R1, 0, 2},
  {3, DDR667, VOLT_ALL, DIMM_SR, NP + DIMM_SR, DIMM_SR, DIMM_SR, R0, 3, 2},
  {3, DDR667, VOLT_ALL, DIMM_SR, NP + DIMM_SR, DIMM_DR, DIMM_SR + DIMM_DR, R0, 3, 2},
  {3, DDR667, VOLT_ALL, DIMM_SR, NP + DIMM_SR + DIMM_QR, DIMM_DR, DIMM_DR, R1, 0, 2},
  {3, DDR667, VOLT_ALL, DIMM_SR, DIMM_DR, DIMM_SR + DIMM_DR, DIMM_SR + DIMM_DR, R0, 3, 2},
  {3, DDR667, VOLT_ALL, DIMM_SR, DIMM_DR, DIMM_SR + DIMM_DR, DIMM_DR, R1, 0, 2},
  {3, DDR667, VOLT_ALL, DIMM_SR + DIMM_DR, DIMM_QR, DIMM_SR + DIMM_DR, DIMM_QR, R1 + R3, 0, 2},
  {3, DDR667, VOLT_ALL, DIMM_SR, DIMM_QR, DIMM_DR, DIMM_SR + DIMM_DR, R0, 5, 2},
  {3, DDR667, VOLT_ALL, DIMM_DR, NP + DIMM_DR, DIMM_SR, DIMM_SR + DIMM_DR, R0, 3, 2},
  {3, DDR667, VOLT_ALL, DIMM_DR, NP + DIMM_SR + DIMM_DR + DIMM_QR, DIMM_SR + DIMM_DR, DIMM_DR, R1, 0, 2},
  {3, DDR667, VOLT_ALL, DIMM_DR, NP + DIMM_DR, DIMM_DR, DIMM_DR, R0, 3, 2},
  {3, DDR667, VOLT_ALL, DIMM_DR, DIMM_SR, DIMM_SR + DIMM_DR, DIMM_SR + DIMM_DR, R0, 3, 2},
  {3, DDR667, VOLT_ALL, DIMM_DR, DIMM_QR, DIMM_SR, DIMM_SR + DIMM_DR, R0, 5, 2},
  {3, DDR800, VOLT_ALL, NP, DIMM_QR, NP + DIMM_SR + DIMM_DR, DIMM_QR, R0 + R2, 1, 2},
  {3, DDR800, VOLT_ALL, NP, DIMM_QR, DIMM_SR, DIMM_SR, R0, 5, 2},
  {3, DDR800, VOLT_ALL, NP, DIMM_QR, DIMM_DR, DIMM_DR, R0, 5, 2},
  {3, DDR800 + DDR1066, VOLT_ALL, DIMM_SR, NP, DIMM_SR, DIMM_SR, R0, 3, 2},
  {3, DDR800 + DDR1066, VOLT_ALL, DIMM_SR, NP, DIMM_DR, DIMM_SR + DIMM_DR, R0, 3, 2},
  {3, DDR800, V1_5 + V1_35, DIMM_SR, NP + DIMM_SR + DIMM_QR, DIMM_DR, DIMM_DR, R1, 0, 2},
  {3, DDR800, V1_5 + V1_35, DIMM_SR, DIMM_SR + DIMM_QR, DIMM_SR, DIMM_SR, R0, 5, 2},
  {3, DDR800, V1_5 + V1_35, DIMM_SR, DIMM_SR + DIMM_QR, DIMM_DR, DIMM_SR + DIMM_DR, R0, 5, 2},
  {3, DDR800, V1_5 + V1_35, DIMM_SR, DIMM_DR, DIMM_SR + DIMM_DR, DIMM_SR + DIMM_DR, R0, 5, 2},
  {3, DDR800, V1_5 + V1_35, DIMM_SR, DIMM_DR, DIMM_SR + DIMM_DR, DIMM_DR, R1, 0, 2},
  {3, DDR800, V1_5 + V1_35, DIMM_SR + DIMM_DR, DIMM_QR, DIMM_SR + DIMM_DR, DIMM_QR, R0 + R2, 1, 2},
  {3, DDR800, V1_5 + V1_35, DIMM_SR + DIMM_DR, DIMM_QR, DIMM_SR + DIMM_DR, DIMM_QR, R1 + R3, 0, 2},
  {3, DDR800 + DDR1066, VOLT_ALL, DIMM_DR, NP, DIMM_SR, DIMM_SR + DIMM_DR, R0, 3, 2},
  {3, DDR800, V1_5 + V1_35, DIMM_DR, NP + DIMM_SR + DIMM_DR + DIMM_QR, DIMM_SR + DIMM_DR, DIMM_DR, R1, 0, 2},
  {3, DDR800 + DDR1066, VOLT_ALL, DIMM_DR, NP, DIMM_DR, DIMM_DR, R0, 3, 2},
  {3, DDR800, V1_5 + V1_35, DIMM_DR, DIMM_SR, DIMM_SR + DIMM_DR, DIMM_SR + DIMM_DR, R0, 5, 2},
  {3, DDR800, V1_5 + V1_35, DIMM_DR, DIMM_DR + DIMM_QR, DIMM_SR, DIMM_SR + DIMM_DR, R0, 5, 2},
  {3, DDR800, V1_5 + V1_35, DIMM_DR, DIMM_DR + DIMM_QR, DIMM_DR, DIMM_DR, R0, 5, 2},
  {3, DDR800, V1_25, DIMM_SR, NP, DIMM_DR, DIMM_DR, R1, 0, 2},
  {3, DDR800, V1_25, DIMM_SR, DIMM_SR, DIMM_SR, DIMM_SR, R0, 5, 2},
  {3, DDR800, V1_25, DIMM_DR, NP, DIMM_SR + DIMM_DR, DIMM_DR, R1, 0, 2},
  {3, DDR1066 + DDR1333, VOLT_ALL, NP, NP, DIMM_SR, DIMM_SR, R0, 0, 1},
  {3, DDR1066 + DDR1333, VOLT_ALL, NP, NP, DIMM_DR, DIMM_DR, R0 + R1, 0, 1},
  {3, DDR1066, V1_5 + V1_35, NP, DIMM_QR, NP, DIMM_QR, R0 + R2, 1, 2},
  {3, DDR1066, V1_5 + V1_35, NP, DIMM_QR, NP, DIMM_QR, R1 + R3, 0, 2},
  {3, DDR1066, V1_5, DIMM_SR, NP + DIMM_SR, DIMM_DR, DIMM_DR, R1, 0, 2},
  {3, DDR1066, V1_5 + V1_35, DIMM_SR, DIMM_SR, DIMM_SR, DIMM_SR, R0, 5, 2},
  {3, DDR1066, V1_5, DIMM_SR, DIMM_SR, DIMM_DR, DIMM_SR + DIMM_DR, R0, 5, 2},
  {3, DDR1066, V1_5, DIMM_SR, DIMM_DR, DIMM_SR + DIMM_DR, DIMM_SR + DIMM_DR, R0, 5, 2},
  {3, DDR1066, V1_5, DIMM_SR, DIMM_DR, DIMM_SR + DIMM_DR, DIMM_DR, R1, 0, 2},
  {3, DDR1066, V1_5, DIMM_DR, NP + DIMM_SR + DIMM_DR, DIMM_SR + DIMM_DR, DIMM_DR, R1, 0, 2},
  {3, DDR1066, V1_5, DIMM_DR, DIMM_SR, DIMM_SR + DIMM_DR, DIMM_SR + DIMM_DR, R0, 5, 2},
  {3, DDR1066, V1_5, DIMM_DR, DIMM_DR, DIMM_SR, DIMM_SR + DIMM_DR, R0, 5, 2},
  {3, DDR1066, V1_5, DIMM_DR, DIMM_DR, DIMM_DR, DIMM_DR, R0, 5, 2},
  {3, DDR1066, V1_35 + V1_25, DIMM_SR, NP, DIMM_DR, DIMM_DR, R1, 0, 2},
  {3, DDR1066, V1_35 + V1_25, DIMM_DR, NP, DIMM_SR + DIMM_DR, DIMM_DR, R1, 0, 2},
  {3, DDR1333, VOLT_ALL, DIMM_SR, NP, DIMM_SR, DIMM_SR, R0, 5, 2},
  {3, DDR1333, V1_5 + V1_35, DIMM_SR, NP, DIMM_DR, DIMM_SR + DIMM_DR, R0, 5, 2},
  {3, DDR1333, V1_5 + V1_35, DIMM_SR, NP, DIMM_DR, DIMM_DR, R1, 0, 2},
  {3, DDR1333, V1_5 + V1_35, DIMM_DR, NP, DIMM_SR, DIMM_SR + DIMM_DR, R0, 5, 2},
  {3, DDR1333, V1_5 + V1_35, DIMM_DR, NP, DIMM_SR + DIMM_DR, DIMM_DR, R1, 0, 2},
  {3, DDR1333, V1_5 + V1_35, DIMM_DR, NP, DIMM_DR, DIMM_DR, R0, 5, 2},
  {3, DDR1600, V1_5, NP, NP, DIMM_SR, DIMM_SR, R0, 0, 1},
  {3, DDR1600, V1_5, NP, NP, DIMM_DR, DIMM_DR, R0 + R1, 0, 1},
  {3, DDR800, V1_25, DIMM_SR, DIMM_SR, DIMM_DR, DIMM_SR + DIMM_DR, R0, 5, 2},
  {3, DDR800, V1_25, DIMM_SR, DIMM_SR, DIMM_DR, DIMM_DR, R1, 0, 2},
  {3, DDR800, V1_25, DIMM_SR, DIMM_DR, DIMM_SR + DIMM_DR, DIMM_SR + DIMM_DR, R0, 5, 2},
  {3, DDR800, V1_25, DIMM_SR, DIMM_DR, DIMM_SR + DIMM_DR, DIMM_DR, R1, 0, 2},
  {3, DDR800, V1_25, DIMM_DR, DIMM_SR, DIMM_SR + DIMM_DR, DIMM_SR + DIMM_DR, R0, 5, 2},
  {3, DDR800, V1_25, DIMM_DR, DIMM_SR + DIMM_DR, DIMM_SR + DIMM_DR, DIMM_DR, R1, 0, 2},
  {3, DDR800, V1_25, DIMM_DR, DIMM_DR, DIMM_SR, DIMM_SR + DIMM_DR, R0, 5, 2},
  {3, DDR800, V1_25, DIMM_DR, DIMM_DR, DIMM_DR, DIMM_DR, R0, 5, 2},
  {3, DDR1066, V1_5 + V1_35, NP, DIMM_QR, DIMM_SR, DIMM_SR, R0, 5, 1},
  {3, DDR1066, V1_5 + V1_35, NP, DIMM_QR, DIMM_SR + DIMM_DR, DIMM_QR, R0 + R2, 1, 1},
  {3, DDR1066, V1_5 + V1_35, NP, DIMM_QR, DIMM_SR + DIMM_DR, DIMM_QR, R1 + R3, 0, 1},
  {3, DDR1066, V1_5 + V1_35, NP, DIMM_QR, DIMM_DR, DIMM_DR, R0, 5, 1},
  {3, DDR1066, V1_5 + V1_35, NP, DIMM_QR, DIMM_DR, DIMM_DR, R1, 0, 1},
  {3, DDR1066, V1_5, DIMM_SR, DIMM_QR, DIMM_SR, DIMM_SR, R0, 5, 2},
  {3, DDR1066, V1_5, DIMM_SR, DIMM_QR, DIMM_SR, DIMM_QR, R0 + R2, 1, 2},
  {3, DDR1066, V1_5, DIMM_SR, DIMM_QR, DIMM_SR, DIMM_QR, R1 + R3, 0, 2},
  {3, DDR1066, V1_5, DIMM_DR, DIMM_QR, DIMM_DR, DIMM_DR, R0, 5, 2},
  {3, DDR1066, V1_5, DIMM_DR, DIMM_QR, DIMM_DR, DIMM_DR, R1, 0, 2},
  {3, DDR1066, V1_5, DIMM_DR, DIMM_QR, DIMM_DR, DIMM_QR, R0 + R2, 1, 2},
  {3, DDR1066, V1_5, DIMM_DR, DIMM_QR, DIMM_DR, DIMM_QR, R1 + R3, 0, 2},
  {3, DDR1066, V1_35, DIMM_SR, DIMM_SR, DIMM_DR, DIMM_SR + DIMM_DR, R0, 5, 2},
  {3, DDR1066, V1_35, DIMM_SR, DIMM_SR, DIMM_DR, DIMM_DR, R1, 0, 2},
  {3, DDR1066, V1_35, DIMM_SR, DIMM_DR, DIMM_SR + DIMM_DR, DIMM_SR + DIMM_DR, R0, 5, 2},
  {3, DDR1066, V1_35, DIMM_SR, DIMM_DR, DIMM_SR + DIMM_DR, DIMM_DR, R1, 0, 2},
  {3, DDR1066, V1_35, DIMM_DR, DIMM_SR, DIMM_SR + DIMM_DR, DIMM_SR + DIMM_DR, R0, 5, 2},
  {3, DDR1066, V1_35, DIMM_DR, DIMM_SR + DIMM_DR, DIMM_SR + DIMM_DR, DIMM_DR, R1, 0, 2},
  {3, DDR1066, V1_35, DIMM_DR, DIMM_DR, DIMM_SR, DIMM_SR + DIMM_DR, R0, 5, 2},
  {3, DDR1066, V1_35, DIMM_DR, DIMM_DR, DIMM_DR, DIMM_DR, R0, 5, 2},
  {3, DDR1333, V1_5, NP, DIMM_QR, NP, DIMM_QR, R0 + R2, 3, 2},
  {3, DDR1333, V1_5, NP, DIMM_QR, NP, DIMM_QR, R1 + R3, 0, 2},
  {3, DDR1333, V1_5, DIMM_SR, DIMM_SR, DIMM_DR, DIMM_SR + DIMM_DR, R0, 5, 2},
  {3, DDR1333, V1_5, DIMM_SR, DIMM_SR, DIMM_DR, DIMM_DR, R1, 0, 2},
  {3, DDR1333, V1_5, DIMM_SR, DIMM_DR, DIMM_SR + DIMM_DR, DIMM_SR + DIMM_DR, R0, 5, 2},
  {3, DDR1333, V1_5, DIMM_SR, DIMM_DR, DIMM_SR + DIMM_DR, DIMM_DR, R1, 0, 2},
  {3, DDR1333, V1_5, DIMM_DR, DIMM_SR, DIMM_SR + DIMM_DR, DIMM_SR + DIMM_DR, R0, 5, 2},
  {3, DDR1333, V1_5, DIMM_DR, DIMM_SR + DIMM_DR, DIMM_SR + DIMM_DR, DIMM_DR, R1, 0, 2},
  {3, DDR1333, V1_5, DIMM_DR, DIMM_DR, DIMM_SR, DIMM_SR + DIMM_DR, R0, 5, 2},
  {3, DDR1333, V1_5, DIMM_DR, DIMM_DR, DIMM_DR, DIMM_DR, R0, 5, 2},
  {3, DDR1600, V1_5, DIMM_SR, NP, DIMM_SR, DIMM_SR, R0, 4, 1},
  {3, DDR1600, V1_5, DIMM_SR, NP, DIMM_DR, DIMM_SR + DIMM_DR, R0, 4, 1},
  {3, DDR1600, V1_5, DIMM_SR, NP, DIMM_DR, DIMM_DR, R1, 0, 1},
  {3, DDR1600, V1_5, DIMM_DR, NP, DIMM_SR, DIMM_SR + DIMM_DR, R0, 4, 1},
  {3, DDR1600, V1_5, DIMM_DR, NP, DIMM_SR + DIMM_DR, DIMM_DR, R1, 0, 1},
  {3, DDR1600, V1_5, DIMM_DR, NP, DIMM_DR, DIMM_DR, R0, 4, 1},
};
CONST PSC_TBL_ENTRY DramTermTblEntRG34 = {
   {PSCFG_RTT, RDIMM_TYPE, NOD_DONT_CARE, {AMD_FAMILY_15_OR, AMD_F15_ALL}, OR_SOCKET_G34, DDR3_TECHNOLOGY},
   sizeof (DramTermOrG34RDIMM) / sizeof (PSCFG_RTT_ENTRY),
   (VOID *)&DramTermOrG34RDIMM
};

// Max Freq.
// Format :
// DimmPerCh,   Dimms,   SR,   DR,   QR,   Speed1_5V,   Speed1_35V,   Speed1_25V
//
STATIC CONST PSCFG_MAXFREQ_ENTRY ROMDATA MaxFreqOrG34RDIMM[] = {
  {{1, 1, 1, 0, 0, DDR1866_FREQUENCY, DDR1600_FREQUENCY, DDR1333_FREQUENCY}},
  {{1, 1, 0, 1, 0, DDR1866_FREQUENCY, DDR1600_FREQUENCY, DDR1333_FREQUENCY}},
  {{1, 1, 0, 0, 1, DDR1333_FREQUENCY, DDR1333_FREQUENCY, DDR1066_FREQUENCY}},
  {{2, 1, 1, 0, 0, DDR1600_FREQUENCY, DDR1333_FREQUENCY, DDR1333_FREQUENCY}},
  {{2, 1, 0, 1, 0, DDR1600_FREQUENCY, DDR1333_FREQUENCY, DDR1333_FREQUENCY}},
  {{2, 1, 0, 0, 1, DDR1333_FREQUENCY, DDR1066_FREQUENCY, DDR1066_FREQUENCY}},
  {{2, 2, 2, 0, 0, DDR1600_FREQUENCY, DDR1333_FREQUENCY, DDR1333_FREQUENCY}},
  {{2, 2, 1, 1, 0, DDR1600_FREQUENCY, DDR1333_FREQUENCY, DDR1066_FREQUENCY}},
  {{2, 2, 1, 0, 1, DDR1066_FREQUENCY, DDR800_FREQUENCY, DDR800_FREQUENCY}},
  {{2, 2, 0, 2, 0, DDR1600_FREQUENCY, DDR1333_FREQUENCY, DDR1066_FREQUENCY}},
  {{2, 2, 0, 1, 1, DDR1066_FREQUENCY, DDR800_FREQUENCY, DDR800_FREQUENCY}},
  {{2, 2, 0, 0, 2, DDR1066_FREQUENCY, DDR800_FREQUENCY, DDR800_FREQUENCY}},
  {{3, 1, 1, 0, 0, DDR1600_FREQUENCY, DDR1333_FREQUENCY, DDR1333_FREQUENCY}},
  {{3, 1, 0, 1, 0, DDR1600_FREQUENCY, DDR1333_FREQUENCY, DDR1333_FREQUENCY}},
  {{3, 1, 0, 0, 1, DDR1066_FREQUENCY, DDR1066_FREQUENCY, DDR800_FREQUENCY}},
  {{3, 2, 2, 0, 0, DDR1333_FREQUENCY, DDR1333_FREQUENCY, DDR1333_FREQUENCY}},
  {{3, 2, 1, 1, 0, DDR1333_FREQUENCY, DDR1333_FREQUENCY, DDR1066_FREQUENCY}},
  {{3, 2, 1, 0, 1, DDR800_FREQUENCY, DDR800_FREQUENCY, DDR800_FREQUENCY}},
  {{3, 2, 0, 2, 0, DDR1333_FREQUENCY, DDR1333_FREQUENCY, DDR1066_FREQUENCY}},
  {{3, 2, 0, 1, 1, DDR800_FREQUENCY, DDR800_FREQUENCY, DDR800_FREQUENCY}},
  {{3, 3, 3, 0, 0, DDR1066_FREQUENCY, DDR1066_FREQUENCY, DDR800_FREQUENCY}},
  {{3, 3, 2, 1, 0, DDR1066_FREQUENCY, DDR800_FREQUENCY, DDR667_FREQUENCY}},
  {{3, 3, 2, 0, 1, DDR800_FREQUENCY, DDR800_FREQUENCY, DDR667_FREQUENCY}},
  {{3, 3, 1, 2, 0, DDR1066_FREQUENCY, DDR800_FREQUENCY, DDR667_FREQUENCY}},
  {{3, 3, 1, 1, 1, DDR800_FREQUENCY, DDR800_FREQUENCY, DDR667_FREQUENCY}},
  {{3, 3, 0, 3, 0, DDR1066_FREQUENCY, DDR800_FREQUENCY, DDR667_FREQUENCY}},
  {{3, 3, 0, 2, 1, DDR800_FREQUENCY, DDR800_FREQUENCY, DDR667_FREQUENCY}},
};
CONST PSC_TBL_ENTRY MaxFreqTblEntRG34 = {
   {PSCFG_MAXFREQ, RDIMM_TYPE, NOD_DONT_CARE, {AMD_FAMILY_15_OR, AMD_F15_ALL}, OR_SOCKET_G34, DDR3_TECHNOLOGY},
   sizeof (MaxFreqOrG34RDIMM) / sizeof (PSCFG_MAXFREQ_ENTRY),
   (VOID *)&MaxFreqOrG34RDIMM
};

// RC2[IBT]
// Format :
// DimmPerCh,   DDRrate,   VDDIO,   Dimm0,   Dimm1,   Dimm2,   Dimm,   NumOfReg,   IBT
//
STATIC CONST PSCFG_MR2IBT_ENTRY OrRDdr3RC2IBT[] = {
  {1, DDR667 + DDR800, VOLT_ALL, DIMM_SR, NP, NP, DIMM_SR, 1, 1},
  {1, DDR667 + DDR800, VOLT_ALL, DIMM_DR, NP, NP, DIMM_DR, 1, 1},
  {1, DDR667 + DDR800, VOLT_ALL, DIMM_QR, NP, NP, DIMM_QR, 0xF, 1},
  {1, DDR1066 + DDR1333, VOLT_ALL, DIMM_SR, NP, NP, DIMM_SR, 1, 0},
  {1, DDR1066 + DDR1333, VOLT_ALL, DIMM_DR, NP, NP, DIMM_DR, 1, 0},
  {1, DDR1066, VOLT_ALL, DIMM_QR, NP, NP, DIMM_QR, 1, 0},
  {1, DDR1066, VOLT_ALL, DIMM_QR, NP, NP, DIMM_QR, 2, 1},
  {1, DDR1333, V1_5 + V1_35, DIMM_QR, NP, NP, DIMM_QR, 1, 0},
  {1, DDR1333, V1_5 + V1_35, DIMM_QR, NP, NP, DIMM_QR, 2, 1},
  {1, DDR1600, V1_5 + V1_35, DIMM_SR, NP, NP, DIMM_SR, 1, 0},
  {1, DDR1600, V1_5 + V1_35, DIMM_DR, NP, NP, DIMM_DR, 1, 0},
  {1, DDR1866, V1_5, DIMM_SR, NP, NP, DIMM_SR, 1, 0},
  {1, DDR1866, V1_5, DIMM_DR, NP, NP, DIMM_DR, 1, 0},
  {2, DDR667 + DDR800, VOLT_ALL, NP + DIMM_SR, DIMM_SR, NP, DIMM_SR, 1, 1},
  {2, DDR667 + DDR800, VOLT_ALL, NP + DIMM_DR, DIMM_DR, NP, DIMM_DR, 1, 1},
  {2, DDR667 + DDR800, VOLT_ALL, NP, DIMM_QR, NP, DIMM_QR, 0xF, 1},
  {2, DDR667 + DDR800 + DDR1066, VOLT_ALL, DIMM_SR, DIMM_DR, NP, DIMM_SR + DIMM_DR, 1, 1},
  {2, DDR667 + DDR800, VOLT_ALL, DIMM_SR, DIMM_QR, NP, DIMM_SR + DIMM_QR, 1, 1},
  {2, DDR667 + DDR800, VOLT_ALL, DIMM_SR + DIMM_DR, DIMM_QR, NP, DIMM_QR, 2, 8},
  {2, DDR667 + DDR800 + DDR1066, VOLT_ALL, DIMM_DR, DIMM_SR, NP, DIMM_SR + DIMM_DR, 1, 1},
  {2, DDR667 + DDR800, VOLT_ALL, DIMM_DR, DIMM_QR, NP, DIMM_DR + DIMM_QR, 1, 1},
  {2, DDR667 + DDR800, VOLT_ALL, DIMM_QR, DIMM_SR, NP, DIMM_SR + DIMM_QR, 1, 1},
  {2, DDR667 + DDR800, VOLT_ALL, DIMM_QR, DIMM_SR + DIMM_DR + DIMM_QR, NP, DIMM_QR, 2, 8},
  {2, DDR667 + DDR800, VOLT_ALL, DIMM_QR, DIMM_DR, NP, DIMM_DR + DIMM_QR, 1, 1},
  {2, DDR667 + DDR800, VOLT_ALL, DIMM_QR, DIMM_QR, NP, DIMM_QR, 1, 1},
  {2, DDR1066 + DDR1333, VOLT_ALL, NP, DIMM_SR, NP, DIMM_SR, 1, 0},
  {2, DDR1066 + DDR1333, VOLT_ALL, NP, DIMM_DR, NP, DIMM_DR, 1, 0},
  {2, DDR1066, VOLT_ALL, NP, DIMM_QR, NP, DIMM_QR, 1, 0},
  {2, DDR1066, VOLT_ALL, NP, DIMM_QR, NP, DIMM_QR, 2, 1},
  {2, DDR1066 + DDR1333, VOLT_ALL, DIMM_SR, DIMM_SR, NP, DIMM_SR, 1, 1},
  {2, DDR1066, V1_5, DIMM_SR, DIMM_QR, NP, DIMM_SR + DIMM_QR, 1, 1},
  {2, DDR1066, V1_5, DIMM_SR + DIMM_DR, DIMM_QR, NP, DIMM_QR, 2, 8},
  {2, DDR1066, VOLT_ALL, DIMM_DR, DIMM_DR, NP, DIMM_DR, 1, 1},
  {2, DDR1066, V1_5, DIMM_DR, DIMM_QR, NP, DIMM_DR + DIMM_QR, 1, 1},
  {2, DDR1066, V1_5, DIMM_QR, DIMM_SR, NP, DIMM_SR + DIMM_QR, 1, 1},
  {2, DDR1066, V1_5, DIMM_QR, DIMM_SR + DIMM_DR + DIMM_QR, NP, DIMM_QR, 2, 8},
  {2, DDR1066, V1_5, DIMM_QR, DIMM_DR, NP, DIMM_DR + DIMM_QR, 1, 1},
  {2, DDR1066, V1_5, DIMM_QR, DIMM_QR, NP, DIMM_QR, 1, 1},
  {2, DDR1333, V1_5, NP, DIMM_QR, NP, DIMM_QR, 1, 0},
  {2, DDR1333, V1_5, NP, DIMM_QR, NP, DIMM_QR, 2, 1},
  {2, DDR1333, V1_5 + V1_35, DIMM_SR, DIMM_DR, NP, DIMM_SR + DIMM_DR, 1, 1},
  {2, DDR1333, V1_5 + V1_35, DIMM_DR, DIMM_SR, NP, DIMM_SR + DIMM_DR, 1, 1},
  {2, DDR1333, V1_5 + V1_35, DIMM_DR, DIMM_DR, NP, DIMM_DR, 1, 1},
  {2, DDR1600, V1_5, NP, DIMM_SR, NP, DIMM_SR, 1, 0},
  {2, DDR1600, V1_5, NP, DIMM_DR, NP, DIMM_DR, 1, 0},
  {2, DDR1600, V1_5, DIMM_SR, DIMM_SR, NP, DIMM_SR, 1, 1},
  {2, DDR1600, V1_5, DIMM_SR, DIMM_DR, NP, DIMM_SR + DIMM_DR, 1, 1},
  {2, DDR1600, V1_5, DIMM_DR, DIMM_SR, NP, DIMM_SR + DIMM_DR, 1, 1},
  {2, DDR1600, V1_5, DIMM_DR, DIMM_DR, NP, DIMM_DR, 1, 1},
  {2, DDR1066, V1_35, DIMM_SR, DIMM_QR, NP, DIMM_SR + DIMM_QR, 1, 1},
  {2, DDR1066, V1_35, DIMM_SR + DIMM_DR, DIMM_QR, NP, DIMM_QR, 2, 8},
  {2, DDR1066, V1_35, DIMM_DR, DIMM_QR, NP, DIMM_DR + DIMM_QR, 1, 1},
  {2, DDR1066, V1_35, DIMM_QR, DIMM_SR, NP, DIMM_SR + DIMM_QR, 1, 1},
  {2, DDR1066, V1_35, DIMM_QR, DIMM_SR + DIMM_DR + DIMM_QR, NP, DIMM_QR, 2, 8},
  {2, DDR1066, V1_35, DIMM_QR, DIMM_DR, NP, DIMM_DR + DIMM_QR, 1, 1},
  {2, DDR1066, V1_35 + V1_25, DIMM_QR, DIMM_QR, NP, DIMM_QR, 1, 1},
  {2, DDR1066, V1_25, DIMM_QR, DIMM_QR, NP, DIMM_QR, 2, 8},
  {2, DDR1333, V1_5, DIMM_SR, DIMM_QR, NP, DIMM_SR + DIMM_QR, 1, 1},
  {2, DDR1333, V1_5, DIMM_SR + DIMM_DR, DIMM_QR, NP, DIMM_QR, 2, 8},
  {2, DDR1333, V1_5, DIMM_DR, DIMM_QR, NP, DIMM_DR + DIMM_QR, 1, 1},
  {2, DDR1333, V1_5, DIMM_QR, DIMM_SR, NP, DIMM_SR + DIMM_QR, 1, 1},
  {2, DDR1333, V1_5, DIMM_QR, DIMM_SR + DIMM_DR + DIMM_QR, NP, DIMM_QR, 2, 8},
  {2, DDR1333, V1_5, DIMM_QR, DIMM_DR, NP, DIMM_DR + DIMM_QR, 1, 1},
  {2, DDR1333, V1_5, DIMM_QR, DIMM_QR, NP, DIMM_QR, 1, 1},
  {2, DDR1333, V1_35, NP, DIMM_QR, NP, DIMM_QR, 1, 0},
  {2, DDR1333, V1_35, NP, DIMM_QR, NP, DIMM_QR, 2, 1},
  {3, DDR667 + DDR800, VOLT_ALL, NP, NP, DIMM_SR, DIMM_SR, 1, 1},
  {3, DDR667, VOLT_ALL, NP, NP, DIMM_DR, DIMM_DR, 1, 1},
  {3, DDR667 + DDR800, VOLT_ALL, NP, DIMM_QR, NP, DIMM_QR, 0xF, 1},
  {3, DDR667, VOLT_ALL, NP + DIMM_SR, DIMM_QR, DIMM_SR, DIMM_SR + DIMM_QR, 1, 1},
  {3, DDR667, VOLT_ALL, NP + DIMM_SR + DIMM_DR, DIMM_QR, DIMM_SR + DIMM_DR, DIMM_QR, 2, 8},
  {3, DDR667, VOLT_ALL, NP + DIMM_DR, DIMM_QR, DIMM_DR, DIMM_DR + DIMM_QR, 1, 1},
  {3, DDR667 + DDR800, VOLT_ALL, DIMM_SR, NP + DIMM_SR, DIMM_SR, DIMM_SR, 1, 1},
  {3, DDR667, VOLT_ALL, DIMM_SR, NP + DIMM_SR, DIMM_DR, DIMM_SR + DIMM_DR, 1, 1},
  {3, DDR667, VOLT_ALL, DIMM_SR, DIMM_DR, DIMM_SR + DIMM_DR, DIMM_SR + DIMM_DR, 1, 1},
  {3, DDR667, VOLT_ALL, DIMM_SR, DIMM_QR, DIMM_DR, DIMM_SR + DIMM_DR + DIMM_QR, 1, 1},
  {3, DDR667, VOLT_ALL, DIMM_DR, NP + DIMM_DR, DIMM_SR, DIMM_SR + DIMM_DR, 1, 1},
  {3, DDR667, VOLT_ALL, DIMM_DR, NP + DIMM_DR, DIMM_DR, DIMM_DR, 1, 1},
  {3, DDR667, VOLT_ALL, DIMM_DR, DIMM_SR, DIMM_SR + DIMM_DR, DIMM_SR + DIMM_DR, 1, 1},
  {3, DDR667, VOLT_ALL, DIMM_DR, DIMM_QR, DIMM_SR, DIMM_SR + DIMM_DR + DIMM_QR, 1, 1},
  {3, DDR800, V1_5 + V1_35, NP, NP, DIMM_DR, DIMM_DR, 1, 1},
  {3, DDR800, V1_5 + V1_35, NP + DIMM_SR, DIMM_QR, DIMM_SR, DIMM_SR + DIMM_QR, 1, 1},
  {3, DDR800, V1_5 + V1_35, NP + DIMM_SR + DIMM_DR, DIMM_QR, DIMM_SR + DIMM_DR, DIMM_QR, 2, 8},
  {3, DDR800, V1_5 + V1_35, NP + DIMM_DR, DIMM_QR, DIMM_DR, DIMM_DR + DIMM_QR, 1, 1},
  {3, DDR800, V1_5 + V1_35, DIMM_SR, NP + DIMM_SR, DIMM_DR, DIMM_SR + DIMM_DR, 1, 1},
  {3, DDR800, V1_5 + V1_35, DIMM_SR, DIMM_DR, DIMM_SR + DIMM_DR, DIMM_SR + DIMM_DR, 1, 1},
  {3, DDR800, V1_5 + V1_35, DIMM_SR, DIMM_QR, DIMM_DR, DIMM_SR + DIMM_DR + DIMM_QR, 1, 1},
  {3, DDR800, V1_5 + V1_35, DIMM_DR, NP + DIMM_DR, DIMM_SR, DIMM_SR + DIMM_DR, 1, 1},
  {3, DDR800, V1_5 + V1_35, DIMM_DR, NP + DIMM_DR, DIMM_DR, DIMM_DR, 1, 1},
  {3, DDR800, V1_5 + V1_35, DIMM_DR, DIMM_SR, DIMM_SR + DIMM_DR, DIMM_SR + DIMM_DR, 1, 1},
  {3, DDR800, V1_5 + V1_35, DIMM_DR, DIMM_QR, DIMM_SR, DIMM_SR + DIMM_DR + DIMM_QR, 1, 1},
  {3, DDR800, V1_25, NP + DIMM_DR, NP, DIMM_DR, DIMM_DR, 1, 1},
  {3, DDR800, V1_25, NP, DIMM_QR, DIMM_SR, DIMM_SR + DIMM_QR, 1, 1},
  {3, DDR800, V1_25, NP, DIMM_QR, DIMM_SR + DIMM_DR, DIMM_QR, 2, 8},
  {3, DDR800, V1_25, NP, DIMM_QR, DIMM_DR, DIMM_DR + DIMM_QR, 1, 1},
  {3, DDR800, V1_25, DIMM_SR, NP, DIMM_DR, DIMM_SR + DIMM_DR, 1, 1},
  {3, DDR800, V1_25, DIMM_DR, NP, DIMM_SR, DIMM_SR + DIMM_DR, 1, 1},
  {3, DDR1066 + DDR1333, VOLT_ALL, NP, NP, DIMM_SR, DIMM_SR, 1, 0},
  {3, DDR1066 + DDR1333, VOLT_ALL, NP, NP, DIMM_DR, DIMM_DR, 1, 0},
  {3, DDR1066, V1_5 + V1_35, NP, DIMM_QR, NP, DIMM_QR, 1, 0},
  {3, DDR1066, V1_5 + V1_35, NP, DIMM_QR, NP, DIMM_QR, 2, 1},
  {3, DDR1066, V1_5 + V1_35, DIMM_SR, NP + DIMM_SR, DIMM_SR, DIMM_SR, 1, 1},
  {3, DDR1066, V1_5, DIMM_SR, NP + DIMM_SR, DIMM_DR, DIMM_SR + DIMM_DR, 1, 1},
  {3, DDR1066, V1_5, DIMM_SR, DIMM_DR, DIMM_SR + DIMM_DR, DIMM_SR + DIMM_DR, 1, 1},
  {3, DDR1066, V1_5, DIMM_DR, NP + DIMM_DR, DIMM_SR, DIMM_SR + DIMM_DR, 1, 1},
  {3, DDR1066, V1_5, DIMM_DR, NP + DIMM_DR, DIMM_DR, DIMM_DR, 1, 1},
  {3, DDR1066, V1_5, DIMM_DR, DIMM_SR, DIMM_SR + DIMM_DR, DIMM_SR + DIMM_DR, 1, 1},
  {3, DDR1066, V1_35 + V1_25, DIMM_SR, NP, DIMM_DR, DIMM_SR + DIMM_DR, 1, 1},
  {3, DDR1066, V1_35 + V1_25, DIMM_DR, NP, DIMM_SR, DIMM_SR + DIMM_DR, 1, 1},
  {3, DDR1066, V1_35 + V1_25, DIMM_DR, NP, DIMM_DR, DIMM_DR, 1, 1},
  {3, DDR1066, V1_25, DIMM_SR, NP, DIMM_SR, DIMM_SR, 1, 1},
  {3, DDR1333, VOLT_ALL, DIMM_SR, NP, DIMM_SR, DIMM_SR, 1, 1},
  {3, DDR1333, V1_5 + V1_35, DIMM_SR, NP, DIMM_DR, DIMM_SR + DIMM_DR, 1, 1},
  {3, DDR1333, V1_5 + V1_35, DIMM_DR, NP, DIMM_SR, DIMM_SR + DIMM_DR, 1, 1},
  {3, DDR1333, V1_5 + V1_35, DIMM_DR, NP, DIMM_DR, DIMM_DR, 1, 1},
  {3, DDR1600, V1_5, NP, NP, DIMM_SR, DIMM_SR, 1, 0},
  {3, DDR1600, V1_5, NP, NP, DIMM_DR, DIMM_DR, 1, 0},
  {3, DDR800, V1_25, DIMM_SR, DIMM_SR, DIMM_DR, DIMM_SR + DIMM_DR, 1, 1},
  {3, DDR800, V1_25, DIMM_SR, DIMM_DR, DIMM_SR + DIMM_DR, DIMM_SR + DIMM_DR, 1, 1},
  {3, DDR800, V1_25, DIMM_DR, DIMM_SR, DIMM_SR + DIMM_DR, DIMM_SR + DIMM_DR, 1, 1},
  {3, DDR800, V1_25, DIMM_DR, DIMM_DR, DIMM_SR, DIMM_SR + DIMM_DR, 1, 1},
  {3, DDR800, V1_25, DIMM_DR, DIMM_DR, DIMM_DR, DIMM_DR, 1, 1},
  {3, DDR1066, V1_5, NP + DIMM_SR, DIMM_QR, DIMM_SR, DIMM_SR + DIMM_QR, 1, 1},
  {3, DDR1066, V1_5 + V1_35, NP, DIMM_QR, DIMM_SR + DIMM_DR, DIMM_QR, 2, 8},
  {3, DDR1066, V1_5, NP + DIMM_DR, DIMM_QR, DIMM_DR, DIMM_DR + DIMM_QR, 1, 1},
  {3, DDR1066, V1_5, DIMM_SR, DIMM_QR, DIMM_SR, DIMM_QR, 2, 8},
  {3, DDR1066, V1_5, DIMM_DR, DIMM_QR, DIMM_DR, DIMM_QR, 2, 8},
  {3, DDR1066, V1_35, NP, DIMM_QR, DIMM_SR, DIMM_SR + DIMM_QR, 1, 1},
  {3, DDR1066, V1_35, NP, DIMM_QR, DIMM_DR, DIMM_DR + DIMM_QR, 1, 1},
  {3, DDR1066, V1_35, DIMM_SR, DIMM_SR, DIMM_DR, DIMM_SR + DIMM_DR, 1, 1},
  {3, DDR1066, V1_35, DIMM_SR, DIMM_DR, DIMM_SR + DIMM_DR, DIMM_SR + DIMM_DR, 1, 1},
  {3, DDR1066, V1_35, DIMM_DR, DIMM_SR, DIMM_SR + DIMM_DR, DIMM_SR + DIMM_DR, 1, 1},
  {3, DDR1066, V1_35, DIMM_DR, DIMM_DR, DIMM_SR, DIMM_SR + DIMM_DR, 1, 1},
  {3, DDR1066, V1_35, DIMM_DR, DIMM_DR, DIMM_DR, DIMM_DR, 1, 1},
  {3, DDR1333, V1_5, NP, DIMM_QR, NP, DIMM_QR, 1, 0},
  {3, DDR1333, V1_5, NP, DIMM_QR, NP, DIMM_QR, 2, 1},
  {3, DDR1333, V1_5, DIMM_SR, DIMM_SR, DIMM_DR, DIMM_SR + DIMM_DR, 1, 1},
  {3, DDR1333, V1_5, DIMM_SR, DIMM_DR, DIMM_SR + DIMM_DR, DIMM_SR + DIMM_DR, 1, 1},
  {3, DDR1333, V1_5, DIMM_DR, DIMM_SR, DIMM_SR + DIMM_DR, DIMM_SR + DIMM_DR, 1, 1},
  {3, DDR1333, V1_5, DIMM_DR, DIMM_DR, DIMM_SR, DIMM_SR + DIMM_DR, 1, 1},
  {3, DDR1333, V1_5, DIMM_DR, DIMM_DR, DIMM_DR, DIMM_DR, 1, 1},
  {3, DDR1600, V1_5, DIMM_SR, NP, DIMM_SR, DIMM_SR, 1, 1},
  {3, DDR1600, V1_5, DIMM_SR, NP, DIMM_DR, DIMM_SR + DIMM_DR, 1, 1},
  {3, DDR1600, V1_5, DIMM_DR, NP, DIMM_SR, DIMM_SR + DIMM_DR, 1, 1},
  {3, DDR1600, V1_5, DIMM_DR, NP, DIMM_DR, DIMM_DR, 1, 1},
};
CONST PSC_TBL_ENTRY RC2IBTTblEntRG34 = {
   {PSCFG_RC2IBT, RDIMM_TYPE, NOD_DONT_CARE, {AMD_FAMILY_15_OR, AMD_F15_ALL}, OR_SOCKET_G34, DDR3_TECHNOLOGY},
   sizeof (OrRDdr3RC2IBT) / sizeof (PSCFG_MR2IBT_ENTRY),
   (VOID *)&OrRDdr3RC2IBT
};

// RC10[OperatingSpeed]
// Format :
// DDRrate,   Operating Speed
//
STATIC CONST PSCFG_OPSPD_ENTRY OrRDdr3OpSPD[] = {
  {DDR667 + DDR800, 0},
  {DDR1066, 1},
  {DDR1333, 2},
  {DDR1600, 3},
  {DDR1866, 4}
};
CONST PSC_TBL_ENTRY RC10OpSpdTblEntRG34 = {
   {PSCFG_RC10OPSPD, RDIMM_TYPE, NOD_DONT_CARE, {AMD_FAMILY_15_OR, AMD_F15_ALL}, OR_SOCKET_G34, DDR3_TECHNOLOGY},
   sizeof (OrRDdr3OpSPD) / sizeof (PSCFG_OPSPD_ENTRY),
   (VOID *)&OrRDdr3OpSPD
};

//
// MemClkDis
//
STATIC CONST UINT8 ROMDATA Or3RDdr3CLKDis[] = {0x03, 0x0C, 0x00, 0x30, 0x00, 0x00, 0x00, 0x00};
CONST PSC_TBL_ENTRY ClkDisMapEntRG34 = {
   {PSCFG_CLKDIS, RDIMM_TYPE, _1DIMM + _2DIMM + _3DIMM, {AMD_FAMILY_15_OR, AMD_F15_ALL}, OR_SOCKET_G34, DDR3_TECHNOLOGY},
   sizeof (Or3RDdr3CLKDis) / sizeof (UINT8),
   (VOID *)&Or3RDdr3CLKDis
};

//
// WL pass1 seed
//
// Format :
// DimmPerCh in bit map,   Channel #,   Seed value
STATIC CONST PSCFG_SEED_ENTRY ROMDATA WLPas1SeedOrG34RDIMM[] = {
  {_1DIMM + _2DIMM + _3DIMM, CH_ALL, 0x41}
};
CONST PSC_TBL_ENTRY WLPass1SeedEntRG34 = {
   {PSCFG_WL_PASS1_SEED, RDIMM_TYPE, NOD_DONT_CARE, {AMD_FAMILY_15_OR, AMD_F15_ALL}, OR_SOCKET_G34, DDR3_TECHNOLOGY},
   sizeof (WLPas1SeedOrG34RDIMM) / sizeof (PSCFG_SEED_ENTRY),
   (VOID *)&WLPas1SeedOrG34RDIMM
};

//
// HW RxEn pass1 seed
//
// Format :
// DimmPerCh in bit map,   Channel #,   Seed value
STATIC CONST PSCFG_SEED_ENTRY ROMDATA HWRxEnPas1SeedOrG34RDIMM[] = {
  {_1DIMM, CH_A, 0x43},
  {_1DIMM, CH_B, 0x3F},
  {_1DIMM, CH_C, 0x3A},
  {_1DIMM, CH_D, 0x35},
  {_2DIMM, CH_A, 0x54},
  {_2DIMM, CH_B, 0x4D},
  {_2DIMM, CH_C, 0x45},
  {_2DIMM, CH_D, 0x40},
  {_3DIMM, CH_A, 0x6B},
  {_3DIMM, CH_B, 0x5E},
  {_3DIMM, CH_C, 0x4B},
  {_3DIMM, CH_D, 0x3D}
};
CONST PSC_TBL_ENTRY HWRxEnPass1SeedEntRG34 = {
   {PSCFG_HWRXEN_PASS1_SEED, RDIMM_TYPE, NOD_DONT_CARE, {AMD_FAMILY_15_OR, AMD_F15_ALL}, OR_SOCKET_G34, DDR3_TECHNOLOGY},
   sizeof (HWRxEnPas1SeedOrG34RDIMM) / sizeof (PSCFG_SEED_ENTRY),
   (VOID *)&HWRxEnPas1SeedOrG34RDIMM
};
