/****************************************************************************/
/*	 MODULE:					 string.cc									*/
/*	 ROLE: fonctions complementaires de traitement de chaines de caracteres */
/****************************************************************************/

#include "fctsys.h"
#ifdef TO_DOS
#include <dos.h>
#endif


	/*********************************************************************/
	/* int ReadDelimitedText(char * dest, char * source, int NbMaxChar ) */
	/*********************************************************************/

/* lit et place dans dest la chaine de caractere trouvee dans source,
	delimitee par " .
	transfere NbMaxChar max 
	retourne le nombre de codes lus dans source
	dest est termine par NULL
*/
int ReadDelimitedText(char * dest, char * source, int NbMaxChar )
{
int ii, jj, flag = 0;

	 for ( ii = 0, jj = 0; ii < NbMaxChar - 1 ; jj++, source++)
		{
		if ( * source == 0 ) break; /* fin de ligne */
		if ( * source == '"' )			/* delimiteur trouve */
			{
			if ( flag ) break;			/* Fin de texte delimite */
			flag = 1;					/* Marque 1er delimiteur trouve */
			}
		else if ( flag )
			{
			* dest = * source; dest++; ii++;
			}
		}
	*dest = 0;  /* Null terminaison */
	return (jj);
}
	/********************************/
	/* char * StrPurge(char * text) */
	/********************************/

/* Supprime les caracteres Space en debut de la ligne text
	retourne un pointeur sur le 1er caractere non Space de text
*/
char * StrPurge(char * text)
{
char * ptspace;
	while( (*text <= ' ') && *text ) text++;
	ptspace = text + strlen(text) -1;
	while( (*ptspace <= ' ') && *ptspace && (ptspace >= text) )
		{
		*ptspace = 0; ptspace--;
		}
	return(text);
}

	/*******************************************************/
	/* char *GetLine(FILE *File, char *Line, int *LineNum) */
	/*******************************************************/

/* Routine de lecture de 1 ligne utile
	retourne la 1ere ligne utile lue.
	elimine lignes vides et commentaires
	incremente *LineNum a chaque ligne lue
*/
char * GetLine(FILE *File, char *Line, int *LineNum, int MaxLen)
{
	do  {
		if (fgets(Line, MaxLen - 1, File) == NULL) return NULL;
		if ( LineNum ) *LineNum += 1;
		} while (Line[0] == '#' || Line[0] == '\n' ||  Line[0] == '\r' ||
				 Line[0] == 0);

	return Line;
}

	/***********************************/
	/* char * DateAndTime(char * Line) */
	/***********************************/

/* Retourne la chaine de caractere donnant date+heure */
char * DateAndTime(char * Line)
{
#ifdef TO_DOS
struct date Date;
struct time heure;

	getdate(&Date);
	gettime(&heure);
	sprintf(Line,"%d/%d/%d-%d:%d:%d", Date.da_day, Date.da_mon, Date.da_year,
			heure.ti_hour, heure.ti_min, heure.ti_sec );
#else
	*Line = 0;
#endif
	return(Line);
}


	/******************************************/
	/* int StrNumCmp(char **str1,char **str2) */
	/******************************************/

/*
routine (compatible qsort() ) de comparaison pour classement alphabtique
Analogue a strcmp() mais les nombres sont compars selon leur valeur numrique
et non pas par leur code ascii
*/

int StrNumCmp(char *str1,char *str2)
{
int nb1 = 0 , nb2 = 0;

	if( (str1 == NULL) || (str2 == NULL) ) return(0);

	for( ; ; )
		{
		if (isdigit(*str1) && isdigit(*str2) ) /* nombres en jeu */
			{
			nb1 = 0 ; nb2 = 0 ;
			while (isdigit(*str1)) nb1 = nb1*10 + *str1++ -'0' ;
			while (isdigit(*str2)) nb2 = nb2*10 + *str2++ -'0' ;
			if ( nb1 < nb2 ) return(-1) ;
			if ( nb1 > nb2 ) return(1) ;
			}

		if( *str1 < *str2 ) return(-1) ;
		if( *str1 > *str2 ) return(1) ;
		if( (*str1 == 0 ) && ( *str2 == 0 ) ) break;
		str1++ ; str2++ ;
		}

	return(0);
}

	/********************************************************/
	/* int StrLenNumCmp(char **str1,char **str2, int NbMax) */
	/********************************************************/

/*
routine (compatible qsort() ) de comparaison pour classement alphabtique
Analogue a strncmp() mais les nombres sont compars selon leur valeur numrique
et non pas par leur code ascii
*/

int StrLenNumCmp(char *str1,char *str2, int NbMax)
{
register i;
int nb1 = 0 , nb2 = 0;

	if( (str1 == NULL) || (str2 == NULL) ) return(0);

	for ( i = 0 ; i < NbMax ; i++ )
		{
		if (isdigit(*str1) && isdigit(*str2) ) /* nombres en jeu */
			{
			nb1 = 0 ; nb2 = 0 ;
			while (isdigit(*str1)) nb1 = nb1*10 + *str1++ -'0' ;
			while (isdigit(*str2)) nb2 = nb2*10 + *str2++ -'0' ;
			if ( nb1 < nb2 ) return(-1) ;
			if ( nb1 > nb2 ) return(1) ;
			}

		if( *str1 < *str2 ) return(-1) ;
		if( *str1 > *str2 ) return(1) ;
		if( (*str1 == 0 ) && ( *str2 == 0 ) ) return(0) ;
		str1++ ; str2++ ;
		}

	return(0);
}

	/*******************************************/
	/* int StrNumICmp(char **str1,char **str2) */
	/*******************************************/

/*
routine (compatible qsort() ) de comparaison pour classement alphabtique,
avec lower case == upper case.
Analogue a stricmp() mais les nombres sont compars selon leur valeur numrique
et non pas par leur code ascii
*/

int StrNumICmp(char *str1,char *str2)
{
register i;
int nb1 = 0 , nb2 = 0;

	if( (str1 == NULL) || (str2 == NULL) ) return(0);
	for ( i = 0 ; i < 8 ; i++ )
		{
		if (isdigit(*str1) && isdigit(*str2) ) /* nombres en jeu */
			{
			nb1 = 0 ; nb2 = 0 ;
			while (isdigit(*str1)) nb1 = nb1*10 + *str1++ -'0' ;
			while (isdigit(*str2)) nb2 = nb2*10 + *str2++ -'0' ;
			if ( nb1 < nb2 ) return(-1) ;
			if ( nb1 > nb2 ) return(1) ;
			}

		if( toupper(*str1) < toupper(*str2) ) return(-1) ;
		if( toupper(*str1) > toupper(*str2) ) return(1) ;
		if( (*str1 == 0 ) && ( *str2 == 0 ) ) return(0) ;
		str1++ ; str2++ ;
		}

	return(0);
}


	/*********************************************************/
	/* int StrLenNumICmp(char **str1,char **str2, int NbMax) */
	/*********************************************************/

/*
routine (compatible qsort() ) de comparaison pour classement alphabtique,
avec lower case == upper case.
Analogue a stricmp() mais les nombres sont compars selon leur valeur numrique
et non pas par leur code ascii
*/

int StrLenNumICmp(char *str1,char *str2, int NbMax)
{
register i;
int nb1 = 0 , nb2 = 0;

	if( (str1 == NULL) || (str2 == NULL) ) return(0);

	for ( i = 0 ; i < NbMax ; i++ )
		{
		if (isdigit(*str1) && isdigit(*str2) ) /* nombres en jeu */
			{
			nb1 = 0 ; nb2 = 0 ;
			while (isdigit(*str1)) nb1 = nb1*10 + *str1++ -'0' ;
			while (isdigit(*str2)) nb2 = nb2*10 + *str2++ -'0' ;
			if ( nb1 < nb2 ) return(-1) ;
			if ( nb1 > nb2 ) return(1) ;
			}

		if( toupper(*str1) < toupper(*str2) ) return(-1) ;
		if( toupper(*str1) > toupper(*str2) ) return(1) ;
		if( (*str1 == 0 ) && ( *str2 == 0 ) ) return(0) ;
		str1++ ; str2++ ;
		}

	return(0);
}


		/**************************************************/
		/* int match( char  *tst , char  *ref , int len ) */
		/**************************************************/

/* compare 2 noms de composants, selon regles usuelles
	( Jokers * , ? , autoriss).
	la chaine de rfrence est "ref"
	retourne 0 si match
	retourne 1 si differences
*/

int match( char  *tst , char  *ref , int nb )
{
	for ( ; nb > 0 ; nb-- )
		{
		if ( *ref == '*' ) return(0) ;
		if ( *ref == '?' )
			{
			ref++ ; tst++ ; continue ;
			}
		if ( *ref != *tst ) return(1) ;
		if (( *ref == 0) || (*tst == 0 ))
			{
			if (*ref == *tst) return(0) ;
			else return(1) ;
			}
		ref++ ; tst++ ;
		}
	return (0) ;
}

	/********************************/
	/* char * strupper(char * Text) */
	/********************************/

/* Change les caracteres 'a' ... 'z' en 'A' ... 'Z'. dans la chaine Text.
Retourne Text
*/
char * strupper(char * Text)
{
char * code = Text;

	if( Text )
		{
		while( * code)
			{
			if( (*code >= 'a') && (*code <= 'z') ) *code += 'A' - 'a';
			code ++;
			}
		}

	return(Text);
}

	/***********************************************/
	/* void ChangeSpaces(char * Text, int NewChar) */
	/***********************************************/

/* Change dans un texte les espaces en NewChar */
void ChangeSpaces(char * Text, int NewChar)
{
	while( *Text )
		{
		if( *Text == ' ') *Text = (char) NewChar;
		Text++;
		}
}

