	/************************/
	/*	EECad - eesavlib.cc	*/
	/************************/

/* Routines de sauvegarde et maintenance de librairies et composants
*/

#include "fctsys.h"

#include "menu.h"
#include "program.h"
#include "eelibsl.h"
#include "general.h"

#include "liste.fct"


/* Routines locales */

/* Variables locales */


/**************************************************************************/
/* LibraryEntryStruct * CopyLibEntryStruct (LibraryEntryStruct * OldEntry */
/**************************************************************************/

/* Routine de copie d'une partlib
	Parametres d'entree: pointeur sur la structure de depart
	Parametres de sortie: pointeur sur la structure creee
*/

LibraryEntryStruct * CopyLibEntryStruct (LibraryEntryStruct * OldEntry)
{
int size;
LibraryEntryStruct * NewStruct;
LibraryDrawEntryStruct * NewDrawings, * OldDrawings;
LibraryDrawEntryStruct ** PtChain;

	if( OldEntry->Type != ROOT )
		{
		DisplayError("CopyLibEntryStruct(): Type non ROOT");
		return(NULL);
		}

	size = sizeof(LibraryEntryStruct);
	NewStruct = (LibraryEntryStruct *) MyMalloc( size);
	memcpy(NewStruct, OldEntry, size);

	/* Copie des sous stuctures: */
	if(OldEntry->AliasList) NewStruct->AliasList = strdup(OldEntry->AliasList);

	/* Copie des elements type Drawing */
	OldDrawings = OldEntry->Drawings;
	PtChain =  &(NewStruct->Drawings);
	while(OldDrawings)
		{
		size = sizeof(LibraryDrawEntryStruct);
		NewDrawings = (LibraryDrawEntryStruct *) MyMalloc(size);
		memcpy(NewDrawings, OldDrawings, size);
		* PtChain = NewDrawings;
		PtChain = &(NewDrawings->Pnext);

		switch(OldDrawings->DrawType)
			{
			case ARC_DRAW_TYPE:
			case CIRCLE_DRAW_TYPE:
			case SQUARE_DRAW_TYPE:
				break;

			case PIN_DRAW_TYPE:
				if( OldDrawings->U.Pin.Name )
					NewDrawings->U.Pin.Name = strdup(OldDrawings->U.Pin.Name);
				break;

			case TEXT_DRAW_TYPE:
				if( OldDrawings->U.Text.Text) 
					NewDrawings->U.Text.Text = strdup(OldDrawings->U.Text.Text);
				break;

			case POLYLINE_DRAW_TYPE:
				size = sizeof(int) * 2 * OldDrawings->U.Poly.n;
				if( size )
					{
					NewDrawings->U.Poly.PolyList = (int*)MyMalloc(size);
					memcpy(NewDrawings->U.Poly.PolyList,
						OldDrawings->U.Poly.PolyList, size);
					}
				break;

			default:
				DisplayError(" CopyLibEntryStruct: unknown Draw Type");
				break;
			}
		OldDrawings = OldDrawings->Pnext;
		}

	return(NewStruct);
}


/**************************************************************************/
/* int WriteOneLibEntry(FILE * ExportFile, LibraryEntryStruct * LibEntry) */
/**************************************************************************/

/* Routine d'ecriture du composant pointe par LibEntry
	dans le fichier ExportFile( qui doit etre deja ouvert)
	return: FALSE si Ok
			TRUE si err write
*/
int WriteOneLibEntry(FILE * ExportFile, LibraryEntryStruct * LibEntry)
{
LibraryDrawEntryStruct *DrawEntry;
void * DrawItem;
int * ptpoly;
int ii, t1, t2, Etype;
char PinNum[5];
char FlagXpin = 0;

	if( LibEntry->Type != ROOT ) return(FALSE);

	/* Creation du commentaire donnant le nom du composant */
	fprintf(ExportFile,"# %s\n#\n", LibEntry->Name);

	/* Generation des lignes utiles */
	fprintf(ExportFile,"DEF");
	if(LibEntry->DrawName) fprintf(ExportFile," %s",LibEntry->Name);
	else fprintf(ExportFile," ~%s",LibEntry->Name);

	if(LibEntry->Prefix[0] > ' ') fprintf(ExportFile," %s",LibEntry->Prefix);
	else fprintf(ExportFile," ~");
	fprintf(ExportFile," %d %d %d %d %d %c\n",
		LibEntry->NumOfPins,
		LibEntry->TextInside,
		LibEntry->DrawNums,
		LibEntry->NumOfUnits,
		LibEntry->PinsPerUnit,
		LibEntry->IsGridArray ? 'G' : 'N'
		);

	/* Position / orientation / visibilite des champs */
	fprintf(ExportFile,"F0 \"%s\" %d %d %d %c %c\n",
				LibEntry->Prefix,
				LibEntry->PrefixPosX, LibEntry->PrefixPosY,LibEntry->PrefixSize,
				LibEntry->PrefixOrient == 0 ? 'H' : 'V',
				LibEntry->DrawPrefix ? 'V' : 'I' );

	fprintf(ExportFile,"F1 \"%s\" %d %d %d %c %c\n",
				LibEntry->Name,
				LibEntry->NamePosX, LibEntry->NamePosY,LibEntry->NameSize,
				LibEntry->NameOrient == 0 ? 'H' : 'V',
				LibEntry->DrawName ? 'V' : 'I' );

	/* Sauvegarde de la ligne "ALIAS" */
	if( LibEntry->AliasList )
		if( strlen(LibEntry->AliasList) )
			fprintf(ExportFile,"ALIAS %s\n", LibEntry->AliasList);

	/* Sauvegarde des elements de trace */
	DrawEntry = LibEntry->Drawings;
	if(DrawEntry)
		{
		fprintf(ExportFile,"DRAW\n");
		while( DrawEntry )
			{
			switch( DrawEntry->DrawType)
				{
				case ARC_DRAW_TYPE:
					#define DRAWSTRUCT ((LibraryDrawArc *) DrawItem)
					DRAWSTRUCT = &(DrawEntry->U.Arc);
					t1 = DRAWSTRUCT->t1 - 1; if(t1 > 1800) t1 -= 3600;
					t2 = DRAWSTRUCT->t2 + 1; if(t2 > 1800) t2 -= 3600;
					fprintf(ExportFile,"A %d %d %d %d %d %d %d %d\n",
						DRAWSTRUCT->x, DRAWSTRUCT->y,
						DRAWSTRUCT->r, t1, t2,
						DrawEntry->Unit,DrawEntry->Convert, DRAWSTRUCT->width);
					break;

				case CIRCLE_DRAW_TYPE:
					#undef DRAWSTRUCT
					#define DRAWSTRUCT ((LibraryDrawCircle *) DrawItem)
					DRAWSTRUCT = &(DrawEntry->U.Circ);
					fprintf(ExportFile,"C %d %d %d %d %d %d\n",
						DRAWSTRUCT->x, DRAWSTRUCT->y,
						DRAWSTRUCT->r,
						DrawEntry->Unit,DrawEntry->Convert, DRAWSTRUCT->width);
					break;

				case TEXT_DRAW_TYPE:
					#undef DRAWSTRUCT
					#define DRAWSTRUCT ((LibraryDrawText *) DrawItem)
					DRAWSTRUCT = &(DrawEntry->U.Text);
					fprintf(ExportFile,"T %d %d %d %d %d %d %d %s\n",
						DRAWSTRUCT->Horiz,DRAWSTRUCT->x, DRAWSTRUCT->y,
						DRAWSTRUCT->size, DRAWSTRUCT->type,
						DrawEntry->Unit,DrawEntry->Convert,
						DRAWSTRUCT->Text );
					break;

				case SQUARE_DRAW_TYPE:
					#undef DRAWSTRUCT
					#define DRAWSTRUCT ((LibraryDrawSquare *) DrawItem)
					DRAWSTRUCT = &(DrawEntry->U.Sqr);
					fprintf(ExportFile,"S %d %d %d %d %d %d %d\n",
					DRAWSTRUCT->x1,DRAWSTRUCT->y1,
					DRAWSTRUCT->x2,DRAWSTRUCT->y2,
					DrawEntry->Unit,DrawEntry->Convert, DRAWSTRUCT->width);
					break;

				case PIN_DRAW_TYPE:
					#undef DRAWSTRUCT
					#define DRAWSTRUCT ((LibraryDrawPin *) DrawItem)
					FlagXpin = 1;
					DRAWSTRUCT = &(DrawEntry->U.Pin);
					Etype = 'I';
						switch(DRAWSTRUCT->PinType)
						{
						case PIN_INPUT: Etype = 'I'; break;
						case PIN_OUTPUT: Etype = 'O'; break;
						case PIN_BIDI: Etype = 'B'; break;
						case PIN_TRISTATE: Etype = 'T'; break;
						case PIN_PASSIVE: Etype = 'P'; break;
						case PIN_UNSPECIFIED: Etype = 'U'; break;
						case PIN_POWER: Etype = 'W'; break;
						case PIN_OPENCOLLECTOR: Etype = 'C'; break;
						case PIN_OPENEMITTER:	Etype = 'E'; break;
						}
					memset(PinNum,0, sizeof(PinNum) );
					if(DRAWSTRUCT->Num)
						strncpy(PinNum,(char *)(&DRAWSTRUCT->Num), 4);
					else PinNum[0] = '0';
					if((DRAWSTRUCT->Name != NULL) && (DRAWSTRUCT->Name[0] > ' '))
						  fprintf(ExportFile,"X %s", DRAWSTRUCT->Name);
					else fprintf(ExportFile,"X ~");

					fprintf(ExportFile," %s %d %d %d %c %d %d %d %d %c",
						PinNum,
						DRAWSTRUCT->x2,DRAWSTRUCT->y2,
						(int)DRAWSTRUCT->Len,(int)DRAWSTRUCT->Orient,
						DRAWSTRUCT->SizeNum, DRAWSTRUCT->SizeName,
						DrawEntry->Unit,DrawEntry->Convert, Etype);

					if( (DRAWSTRUCT->PinShape) || (DRAWSTRUCT->Flags & PINNOTDRAW) )
						fprintf(ExportFile," ");
					if (DRAWSTRUCT->Flags & PINNOTDRAW)
						fprintf(ExportFile,"N");
					if (DRAWSTRUCT->PinShape & INVERT)
						fprintf(ExportFile,"I");
					if (DRAWSTRUCT->PinShape & CLOCK)
						fprintf(ExportFile,"C");
					if (DRAWSTRUCT->PinShape & LOWLEVEL_IN)
						fprintf(ExportFile,"L");
					if (DRAWSTRUCT->PinShape & LOWLEVEL_OUT)
						fprintf(ExportFile,"V");

					fprintf(ExportFile,"\n");
					break;

				case POLYLINE_DRAW_TYPE:
					#undef DRAWSTRUCT
					#define DRAWSTRUCT ((LibraryDrawPolyline *) DrawItem)
					DRAWSTRUCT = &(DrawEntry->U.Poly);
					fprintf(ExportFile,"P %d %d %d %d", DRAWSTRUCT->n,
						DrawEntry->Unit,DrawEntry->Convert, DRAWSTRUCT->width);
					ptpoly = DRAWSTRUCT->PolyList;
					for( ii = DRAWSTRUCT->n ; ii > 0; ii-- )
						{
						fprintf(ExportFile,"  %d %d", *ptpoly, *(ptpoly+1) );
						ptpoly += 2;
						}
					if (DRAWSTRUCT->Fill) fprintf(ExportFile," F");
					fprintf(ExportFile,"\n");
					break;

				default: DisplayError( "Save Lib: Unknown Draw Type");
					break;
				}

			DrawEntry = DrawEntry->Pnext;
			}
		fprintf(ExportFile,"ENDDRAW\n");
		}

	fprintf(ExportFile,"ENDDEF\n");

	return(FALSE);
}

