/////////////////////////////////////////////////////////////////////////////
// Name:        pinedit-dialog.cpp
// Purpose:     
// Author:      jean-pierre Charras
// Modified by: 
// Created:     11/02/2006 13:30:59
// RCS-ID:      
// Copyright:   License GNU
// Licence:     
/////////////////////////////////////////////////////////////////////////////

// Generated by DialogBlocks (unregistered), 11/02/2006 13:30:59

// For compilers that support precompilation, includes "wx/wx.h".
#include "wx/wxprec.h"

#ifdef __BORLANDC__
#pragma hdrstop
#endif

#ifndef WX_PRECOMP
#include "wx/wx.h"
#endif

////@begin includes
////@end includes

#include "pinedit-dialog.h"

////@begin XPM images
////@end XPM images

/*****************************************************************************************/
void InstallPineditFrame(WinEDA_LibeditFrame * parent, wxDC * DC, const wxPoint & pos)
/*****************************************************************************************/
{
wxPoint MousePos = parent->GetScreen()->m_Curseur;
int accept = TRUE;	
	if ( (CurrentDrawItem == NULL) || (CurrentDrawItem->Type() == COMPONENT_PIN_DRAW_TYPE) )
	{
		LibDrawPin * Pin = (LibDrawPin *) CurrentDrawItem;
		WinEDA_PinPropertiesFrame * frame = new WinEDA_PinPropertiesFrame(parent);
		accept = frame->ShowModal(); frame->Destroy();
		if ( !accept && Pin && ( Pin->m_Flags & IS_NEW ) )	// Abord create new pin
		{
			if ( parent->DrawPanel->ForceCloseManageCurseur && DC)
				parent->DrawPanel->ForceCloseManageCurseur(parent->DrawPanel, DC);
		}
	}
	else DisplayError(parent, wxT("Error: Not a Pin!") );
	parent->GetScreen()->m_Curseur = MousePos;
	parent->DrawPanel->MouseToCursorSchema();
}

/*!
 * WinEDA_PinPropertiesFrame type definition
 */

IMPLEMENT_DYNAMIC_CLASS( WinEDA_PinPropertiesFrame, wxDialog )

/*!
 * WinEDA_PinPropertiesFrame event table definition
 */

BEGIN_EVENT_TABLE( WinEDA_PinPropertiesFrame, wxDialog )

////@begin WinEDA_PinPropertiesFrame event table entries
    EVT_BUTTON( wxID_CANCEL, WinEDA_PinPropertiesFrame::OnCancelClick )

    EVT_BUTTON( wxID_OK, WinEDA_PinPropertiesFrame::OnOkClick )

////@end WinEDA_PinPropertiesFrame event table entries

END_EVENT_TABLE()

/*!
 * WinEDA_PinPropertiesFrame constructors
 */

WinEDA_PinPropertiesFrame::WinEDA_PinPropertiesFrame( )
{
}

WinEDA_PinPropertiesFrame::WinEDA_PinPropertiesFrame( WinEDA_LibeditFrame* parent, wxWindowID id, const wxString& caption, const wxPoint& pos, const wxSize& size, long style )
{
wxString number;
LibDrawPin * CurrentPin = (LibDrawPin *) CurrentDrawItem;
wxString msg, StringPinNum;
int tmp, ii;
	
	m_Parent = parent;
	if ( CurrentPin )
	{
		CurrentPin->ReturnPinStringNum(StringPinNum);
		m_Parent->InitEditOnePin();
	}
    Create(parent, id, caption, pos, size, style);

	/* Init dialog pin name and pin name size values */
	if ( CurrentPin ) msg = CurrentPin->m_PinName;
	else msg = wxEmptyString;
	m_PinNameCtrl->SetValue(msg);
	tmp = CurrentPin ? CurrentPin->m_PinNameSize : LastPinNameSize;
	msg = ReturnStringFromValue(g_UnitMetric, tmp, m_Parent->m_InternalUnits);
	m_PinNameSizeCtrl->SetValue(msg);
	msg = m_PinNameSizeText->GetLabel() + ReturnUnitSymbol();
	m_PinNameSizeText->SetLabel(msg);
	/* Init dialog pin num and pin num size values */
	m_PinNumCtrl->SetValue(StringPinNum);
	tmp = CurrentPin ? CurrentPin->m_PinNumSize : LastPinNumSize;
	msg = ReturnStringFromValue(g_UnitMetric, tmp, m_Parent->m_InternalUnits);
	m_PinNumSizeCtrl->SetValue(msg);
	msg = m_PinNumSizeText->GetLabel() + ReturnUnitSymbol();
	m_PinNumSizeText->SetLabel(msg);
	/* init dialog pin size */
	int pinsize = CurrentPin ? CurrentPin->m_PinLen : LastPinSize;
	m_PinSize->SetValue(pinsize);
	/* init pin options */
	if ( CurrentPin )
		{
		if ( CurrentPin->m_Unit == 0 ) m_CommonUnit->SetValue(TRUE);
		}
	else m_CommonUnit->SetValue(LastPinCommonUnit);
	if ( CurrentPin )
		{
		if ( CurrentPin->m_Convert == 0 ) m_CommonConvert->SetValue(TRUE);
		}
	else m_CommonConvert->SetValue(LastPinCommonConvert);
	if ( CurrentPin )
		{
		if ( CurrentPin->m_Attributs & PINNOTDRAW ) m_NoDraw->SetValue(TRUE);
		}
	else m_NoDraw->SetValue(LastPinNoDraw);
		
	tmp = CurrentPin ? CurrentPin->m_Orient : LastPinOrient;
	switch ( tmp )
	{
		case PIN_RIGHT:
			m_PinOrient->SetSelection(0);
			break;

		case PIN_LEFT:
			m_PinOrient->SetSelection(1);
			break;

		case PIN_UP:
			m_PinOrient->SetSelection(2);
			break;

		case PIN_DOWN:
			m_PinOrient->SetSelection(3);
			break;
	}

	tmp = CurrentPin ? CurrentPin->m_PinShape : LastPinShape;
	m_PinShape->SetSelection( 0 );
	for ( ii = 0; ii < NBSHAPES; ii++ )
	{
		if ( CodeShape[ii] == tmp )
		{
			m_PinShape->SetSelection( ii ); break ;
		}
	}
	
	tmp = CurrentPin ? CurrentPin->m_PinShape : LastPinShape;
	m_PinShape->SetSelection( 0 );
	for ( ii = 0; ii < NBSHAPES; ii++ )
	{
		if ( CodeShape[ii] == tmp )
		{
			m_PinShape->SetSelection( ii ); break ;
		}
	}
	
	m_PinElectricalType->SetSelection( CurrentPin ? CurrentPin->m_PinType : LastPinType);
}

/*!
 * WinEDA_PinPropertiesFrame creator
 */

bool WinEDA_PinPropertiesFrame::Create( wxWindow* parent, wxWindowID id, const wxString& caption, const wxPoint& pos, const wxSize& size, long style )
{
////@begin WinEDA_PinPropertiesFrame member initialisation
    m_PinNameCtrl = NULL;
    m_PinNumCtrl = NULL;
    m_PinSize = NULL;
    m_CommonUnit = NULL;
    m_CommonConvert = NULL;
    m_NoDraw = NULL;
    m_PinNameSizeText = NULL;
    m_PinNameSizeCtrl = NULL;
    m_PinNumSizeText = NULL;
    m_PinNumSizeCtrl = NULL;
    m_PinOrient = NULL;
    m_PinShape = NULL;
    m_PinElectricalType = NULL;
////@end WinEDA_PinPropertiesFrame member initialisation

////@begin WinEDA_PinPropertiesFrame creation
    SetExtraStyle(GetExtraStyle()|wxWS_EX_BLOCK_EVENTS);
    wxDialog::Create( parent, id, caption, pos, size, style );

    CreateControls();
    if (GetSizer())
    {
        GetSizer()->SetSizeHints(this);
    }
    Centre();
////@end WinEDA_PinPropertiesFrame creation
    return true;
}

/*!
 * Control creation for WinEDA_PinPropertiesFrame
 */

void WinEDA_PinPropertiesFrame::CreateControls()
{    
	SetFont(*g_DialogFont);
    
////@begin WinEDA_PinPropertiesFrame content construction
    // Generated by DialogBlocks, 20/02/2007 08:45:04 (unregistered)

    WinEDA_PinPropertiesFrame* itemDialog1 = this;

    wxBoxSizer* itemBoxSizer2 = new wxBoxSizer(wxHORIZONTAL);
    itemDialog1->SetSizer(itemBoxSizer2);

    wxBoxSizer* itemBoxSizer3 = new wxBoxSizer(wxVERTICAL);
    itemBoxSizer2->Add(itemBoxSizer3, 0, wxGROW|wxALL, 5);

    wxStaticText* itemStaticText4 = new wxStaticText( itemDialog1, wxID_STATIC, _("Pin Name :"), wxDefaultPosition, wxDefaultSize, 0 );
    itemBoxSizer3->Add(itemStaticText4, 0, wxALIGN_LEFT|wxLEFT|wxRIGHT|wxTOP|wxADJUST_MINSIZE, 5);

    m_PinNameCtrl = new wxTextCtrl( itemDialog1, ID_TEXTCTRL, _T(""), wxDefaultPosition, wxDefaultSize, 0 );
    itemBoxSizer3->Add(m_PinNameCtrl, 0, wxGROW|wxALL, 5);

    wxStaticText* itemStaticText6 = new wxStaticText( itemDialog1, wxID_STATIC, _("Pin Num :"), wxDefaultPosition, wxDefaultSize, 0 );
    itemBoxSizer3->Add(itemStaticText6, 0, wxALIGN_LEFT|wxLEFT|wxRIGHT|wxTOP|wxADJUST_MINSIZE, 5);

    m_PinNumCtrl = new wxTextCtrl( itemDialog1, ID_TEXTCTRL1, _T(""), wxDefaultPosition, wxDefaultSize, 0 );
    itemBoxSizer3->Add(m_PinNumCtrl, 0, wxGROW|wxALL, 5);

    itemBoxSizer3->Add(5, 5, 0, wxALIGN_CENTER_HORIZONTAL|wxALL, 5);

    wxStaticBox* itemStaticBoxSizer9Static = new wxStaticBox(itemDialog1, wxID_ANY, _(" Pin Options :"));
    wxStaticBoxSizer* itemStaticBoxSizer9 = new wxStaticBoxSizer(itemStaticBoxSizer9Static, wxVERTICAL);
    itemStaticBoxSizer9Static->SetForegroundColour(wxColour(64, 0, 128));
    itemBoxSizer3->Add(itemStaticBoxSizer9, 0, wxGROW|wxALL, 5);

    wxStaticText* itemStaticText10 = new wxStaticText( itemDialog1, wxID_STATIC, _("Pin lenght :"), wxDefaultPosition, wxDefaultSize, 0 );
    itemStaticBoxSizer9->Add(itemStaticText10, 0, wxALIGN_LEFT|wxLEFT|wxRIGHT|wxTOP|wxADJUST_MINSIZE, 5);

    m_PinSize = new wxSpinCtrl( itemDialog1, ID_SPINCTRL, _T("0"), wxDefaultPosition, wxDefaultSize, wxSP_ARROW_KEYS, 0, 2000, 0 );
    itemStaticBoxSizer9->Add(m_PinSize, 0, wxALIGN_CENTER_HORIZONTAL|wxALL, 5);

    m_CommonUnit = new wxCheckBox( itemDialog1, ID_CHECKBOX, _("Common to Units"), wxDefaultPosition, wxDefaultSize, wxCHK_2STATE );
    m_CommonUnit->SetValue(false);
    itemStaticBoxSizer9->Add(m_CommonUnit, 0, wxALIGN_LEFT|wxALL, 5);

    m_CommonConvert = new wxCheckBox( itemDialog1, ID_CHECKBOX1, _("Common to convert"), wxDefaultPosition, wxDefaultSize, wxCHK_2STATE );
    m_CommonConvert->SetValue(false);
    itemStaticBoxSizer9->Add(m_CommonConvert, 0, wxALIGN_LEFT|wxALL, 5);

    m_NoDraw = new wxCheckBox( itemDialog1, ID_CHECKBOX2, _("No Draw"), wxDefaultPosition, wxDefaultSize, wxCHK_2STATE );
    m_NoDraw->SetValue(false);
    itemStaticBoxSizer9->Add(m_NoDraw, 0, wxALIGN_LEFT|wxALL, 5);

    wxBoxSizer* itemBoxSizer15 = new wxBoxSizer(wxVERTICAL);
    itemBoxSizer2->Add(itemBoxSizer15, 0, wxGROW|wxALL, 5);

    m_PinNameSizeText = new wxStaticText( itemDialog1, wxID_STATIC, _("Size"), wxDefaultPosition, wxDefaultSize, 0 );
    itemBoxSizer15->Add(m_PinNameSizeText, 0, wxALIGN_LEFT|wxLEFT|wxRIGHT|wxTOP|wxADJUST_MINSIZE, 5);

    m_PinNameSizeCtrl = new wxTextCtrl( itemDialog1, ID_TEXTCTRL2, _T(""), wxDefaultPosition, wxDefaultSize, 0 );
    itemBoxSizer15->Add(m_PinNameSizeCtrl, 0, wxALIGN_LEFT|wxALL, 5);

    m_PinNumSizeText = new wxStaticText( itemDialog1, wxID_STATIC, _("Size"), wxDefaultPosition, wxDefaultSize, 0 );
    itemBoxSizer15->Add(m_PinNumSizeText, 0, wxALIGN_LEFT|wxLEFT|wxRIGHT|wxTOP|wxADJUST_MINSIZE, 5);

    m_PinNumSizeCtrl = new wxTextCtrl( itemDialog1, ID_TEXTCTRL3, _T(""), wxDefaultPosition, wxDefaultSize, 0 );
    itemBoxSizer15->Add(m_PinNumSizeCtrl, 0, wxALIGN_LEFT|wxALL, 5);

    itemBoxSizer15->Add(5, 5, 0, wxALIGN_CENTER_HORIZONTAL|wxALL, 5);

    wxString m_PinOrientStrings[] = {
        _("Right"),
        _("Left"),
        _("Up"),
        _("Down")
    };
    m_PinOrient = new wxRadioBox( itemDialog1, ID_RADIOBOX, _("Pin Orient:"), wxDefaultPosition, wxDefaultSize, 4, m_PinOrientStrings, 1, wxRA_SPECIFY_COLS );
    m_PinOrient->SetSelection(0);
    m_PinOrient->SetForegroundColour(wxColour(41, 84, 84));
    itemBoxSizer15->Add(m_PinOrient, 0, wxALIGN_CENTER_HORIZONTAL|wxALL, 5);

    wxBoxSizer* itemBoxSizer22 = new wxBoxSizer(wxVERTICAL);
    itemBoxSizer2->Add(itemBoxSizer22, 0, wxGROW|wxALL, 5);

    wxBoxSizer* itemBoxSizer23 = new wxBoxSizer(wxHORIZONTAL);
    itemBoxSizer22->Add(itemBoxSizer23, 0, wxGROW|wxALL, 5);

    wxButton* itemButton24 = new wxButton( itemDialog1, wxID_CANCEL, _("&Cancel"), wxDefaultPosition, wxDefaultSize, 0 );
    itemButton24->SetForegroundColour(wxColour(0, 0, 160));
    itemBoxSizer23->Add(itemButton24, 0, wxGROW|wxALL, 5);

    wxButton* itemButton25 = new wxButton( itemDialog1, wxID_OK, _("&OK"), wxDefaultPosition, wxDefaultSize, 0 );
    itemButton25->SetDefault();
    itemButton25->SetForegroundColour(wxColour(198, 0, 0));
    itemBoxSizer23->Add(itemButton25, 0, wxGROW|wxALL, 5);

    wxBoxSizer* itemBoxSizer26 = new wxBoxSizer(wxHORIZONTAL);
    itemBoxSizer22->Add(itemBoxSizer26, 0, wxGROW|wxALL, 5);

    wxString m_PinShapeStrings[] = {
        _("line"),
        _("invert"),
        _("clock"),
        _("clock inv"),
        _("low in"),
        _("low clock"),
        _("low out")
    };
    m_PinShape = new wxRadioBox( itemDialog1, ID_RADIOBOX1, _("Pin Shape:"), wxDefaultPosition, wxDefaultSize, 7, m_PinShapeStrings, 1, wxRA_SPECIFY_COLS );
    m_PinShape->SetSelection(0);
    m_PinShape->SetForegroundColour(wxColour(0, 64, 0));
    itemBoxSizer26->Add(m_PinShape, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

    wxString m_PinElectricalTypeStrings[] = {
        _("Input"),
        _("Output"),
        _("Bidi"),
        _("3 States"),
        _("Passive"),
        _("Unspecified"),
        _("Power In"),
        _("Power Out"),
        _("Open coll"),
        _("Open emit")
    };
    m_PinElectricalType = new wxRadioBox( itemDialog1, ID_RADIOBOX2, _("Electrical Type:"), wxDefaultPosition, wxDefaultSize, 10, m_PinElectricalTypeStrings, 1, wxRA_SPECIFY_COLS );
    m_PinElectricalType->SetSelection(0);
    m_PinElectricalType->SetForegroundColour(wxColour(68, 68, 34));
    itemBoxSizer26->Add(m_PinElectricalType, 0, wxALIGN_CENTER_VERTICAL|wxALL, 5);

////@end WinEDA_PinPropertiesFrame content construction
}

/*!
 * Should we show tooltips?
 */

bool WinEDA_PinPropertiesFrame::ShowToolTips()
{
    return true;
}

/*!
 * Get bitmap resources
 */

wxBitmap WinEDA_PinPropertiesFrame::GetBitmapResource( const wxString& name )
{
    // Bitmap retrieval
////@begin WinEDA_PinPropertiesFrame bitmap retrieval
    wxUnusedVar(name);
    return wxNullBitmap;
////@end WinEDA_PinPropertiesFrame bitmap retrieval
}

/*!
 * Get icon resources
 */

wxIcon WinEDA_PinPropertiesFrame::GetIconResource( const wxString& name )
{
    // Icon retrieval
////@begin WinEDA_PinPropertiesFrame icon retrieval
    wxUnusedVar(name);
    return wxNullIcon;
////@end WinEDA_PinPropertiesFrame icon retrieval
}
/*!
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for wxID_OK
 */

void WinEDA_PinPropertiesFrame::OnOkClick( wxCommandEvent& event )
{
	PinPropertiesAccept(event);
	EndModal(1);
}

/*!
 * wxEVT_COMMAND_BUTTON_CLICKED event handler for wxID_CANCEL
 */

void WinEDA_PinPropertiesFrame::OnCancelClick( wxCommandEvent& event )
{
	EndModal(0);
}


