;;; tty-init.el --- initialization code for tty's

;; Copyright (C) 1994, 1997 Free Software Foundation, Inc.
;; Copyright (C) 1996 Ben Wing <ben@xemacs.org>.

;; Maintainer: XEmacs Development Team
;; Keywords: terminals, dumped

;; This file is part of XEmacs.

;; XEmacs is free software: you can redistribute it and/or modify it
;; under the terms of the GNU General Public License as published by the
;; Free Software Foundation, either version 3 of the License, or (at your
;; option) any later version.

;; XEmacs is distributed in the hope that it will be useful, but WITHOUT
;; ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
;; FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License
;; for more details.

;; You should have received a copy of the GNU General Public License
;; along with XEmacs.  If not, see <http://www.gnu.org/licenses/>.

;;; Synched up with: Not synched.

;;; Commentary:

;; This file is dumped with XEmacs (when TTY support is compiled in).

;;; Code:

(defvar make-device-early-tty-entry-point-called-p nil
  "Whether `make-device-early-tty-entry-point' has been called, at least once.")

(defun make-device-early-tty-entry-point ()
  "Entry point to set up the Lisp environment for TTY device creation."
  (setq make-device-early-tty-entry-point-called-p t))

(defun make-device-late-tty-entry-point (device)
  "Entry point to finish set up of TTY device creation."
  (with-fboundp 'register-tty-color
    (let ((console (device-console device)))
      (register-tty-color "black"   "\e[30m" "\e[40m" console [0 0 0])
      (register-tty-color "red"     "\e[31m" "\e[41m" console [128 0 0])
      (register-tty-color "green"   "\e[32m" "\e[42m" console [0 128 0])
      (register-tty-color "yellow"  "\e[33m" "\e[43m" console [128 128 0])
      (register-tty-color "blue"    "\e[34m" "\e[44m" console [0 0 128])
      (register-tty-color "magenta" "\e[35m" "\e[45m" console [128 0 128])
      (register-tty-color "cyan"    "\e[36m" "\e[46m" console [0 128 128])
      (register-tty-color "white"   "\e[37m" "\e[47m" console [192 192 192])

      ;; Define `highlighted' tty colors
      (register-tty-color "darkgrey"      "\e[1;30m" "\e[1;40m" console [128 128 128])
      (register-tty-color "brightred"     "\e[1;31m" "\e[1;41m" console [255 0 0])
      (register-tty-color "brightgreen"   "\e[1;32m" "\e[1;42m" console [0 255 0])
      (register-tty-color "brightyellow"  "\e[1;33m" "\e[1;43m" console [255 255 0])
      (register-tty-color "brightblue"    "\e[1;34m" "\e[1;44m" console [0 0 255])
      (register-tty-color "brightmagenta" "\e[1;35m" "\e[1;45m" console [255 0 255])
      (register-tty-color "brightcyan"    "\e[1;36m" "\e[1;46m" console [0 255 255])
      (register-tty-color "brightwhite"   "\e[1;37m" "\e[1;47m" console [255 255 255])

      (when (>= (display-color-cells device) 256)
	(register-tty-color "color-16" "\e[38;5;16m" "\e[48;5;16m" console [0 0 0])
	(register-tty-color "color-17" "\e[38;5;17m" "\e[48;5;17m" console [0 0 95])
	(register-tty-color "color-18" "\e[38;5;18m" "\e[48;5;18m" console [0 0 135])
	(register-tty-color "color-19" "\e[38;5;19m" "\e[48;5;19m" console [0 0 175])
	(register-tty-color "color-20" "\e[38;5;20m" "\e[48;5;20m" console [0 0 215])
	(register-tty-color "color-21" "\e[38;5;21m" "\e[48;5;21m" console [0 0 255])
	(register-tty-color "color-22" "\e[38;5;22m" "\e[48;5;22m" console [0 95 0])
	(register-tty-color "color-23" "\e[38;5;23m" "\e[48;5;23m" console [0 95 95])
	(register-tty-color "color-24" "\e[38;5;24m" "\e[48;5;24m" console [0 95 135])
	(register-tty-color "color-25" "\e[38;5;25m" "\e[48;5;25m" console [0 95 175])
	(register-tty-color "color-26" "\e[38;5;26m" "\e[48;5;26m" console [0 95 215])
	(register-tty-color "color-27" "\e[38;5;27m" "\e[48;5;27m" console [0 95 255])
	(register-tty-color "color-28" "\e[38;5;28m" "\e[48;5;28m" console [0 135 0])
	(register-tty-color "color-29" "\e[38;5;29m" "\e[48;5;29m" console [0 135 95])
	(register-tty-color "color-30" "\e[38;5;30m" "\e[48;5;30m" console [0 135 135])
	(register-tty-color "color-31" "\e[38;5;31m" "\e[48;5;31m" console [0 135 175])
	(register-tty-color "color-32" "\e[38;5;32m" "\e[48;5;32m" console [0 135 215])
	(register-tty-color "color-33" "\e[38;5;33m" "\e[48;5;33m" console [0 135 255])
	(register-tty-color "color-34" "\e[38;5;34m" "\e[48;5;34m" console [0 175 0])
	(register-tty-color "color-35" "\e[38;5;35m" "\e[48;5;35m" console [0 175 95])
	(register-tty-color "color-36" "\e[38;5;36m" "\e[48;5;36m" console [0 175 135])
	(register-tty-color "color-37" "\e[38;5;37m" "\e[48;5;37m" console [0 175 175])
	(register-tty-color "color-38" "\e[38;5;38m" "\e[48;5;38m" console [0 175 215])
	(register-tty-color "color-39" "\e[38;5;39m" "\e[48;5;39m" console [0 175 255])
	(register-tty-color "color-40" "\e[38;5;40m" "\e[48;5;40m" console [0 215 0])
	(register-tty-color "color-41" "\e[38;5;41m" "\e[48;5;41m" console [0 215 95])
	(register-tty-color "color-42" "\e[38;5;42m" "\e[48;5;42m" console [0 215 135])
	(register-tty-color "color-43" "\e[38;5;43m" "\e[48;5;43m" console [0 215 175])
	(register-tty-color "color-44" "\e[38;5;44m" "\e[48;5;44m" console [0 215 215])
	(register-tty-color "color-45" "\e[38;5;45m" "\e[48;5;45m" console [0 215 255])
	(register-tty-color "color-46" "\e[38;5;46m" "\e[48;5;46m" console [0 255 0])
	(register-tty-color "color-47" "\e[38;5;47m" "\e[48;5;47m" console [0 255 95])
	(register-tty-color "color-48" "\e[38;5;48m" "\e[48;5;48m" console [0 255 135])
	(register-tty-color "color-49" "\e[38;5;49m" "\e[48;5;49m" console [0 255 175])
	(register-tty-color "color-50" "\e[38;5;50m" "\e[48;5;50m" console [0 255 215])
	(register-tty-color "color-51" "\e[38;5;51m" "\e[48;5;51m" console [0 255 255])
	(register-tty-color "color-52" "\e[38;5;52m" "\e[48;5;52m" console [95 0 0])
	(register-tty-color "color-53" "\e[38;5;53m" "\e[48;5;53m" console [95 0 95])
	(register-tty-color "color-54" "\e[38;5;54m" "\e[48;5;54m" console [95 0 135])
	(register-tty-color "color-55" "\e[38;5;55m" "\e[48;5;55m" console [95 0 175])
	(register-tty-color "color-56" "\e[38;5;56m" "\e[48;5;56m" console [95 0 215])
	(register-tty-color "color-57" "\e[38;5;57m" "\e[48;5;57m" console [95 0 255])
	(register-tty-color "color-58" "\e[38;5;58m" "\e[48;5;58m" console [95 95 0])
	(register-tty-color "color-59" "\e[38;5;59m" "\e[48;5;59m" console [95 95 95])
	(register-tty-color "color-60" "\e[38;5;60m" "\e[48;5;60m" console [95 95 135])
	(register-tty-color "color-61" "\e[38;5;61m" "\e[48;5;61m" console [95 95 175])
	(register-tty-color "color-62" "\e[38;5;62m" "\e[48;5;62m" console [95 95 215])
	(register-tty-color "color-63" "\e[38;5;63m" "\e[48;5;63m" console [95 95 255])
	(register-tty-color "color-64" "\e[38;5;64m" "\e[48;5;64m" console [95 135 0])
	(register-tty-color "color-65" "\e[38;5;65m" "\e[48;5;65m" console [95 135 95])
	(register-tty-color "color-66" "\e[38;5;66m" "\e[48;5;66m" console [95 135 135])
	(register-tty-color "color-67" "\e[38;5;67m" "\e[48;5;67m" console [95 135 175])
	(register-tty-color "color-68" "\e[38;5;68m" "\e[48;5;68m" console [95 135 215])
	(register-tty-color "color-69" "\e[38;5;69m" "\e[48;5;69m" console [95 135 255])
	(register-tty-color "color-70" "\e[38;5;70m" "\e[48;5;70m" console [95 175 0])
	(register-tty-color "color-71" "\e[38;5;71m" "\e[48;5;71m" console [95 175 95])
	(register-tty-color "color-72" "\e[38;5;72m" "\e[48;5;72m" console [95 175 135])
	(register-tty-color "color-73" "\e[38;5;73m" "\e[48;5;73m" console [95 175 175])
	(register-tty-color "color-74" "\e[38;5;74m" "\e[48;5;74m" console [95 175 215])
	(register-tty-color "color-75" "\e[38;5;75m" "\e[48;5;75m" console [95 175 255])
	(register-tty-color "color-76" "\e[38;5;76m" "\e[48;5;76m" console [95 215 0])
	(register-tty-color "color-77" "\e[38;5;77m" "\e[48;5;77m" console [95 215 95])
	(register-tty-color "color-78" "\e[38;5;78m" "\e[48;5;78m" console [95 215 135])
	(register-tty-color "color-79" "\e[38;5;79m" "\e[48;5;79m" console [95 215 175])
	(register-tty-color "color-80" "\e[38;5;80m" "\e[48;5;80m" console [95 215 215])
	(register-tty-color "color-81" "\e[38;5;81m" "\e[48;5;81m" console [95 215 255])
	(register-tty-color "color-82" "\e[38;5;82m" "\e[48;5;82m" console [95 255 0])
	(register-tty-color "color-83" "\e[38;5;83m" "\e[48;5;83m" console [95 255 95])
	(register-tty-color "color-84" "\e[38;5;84m" "\e[48;5;84m" console [95 255 135])
	(register-tty-color "color-85" "\e[38;5;85m" "\e[48;5;85m" console [95 255 175])
	(register-tty-color "color-86" "\e[38;5;86m" "\e[48;5;86m" console [95 255 215])
	(register-tty-color "color-87" "\e[38;5;87m" "\e[48;5;87m" console [95 255 255])
	(register-tty-color "color-88" "\e[38;5;88m" "\e[48;5;88m" console [135 0 0])
	(register-tty-color "color-89" "\e[38;5;89m" "\e[48;5;89m" console [135 0 95])
	(register-tty-color "color-90" "\e[38;5;90m" "\e[48;5;90m" console [135 0 135])
	(register-tty-color "color-91" "\e[38;5;91m" "\e[48;5;91m" console [135 0 175])
	(register-tty-color "color-92" "\e[38;5;92m" "\e[48;5;92m" console [135 0 215])
	(register-tty-color "color-93" "\e[38;5;93m" "\e[48;5;93m" console [135 0 255])
	(register-tty-color "color-94" "\e[38;5;94m" "\e[48;5;94m" console [135 95 0])
	(register-tty-color "color-95" "\e[38;5;95m" "\e[48;5;95m" console [135 95 95])
	(register-tty-color "color-96" "\e[38;5;96m" "\e[48;5;96m" console [135 95 135])
	(register-tty-color "color-97" "\e[38;5;97m" "\e[48;5;97m" console [135 95 175])
	(register-tty-color "color-98" "\e[38;5;98m" "\e[48;5;98m" console [135 95 215])
	(register-tty-color "color-99" "\e[38;5;99m" "\e[48;5;99m" console [135 95 255])
	(register-tty-color "color-100" "\e[38;5;100m" "\e[48;5;100m" console [135 135 0])
	(register-tty-color "color-101" "\e[38;5;101m" "\e[48;5;101m" console [135 135 95])
	(register-tty-color "color-102" "\e[38;5;102m" "\e[48;5;102m" console [135 135 135])
	(register-tty-color "color-103" "\e[38;5;103m" "\e[48;5;103m" console [135 135 175])
	(register-tty-color "color-104" "\e[38;5;104m" "\e[48;5;104m" console [135 135 215])
	(register-tty-color "color-105" "\e[38;5;105m" "\e[48;5;105m" console [135 135 255])
	(register-tty-color "color-106" "\e[38;5;106m" "\e[48;5;106m" console [135 175 0])
	(register-tty-color "color-107" "\e[38;5;107m" "\e[48;5;107m" console [135 175 95])
	(register-tty-color "color-108" "\e[38;5;108m" "\e[48;5;108m" console [135 175 135])
	(register-tty-color "color-109" "\e[38;5;109m" "\e[48;5;109m" console [135 175 175])
	(register-tty-color "color-110" "\e[38;5;110m" "\e[48;5;110m" console [135 175 215])
	(register-tty-color "color-111" "\e[38;5;111m" "\e[48;5;111m" console [135 175 255])
	(register-tty-color "color-112" "\e[38;5;112m" "\e[48;5;112m" console [135 215 0])
	(register-tty-color "color-113" "\e[38;5;113m" "\e[48;5;113m" console [135 215 95])
	(register-tty-color "color-114" "\e[38;5;114m" "\e[48;5;114m" console [135 215 135])
	(register-tty-color "color-115" "\e[38;5;115m" "\e[48;5;115m" console [135 215 175])
	(register-tty-color "color-116" "\e[38;5;116m" "\e[48;5;116m" console [135 215 215])
	(register-tty-color "color-117" "\e[38;5;117m" "\e[48;5;117m" console [135 215 255])
	(register-tty-color "color-118" "\e[38;5;118m" "\e[48;5;118m" console [135 255 0])
	(register-tty-color "color-119" "\e[38;5;119m" "\e[48;5;119m" console [135 255 95])
	(register-tty-color "color-120" "\e[38;5;120m" "\e[48;5;120m" console [135 255 135])
	(register-tty-color "color-121" "\e[38;5;121m" "\e[48;5;121m" console [135 255 175])
	(register-tty-color "color-122" "\e[38;5;122m" "\e[48;5;122m" console [135 255 215])
	(register-tty-color "color-123" "\e[38;5;123m" "\e[48;5;123m" console [135 255 255])
	(register-tty-color "color-124" "\e[38;5;124m" "\e[48;5;124m" console [175 0 0])
	(register-tty-color "color-125" "\e[38;5;125m" "\e[48;5;125m" console [175 0 95])
	(register-tty-color "color-126" "\e[38;5;126m" "\e[48;5;126m" console [175 0 135])
	(register-tty-color "color-127" "\e[38;5;127m" "\e[48;5;127m" console [175 0 175])
	(register-tty-color "color-128" "\e[38;5;128m" "\e[48;5;128m" console [175 0 215])
	(register-tty-color "color-129" "\e[38;5;129m" "\e[48;5;129m" console [175 0 255])
	(register-tty-color "color-130" "\e[38;5;130m" "\e[48;5;130m" console [175 95 0])
	(register-tty-color "color-131" "\e[38;5;131m" "\e[48;5;131m" console [175 95 95])
	(register-tty-color "color-132" "\e[38;5;132m" "\e[48;5;132m" console [175 95 135])
	(register-tty-color "color-133" "\e[38;5;133m" "\e[48;5;133m" console [175 95 175])
	(register-tty-color "color-134" "\e[38;5;134m" "\e[48;5;134m" console [175 95 215])
	(register-tty-color "color-135" "\e[38;5;135m" "\e[48;5;135m" console [175 95 255])
	(register-tty-color "color-136" "\e[38;5;136m" "\e[48;5;136m" console [175 135 0])
	(register-tty-color "color-137" "\e[38;5;137m" "\e[48;5;137m" console [175 135 95])
	(register-tty-color "color-138" "\e[38;5;138m" "\e[48;5;138m" console [175 135 135])
	(register-tty-color "color-139" "\e[38;5;139m" "\e[48;5;139m" console [175 135 175])
	(register-tty-color "color-140" "\e[38;5;140m" "\e[48;5;140m" console [175 135 215])
	(register-tty-color "color-141" "\e[38;5;141m" "\e[48;5;141m" console [175 135 255])
	(register-tty-color "color-142" "\e[38;5;142m" "\e[48;5;142m" console [175 175 0])
	(register-tty-color "color-143" "\e[38;5;143m" "\e[48;5;143m" console [175 175 95])
	(register-tty-color "color-144" "\e[38;5;144m" "\e[48;5;144m" console [175 175 135])
	(register-tty-color "color-145" "\e[38;5;145m" "\e[48;5;145m" console [175 175 175])
	(register-tty-color "color-146" "\e[38;5;146m" "\e[48;5;146m" console [175 175 215])
	(register-tty-color "color-147" "\e[38;5;147m" "\e[48;5;147m" console [175 175 255])
	(register-tty-color "color-148" "\e[38;5;148m" "\e[48;5;148m" console [175 215 0])
	(register-tty-color "color-149" "\e[38;5;149m" "\e[48;5;149m" console [175 215 95])
	(register-tty-color "color-150" "\e[38;5;150m" "\e[48;5;150m" console [175 215 135])
	(register-tty-color "color-151" "\e[38;5;151m" "\e[48;5;151m" console [175 215 175])
	(register-tty-color "color-152" "\e[38;5;152m" "\e[48;5;152m" console [175 215 215])
	(register-tty-color "color-153" "\e[38;5;153m" "\e[48;5;153m" console [175 215 255])
	(register-tty-color "color-154" "\e[38;5;154m" "\e[48;5;154m" console [175 255 0])
	(register-tty-color "color-155" "\e[38;5;155m" "\e[48;5;155m" console [175 255 95])
	(register-tty-color "color-156" "\e[38;5;156m" "\e[48;5;156m" console [175 255 135])
	(register-tty-color "color-157" "\e[38;5;157m" "\e[48;5;157m" console [175 255 175])
	(register-tty-color "color-158" "\e[38;5;158m" "\e[48;5;158m" console [175 255 215])
	(register-tty-color "color-159" "\e[38;5;159m" "\e[48;5;159m" console [175 255 255])
	(register-tty-color "color-160" "\e[38;5;160m" "\e[48;5;160m" console [215 0 0])
	(register-tty-color "color-161" "\e[38;5;161m" "\e[48;5;161m" console [215 0 95])
	(register-tty-color "color-162" "\e[38;5;162m" "\e[48;5;162m" console [215 0 135])
	(register-tty-color "color-163" "\e[38;5;163m" "\e[48;5;163m" console [215 0 175])
	(register-tty-color "color-164" "\e[38;5;164m" "\e[48;5;164m" console [215 0 215])
	(register-tty-color "color-165" "\e[38;5;165m" "\e[48;5;165m" console [215 0 255])
	(register-tty-color "color-166" "\e[38;5;166m" "\e[48;5;166m" console [215 95 0])
	(register-tty-color "color-167" "\e[38;5;167m" "\e[48;5;167m" console [215 95 95])
	(register-tty-color "color-168" "\e[38;5;168m" "\e[48;5;168m" console [215 95 135])
	(register-tty-color "color-169" "\e[38;5;169m" "\e[48;5;169m" console [215 95 175])
	(register-tty-color "color-170" "\e[38;5;170m" "\e[48;5;170m" console [215 95 215])
	(register-tty-color "color-171" "\e[38;5;171m" "\e[48;5;171m" console [215 95 255])
	(register-tty-color "color-172" "\e[38;5;172m" "\e[48;5;172m" console [215 135 0])
	(register-tty-color "color-173" "\e[38;5;173m" "\e[48;5;173m" console [215 135 95])
	(register-tty-color "color-174" "\e[38;5;174m" "\e[48;5;174m" console [215 135 135])
	(register-tty-color "color-175" "\e[38;5;175m" "\e[48;5;175m" console [215 135 175])
	(register-tty-color "color-176" "\e[38;5;176m" "\e[48;5;176m" console [215 135 215])
	(register-tty-color "color-177" "\e[38;5;177m" "\e[48;5;177m" console [215 135 255])
	(register-tty-color "color-178" "\e[38;5;178m" "\e[48;5;178m" console [215 175 0])
	(register-tty-color "color-179" "\e[38;5;179m" "\e[48;5;179m" console [215 175 95])
	(register-tty-color "color-180" "\e[38;5;180m" "\e[48;5;180m" console [215 175 135])
	(register-tty-color "color-181" "\e[38;5;181m" "\e[48;5;181m" console [215 175 175])
	(register-tty-color "color-182" "\e[38;5;182m" "\e[48;5;182m" console [215 175 215])
	(register-tty-color "color-183" "\e[38;5;183m" "\e[48;5;183m" console [215 175 255])
	(register-tty-color "color-184" "\e[38;5;184m" "\e[48;5;184m" console [215 215 0])
	(register-tty-color "color-185" "\e[38;5;185m" "\e[48;5;185m" console [215 215 95])
	(register-tty-color "color-186" "\e[38;5;186m" "\e[48;5;186m" console [215 215 135])
	(register-tty-color "color-187" "\e[38;5;187m" "\e[48;5;187m" console [215 215 175])
	(register-tty-color "color-188" "\e[38;5;188m" "\e[48;5;188m" console [215 215 215])
	(register-tty-color "color-189" "\e[38;5;189m" "\e[48;5;189m" console [215 215 255])
	(register-tty-color "color-190" "\e[38;5;190m" "\e[48;5;190m" console [215 255 0])
	(register-tty-color "color-191" "\e[38;5;191m" "\e[48;5;191m" console [215 255 95])
	(register-tty-color "color-192" "\e[38;5;192m" "\e[48;5;192m" console [215 255 135])
	(register-tty-color "color-193" "\e[38;5;193m" "\e[48;5;193m" console [215 255 175])
	(register-tty-color "color-194" "\e[38;5;194m" "\e[48;5;194m" console [215 255 215])
	(register-tty-color "color-195" "\e[38;5;195m" "\e[48;5;195m" console [215 255 255])
	(register-tty-color "color-196" "\e[38;5;196m" "\e[48;5;196m" console [255 0 0])
	(register-tty-color "color-197" "\e[38;5;197m" "\e[48;5;197m" console [255 0 95])
	(register-tty-color "color-198" "\e[38;5;198m" "\e[48;5;198m" console [255 0 135])
	(register-tty-color "color-199" "\e[38;5;199m" "\e[48;5;199m" console [255 0 175])
	(register-tty-color "color-200" "\e[38;5;200m" "\e[48;5;200m" console [255 0 215])
	(register-tty-color "color-201" "\e[38;5;201m" "\e[48;5;201m" console [255 0 255])
	(register-tty-color "color-202" "\e[38;5;202m" "\e[48;5;202m" console [255 95 0])
	(register-tty-color "color-203" "\e[38;5;203m" "\e[48;5;203m" console [255 95 95])
	(register-tty-color "color-204" "\e[38;5;204m" "\e[48;5;204m" console [255 95 135])
	(register-tty-color "color-205" "\e[38;5;205m" "\e[48;5;205m" console [255 95 175])
	(register-tty-color "color-206" "\e[38;5;206m" "\e[48;5;206m" console [255 95 215])
	(register-tty-color "color-207" "\e[38;5;207m" "\e[48;5;207m" console [255 95 255])
	(register-tty-color "color-208" "\e[38;5;208m" "\e[48;5;208m" console [255 135 0])
	(register-tty-color "color-209" "\e[38;5;209m" "\e[48;5;209m" console [255 135 95])
	(register-tty-color "color-210" "\e[38;5;210m" "\e[48;5;210m" console [255 135 135])
	(register-tty-color "color-211" "\e[38;5;211m" "\e[48;5;211m" console [255 135 175])
	(register-tty-color "color-212" "\e[38;5;212m" "\e[48;5;212m" console [255 135 215])
	(register-tty-color "color-213" "\e[38;5;213m" "\e[48;5;213m" console [255 135 255])
	(register-tty-color "color-214" "\e[38;5;214m" "\e[48;5;214m" console [255 175 0])
	(register-tty-color "color-215" "\e[38;5;215m" "\e[48;5;215m" console [255 175 95])
	(register-tty-color "color-216" "\e[38;5;216m" "\e[48;5;216m" console [255 175 135])
	(register-tty-color "color-217" "\e[38;5;217m" "\e[48;5;217m" console [255 175 175])
	(register-tty-color "color-218" "\e[38;5;218m" "\e[48;5;218m" console [255 175 215])
	(register-tty-color "color-219" "\e[38;5;219m" "\e[48;5;219m" console [255 175 255])
	(register-tty-color "color-220" "\e[38;5;220m" "\e[48;5;220m" console [255 215 0])
	(register-tty-color "color-221" "\e[38;5;221m" "\e[48;5;221m" console [255 215 95])
	(register-tty-color "color-222" "\e[38;5;222m" "\e[48;5;222m" console [255 215 135])
	(register-tty-color "color-223" "\e[38;5;223m" "\e[48;5;223m" console [255 215 175])
	(register-tty-color "color-224" "\e[38;5;224m" "\e[48;5;224m" console [255 215 215])
	(register-tty-color "color-225" "\e[38;5;225m" "\e[48;5;225m" console [255 215 255])
	(register-tty-color "color-226" "\e[38;5;226m" "\e[48;5;226m" console [255 255 0])
	(register-tty-color "color-227" "\e[38;5;227m" "\e[48;5;227m" console [255 255 95])
	(register-tty-color "color-228" "\e[38;5;228m" "\e[48;5;228m" console [255 255 135])
	(register-tty-color "color-229" "\e[38;5;229m" "\e[48;5;229m" console [255 255 175])
	(register-tty-color "color-230" "\e[38;5;230m" "\e[48;5;230m" console [255 255 215])
	(register-tty-color "color-231" "\e[38;5;231m" "\e[48;5;231m" console [255 255 255])
	(register-tty-color "color-232" "\e[38;5;232m" "\e[48;5;232m" console [8 8 8])
	(register-tty-color "color-233" "\e[38;5;233m" "\e[48;5;233m" console [18 18 18])
	(register-tty-color "color-234" "\e[38;5;234m" "\e[48;5;234m" console [28 28 28])
	(register-tty-color "color-235" "\e[38;5;235m" "\e[48;5;235m" console [38 38 38])
	(register-tty-color "color-236" "\e[38;5;236m" "\e[48;5;236m" console [48 48 48])
	(register-tty-color "color-237" "\e[38;5;237m" "\e[48;5;237m" console [58 58 58])
	(register-tty-color "color-238" "\e[38;5;238m" "\e[48;5;238m" console [68 68 68])
	(register-tty-color "color-239" "\e[38;5;239m" "\e[48;5;239m" console [78 78 78])
	(register-tty-color "color-240" "\e[38;5;240m" "\e[48;5;240m" console [88 88 88])
	(register-tty-color "color-241" "\e[38;5;241m" "\e[48;5;241m" console [98 98 98])
	(register-tty-color "color-242" "\e[38;5;242m" "\e[48;5;242m" console [108 108 108])
	(register-tty-color "color-243" "\e[38;5;243m" "\e[48;5;243m" console [118 118 118])
	(register-tty-color "color-244" "\e[38;5;244m" "\e[48;5;244m" console [128 128 128])
	(register-tty-color "color-245" "\e[38;5;245m" "\e[48;5;245m" console [138 138 138])
	(register-tty-color "color-246" "\e[38;5;246m" "\e[48;5;246m" console [148 148 148])
	(register-tty-color "color-247" "\e[38;5;247m" "\e[48;5;247m" console [158 158 158])
	(register-tty-color "color-248" "\e[38;5;248m" "\e[48;5;248m" console [168 168 168])
	(register-tty-color "color-249" "\e[38;5;249m" "\e[48;5;249m" console [178 178 178])
	(register-tty-color "color-250" "\e[38;5;250m" "\e[48;5;250m" console [188 188 188])
	(register-tty-color "color-251" "\e[38;5;251m" "\e[48;5;251m" console [198 198 198])
	(register-tty-color "color-252" "\e[38;5;252m" "\e[48;5;252m" console [208 208 208])
	(register-tty-color "color-253" "\e[38;5;253m" "\e[48;5;253m" console [218 218 218])
	(register-tty-color "color-254" "\e[38;5;254m" "\e[48;5;254m" console [228 228 228])
	(register-tty-color "color-255" "\e[38;5;255m" "\e[48;5;255m" console [238 238 238])))))

;; We have to do this for every created TTY console, after the first frame
;; has been created.
(defun make-frame-after-init-entry-point (console)
  "Entry point for Lisp called after first frame creation on a TTY device."
  ;; load the appropriate term-type-specific Lisp file.
  ;; we don't do this at startup here so that the user can
  ;; override term-file-prefix. (startup.el does it after
  ;; loading the init file.)
  (when (and (find-coding-system 'euc-jp)
             (member* (mismatch "kterm" (console-tty-terminal-type console)
                                :test #'equalp)
                      '(nil 5)))
    (set-console-tty-coding-system console 'euc-jp))
  (when init-file-loaded
    ;; temporarily select the console so that the changes
    ;; to function-key-map are made for the right console.
    (let ((foobar (selected-console)))
      (unwind-protect
	  (progn
	    (select-console console)
	    (load-terminal-library))
	(select-console foobar)))))

(defun make-frame-on-tty (tty &optional props)
  "Create a frame on the TTY connection named TTY.
TTY should be a TTY device name such as \"/dev/ttyp3\" (as returned by
the `tty' command in that TTY), or nil for the standard input/output
of the running XEmacs process.

PROPS should be a plist of properties, as in the call to `make-frame'.

This function opens a connection to the TTY or reuses an existing
connection.

This function is a trivial wrapper around `make-frame-on-device'."
  (interactive "sMake frame on TTY: ")
  (if (equal tty "") (setq tty nil))
  (make-frame-on-device 'tty tty props))

;;; tty-init.el ends here
