/*
 * Decompiled with CFR 0.152.
 */
package com.xmlcalabash.util;

import com.xmlcalabash.core.XProcException;
import com.xmlcalabash.core.XProcRuntime;
import com.xmlcalabash.util.S9apiUtils;
import com.xmlcalabash.util.TreeWriter;
import com.xmlcalabash.xpcgrammar.ASTAttribute;
import com.xmlcalabash.xpcgrammar.ASTComment;
import com.xmlcalabash.xpcgrammar.ASTDataBinding;
import com.xmlcalabash.xpcgrammar.ASTDeclareStep;
import com.xmlcalabash.xpcgrammar.ASTDocumentBinding;
import com.xmlcalabash.xpcgrammar.ASTDocumentation;
import com.xmlcalabash.xpcgrammar.ASTEmptyBinding;
import com.xmlcalabash.xpcgrammar.ASTImports;
import com.xmlcalabash.xpcgrammar.ASTInlineBinding;
import com.xmlcalabash.xpcgrammar.ASTInput;
import com.xmlcalabash.xpcgrammar.ASTIterationSource;
import com.xmlcalabash.xpcgrammar.ASTLibrary;
import com.xmlcalabash.xpcgrammar.ASTLiteralChar;
import com.xmlcalabash.xpcgrammar.ASTLog;
import com.xmlcalabash.xpcgrammar.ASTNamespace;
import com.xmlcalabash.xpcgrammar.ASTNamespaces;
import com.xmlcalabash.xpcgrammar.ASTOption;
import com.xmlcalabash.xpcgrammar.ASTOutput;
import com.xmlcalabash.xpcgrammar.ASTPI;
import com.xmlcalabash.xpcgrammar.ASTPipeBinding;
import com.xmlcalabash.xpcgrammar.ASTPipeinfo;
import com.xmlcalabash.xpcgrammar.ASTPipeline;
import com.xmlcalabash.xpcgrammar.ASTSerialization;
import com.xmlcalabash.xpcgrammar.ASTStart;
import com.xmlcalabash.xpcgrammar.ASTStep;
import com.xmlcalabash.xpcgrammar.ASTVariable;
import com.xmlcalabash.xpcgrammar.ASTVersion;
import com.xmlcalabash.xpcgrammar.ASTViewportSource;
import com.xmlcalabash.xpcgrammar.ASTWhenStep;
import com.xmlcalabash.xpcgrammar.ASTWithOption;
import com.xmlcalabash.xpcgrammar.ASTWithParam;
import com.xmlcalabash.xpcgrammar.ASTXPathContext;
import com.xmlcalabash.xpcgrammar.ASTXml;
import com.xmlcalabash.xpcgrammar.Node;
import com.xmlcalabash.xpcgrammar.XpcParser;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Hashtable;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.s9api.Axis;
import net.sf.saxon.s9api.DocumentBuilder;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.QName;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.s9api.XdmNode;
import net.sf.saxon.s9api.XdmNodeKind;
import net.sf.saxon.s9api.XdmSequenceIterator;
import org.xml.sax.InputSource;

public class ParseXPC {
    private static QName _name = new QName("", "name");
    private static QName _href = new QName("", "href");
    private static QName _port = new QName("", "port");
    private static QName _select = new QName("", "select");
    private static QName _required = new QName("", "required");
    private static QName _step = new QName("", "step");
    private static QName _test = new QName("", "test");
    private Processor processor = null;
    private TreeWriter tree = null;
    private URI baseURI = null;
    private Hashtable<String, String> xmlns = new Hashtable();
    private String defaultNamespace = null;
    private String pfx = "p";
    private String version = "ERROR";

    public ParseXPC(XProcRuntime xProcRuntime) {
        this.processor = xProcRuntime.getProcessor();
    }

    public ParseXPC(Processor processor) {
        this.processor = processor;
    }

    public XdmNode parse(InputStream inputStream, URI uRI) {
        try {
            ASTStart aSTStart = XpcParser.parse(inputStream);
            this.tree = new TreeWriter(this.processor);
            this.baseURI = uRI;
            XdmNode xdmNode = this.walk(aSTStart);
        }
        catch (Exception exception) {
            throw new XProcException(exception);
        }
        return this.tree.getResult();
    }

    private XdmNode walk(ASTStart aSTStart) {
        XdmNode xdmNode = null;
        for (int i = 0; i < aSTStart.jjtGetNumChildren(); ++i) {
            Node node = aSTStart.jjtGetChild(i);
            if (node instanceof ASTNamespace) {
                ASTNamespace aSTNamespace = (ASTNamespace)node;
                if (aSTNamespace.prefix == null) {
                    this.defaultNamespace = aSTNamespace.namespace;
                    continue;
                }
                this.xmlns.put(aSTNamespace.prefix, aSTNamespace.namespace);
                continue;
            }
            if (node instanceof ASTPipeline) {
                xdmNode = this.walkPipeline(node, this.xmlns, true);
                continue;
            }
            if (node instanceof ASTDeclareStep) {
                xdmNode = this.walkPipeline(node, this.xmlns, false);
                continue;
            }
            if (node instanceof ASTLibrary) {
                xdmNode = this.walkLibrary(node, this.xmlns);
                continue;
            }
            if (node instanceof ASTVersion) {
                this.version = ((ASTVersion)node).version;
                continue;
            }
            throw new XProcException("Found unexpected production in XPC tree");
        }
        return xdmNode;
    }

    private void addAttributes(Node node) {
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            Node node2 = node.jjtGetChild(i);
            if (!(node2 instanceof ASTAttribute)) {
                return;
            }
            String string = ((ASTAttribute)node2).qname;
            String string2 = ((ASTAttribute)node2).value;
            this.tree.addAttribute(this.pqname(string), string2);
        }
    }

    private void walk(Node node) {
        for (int i = 0; i < node.jjtGetNumChildren(); ++i) {
            String string;
            Node node2 = node.jjtGetChild(i);
            boolean bl = false;
            if (node2 instanceof ASTAttribute) {
                bl = true;
            } else if (node2 instanceof ASTInput) {
                this.tree.addStartElement(this.qname("input"));
                this.tree.addAttribute(_port, ((ASTInput)node2).port);
            } else if (node2 instanceof ASTOutput) {
                this.tree.addStartElement(this.qname("output"));
                this.tree.addAttribute(_port, ((ASTOutput)node2).port);
            } else if (node2 instanceof ASTOption) {
                this.tree.addStartElement(this.qname("option"));
                this.tree.addAttribute(_name, ((ASTOption)node2).name);
                if (((ASTOption)node2).required) {
                    this.tree.addAttribute(_required, "true");
                }
            } else if (node2 instanceof ASTWithOption) {
                this.tree.addStartElement(this.qname("with-option"));
                this.tree.addAttribute(_name, ((ASTWithOption)node2).name);
                this.tree.addAttribute(_select, ((ASTWithOption)node2).select);
            } else if (node2 instanceof ASTWithParam) {
                this.tree.addStartElement(this.qname("with-param"));
                this.tree.addAttribute(_name, ((ASTWithParam)node2).name);
                this.tree.addAttribute(_select, ((ASTWithParam)node2).select);
            } else if (node2 instanceof ASTVariable) {
                this.tree.addStartElement(this.qname("variable"));
                this.tree.addAttribute(_name, ((ASTVariable)node2).name);
                this.tree.addAttribute(_select, ((ASTVariable)node2).select);
            } else if (node2 instanceof ASTIterationSource) {
                this.tree.addStartElement(this.qname("iteration-source"));
                string = ((ASTIterationSource)node2).select;
                if (string != null) {
                    this.tree.addAttribute(_select, string);
                }
            } else if (node2 instanceof ASTViewportSource) {
                this.tree.addStartElement(this.qname("viewport-source"));
            } else if (node2 instanceof ASTXPathContext) {
                this.tree.addStartElement(this.qname("xpath-context"));
            } else if (node2 instanceof ASTNamespaces) {
                this.tree.addStartElement(this.qname("namespaces"));
                for (int j = 0; j < node2.jjtGetNumChildren(); ++j) {
                    Node node3 = node2.jjtGetChild(j);
                    if (!(node3 instanceof ASTNamespace)) continue;
                    String string2 = ((ASTNamespace)node3).prefix;
                    String string3 = ((ASTNamespace)node3).namespace;
                    this.tree.addNamespace(string2, string3);
                }
            } else if (node2 instanceof ASTNamespace) {
                bl = true;
            } else if (node2 instanceof ASTEmptyBinding) {
                this.tree.addStartElement(this.qname("empty"));
            } else if (node2 instanceof ASTDocumentBinding) {
                this.tree.addStartElement(this.qname("document"));
                this.tree.addAttribute(_href, ((ASTDocumentBinding)node2).href);
            } else if (node2 instanceof ASTPipeBinding) {
                this.tree.addStartElement(this.qname("pipe"));
                this.tree.addAttribute(_step, ((ASTPipeBinding)node2).step);
                this.tree.addAttribute(_port, ((ASTPipeBinding)node2).port);
            } else if (node2 instanceof ASTDataBinding) {
                this.tree.addStartElement(this.qname("data"));
                this.tree.addAttribute(_href, ((ASTDataBinding)node2).href);
            } else if (node2 instanceof ASTInlineBinding) {
                this.tree.addStartElement(this.qname("inline"));
            } else if (node2 instanceof ASTDocumentation) {
                this.tree.addStartElement(this.qname("documentation"));
            } else if (node2 instanceof ASTPipeinfo) {
                this.tree.addStartElement(this.qname("pipeinfo"));
            } else if (node2 instanceof ASTXml) {
                i += this.walkXML(node, i);
                bl = true;
            } else if (node2 instanceof ASTComment) {
                string = "";
                for (int j = 0; j < node2.jjtGetNumChildren(); ++j) {
                    ASTLiteralChar aSTLiteralChar = (ASTLiteralChar)node2.jjtGetChild(j);
                    string = string + aSTLiteralChar.data;
                }
                this.tree.addComment(string);
                bl = true;
            } else if (node2 instanceof ASTPI) {
                string = "";
                String string4 = "";
                boolean bl2 = true;
                for (int j = 0; j < node2.jjtGetNumChildren(); ++j) {
                    ASTLiteralChar aSTLiteralChar = (ASTLiteralChar)node2.jjtGetChild(j);
                    if (bl2) {
                        if (Character.isSpaceChar(aSTLiteralChar.data.charAt(0))) {
                            bl2 = false;
                            continue;
                        }
                        string = string + aSTLiteralChar.data;
                        continue;
                    }
                    string4 = string4 + aSTLiteralChar.data;
                }
                this.tree.addPI(string, string4);
                bl = true;
            } else if (node2 instanceof ASTLog) {
                this.tree.addStartElement(this.qname("log"));
                this.tree.addAttribute(_port, ((ASTLog)node2).port);
                this.tree.addAttribute(_href, ((ASTLog)node2).href);
            } else if (node2 instanceof ASTImports) {
                this.tree.addStartElement(this.qname("import"));
                this.tree.addAttribute(_href, ((ASTImports)node2).href);
            } else if (node2 instanceof ASTSerialization) {
                this.tree.addStartElement(this.qname("serialization"));
                this.tree.addAttribute(_port, ((ASTSerialization)node2).port);
            } else if (node2 instanceof ASTPipeline) {
                this.tree.addStartElement(this.qname("pipeline"));
                string = ((ASTPipeline)node2).name;
                if (string != null) {
                    this.tree.addAttribute(_name, string);
                }
            } else if (node2 instanceof ASTDeclareStep) {
                this.tree.addStartElement(this.qname("declare-step"));
                string = ((ASTDeclareStep)node2).name;
                if (string != null) {
                    this.tree.addAttribute(_name, string);
                }
            } else if (node2 instanceof ASTWhenStep) {
                this.tree.addStartElement(this.qname("when"));
                this.tree.addAttribute(_test, ((ASTWhenStep)node2).test);
            } else if (node2 instanceof ASTStep) {
                string = ((ASTStep)node2).type;
                String string5 = ((ASTStep)node2).name;
                if (string.contains(":")) {
                    this.tree.addStartElement(this.pqname(string));
                } else {
                    this.tree.addStartElement(this.qname(string));
                }
                if (string5 != null) {
                    this.tree.addAttribute(_name, string5);
                }
            } else {
                throw new XProcException("Unexpected node type in XPC parse tree");
            }
            if (bl) continue;
            this.addAttributes(node2);
            this.walk(node2);
            this.tree.addEndElement();
        }
    }

    private int walkXML(Node node, int n) {
        Object object;
        int n2 = 0;
        int n3 = n;
        String string = "<wrapper";
        if (this.defaultNamespace != null) {
            string = string + " xmlns=\"" + this.defaultNamespace + "\"";
        }
        for (String object22 : this.xmlns.keySet()) {
            string = string + " xmlns:" + object22 + "=\"" + this.xmlns.get(object22) + "\"";
        }
        string = string + ">";
        while (n3 < node.jjtGetNumChildren()) {
            ++n2;
            object = node.jjtGetChild(n3);
            if (!(object instanceof ASTXml)) break;
            ASTXml aSTXml = (ASTXml)object;
            if (aSTXml.data == null) {
                string = string + "<![CDATA[";
                for (int i = 0; i < aSTXml.jjtGetNumChildren(); ++i) {
                    ASTLiteralChar aSTLiteralChar = (ASTLiteralChar)aSTXml.jjtGetChild(i);
                    string = string + aSTLiteralChar.data;
                }
                string = string + "]]>";
            } else {
                string = string + aSTXml.data;
            }
            ++n3;
        }
        string = string + "</wrapper>";
        object = null;
        try {
            object = new SAXSource(new InputSource(new ByteArrayInputStream(string.getBytes("utf-8"))));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new XProcException(unsupportedEncodingException);
        }
        DocumentBuilder documentBuilder = this.processor.newDocumentBuilder();
        documentBuilder.setDTDValidation(false);
        documentBuilder.setLineNumbering(true);
        try {
            XdmNode xdmNode = documentBuilder.build((Source)object);
            xdmNode = S9apiUtils.getDocumentElement(xdmNode);
            this.copyTree(xdmNode);
        }
        catch (SaxonApiException saxonApiException) {
            throw new XProcException(saxonApiException);
        }
        return n2;
    }

    private void copyTree(XdmNode xdmNode) {
        XdmSequenceIterator xdmSequenceIterator = xdmNode.axisIterator(Axis.CHILD);
        while (xdmSequenceIterator.hasNext()) {
            XdmNode xdmNode2 = (XdmNode)xdmSequenceIterator.next();
            if (xdmNode2.getNodeKind() == XdmNodeKind.TEXT) {
                this.tree.addText(xdmNode2.getStringValue());
                continue;
            }
            if (xdmNode2.getNodeKind() == XdmNodeKind.ELEMENT) {
                this.tree.addStartElement(xdmNode2);
                XdmSequenceIterator xdmSequenceIterator2 = xdmNode2.axisIterator(Axis.ATTRIBUTE);
                while (xdmSequenceIterator2.hasNext()) {
                    XdmNode xdmNode3 = (XdmNode)xdmSequenceIterator2.next();
                    this.tree.addAttribute(xdmNode3);
                }
                this.tree.startContent();
                this.copyTree(xdmNode2);
                this.tree.addEndElement();
                continue;
            }
            if (xdmNode2.getNodeKind() == XdmNodeKind.COMMENT) {
                this.tree.addComment(xdmNode2.getStringValue());
                continue;
            }
            if (xdmNode2.getNodeKind() == XdmNodeKind.PROCESSING_INSTRUCTION) {
                this.tree.addPI(xdmNode2.getNodeName().getLocalName(), xdmNode2.getStringValue());
                continue;
            }
            throw new XProcException("Unexpected node kind in XPC inline XML");
        }
    }

    private QName qname(String string) {
        return new QName(this.pfx, "http://www.w3.org/ns/xproc", string);
    }

    private QName pqname(String string) {
        if (string.contains(":")) {
            String string2 = string.substring(0, string.indexOf(":"));
            String string3 = string.substring(string.indexOf(":") + 1);
            if (this.xmlns.containsKey(string2)) {
                return new QName(string2, this.xmlns.get(string2), string3);
            }
            if ("xml".equals(string2)) {
                return new QName("xml", "http://www.w3.org/XML/1998/namespace", string3);
            }
            throw new XProcException("No namespace binding for '" + string2 + "'");
        }
        return new QName("", string);
    }

    private XdmNode walkPipeline(Node node, Hashtable<String, String> hashtable, boolean bl) {
        this.tree.startDocument(this.baseURI);
        for (String string : hashtable.keySet()) {
            String string2 = hashtable.get(string);
            if (!"http://www.w3.org/ns/xproc".equals(string2)) continue;
            this.pfx = string;
            break;
        }
        if (bl) {
            this.tree.addStartElement(this.qname("pipeline"));
        } else {
            this.tree.addStartElement(this.qname("declare-step"));
        }
        Object object = hashtable.keySet().iterator();
        while (object.hasNext()) {
            String string;
            string = object.next();
            this.tree.addNamespace(string, hashtable.get(string));
        }
        if (!(node instanceof ASTLibrary) && (object = ((ASTDeclareStep)node).name) != null) {
            this.tree.addAttribute(_name, (String)object);
        }
        this.tree.addAttribute(new QName("", "version"), this.version);
        this.addAttributes(node);
        this.tree.startContent();
        this.walk(node);
        this.tree.addEndElement();
        this.tree.endDocument();
        return this.tree.getResult();
    }

    private XdmNode walkLibrary(Node node, Hashtable<String, String> hashtable) {
        throw new UnsupportedOperationException("Library not handled yet");
    }
}

