---
title: "Great House Za'lek"
---
<%
wgtfct = require("naevpedia.lore.faction").init( "Za'lek" )
%>
<widget wgtfct />

# Great House Za'lek

House Za'lek is one of the Great Houses in [the Empire](lore/factions/empire).

## Organization
<%
    leader = ""
    if player.misnDone([[Za'lek Particle Physics 6]]) then
        leader = _([[(Currently Noona Sanderaite)]])
    end
%>

* **Leader:** Za'lek Chairperson of the Board <%= leader %>
* **Leading Structure:** Za'lek Philosophical Board for the Promotion of Science
* **Government:** Stochastic Meritocracy
* **Formation:** [UST 72](lore/history)
* **Homeworld:** Ruadan Prime (Ruadan system)

## Za'lek Society

As House Za'lek was and is a gigantic think tank, its social structure leaves something to be desired.
The Za'lek half-heartedly mimic [the Empire](lore/factions/empire), with one all-important Chairman of the Board, who is naturally ignored by every other Za'lek in existence.
What passes for politics in Za'lek terms is a big room full of furious, shouting scientists, each trying to prove that their way of running the House is best, often producing charts and graphs that are indistinguishable from any other charts and graphs the Za'lek produce.

Nevertheless, the Za'lek get by, and their worlds run well enough to sustain the many research labs, observatories and computer cores that litter any Za'lek planet's surface.
The local economies are kept running by non-researchers, whose main purpose is to keep the sizable intellectual elite happy.
This seems a thankless life, but it is actually quite attractive for some, as the Za'lek seem utterly disinterested in passing law over those they consider irrelevant to progress.
Effectively, this means the normal people in Za'lek space enjoy as much freedom as anyone in the galaxy, bound only by the unreasonable demands placed on them by the Za'lek scientists, and whatever laws they impose on themselves.

The Za'lek have a standing army as is befitting a Great House, but it is unclear how they manage to maintain it.
As a general rule, Za'lek scientists don't bother with anything they consider finished and thought out, so most concepts are never put into service except for a small number of prototypes.
Nevertheless, the Za'lek possess more-or-less standardized military forces, so someone out there must be putting theory to practical use.

## History

### Project Za'lek

Project Za'lek was the second Great Project [the Empire](lore/factions/empire) called into existence.
It was felt that instead of spending a portion of [the Empire](lore/factions/empire)'s own budget to research and development, better results could be attained by dedicating one or more entire worlds to the pursuit of knowledge.
A suitable world was found near the border of Empire space, and there a new colony was built, geared solely towards scientific research.

The colony prospered, and after a few decades it was found that the planet had become too small to facilitate all the experiments and institutes necessary to meet the ever increasing flow of research proposals.
A second world was added to Project Za'lek, and soon after a third.
A few generations later, Project Za'lek had accumulated enough mass to develop a stable internal economy.
By this time the Project had produced numerous advances in almost every scientific field, so the Emperor chose to bestow on the Project the noble title of Great House.

### House Za'lek

House Za'lek continued to grow and advance.
Over time, it became the only place of consequence to be for any scientists, since [the Empire](lore/factions/empire)'s own R&D budget had all but dried up.
Gradually, the Imperial intellectual elite shifted its weight to Za'lek space.
The Empire took notice of this, but given the steady flow of research from House Za'lek under their oath of loyalty, it did not consider it a problem.

This changed when [the Empire](lore/factions/empire) was finally starved of its top minds.
Without scientists to keep up with the rapid pace of the Za'lek advancement, the Emperor found that the latest discoveries were poorly understood by his subjects, if they were understood at all.
Measures were taken to reverse the process, but the damage had been done.
House Za'lek's momentum could no longer be stopped.
Before long, all [the Empire](lore/factions/empire) was getting out of its former Great Project was a yearly file of unintelligible reports, articles and theorems, many of which used forms of mathematics the Imperial engineers had never even heard of before.
When asked to provide [the Empire](lore/factions/empire) with tangible results such as pre-produced weapons or ships, the Za'lek indignantly replied that things like manufacturing things that had been successfully prototyped were beneath them.
They could not be coaxed to change their disposition.
[The Empire](lore/factions/empire), in short, was left behind.

Over the years, House Za'lek built up an impressive technological lead.
At the same time, it became more isolated, its scientists choosing to devote their time to working on their myriad of projects rather than waste it on "the simpletons elsewhere".
The Empire in turn lost its motivation to seek gain from the Za'lek, as it became clear nobody within its borders was ever going to grasp what any of them were talking about.
House Za'lek became the equivalent of an ivory tower, forgotten by some, ignored by most.

Then, a few years before the present time, there was a change in House Za'lek that would have attracted notice had anyone been paying attention.
Though the Za'lek had always been secretive and withdrawn, they became much more so almost overnight.
The few traders who frequent Za'lek space say that while the border guard is almost unchanged, security in many other systems has been dismantled, their forces relocated to one single planet: Ruadan.
Little is known of Ruadan, other than that it is one of Za'lek's youngest worlds.
Nobody knows what goes on on its surface, as the Za'lek don't brook anyone in the system who isn't expressly authorized.
However, it is clear to anyone who will see that the Za'lek have found something, or maybe created it, and whatever this something is, they consider it extremely important.
It is unknown what they are planning, but it may well be that the universe will not like finding out...
