## RabbitMQ 3.8.17

RabbitMQ `3.8.17` is a maintenance release that includes a security patch.

### Security Patches

This release addresses an undisclosed vulnerability with CVSS 3.1 [score of 3.1](https://www.first.org/cvss/calculator/3.1#CVSS:3.1/AV:N/AC:H/PR:H/UI:R/S:U/C:L/I:L/A:N/E:P/RL:O/RC:C) (low): [CVE-2021-32718](https://github.com/rabbitmq/rabbitmq-server/security/advisories/GHSA-c3hj-rg5h-2772).

Our team would like to thank Christian Rellmann from [usd AG](https://www.usd.de/) for [responsibly disclosing](https://www.rabbitmq.com/contact.html#security)
the vulnerability and helping us verify a fix.

### Obtaining Packages

RabbitMQ releases are distributed via [GitHub](https://github.com/rabbitmq/rabbitmq-server/releases), [Cloudsmith](https://cloudsmith.io/~rabbitmq/repos/),
and [PackageCloud](https://packagecloud.io/rabbitmq).

### Erlang/OTP Compatibility Notes

This release [requires Erlang 23.2](https://www.rabbitmq.com/which-erlang.html) and [supports Erlang 24](https://blog.rabbitmq.com/posts/2021/03/erlang-24-support-roadmap/).

[Provisioning Latest Erlang Releases](https://www.rabbitmq.com/which-erlang.html#erlang-repositories) explains
what package repositories and tools can be used to provision modern Erlang versions.


## Upgrade and Compatibility Notes

See the [Upgrading guide](https://www.rabbitmq.com/upgrade.html) for general documentation on upgrades and
[RabbitMQ change log](https://www.rabbitmq.com/changelog.html) for release notes of other releases.

If upgrading from a`3.7.x` release, see [3.8.0 release notes](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.8.0)
upgrade and compatibility notes first.

If upgrading from a `3.6.x` or older [release series](https://www.rabbitmq.com/versions.html), first upgrade
to [`3.7.27`](https://github.com/rabbitmq/rabbitmq-server/releases/tag/v3.7.27) and then to this version.


## Getting Help

Any questions about this release, upgrades or RabbitMQ in general are welcome on the [RabbitMQ mailing list](https://groups.google.com/forum/#!forum/rabbitmq-users)
and [RabbitMQ community Slack](https://rabbitmq-slack.herokuapp.com/).


## Changes Worth Mentioning

### Core Server

#### Enhancements

 * Queue index efficiency improvements, mostly around peak memory consumption with large backlogs of small messages.

   Note that some of the improvements come from more optimal defaults: those will only be
   applicable to newly created virtual hosts (or new clusters).

   GitHub issues: [#2954](https://github.com/rabbitmq/rabbitmq-server/pull/2954), [#3041](https://github.com/rabbitmq/rabbitmq-server/pull/3041)

 * [Consumer delivery acknowledgement timeout](https://www.rabbitmq.com/consumers.html#acknowledgement-timeout) default has been bumped to 30 minutes (previously 15 minutes). The value
   can be overridden.

   GitHub issue: [#3033](https://github.com/rabbitmq/rabbitmq-server/pull/3033)

#### Bug Fixes

 * A classic queue with [single active consumer](https://www.rabbitmq.com/consumers.html#single-active-consumer) option enabled could run into
   an exception after a restart or initial enablement of the management plugin.

   GitHub issue: [#3072](https://github.com/rabbitmq/rabbitmq-server/issues/3072)


### Management Plugin

#### Bug Fixes

 * A combination of HTTPS (TLS) settings and advanced HTTP server settings
   resulted in an exception.

   GitHub issue: [#3039](https://github.com/rabbitmq/rabbitmq-server/pull/3039)

 * External stats collector is now restarted again if it fails for any reason.

   Contributed by @luos.

   GitHub issue: [#3040](https://github.com/rabbitmq/rabbitmq-server/pull/3040)


### Consistent History Exchange Plugin

#### Enhancements

 * When nodes are restarted, schema database tables used by this plugin are now reconciled
   with cluster peers the [same way RabbitMQ core does it](https://www.rabbitmq.com/clustering.html#restarting).

   GitHub issue: [#3067](https://github.com/rabbitmq/rabbitmq-server/pull/3067)


### Recent History Exchange Plugin

#### Enhancements

 * When nodes are restarted, schema database tables used by this plugin are now reconciled
   with cluster peers the [same way RabbitMQ core does it](https://www.rabbitmq.com/clustering.html#restarting).

   GitHub issue: [#3067](https://github.com/rabbitmq/rabbitmq-server/pull/3067)


### Delayed Message Exchange Plugin

#### Enhancements

 * When nodes are restarted, schema database tables used by this plugin are now reconciled
   with cluster peers the [same way RabbitMQ core does it](https://www.rabbitmq.com/clustering.html#restarting).

   Contributed by @mwfriedm.

   GitHub issue: [rabbitmq/rabbitmq-delayed-message-exchange#163](https://github.com/rabbitmq/rabbitmq-delayed-message-exchange/pull/163)


### Last Value Cache Exchange Plugin

#### Enhancements

 * When nodes are restarted, schema database tables used by this plugin are now reconciled
   with cluster peers the [same way RabbitMQ core does it](https://www.rabbitmq.com/clustering.html#restarting).

   GitHub issue: [rabbitmq/rabbitmq-lvc-exchange#28](https://github.com/rabbitmq/rabbitmq-lvc-exchange/issues/28)



### Web MQTT Plugin

#### Bug Fixes

 * MQTT-over-WebSockets client connections were not accounted for by the file handle tracking mechanism (metric and resource alarm).

   GitHub issue: [#3076](https://github.com/rabbitmq/rabbitmq-server/pull/3076)


## Dependency Upgrades

None in this release.


## Source Code Archives

To obtain source code of the entire distribution, please download the archive named `rabbitmq-server-3.8.17.tar.xz`
instead of the source tarball produced by GitHub.
