package testcases

import (
	"bytes"
	"testing"
)

func TestVectorContainer(t *testing.T) {
	v := &Vec{
		Values: []uint64{1, 2, 3, 4, 5, 6},
	}
	expectedHash := [32]byte{
		0xac, 0x13, 0x6e, 0xdd, 0xa3, 0xbd, 0xd2, 0xe9,
		0x49, 0xa1, 0x9a, 0x94, 0x5b, 0x1a, 0xc5, 0x54,
		0xe4, 0xb6, 0x07, 0xd3, 0x39, 0xa4, 0x3c, 0x54,
		0x0c, 0x33, 0x60, 0x98, 0xff, 0xf9, 0x7f, 0x2b,
	}
	h, err := v.HashTreeRoot()
	if err != nil {
		t.Fatal(err)
	}
	if !bytes.Equal(h[:], expectedHash[:]) {
		t.Fatalf("hash mismatch")
	}
}
