//go:build !purego

// Copyright 2020-2025 Consensys Software Inc.
// Licensed under the Apache License, Version 2.0. See the LICENSE file for details.

// Code generated by consensys/gnark-crypto DO NOT EDIT

package sis

import (
	"github.com/consensys/gnark-crypto/field/babybear"
)

// q + r'.r = 1, i.e., qInvNeg = - q⁻¹ mod r
// used for Montgomery reduction
const qInvNeg = 2013265919
const q = 2013265921

// index table used in avx512 shuffling
var vInterleaveIndices = []uint64{
	2, 3, 8, 9, 6, 7, 12, 13,
}

//go:noescape
func sisShuffle_avx512(a []babybear.Element)

//go:noescape
func sisUnshuffle_avx512(a []babybear.Element)

//go:noescape
func sis512_16_avx512(k256, cosets []babybear.Element, twiddles [][]babybear.Element, rag, res []babybear.Element)
