//go:build !purego

// Code generated by gnark-crypto/generator. DO NOT EDIT.
// Refer to the generator for more documentation.

#include "textflag.h"
#include "funcdata.h"
#include "go_asm.h"

TEXT ·permutation24_avx512(SB), NOSPLIT, $0-48
	MOVQ         $0x0000000000005555, AX
	KMOVD        AX, K3
	MOVQ         $1, AX
	KMOVQ        AX, K2
	MOVD         $const_q, AX
	VPBROADCASTD AX, Z0
	MOVD         $const_qInvNeg, AX
	VPBROADCASTD AX, Z1
	MOVQ         input+0(FP), R15
	MOVQ         roundKeys+24(FP), R14
	VMOVDQU32    0(R15), Z2
	VMOVDQU32    64(R15), Y3
	MOVQ         ·diag24+0(SB), CX
	VMOVDQU32    0(CX), Z18
	VMOVDQU32    64(CX), Y20
	VPSRLQ       $32, Z18, Z19
	VPSRLQ       $32, Y20, Y21

#define ADD(in0, in1, in2, in3, in4) \
	VPADDD  in0, in1, in4 \
	VPSUBD  in2, in4, in3 \
	VPMINUD in4, in3, in4 \

#define MAT_MUL_M4(in0, in1, in2, in3, in4, in5) \
	VPSHUFD $0x000000000000004e, in0, in1 \
	ADD(in1, in0, in4, in5, in1)          \
	VPSHUFD $0x00000000000000b1, in1, in2 \
	ADD(in1, in2, in4, in5, in1)          \
	VPSHUFD $0x0000000000000039, in0, in3 \
	VPSLLD  $1, in3, in3                  \
	VPSUBD  in4, in3, in5                 \
	VPMINUD in3, in5, in3                 \
	ADD(in0, in1, in4, in5, in0)          \
	ADD(in0, in3, in4, in5, in0)          \

#define MAT_MUL_EXTERNAL() \
	MAT_MUL_M4(Z2, Z6, Z7, Z8, Z0, Z11) \
	MAT_MUL_M4(Y3, Y6, Y7, Y8, Y0, Y11) \
	VEXTRACTI64X4 $1, Z2, Y16           \
	ADD(Y16, Y2, Y0, Y11, Y16)          \
	ADD(Y16, Y3, Y0, Y11, Y16)          \
	VSHUFF64X2    $1, Y16, Y16, Y17     \
	ADD(Y16, Y17, Y0, Y11, Y16)         \
	VINSERTI64X4  $1, Y16, Z16, Z16     \
	ADD(Y3, Y16, Y0, Y9, Y3)            \
	ADD(Z2, Z16, Z0, Z11, Z2)           \

#define MULD(in0, in1, in2, in3, in4, in5, in6, in7, in8, in9, in10) \
	VPSRLQ    $32, in0, in2  \
	VPSRLQ    $32, in1, in3  \
	VPMULUDQ  in0, in1, in4  \
	VPMULUDQ  in2, in3, in5  \
	VPMULUDQ  in4, in9, in6  \
	VPMULUDQ  in5, in9, in7  \
	VPMULUDQ  in6, in8, in6  \
	VPADDQ    in4, in6, in4  \
	VPMULUDQ  in7, in8, in7  \
	VPADDQ    in5, in7, in10 \
	VMOVSHDUP in4, K3, in10  \

#define REDUCE1Q(in0, in1, in2) \
	VPSUBD  in0, in1, in2 \
	VPMINUD in1, in2, in1 \

#define SBOX_FULL() \
	MULD(Z2, Z2, Z12, Z13, Z6, Z7, Z14, Z15, Z0, Z1, Z8) \
	REDUCE1Q(Z0, Z8, Z15)                                \
	MULD(Z8, Z8, Z12, Z13, Z6, Z7, Z14, Z15, Z0, Z1, Z9) \
	MULD(Z2, Z8, Z12, Z13, Z6, Z7, Z14, Z15, Z0, Z1, Z2) \
	MULD(Z2, Z9, Z12, Z13, Z6, Z7, Z14, Z15, Z0, Z1, Z2) \
	REDUCE1Q(Z0, Z2, Z15)                                \
	MULD(Y3, Y3, Y12, Y13, Y6, Y7, Y14, Y15, Y0, Y1, Y8) \
	REDUCE1Q(Y0, Y8, Y15)                                \
	MULD(Y8, Y8, Y12, Y13, Y6, Y7, Y14, Y15, Y0, Y1, Y9) \
	MULD(Y3, Y8, Y12, Y13, Y6, Y7, Y14, Y15, Y0, Y1, Y3) \
	MULD(Y3, Y9, Y12, Y13, Y6, Y7, Y14, Y15, Y0, Y1, Y3) \
	REDUCE1Q(Y0, Y3, Y15)                                \

#define SBOX_PARTIAL() \
	MULD(Y5, Y5, Y12, Y13, Y6, Y7, Y14, Y15, Y0, Y1, Y8) \
	REDUCE1Q(Y0, Y8, Y15)                                \
	MULD(Y8, Y8, Y12, Y13, Y6, Y7, Y14, Y15, Y0, Y1, Y9) \
	MULD(Y5, Y8, Y12, Y13, Y6, Y7, Y14, Y15, Y0, Y1, Y5) \
	MULD(Y5, Y9, Y12, Y13, Y6, Y7, Y14, Y15, Y0, Y1, Y5) \
	REDUCE1Q(Y0, Y5, Y15)                                \

#define SUM_STATE() \
	VEXTRACTI64X4 $1, Z2, Y16                   \
	ADD(Y16, Y3, Y0, Y11, Y16)                  \
	ADD(Y16, Y10, Y0, Y11, Y16)                 \
	VSHUFF64X2    $1, Y16, Y16, Y17             \
	ADD(Y16, Y17, Y0, Y11, Y16)                 \
	VPSHUFD       $0x000000000000004e, Y16, Y17 \
	ADD(Y16, Y17, Y0, Y11, Y16)                 \
	VPSHUFD       $0x00000000000000b1, Y16, Y17 \
	ADD(Y16, Y17, Y0, Y11, Y16)                 \
	VINSERTI64X4  $1, Y16, Z16, Z16             \

#define FULL_ROUND() \
	VMOVDQU32 0(BX), Z4      \
	VMOVDQU32 64(BX), Y5     \
	ADD(Z2, Z4, Z0, Z11, Z2) \
	ADD(Y3, Y5, Y0, Y8, Y3)  \
	SBOX_FULL()              \
	MAT_MUL_EXTERNAL()       \

	MAT_MUL_EXTERNAL()
	MOVQ 0(R14), BX
	FULL_ROUND()
	MOVQ 24(R14), BX
	FULL_ROUND()
	MOVQ 48(R14), BX
	FULL_ROUND()
	MOVQ 72(R14), BX
	FULL_ROUND()

	// loop over the partial rounds
	MOVQ $0x0000000000000015, SI // nb partial rounds --> 21
	MOVQ R14, DI
	ADDQ $0x0000000000000060, DI

loop_1:
	TESTQ     SI, SI
	JEQ       done_2
	DECQ      SI
	MOVQ      0(DI), BX
	VMOVD     0(BX), X4
	VMOVDQA32 Z2, Z10
	ADD(X10, X4, X0, X14, X5)
	SBOX_PARTIAL()
	VPBLENDMD Z5, Z10, K2, Z10
	VPSRLQ    $32, Y3, Y12
	VPMULUDQ  Y3, Y20, Y6
	VPMULUDQ  Y12, Y21, Y7
	VPMULUDQ  Y6, Y1, Y14
	VPMULUDQ  Y7, Y1, Y15
	VPMULUDQ  Y14, Y0, Y14
	VPADDQ    Y6, Y14, Y6
	VPMULUDQ  Y15, Y0, Y15
	VPADDQ    Y7, Y15, Y9
	VMOVSHDUP Y6, K3, Y9
	VPSUBD    Y0, Y9, Y11
	VPMINUD   Y9, Y11, Y9
	VPSRLQ    $32, Z2, Z12
	VPMULUDQ  Z12, Z19, Z8
	VPMULUDQ  Z8, Z1, Z15
	VPMULUDQ  Z15, Z0, Z15
	VPADDQ    Z8, Z15, Z8
	SUM_STATE()
	VPMULUDQ  Z10, Z18, Z6
	VPMULUDQ  Z6, Z1, Z14
	VPMULUDQ  Z14, Z0, Z14
	VPADDQ    Z6, Z14, Z6
	VMOVSHDUP Z6, K3, Z8
	VPSUBD    Z0, Z8, Z11
	VPMINUD   Z8, Z11, Z2
	ADD(Z2, Z16, Z0, Z11, Z2)
	ADD(Y9, Y16, Y0, Y5, Y3)
	ADDQ      $24, DI
	JMP       loop_1

done_2:
	MOVQ      600(R14), BX
	FULL_ROUND()
	MOVQ      624(R14), BX
	FULL_ROUND()
	MOVQ      648(R14), BX
	FULL_ROUND()
	MOVQ      672(R14), BX
	FULL_ROUND()
	VMOVDQU32 Z2, 0(R15)
	VMOVDQU32 Y3, 64(R15)
	RET

TEXT ·permutation16x24_avx512(SB), NOSPLIT, $0-32
	MOVD         $const_q, AX
	VPBROADCASTD AX, Z24
	MOVD         $const_qInvNeg, AX
	VPBROADCASTD AX, Z25
	MOVQ         $0x0000000000005555, AX
	KMOVD        AX, K3
	MOVQ         input+0(FP), R15
	MOVQ         roundKeys+8(FP), R14
	VMOVDQU32    0(R15), Z0
	VMOVDQU32    64(R15), Z1
	VMOVDQU32    128(R15), Z2
	VMOVDQU32    192(R15), Z3
	VMOVDQU32    256(R15), Z4
	VMOVDQU32    320(R15), Z5
	VMOVDQU32    384(R15), Z6
	VMOVDQU32    448(R15), Z7
	VMOVDQU32    512(R15), Z8
	VMOVDQU32    576(R15), Z9
	VMOVDQU32    640(R15), Z10
	VMOVDQU32    704(R15), Z11
	VMOVDQU32    768(R15), Z12
	VMOVDQU32    832(R15), Z13
	VMOVDQU32    896(R15), Z14
	VMOVDQU32    960(R15), Z15
	VMOVDQU32    1024(R15), Z16
	VMOVDQU32    1088(R15), Z17
	VMOVDQU32    1152(R15), Z18
	VMOVDQU32    1216(R15), Z19
	VMOVDQU32    1280(R15), Z20
	VMOVDQU32    1344(R15), Z21
	VMOVDQU32    1408(R15), Z22
	VMOVDQU32    1472(R15), Z23
	ADD(Z0, Z1, Z24, Z31, Z26)
	ADD(Z2, Z3, Z24, Z31, Z27)
	ADD(Z26, Z27, Z24, Z31, Z28)
	ADD(Z28, Z1, Z24, Z31, Z29)
	ADD(Z28, Z3, Z24, Z31, Z30)

#define DOUBLE(in0, in1, in2, in3) \
	VPSLLD  $1, in0, in3  \
	VPSUBD  in1, in3, in2 \
	VPMINUD in3, in2, in3 \

	DOUBLE(Z0, Z24, Z31, Z3)
	ADD(Z3, Z30, Z24, Z31, Z3)
	DOUBLE(Z2, Z24, Z31, Z1)
	ADD(Z1, Z29, Z24, Z31, Z1)
	ADD(Z26, Z29, Z24, Z31, Z0)
	ADD(Z27, Z30, Z24, Z31, Z2)
	ADD(Z4, Z5, Z24, Z31, Z26)
	ADD(Z6, Z7, Z24, Z31, Z27)
	ADD(Z26, Z27, Z24, Z31, Z28)
	ADD(Z28, Z5, Z24, Z31, Z29)
	ADD(Z28, Z7, Z24, Z31, Z30)
	DOUBLE(Z4, Z24, Z31, Z7)
	ADD(Z7, Z30, Z24, Z31, Z7)
	DOUBLE(Z6, Z24, Z31, Z5)
	ADD(Z5, Z29, Z24, Z31, Z5)
	ADD(Z26, Z29, Z24, Z31, Z4)
	ADD(Z27, Z30, Z24, Z31, Z6)
	ADD(Z8, Z9, Z24, Z31, Z26)
	ADD(Z10, Z11, Z24, Z31, Z27)
	ADD(Z26, Z27, Z24, Z31, Z28)
	ADD(Z28, Z9, Z24, Z31, Z29)
	ADD(Z28, Z11, Z24, Z31, Z30)
	DOUBLE(Z8, Z24, Z31, Z11)
	ADD(Z11, Z30, Z24, Z31, Z11)
	DOUBLE(Z10, Z24, Z31, Z9)
	ADD(Z9, Z29, Z24, Z31, Z9)
	ADD(Z26, Z29, Z24, Z31, Z8)
	ADD(Z27, Z30, Z24, Z31, Z10)
	ADD(Z12, Z13, Z24, Z31, Z26)
	ADD(Z14, Z15, Z24, Z31, Z27)
	ADD(Z26, Z27, Z24, Z31, Z28)
	ADD(Z28, Z13, Z24, Z31, Z29)
	ADD(Z28, Z15, Z24, Z31, Z30)
	DOUBLE(Z12, Z24, Z31, Z15)
	ADD(Z15, Z30, Z24, Z31, Z15)
	DOUBLE(Z14, Z24, Z31, Z13)
	ADD(Z13, Z29, Z24, Z31, Z13)
	ADD(Z26, Z29, Z24, Z31, Z12)
	ADD(Z27, Z30, Z24, Z31, Z14)
	ADD(Z16, Z17, Z24, Z31, Z26)
	ADD(Z18, Z19, Z24, Z31, Z27)
	ADD(Z26, Z27, Z24, Z31, Z28)
	ADD(Z28, Z17, Z24, Z31, Z29)
	ADD(Z28, Z19, Z24, Z31, Z30)
	DOUBLE(Z16, Z24, Z31, Z19)
	ADD(Z19, Z30, Z24, Z31, Z19)
	DOUBLE(Z18, Z24, Z31, Z17)
	ADD(Z17, Z29, Z24, Z31, Z17)
	ADD(Z26, Z29, Z24, Z31, Z16)
	ADD(Z27, Z30, Z24, Z31, Z18)
	ADD(Z20, Z21, Z24, Z31, Z26)
	ADD(Z22, Z23, Z24, Z31, Z27)
	ADD(Z26, Z27, Z24, Z31, Z28)
	ADD(Z28, Z21, Z24, Z31, Z29)
	ADD(Z28, Z23, Z24, Z31, Z30)
	DOUBLE(Z20, Z24, Z31, Z23)
	ADD(Z23, Z30, Z24, Z31, Z23)
	DOUBLE(Z22, Z24, Z31, Z21)
	ADD(Z21, Z29, Z24, Z31, Z21)
	ADD(Z26, Z29, Z24, Z31, Z20)
	ADD(Z27, Z30, Z24, Z31, Z22)
	ADD(Z0, Z4, Z24, Z29, Z31)
	ADD(Z1, Z5, Z24, Z30, Z26)
	ADD(Z2, Z6, Z24, Z29, Z27)
	ADD(Z3, Z7, Z24, Z30, Z28)
	ADD(Z8, Z31, Z24, Z29, Z31)
	ADD(Z9, Z26, Z24, Z30, Z26)
	ADD(Z10, Z27, Z24, Z29, Z27)
	ADD(Z11, Z28, Z24, Z30, Z28)
	ADD(Z12, Z31, Z24, Z29, Z31)
	ADD(Z13, Z26, Z24, Z30, Z26)
	ADD(Z14, Z27, Z24, Z29, Z27)
	ADD(Z15, Z28, Z24, Z30, Z28)
	ADD(Z16, Z31, Z24, Z29, Z31)
	ADD(Z17, Z26, Z24, Z30, Z26)
	ADD(Z18, Z27, Z24, Z29, Z27)
	ADD(Z19, Z28, Z24, Z30, Z28)
	ADD(Z20, Z31, Z24, Z29, Z31)
	ADD(Z21, Z26, Z24, Z30, Z26)
	ADD(Z22, Z27, Z24, Z29, Z27)
	ADD(Z23, Z28, Z24, Z30, Z28)
	ADD(Z0, Z31, Z24, Z29, Z0)
	ADD(Z1, Z26, Z24, Z30, Z1)
	ADD(Z2, Z27, Z24, Z29, Z2)
	ADD(Z3, Z28, Z24, Z30, Z3)
	ADD(Z4, Z31, Z24, Z29, Z4)
	ADD(Z5, Z26, Z24, Z30, Z5)
	ADD(Z6, Z27, Z24, Z29, Z6)
	ADD(Z7, Z28, Z24, Z30, Z7)
	ADD(Z8, Z31, Z24, Z29, Z8)
	ADD(Z9, Z26, Z24, Z30, Z9)
	ADD(Z10, Z27, Z24, Z29, Z10)
	ADD(Z11, Z28, Z24, Z30, Z11)
	ADD(Z12, Z31, Z24, Z29, Z12)
	ADD(Z13, Z26, Z24, Z30, Z13)
	ADD(Z14, Z27, Z24, Z29, Z14)
	ADD(Z15, Z28, Z24, Z30, Z15)
	ADD(Z16, Z31, Z24, Z29, Z16)
	ADD(Z17, Z26, Z24, Z30, Z17)
	ADD(Z18, Z27, Z24, Z29, Z18)
	ADD(Z19, Z28, Z24, Z30, Z19)
	ADD(Z20, Z31, Z24, Z29, Z20)
	ADD(Z21, Z26, Z24, Z30, Z21)
	ADD(Z22, Z27, Z24, Z29, Z22)
	ADD(Z23, Z28, Z24, Z30, Z23)

	// loop over the first full rounds
	MOVQ $0x0000000000000004, BX

loop_3:
	TESTQ        BX, BX
	JEQ          done_4
	DECQ         BX
	MOVQ         0(R14), CX
	VPBROADCASTD 0(CX), Z29
	ADD(Z0, Z29, Z24, Z30, Z0)

#define MUL_W(in0, in1, in2, in3, in4, in5, in6) \
	VPSRLQ    $32, in0, in2 \
	VPSRLQ    $32, in1, in3 \
	VPMULUDQ  in0, in1, in4 \
	VPMULUDQ  in2, in3, in5 \
	VPMULUDQ  in4, Z25, in2 \
	VPMULUDQ  in5, Z25, in3 \
	VPMULUDQ  in2, Z24, in2 \
	VPADDQ    in4, in2, in4 \
	VPMULUDQ  in3, Z24, in3 \
	VPADDQ    in5, in3, in6 \
	VMOVSHDUP in4, K3, in6  \

	MUL_W(Z0, Z0, Z27, Z28, Z30, Z29, Z31)
	REDUCE1Q(Z24, Z31, Z27)
	MUL_W(Z31, Z31, Z28, Z30, Z29, Z27, Z26)
	MUL_W(Z0, Z26, Z28, Z30, Z29, Z27, Z0)
	MUL_W(Z0, Z31, Z28, Z30, Z29, Z27, Z0)
	REDUCE1Q(Z24, Z0, Z28)
	VPBROADCASTD 4(CX), Z30
	ADD(Z1, Z30, Z24, Z29, Z1)
	MUL_W(Z1, Z1, Z31, Z26, Z29, Z30, Z27)
	REDUCE1Q(Z24, Z27, Z31)
	MUL_W(Z27, Z27, Z26, Z29, Z30, Z31, Z28)
	MUL_W(Z1, Z28, Z26, Z29, Z30, Z31, Z1)
	MUL_W(Z1, Z27, Z26, Z29, Z30, Z31, Z1)
	REDUCE1Q(Z24, Z1, Z26)
	VPBROADCASTD 8(CX), Z29
	ADD(Z2, Z29, Z24, Z30, Z2)
	MUL_W(Z2, Z2, Z27, Z28, Z30, Z29, Z31)
	REDUCE1Q(Z24, Z31, Z27)
	MUL_W(Z31, Z31, Z28, Z30, Z29, Z27, Z26)
	MUL_W(Z2, Z26, Z28, Z30, Z29, Z27, Z2)
	MUL_W(Z2, Z31, Z28, Z30, Z29, Z27, Z2)
	REDUCE1Q(Z24, Z2, Z28)
	VPBROADCASTD 12(CX), Z30
	ADD(Z3, Z30, Z24, Z29, Z3)
	MUL_W(Z3, Z3, Z31, Z26, Z29, Z30, Z27)
	REDUCE1Q(Z24, Z27, Z31)
	MUL_W(Z27, Z27, Z26, Z29, Z30, Z31, Z28)
	MUL_W(Z3, Z28, Z26, Z29, Z30, Z31, Z3)
	MUL_W(Z3, Z27, Z26, Z29, Z30, Z31, Z3)
	REDUCE1Q(Z24, Z3, Z26)
	VPBROADCASTD 16(CX), Z29
	ADD(Z4, Z29, Z24, Z30, Z4)
	MUL_W(Z4, Z4, Z27, Z28, Z30, Z29, Z31)
	REDUCE1Q(Z24, Z31, Z27)
	MUL_W(Z31, Z31, Z28, Z30, Z29, Z27, Z26)
	MUL_W(Z4, Z26, Z28, Z30, Z29, Z27, Z4)
	MUL_W(Z4, Z31, Z28, Z30, Z29, Z27, Z4)
	REDUCE1Q(Z24, Z4, Z28)
	VPBROADCASTD 20(CX), Z30
	ADD(Z5, Z30, Z24, Z29, Z5)
	MUL_W(Z5, Z5, Z31, Z26, Z29, Z30, Z27)
	REDUCE1Q(Z24, Z27, Z31)
	MUL_W(Z27, Z27, Z26, Z29, Z30, Z31, Z28)
	MUL_W(Z5, Z28, Z26, Z29, Z30, Z31, Z5)
	MUL_W(Z5, Z27, Z26, Z29, Z30, Z31, Z5)
	REDUCE1Q(Z24, Z5, Z26)
	VPBROADCASTD 24(CX), Z29
	ADD(Z6, Z29, Z24, Z30, Z6)
	MUL_W(Z6, Z6, Z27, Z28, Z30, Z29, Z31)
	REDUCE1Q(Z24, Z31, Z27)
	MUL_W(Z31, Z31, Z28, Z30, Z29, Z27, Z26)
	MUL_W(Z6, Z26, Z28, Z30, Z29, Z27, Z6)
	MUL_W(Z6, Z31, Z28, Z30, Z29, Z27, Z6)
	REDUCE1Q(Z24, Z6, Z28)
	VPBROADCASTD 28(CX), Z30
	ADD(Z7, Z30, Z24, Z29, Z7)
	MUL_W(Z7, Z7, Z31, Z26, Z29, Z30, Z27)
	REDUCE1Q(Z24, Z27, Z31)
	MUL_W(Z27, Z27, Z26, Z29, Z30, Z31, Z28)
	MUL_W(Z7, Z28, Z26, Z29, Z30, Z31, Z7)
	MUL_W(Z7, Z27, Z26, Z29, Z30, Z31, Z7)
	REDUCE1Q(Z24, Z7, Z26)
	VPBROADCASTD 32(CX), Z29
	ADD(Z8, Z29, Z24, Z30, Z8)
	MUL_W(Z8, Z8, Z27, Z28, Z30, Z29, Z31)
	REDUCE1Q(Z24, Z31, Z27)
	MUL_W(Z31, Z31, Z28, Z30, Z29, Z27, Z26)
	MUL_W(Z8, Z26, Z28, Z30, Z29, Z27, Z8)
	MUL_W(Z8, Z31, Z28, Z30, Z29, Z27, Z8)
	REDUCE1Q(Z24, Z8, Z28)
	VPBROADCASTD 36(CX), Z30
	ADD(Z9, Z30, Z24, Z29, Z9)
	MUL_W(Z9, Z9, Z31, Z26, Z29, Z30, Z27)
	REDUCE1Q(Z24, Z27, Z31)
	MUL_W(Z27, Z27, Z26, Z29, Z30, Z31, Z28)
	MUL_W(Z9, Z28, Z26, Z29, Z30, Z31, Z9)
	MUL_W(Z9, Z27, Z26, Z29, Z30, Z31, Z9)
	REDUCE1Q(Z24, Z9, Z26)
	VPBROADCASTD 40(CX), Z29
	ADD(Z10, Z29, Z24, Z30, Z10)
	MUL_W(Z10, Z10, Z27, Z28, Z30, Z29, Z31)
	REDUCE1Q(Z24, Z31, Z27)
	MUL_W(Z31, Z31, Z28, Z30, Z29, Z27, Z26)
	MUL_W(Z10, Z26, Z28, Z30, Z29, Z27, Z10)
	MUL_W(Z10, Z31, Z28, Z30, Z29, Z27, Z10)
	REDUCE1Q(Z24, Z10, Z28)
	VPBROADCASTD 44(CX), Z30
	ADD(Z11, Z30, Z24, Z29, Z11)
	MUL_W(Z11, Z11, Z31, Z26, Z29, Z30, Z27)
	REDUCE1Q(Z24, Z27, Z31)
	MUL_W(Z27, Z27, Z26, Z29, Z30, Z31, Z28)
	MUL_W(Z11, Z28, Z26, Z29, Z30, Z31, Z11)
	MUL_W(Z11, Z27, Z26, Z29, Z30, Z31, Z11)
	REDUCE1Q(Z24, Z11, Z26)
	VPBROADCASTD 48(CX), Z29
	ADD(Z12, Z29, Z24, Z30, Z12)
	MUL_W(Z12, Z12, Z27, Z28, Z30, Z29, Z31)
	REDUCE1Q(Z24, Z31, Z27)
	MUL_W(Z31, Z31, Z28, Z30, Z29, Z27, Z26)
	MUL_W(Z12, Z26, Z28, Z30, Z29, Z27, Z12)
	MUL_W(Z12, Z31, Z28, Z30, Z29, Z27, Z12)
	REDUCE1Q(Z24, Z12, Z28)
	VPBROADCASTD 52(CX), Z30
	ADD(Z13, Z30, Z24, Z29, Z13)
	MUL_W(Z13, Z13, Z31, Z26, Z29, Z30, Z27)
	REDUCE1Q(Z24, Z27, Z31)
	MUL_W(Z27, Z27, Z26, Z29, Z30, Z31, Z28)
	MUL_W(Z13, Z28, Z26, Z29, Z30, Z31, Z13)
	MUL_W(Z13, Z27, Z26, Z29, Z30, Z31, Z13)
	REDUCE1Q(Z24, Z13, Z26)
	VPBROADCASTD 56(CX), Z29
	ADD(Z14, Z29, Z24, Z30, Z14)
	MUL_W(Z14, Z14, Z27, Z28, Z30, Z29, Z31)
	REDUCE1Q(Z24, Z31, Z27)
	MUL_W(Z31, Z31, Z28, Z30, Z29, Z27, Z26)
	MUL_W(Z14, Z26, Z28, Z30, Z29, Z27, Z14)
	MUL_W(Z14, Z31, Z28, Z30, Z29, Z27, Z14)
	REDUCE1Q(Z24, Z14, Z28)
	VPBROADCASTD 60(CX), Z30
	ADD(Z15, Z30, Z24, Z29, Z15)
	MUL_W(Z15, Z15, Z31, Z26, Z29, Z30, Z27)
	REDUCE1Q(Z24, Z27, Z31)
	MUL_W(Z27, Z27, Z26, Z29, Z30, Z31, Z28)
	MUL_W(Z15, Z28, Z26, Z29, Z30, Z31, Z15)
	MUL_W(Z15, Z27, Z26, Z29, Z30, Z31, Z15)
	REDUCE1Q(Z24, Z15, Z26)
	VPBROADCASTD 64(CX), Z29
	ADD(Z16, Z29, Z24, Z30, Z16)
	MUL_W(Z16, Z16, Z27, Z28, Z30, Z29, Z31)
	REDUCE1Q(Z24, Z31, Z27)
	MUL_W(Z31, Z31, Z28, Z30, Z29, Z27, Z26)
	MUL_W(Z16, Z26, Z28, Z30, Z29, Z27, Z16)
	MUL_W(Z16, Z31, Z28, Z30, Z29, Z27, Z16)
	REDUCE1Q(Z24, Z16, Z28)
	VPBROADCASTD 68(CX), Z30
	ADD(Z17, Z30, Z24, Z29, Z17)
	MUL_W(Z17, Z17, Z31, Z26, Z29, Z30, Z27)
	REDUCE1Q(Z24, Z27, Z31)
	MUL_W(Z27, Z27, Z26, Z29, Z30, Z31, Z28)
	MUL_W(Z17, Z28, Z26, Z29, Z30, Z31, Z17)
	MUL_W(Z17, Z27, Z26, Z29, Z30, Z31, Z17)
	REDUCE1Q(Z24, Z17, Z26)
	VPBROADCASTD 72(CX), Z29
	ADD(Z18, Z29, Z24, Z30, Z18)
	MUL_W(Z18, Z18, Z27, Z28, Z30, Z29, Z31)
	REDUCE1Q(Z24, Z31, Z27)
	MUL_W(Z31, Z31, Z28, Z30, Z29, Z27, Z26)
	MUL_W(Z18, Z26, Z28, Z30, Z29, Z27, Z18)
	MUL_W(Z18, Z31, Z28, Z30, Z29, Z27, Z18)
	REDUCE1Q(Z24, Z18, Z28)
	VPBROADCASTD 76(CX), Z30
	ADD(Z19, Z30, Z24, Z29, Z19)
	MUL_W(Z19, Z19, Z31, Z26, Z29, Z30, Z27)
	REDUCE1Q(Z24, Z27, Z31)
	MUL_W(Z27, Z27, Z26, Z29, Z30, Z31, Z28)
	MUL_W(Z19, Z28, Z26, Z29, Z30, Z31, Z19)
	MUL_W(Z19, Z27, Z26, Z29, Z30, Z31, Z19)
	REDUCE1Q(Z24, Z19, Z26)
	VPBROADCASTD 80(CX), Z29
	ADD(Z20, Z29, Z24, Z30, Z20)
	MUL_W(Z20, Z20, Z27, Z28, Z30, Z29, Z31)
	REDUCE1Q(Z24, Z31, Z27)
	MUL_W(Z31, Z31, Z28, Z30, Z29, Z27, Z26)
	MUL_W(Z20, Z26, Z28, Z30, Z29, Z27, Z20)
	MUL_W(Z20, Z31, Z28, Z30, Z29, Z27, Z20)
	REDUCE1Q(Z24, Z20, Z28)
	VPBROADCASTD 84(CX), Z30
	ADD(Z21, Z30, Z24, Z29, Z21)
	MUL_W(Z21, Z21, Z31, Z26, Z29, Z30, Z27)
	REDUCE1Q(Z24, Z27, Z31)
	MUL_W(Z27, Z27, Z26, Z29, Z30, Z31, Z28)
	MUL_W(Z21, Z28, Z26, Z29, Z30, Z31, Z21)
	MUL_W(Z21, Z27, Z26, Z29, Z30, Z31, Z21)
	REDUCE1Q(Z24, Z21, Z26)
	VPBROADCASTD 88(CX), Z29
	ADD(Z22, Z29, Z24, Z30, Z22)
	MUL_W(Z22, Z22, Z27, Z28, Z30, Z29, Z31)
	REDUCE1Q(Z24, Z31, Z27)
	MUL_W(Z31, Z31, Z28, Z30, Z29, Z27, Z26)
	MUL_W(Z22, Z26, Z28, Z30, Z29, Z27, Z22)
	MUL_W(Z22, Z31, Z28, Z30, Z29, Z27, Z22)
	REDUCE1Q(Z24, Z22, Z28)
	VPBROADCASTD 92(CX), Z30
	ADD(Z23, Z30, Z24, Z29, Z23)
	MUL_W(Z23, Z23, Z31, Z26, Z29, Z30, Z27)
	REDUCE1Q(Z24, Z27, Z31)
	MUL_W(Z27, Z27, Z26, Z29, Z30, Z31, Z28)
	MUL_W(Z23, Z28, Z26, Z29, Z30, Z31, Z23)
	MUL_W(Z23, Z27, Z26, Z29, Z30, Z31, Z23)
	REDUCE1Q(Z24, Z23, Z26)
	ADD(Z0, Z1, Z24, Z28, Z29)
	ADD(Z2, Z3, Z24, Z28, Z30)
	ADD(Z29, Z30, Z24, Z28, Z31)
	ADD(Z31, Z1, Z24, Z28, Z26)
	ADD(Z31, Z3, Z24, Z28, Z27)
	DOUBLE(Z0, Z24, Z28, Z3)
	ADD(Z3, Z27, Z24, Z28, Z3)
	DOUBLE(Z2, Z24, Z28, Z1)
	ADD(Z1, Z26, Z24, Z28, Z1)
	ADD(Z29, Z26, Z24, Z28, Z0)
	ADD(Z30, Z27, Z24, Z28, Z2)
	ADD(Z4, Z5, Z24, Z28, Z29)
	ADD(Z6, Z7, Z24, Z28, Z30)
	ADD(Z29, Z30, Z24, Z28, Z31)
	ADD(Z31, Z5, Z24, Z28, Z26)
	ADD(Z31, Z7, Z24, Z28, Z27)
	DOUBLE(Z4, Z24, Z28, Z7)
	ADD(Z7, Z27, Z24, Z28, Z7)
	DOUBLE(Z6, Z24, Z28, Z5)
	ADD(Z5, Z26, Z24, Z28, Z5)
	ADD(Z29, Z26, Z24, Z28, Z4)
	ADD(Z30, Z27, Z24, Z28, Z6)
	ADD(Z8, Z9, Z24, Z28, Z29)
	ADD(Z10, Z11, Z24, Z28, Z30)
	ADD(Z29, Z30, Z24, Z28, Z31)
	ADD(Z31, Z9, Z24, Z28, Z26)
	ADD(Z31, Z11, Z24, Z28, Z27)
	DOUBLE(Z8, Z24, Z28, Z11)
	ADD(Z11, Z27, Z24, Z28, Z11)
	DOUBLE(Z10, Z24, Z28, Z9)
	ADD(Z9, Z26, Z24, Z28, Z9)
	ADD(Z29, Z26, Z24, Z28, Z8)
	ADD(Z30, Z27, Z24, Z28, Z10)
	ADD(Z12, Z13, Z24, Z28, Z29)
	ADD(Z14, Z15, Z24, Z28, Z30)
	ADD(Z29, Z30, Z24, Z28, Z31)
	ADD(Z31, Z13, Z24, Z28, Z26)
	ADD(Z31, Z15, Z24, Z28, Z27)
	DOUBLE(Z12, Z24, Z28, Z15)
	ADD(Z15, Z27, Z24, Z28, Z15)
	DOUBLE(Z14, Z24, Z28, Z13)
	ADD(Z13, Z26, Z24, Z28, Z13)
	ADD(Z29, Z26, Z24, Z28, Z12)
	ADD(Z30, Z27, Z24, Z28, Z14)
	ADD(Z16, Z17, Z24, Z28, Z29)
	ADD(Z18, Z19, Z24, Z28, Z30)
	ADD(Z29, Z30, Z24, Z28, Z31)
	ADD(Z31, Z17, Z24, Z28, Z26)
	ADD(Z31, Z19, Z24, Z28, Z27)
	DOUBLE(Z16, Z24, Z28, Z19)
	ADD(Z19, Z27, Z24, Z28, Z19)
	DOUBLE(Z18, Z24, Z28, Z17)
	ADD(Z17, Z26, Z24, Z28, Z17)
	ADD(Z29, Z26, Z24, Z28, Z16)
	ADD(Z30, Z27, Z24, Z28, Z18)
	ADD(Z20, Z21, Z24, Z28, Z29)
	ADD(Z22, Z23, Z24, Z28, Z30)
	ADD(Z29, Z30, Z24, Z28, Z31)
	ADD(Z31, Z21, Z24, Z28, Z26)
	ADD(Z31, Z23, Z24, Z28, Z27)
	DOUBLE(Z20, Z24, Z28, Z23)
	ADD(Z23, Z27, Z24, Z28, Z23)
	DOUBLE(Z22, Z24, Z28, Z21)
	ADD(Z21, Z26, Z24, Z28, Z21)
	ADD(Z29, Z26, Z24, Z28, Z20)
	ADD(Z30, Z27, Z24, Z28, Z22)
	ADD(Z0, Z4, Z24, Z26, Z28)
	ADD(Z1, Z5, Z24, Z27, Z29)
	ADD(Z2, Z6, Z24, Z26, Z30)
	ADD(Z3, Z7, Z24, Z27, Z31)
	ADD(Z8, Z28, Z24, Z26, Z28)
	ADD(Z9, Z29, Z24, Z27, Z29)
	ADD(Z10, Z30, Z24, Z26, Z30)
	ADD(Z11, Z31, Z24, Z27, Z31)
	ADD(Z12, Z28, Z24, Z26, Z28)
	ADD(Z13, Z29, Z24, Z27, Z29)
	ADD(Z14, Z30, Z24, Z26, Z30)
	ADD(Z15, Z31, Z24, Z27, Z31)
	ADD(Z16, Z28, Z24, Z26, Z28)
	ADD(Z17, Z29, Z24, Z27, Z29)
	ADD(Z18, Z30, Z24, Z26, Z30)
	ADD(Z19, Z31, Z24, Z27, Z31)
	ADD(Z20, Z28, Z24, Z26, Z28)
	ADD(Z21, Z29, Z24, Z27, Z29)
	ADD(Z22, Z30, Z24, Z26, Z30)
	ADD(Z23, Z31, Z24, Z27, Z31)
	ADD(Z0, Z28, Z24, Z26, Z0)
	ADD(Z1, Z29, Z24, Z27, Z1)
	ADD(Z2, Z30, Z24, Z26, Z2)
	ADD(Z3, Z31, Z24, Z27, Z3)
	ADD(Z4, Z28, Z24, Z26, Z4)
	ADD(Z5, Z29, Z24, Z27, Z5)
	ADD(Z6, Z30, Z24, Z26, Z6)
	ADD(Z7, Z31, Z24, Z27, Z7)
	ADD(Z8, Z28, Z24, Z26, Z8)
	ADD(Z9, Z29, Z24, Z27, Z9)
	ADD(Z10, Z30, Z24, Z26, Z10)
	ADD(Z11, Z31, Z24, Z27, Z11)
	ADD(Z12, Z28, Z24, Z26, Z12)
	ADD(Z13, Z29, Z24, Z27, Z13)
	ADD(Z14, Z30, Z24, Z26, Z14)
	ADD(Z15, Z31, Z24, Z27, Z15)
	ADD(Z16, Z28, Z24, Z26, Z16)
	ADD(Z17, Z29, Z24, Z27, Z17)
	ADD(Z18, Z30, Z24, Z26, Z18)
	ADD(Z19, Z31, Z24, Z27, Z19)
	ADD(Z20, Z28, Z24, Z26, Z20)
	ADD(Z21, Z29, Z24, Z27, Z21)
	ADD(Z22, Z30, Z24, Z26, Z22)
	ADD(Z23, Z31, Z24, Z27, Z23)
	ADDQ         $24, R14
	JMP          loop_3

done_4:
	// loop over the partial rounds
	MOVQ $0x0000000000000015, SI

loop_5:
	TESTQ        SI, SI
	JEQ          done_6
	DECQ         SI
	MOVQ         0(R14), CX
	VPBROADCASTD 0(CX), Z26
	ADD(Z0, Z26, Z24, Z27, Z0)
	MUL_W(Z0, Z0, Z30, Z31, Z27, Z26, Z28)
	REDUCE1Q(Z24, Z28, Z30)
	MUL_W(Z28, Z28, Z31, Z27, Z26, Z30, Z29)
	MUL_W(Z0, Z29, Z31, Z27, Z26, Z30, Z0)
	MUL_W(Z0, Z28, Z31, Z27, Z26, Z30, Z0)
	REDUCE1Q(Z24, Z0, Z31)
	ADD(Z0, Z1, Z24, Z29, Z30)
	ADD(Z2, Z3, Z24, Z29, Z31)
	ADD(Z4, Z5, Z24, Z29, Z28)
	ADD(Z6, Z7, Z24, Z29, Z27)
	ADD(Z8, Z30, Z24, Z29, Z30)
	ADD(Z9, Z31, Z24, Z29, Z31)
	ADD(Z10, Z28, Z24, Z29, Z28)
	ADD(Z11, Z27, Z24, Z29, Z27)
	ADD(Z12, Z30, Z24, Z29, Z30)
	ADD(Z13, Z31, Z24, Z29, Z31)
	ADD(Z14, Z28, Z24, Z29, Z28)
	ADD(Z15, Z27, Z24, Z29, Z27)
	ADD(Z16, Z30, Z24, Z29, Z30)
	ADD(Z17, Z31, Z24, Z29, Z31)
	ADD(Z18, Z28, Z24, Z29, Z28)
	ADD(Z19, Z27, Z24, Z29, Z27)
	ADD(Z20, Z30, Z24, Z29, Z30)
	ADD(Z21, Z31, Z24, Z29, Z31)
	ADD(Z22, Z28, Z24, Z29, Z28)
	ADD(Z23, Z27, Z24, Z29, Z27)
	ADD(Z30, Z31, Z24, Z29, Z30)
	ADD(Z28, Z27, Z24, Z29, Z28)
	ADD(Z30, Z28, Z24, Z29, Z27)
	DOUBLE(Z0, Z24, Z29, Z0)
	DOUBLE(Z2, Z24, Z29, Z2)

#define HALVE(in0, in1) \
	MOVD         $1, AX            \
	VPBROADCASTD AX, in1           \
	VPTESTMD     in0, in1, K4      \
	VPADDD       in0, Z24, K4, in0 \
	VPSRLD       $1, in0, in0      \

	HALVE(Z3, Z29)
	HALVE(Z6, Z29)
	DOUBLE(Z4, Z24, Z29, Z30)
	ADD(Z4, Z30, Z24, Z29, Z4)
	DOUBLE(Z5, Z24, Z29, Z5)
	DOUBLE(Z5, Z24, Z29, Z5)
	DOUBLE(Z7, Z24, Z29, Z26)
	ADD(Z7, Z26, Z24, Z29, Z7)
	DOUBLE(Z8, Z24, Z29, Z8)
	DOUBLE(Z8, Z24, Z29, Z8)

#define MUL_2_EXP_NEG_N(in0, in1, in2, in3, in4, in5, in6, in7, in8) \
	VPSRLQ    $32, in0, in6 \
	VPSLLQ    $32, in0, in0 \
	VPSRLQ    in2, in0, in4 \
	VPSLLQ    in3, in6, in5 \
	VPMULUDQ  in4, Z25, in7 \
	VPMULUDQ  in5, Z25, in8 \
	VPMULUDQ  in7, Z24, in7 \
	VPADDQ    in4, in7, in4 \
	VPMULUDQ  in8, Z24, in8 \
	VPADDQ    in5, in8, in1 \
	VMOVSHDUP in4, K3, in1  \
	VPSUBD    Z24, in1, in8 \
	VPMINUD   in1, in8, in1 \

	MUL_2_EXP_NEG_N(Z9, Z9, $8, $24, Z29, Z26, Z30, Z31, Z28)
	MUL_2_EXP_NEG_N(Z10, Z10, $2, $30, Z29, Z26, Z30, Z31, Z28)
	MUL_2_EXP_NEG_N(Z11, Z11, $3, $29, Z29, Z26, Z30, Z31, Z28)
	MUL_2_EXP_NEG_N(Z12, Z12, $4, $28, Z29, Z26, Z30, Z31, Z28)
	MUL_2_EXP_NEG_N(Z13, Z13, $7, $25, Z29, Z26, Z30, Z31, Z28)
	MUL_2_EXP_NEG_N(Z14, Z14, $9, $23, Z29, Z26, Z30, Z31, Z28)
	MUL_2_EXP_NEG_N(Z15, Z15, $27, $5, Z29, Z26, Z30, Z31, Z28)
	MUL_2_EXP_NEG_N(Z16, Z16, $8, $24, Z29, Z26, Z30, Z31, Z28)
	MUL_2_EXP_NEG_N(Z17, Z17, $2, $30, Z29, Z26, Z30, Z31, Z28)
	MUL_2_EXP_NEG_N(Z18, Z18, $3, $29, Z29, Z26, Z30, Z31, Z28)
	MUL_2_EXP_NEG_N(Z19, Z19, $4, $28, Z29, Z26, Z30, Z31, Z28)
	MUL_2_EXP_NEG_N(Z20, Z20, $5, $27, Z29, Z26, Z30, Z31, Z28)
	MUL_2_EXP_NEG_N(Z21, Z21, $6, $26, Z29, Z26, Z30, Z31, Z28)
	MUL_2_EXP_NEG_N(Z22, Z22, $7, $25, Z29, Z26, Z30, Z31, Z28)
	MUL_2_EXP_NEG_N(Z23, Z23, $27, $5, Z29, Z26, Z30, Z31, Z28)

#define SUB(in0, in1, in2, in3, in4) \
	VPSUBD  in1, in0, in4 \
	VPADDD  in2, in4, in3 \
	VPMINUD in4, in3, in4 \

	SUB(Z27, Z0, Z24, Z29, Z0)
	ADD(Z27, Z1, Z24, Z26, Z1)
	ADD(Z2, Z27, Z24, Z30, Z2)
	ADD(Z3, Z27, Z24, Z31, Z3)
	ADD(Z4, Z27, Z24, Z28, Z4)
	ADD(Z5, Z27, Z24, Z29, Z5)
	SUB(Z27, Z6, Z24, Z26, Z6)
	SUB(Z27, Z7, Z24, Z30, Z7)
	SUB(Z27, Z8, Z24, Z31, Z8)
	ADD(Z9, Z27, Z24, Z28, Z9)
	ADD(Z10, Z27, Z24, Z29, Z10)
	ADD(Z11, Z27, Z24, Z26, Z11)
	ADD(Z12, Z27, Z24, Z30, Z12)
	ADD(Z13, Z27, Z24, Z31, Z13)
	ADD(Z14, Z27, Z24, Z28, Z14)
	ADD(Z15, Z27, Z24, Z29, Z15)
	SUB(Z27, Z16, Z24, Z26, Z16)
	SUB(Z27, Z17, Z24, Z30, Z17)
	SUB(Z27, Z18, Z24, Z31, Z18)
	SUB(Z27, Z19, Z24, Z28, Z19)
	SUB(Z27, Z20, Z24, Z29, Z20)
	SUB(Z27, Z21, Z24, Z26, Z21)
	SUB(Z27, Z22, Z24, Z30, Z22)
	SUB(Z27, Z23, Z24, Z31, Z23)
	ADDQ $24, R14
	JMP  loop_5

done_6:
	// loop over the final full rounds
	MOVQ $0x0000000000000004, DI

loop_7:
	TESTQ        DI, DI
	JEQ          done_8
	DECQ         DI
	MOVQ         0(R14), CX
	VPBROADCASTD 0(CX), Z28
	ADD(Z0, Z28, Z24, Z29, Z0)
	MUL_W(Z0, Z0, Z31, Z27, Z29, Z28, Z26)
	REDUCE1Q(Z24, Z26, Z31)
	MUL_W(Z26, Z26, Z27, Z29, Z28, Z31, Z30)
	MUL_W(Z0, Z30, Z27, Z29, Z28, Z31, Z0)
	MUL_W(Z0, Z26, Z27, Z29, Z28, Z31, Z0)
	REDUCE1Q(Z24, Z0, Z27)
	VPBROADCASTD 4(CX), Z29
	ADD(Z1, Z29, Z24, Z28, Z1)
	MUL_W(Z1, Z1, Z26, Z30, Z28, Z29, Z31)
	REDUCE1Q(Z24, Z31, Z26)
	MUL_W(Z31, Z31, Z30, Z28, Z29, Z26, Z27)
	MUL_W(Z1, Z27, Z30, Z28, Z29, Z26, Z1)
	MUL_W(Z1, Z31, Z30, Z28, Z29, Z26, Z1)
	REDUCE1Q(Z24, Z1, Z30)
	VPBROADCASTD 8(CX), Z28
	ADD(Z2, Z28, Z24, Z29, Z2)
	MUL_W(Z2, Z2, Z31, Z27, Z29, Z28, Z26)
	REDUCE1Q(Z24, Z26, Z31)
	MUL_W(Z26, Z26, Z27, Z29, Z28, Z31, Z30)
	MUL_W(Z2, Z30, Z27, Z29, Z28, Z31, Z2)
	MUL_W(Z2, Z26, Z27, Z29, Z28, Z31, Z2)
	REDUCE1Q(Z24, Z2, Z27)
	VPBROADCASTD 12(CX), Z29
	ADD(Z3, Z29, Z24, Z28, Z3)
	MUL_W(Z3, Z3, Z26, Z30, Z28, Z29, Z31)
	REDUCE1Q(Z24, Z31, Z26)
	MUL_W(Z31, Z31, Z30, Z28, Z29, Z26, Z27)
	MUL_W(Z3, Z27, Z30, Z28, Z29, Z26, Z3)
	MUL_W(Z3, Z31, Z30, Z28, Z29, Z26, Z3)
	REDUCE1Q(Z24, Z3, Z30)
	VPBROADCASTD 16(CX), Z28
	ADD(Z4, Z28, Z24, Z29, Z4)
	MUL_W(Z4, Z4, Z31, Z27, Z29, Z28, Z26)
	REDUCE1Q(Z24, Z26, Z31)
	MUL_W(Z26, Z26, Z27, Z29, Z28, Z31, Z30)
	MUL_W(Z4, Z30, Z27, Z29, Z28, Z31, Z4)
	MUL_W(Z4, Z26, Z27, Z29, Z28, Z31, Z4)
	REDUCE1Q(Z24, Z4, Z27)
	VPBROADCASTD 20(CX), Z29
	ADD(Z5, Z29, Z24, Z28, Z5)
	MUL_W(Z5, Z5, Z26, Z30, Z28, Z29, Z31)
	REDUCE1Q(Z24, Z31, Z26)
	MUL_W(Z31, Z31, Z30, Z28, Z29, Z26, Z27)
	MUL_W(Z5, Z27, Z30, Z28, Z29, Z26, Z5)
	MUL_W(Z5, Z31, Z30, Z28, Z29, Z26, Z5)
	REDUCE1Q(Z24, Z5, Z30)
	VPBROADCASTD 24(CX), Z28
	ADD(Z6, Z28, Z24, Z29, Z6)
	MUL_W(Z6, Z6, Z31, Z27, Z29, Z28, Z26)
	REDUCE1Q(Z24, Z26, Z31)
	MUL_W(Z26, Z26, Z27, Z29, Z28, Z31, Z30)
	MUL_W(Z6, Z30, Z27, Z29, Z28, Z31, Z6)
	MUL_W(Z6, Z26, Z27, Z29, Z28, Z31, Z6)
	REDUCE1Q(Z24, Z6, Z27)
	VPBROADCASTD 28(CX), Z29
	ADD(Z7, Z29, Z24, Z28, Z7)
	MUL_W(Z7, Z7, Z26, Z30, Z28, Z29, Z31)
	REDUCE1Q(Z24, Z31, Z26)
	MUL_W(Z31, Z31, Z30, Z28, Z29, Z26, Z27)
	MUL_W(Z7, Z27, Z30, Z28, Z29, Z26, Z7)
	MUL_W(Z7, Z31, Z30, Z28, Z29, Z26, Z7)
	REDUCE1Q(Z24, Z7, Z30)
	VPBROADCASTD 32(CX), Z28
	ADD(Z8, Z28, Z24, Z29, Z8)
	MUL_W(Z8, Z8, Z31, Z27, Z29, Z28, Z26)
	REDUCE1Q(Z24, Z26, Z31)
	MUL_W(Z26, Z26, Z27, Z29, Z28, Z31, Z30)
	MUL_W(Z8, Z30, Z27, Z29, Z28, Z31, Z8)
	MUL_W(Z8, Z26, Z27, Z29, Z28, Z31, Z8)
	REDUCE1Q(Z24, Z8, Z27)
	VPBROADCASTD 36(CX), Z29
	ADD(Z9, Z29, Z24, Z28, Z9)
	MUL_W(Z9, Z9, Z26, Z30, Z28, Z29, Z31)
	REDUCE1Q(Z24, Z31, Z26)
	MUL_W(Z31, Z31, Z30, Z28, Z29, Z26, Z27)
	MUL_W(Z9, Z27, Z30, Z28, Z29, Z26, Z9)
	MUL_W(Z9, Z31, Z30, Z28, Z29, Z26, Z9)
	REDUCE1Q(Z24, Z9, Z30)
	VPBROADCASTD 40(CX), Z28
	ADD(Z10, Z28, Z24, Z29, Z10)
	MUL_W(Z10, Z10, Z31, Z27, Z29, Z28, Z26)
	REDUCE1Q(Z24, Z26, Z31)
	MUL_W(Z26, Z26, Z27, Z29, Z28, Z31, Z30)
	MUL_W(Z10, Z30, Z27, Z29, Z28, Z31, Z10)
	MUL_W(Z10, Z26, Z27, Z29, Z28, Z31, Z10)
	REDUCE1Q(Z24, Z10, Z27)
	VPBROADCASTD 44(CX), Z29
	ADD(Z11, Z29, Z24, Z28, Z11)
	MUL_W(Z11, Z11, Z26, Z30, Z28, Z29, Z31)
	REDUCE1Q(Z24, Z31, Z26)
	MUL_W(Z31, Z31, Z30, Z28, Z29, Z26, Z27)
	MUL_W(Z11, Z27, Z30, Z28, Z29, Z26, Z11)
	MUL_W(Z11, Z31, Z30, Z28, Z29, Z26, Z11)
	REDUCE1Q(Z24, Z11, Z30)
	VPBROADCASTD 48(CX), Z28
	ADD(Z12, Z28, Z24, Z29, Z12)
	MUL_W(Z12, Z12, Z31, Z27, Z29, Z28, Z26)
	REDUCE1Q(Z24, Z26, Z31)
	MUL_W(Z26, Z26, Z27, Z29, Z28, Z31, Z30)
	MUL_W(Z12, Z30, Z27, Z29, Z28, Z31, Z12)
	MUL_W(Z12, Z26, Z27, Z29, Z28, Z31, Z12)
	REDUCE1Q(Z24, Z12, Z27)
	VPBROADCASTD 52(CX), Z29
	ADD(Z13, Z29, Z24, Z28, Z13)
	MUL_W(Z13, Z13, Z26, Z30, Z28, Z29, Z31)
	REDUCE1Q(Z24, Z31, Z26)
	MUL_W(Z31, Z31, Z30, Z28, Z29, Z26, Z27)
	MUL_W(Z13, Z27, Z30, Z28, Z29, Z26, Z13)
	MUL_W(Z13, Z31, Z30, Z28, Z29, Z26, Z13)
	REDUCE1Q(Z24, Z13, Z30)
	VPBROADCASTD 56(CX), Z28
	ADD(Z14, Z28, Z24, Z29, Z14)
	MUL_W(Z14, Z14, Z31, Z27, Z29, Z28, Z26)
	REDUCE1Q(Z24, Z26, Z31)
	MUL_W(Z26, Z26, Z27, Z29, Z28, Z31, Z30)
	MUL_W(Z14, Z30, Z27, Z29, Z28, Z31, Z14)
	MUL_W(Z14, Z26, Z27, Z29, Z28, Z31, Z14)
	REDUCE1Q(Z24, Z14, Z27)
	VPBROADCASTD 60(CX), Z29
	ADD(Z15, Z29, Z24, Z28, Z15)
	MUL_W(Z15, Z15, Z26, Z30, Z28, Z29, Z31)
	REDUCE1Q(Z24, Z31, Z26)
	MUL_W(Z31, Z31, Z30, Z28, Z29, Z26, Z27)
	MUL_W(Z15, Z27, Z30, Z28, Z29, Z26, Z15)
	MUL_W(Z15, Z31, Z30, Z28, Z29, Z26, Z15)
	REDUCE1Q(Z24, Z15, Z30)
	VPBROADCASTD 64(CX), Z28
	ADD(Z16, Z28, Z24, Z29, Z16)
	MUL_W(Z16, Z16, Z31, Z27, Z29, Z28, Z26)
	REDUCE1Q(Z24, Z26, Z31)
	MUL_W(Z26, Z26, Z27, Z29, Z28, Z31, Z30)
	MUL_W(Z16, Z30, Z27, Z29, Z28, Z31, Z16)
	MUL_W(Z16, Z26, Z27, Z29, Z28, Z31, Z16)
	REDUCE1Q(Z24, Z16, Z27)
	VPBROADCASTD 68(CX), Z29
	ADD(Z17, Z29, Z24, Z28, Z17)
	MUL_W(Z17, Z17, Z26, Z30, Z28, Z29, Z31)
	REDUCE1Q(Z24, Z31, Z26)
	MUL_W(Z31, Z31, Z30, Z28, Z29, Z26, Z27)
	MUL_W(Z17, Z27, Z30, Z28, Z29, Z26, Z17)
	MUL_W(Z17, Z31, Z30, Z28, Z29, Z26, Z17)
	REDUCE1Q(Z24, Z17, Z30)
	VPBROADCASTD 72(CX), Z28
	ADD(Z18, Z28, Z24, Z29, Z18)
	MUL_W(Z18, Z18, Z31, Z27, Z29, Z28, Z26)
	REDUCE1Q(Z24, Z26, Z31)
	MUL_W(Z26, Z26, Z27, Z29, Z28, Z31, Z30)
	MUL_W(Z18, Z30, Z27, Z29, Z28, Z31, Z18)
	MUL_W(Z18, Z26, Z27, Z29, Z28, Z31, Z18)
	REDUCE1Q(Z24, Z18, Z27)
	VPBROADCASTD 76(CX), Z29
	ADD(Z19, Z29, Z24, Z28, Z19)
	MUL_W(Z19, Z19, Z26, Z30, Z28, Z29, Z31)
	REDUCE1Q(Z24, Z31, Z26)
	MUL_W(Z31, Z31, Z30, Z28, Z29, Z26, Z27)
	MUL_W(Z19, Z27, Z30, Z28, Z29, Z26, Z19)
	MUL_W(Z19, Z31, Z30, Z28, Z29, Z26, Z19)
	REDUCE1Q(Z24, Z19, Z30)
	VPBROADCASTD 80(CX), Z28
	ADD(Z20, Z28, Z24, Z29, Z20)
	MUL_W(Z20, Z20, Z31, Z27, Z29, Z28, Z26)
	REDUCE1Q(Z24, Z26, Z31)
	MUL_W(Z26, Z26, Z27, Z29, Z28, Z31, Z30)
	MUL_W(Z20, Z30, Z27, Z29, Z28, Z31, Z20)
	MUL_W(Z20, Z26, Z27, Z29, Z28, Z31, Z20)
	REDUCE1Q(Z24, Z20, Z27)
	VPBROADCASTD 84(CX), Z29
	ADD(Z21, Z29, Z24, Z28, Z21)
	MUL_W(Z21, Z21, Z26, Z30, Z28, Z29, Z31)
	REDUCE1Q(Z24, Z31, Z26)
	MUL_W(Z31, Z31, Z30, Z28, Z29, Z26, Z27)
	MUL_W(Z21, Z27, Z30, Z28, Z29, Z26, Z21)
	MUL_W(Z21, Z31, Z30, Z28, Z29, Z26, Z21)
	REDUCE1Q(Z24, Z21, Z30)
	VPBROADCASTD 88(CX), Z28
	ADD(Z22, Z28, Z24, Z29, Z22)
	MUL_W(Z22, Z22, Z31, Z27, Z29, Z28, Z26)
	REDUCE1Q(Z24, Z26, Z31)
	MUL_W(Z26, Z26, Z27, Z29, Z28, Z31, Z30)
	MUL_W(Z22, Z30, Z27, Z29, Z28, Z31, Z22)
	MUL_W(Z22, Z26, Z27, Z29, Z28, Z31, Z22)
	REDUCE1Q(Z24, Z22, Z27)
	VPBROADCASTD 92(CX), Z29
	ADD(Z23, Z29, Z24, Z28, Z23)
	MUL_W(Z23, Z23, Z26, Z30, Z28, Z29, Z31)
	REDUCE1Q(Z24, Z31, Z26)
	MUL_W(Z31, Z31, Z30, Z28, Z29, Z26, Z27)
	MUL_W(Z23, Z27, Z30, Z28, Z29, Z26, Z23)
	MUL_W(Z23, Z31, Z30, Z28, Z29, Z26, Z23)
	REDUCE1Q(Z24, Z23, Z30)
	ADD(Z0, Z1, Z24, Z27, Z28)
	ADD(Z2, Z3, Z24, Z27, Z29)
	ADD(Z28, Z29, Z24, Z27, Z26)
	ADD(Z26, Z1, Z24, Z27, Z30)
	ADD(Z26, Z3, Z24, Z27, Z31)
	DOUBLE(Z0, Z24, Z27, Z3)
	ADD(Z3, Z31, Z24, Z27, Z3)
	DOUBLE(Z2, Z24, Z27, Z1)
	ADD(Z1, Z30, Z24, Z27, Z1)
	ADD(Z28, Z30, Z24, Z27, Z0)
	ADD(Z29, Z31, Z24, Z27, Z2)
	ADD(Z4, Z5, Z24, Z27, Z28)
	ADD(Z6, Z7, Z24, Z27, Z29)
	ADD(Z28, Z29, Z24, Z27, Z26)
	ADD(Z26, Z5, Z24, Z27, Z30)
	ADD(Z26, Z7, Z24, Z27, Z31)
	DOUBLE(Z4, Z24, Z27, Z7)
	ADD(Z7, Z31, Z24, Z27, Z7)
	DOUBLE(Z6, Z24, Z27, Z5)
	ADD(Z5, Z30, Z24, Z27, Z5)
	ADD(Z28, Z30, Z24, Z27, Z4)
	ADD(Z29, Z31, Z24, Z27, Z6)
	ADD(Z8, Z9, Z24, Z27, Z28)
	ADD(Z10, Z11, Z24, Z27, Z29)
	ADD(Z28, Z29, Z24, Z27, Z26)
	ADD(Z26, Z9, Z24, Z27, Z30)
	ADD(Z26, Z11, Z24, Z27, Z31)
	DOUBLE(Z8, Z24, Z27, Z11)
	ADD(Z11, Z31, Z24, Z27, Z11)
	DOUBLE(Z10, Z24, Z27, Z9)
	ADD(Z9, Z30, Z24, Z27, Z9)
	ADD(Z28, Z30, Z24, Z27, Z8)
	ADD(Z29, Z31, Z24, Z27, Z10)
	ADD(Z12, Z13, Z24, Z27, Z28)
	ADD(Z14, Z15, Z24, Z27, Z29)
	ADD(Z28, Z29, Z24, Z27, Z26)
	ADD(Z26, Z13, Z24, Z27, Z30)
	ADD(Z26, Z15, Z24, Z27, Z31)
	DOUBLE(Z12, Z24, Z27, Z15)
	ADD(Z15, Z31, Z24, Z27, Z15)
	DOUBLE(Z14, Z24, Z27, Z13)
	ADD(Z13, Z30, Z24, Z27, Z13)
	ADD(Z28, Z30, Z24, Z27, Z12)
	ADD(Z29, Z31, Z24, Z27, Z14)
	ADD(Z16, Z17, Z24, Z27, Z28)
	ADD(Z18, Z19, Z24, Z27, Z29)
	ADD(Z28, Z29, Z24, Z27, Z26)
	ADD(Z26, Z17, Z24, Z27, Z30)
	ADD(Z26, Z19, Z24, Z27, Z31)
	DOUBLE(Z16, Z24, Z27, Z19)
	ADD(Z19, Z31, Z24, Z27, Z19)
	DOUBLE(Z18, Z24, Z27, Z17)
	ADD(Z17, Z30, Z24, Z27, Z17)
	ADD(Z28, Z30, Z24, Z27, Z16)
	ADD(Z29, Z31, Z24, Z27, Z18)
	ADD(Z20, Z21, Z24, Z27, Z28)
	ADD(Z22, Z23, Z24, Z27, Z29)
	ADD(Z28, Z29, Z24, Z27, Z26)
	ADD(Z26, Z21, Z24, Z27, Z30)
	ADD(Z26, Z23, Z24, Z27, Z31)
	DOUBLE(Z20, Z24, Z27, Z23)
	ADD(Z23, Z31, Z24, Z27, Z23)
	DOUBLE(Z22, Z24, Z27, Z21)
	ADD(Z21, Z30, Z24, Z27, Z21)
	ADD(Z28, Z30, Z24, Z27, Z20)
	ADD(Z29, Z31, Z24, Z27, Z22)
	ADD(Z0, Z4, Z24, Z30, Z27)
	ADD(Z1, Z5, Z24, Z31, Z28)
	ADD(Z2, Z6, Z24, Z30, Z29)
	ADD(Z3, Z7, Z24, Z31, Z26)
	ADD(Z8, Z27, Z24, Z30, Z27)
	ADD(Z9, Z28, Z24, Z31, Z28)
	ADD(Z10, Z29, Z24, Z30, Z29)
	ADD(Z11, Z26, Z24, Z31, Z26)
	ADD(Z12, Z27, Z24, Z30, Z27)
	ADD(Z13, Z28, Z24, Z31, Z28)
	ADD(Z14, Z29, Z24, Z30, Z29)
	ADD(Z15, Z26, Z24, Z31, Z26)
	ADD(Z16, Z27, Z24, Z30, Z27)
	ADD(Z17, Z28, Z24, Z31, Z28)
	ADD(Z18, Z29, Z24, Z30, Z29)
	ADD(Z19, Z26, Z24, Z31, Z26)
	ADD(Z20, Z27, Z24, Z30, Z27)
	ADD(Z21, Z28, Z24, Z31, Z28)
	ADD(Z22, Z29, Z24, Z30, Z29)
	ADD(Z23, Z26, Z24, Z31, Z26)
	ADD(Z0, Z27, Z24, Z30, Z0)
	ADD(Z1, Z28, Z24, Z31, Z1)
	ADD(Z2, Z29, Z24, Z30, Z2)
	ADD(Z3, Z26, Z24, Z31, Z3)
	ADD(Z4, Z27, Z24, Z30, Z4)
	ADD(Z5, Z28, Z24, Z31, Z5)
	ADD(Z6, Z29, Z24, Z30, Z6)
	ADD(Z7, Z26, Z24, Z31, Z7)
	ADD(Z8, Z27, Z24, Z30, Z8)
	ADD(Z9, Z28, Z24, Z31, Z9)
	ADD(Z10, Z29, Z24, Z30, Z10)
	ADD(Z11, Z26, Z24, Z31, Z11)
	ADD(Z12, Z27, Z24, Z30, Z12)
	ADD(Z13, Z28, Z24, Z31, Z13)
	ADD(Z14, Z29, Z24, Z30, Z14)
	ADD(Z15, Z26, Z24, Z31, Z15)
	ADD(Z16, Z27, Z24, Z30, Z16)
	ADD(Z17, Z28, Z24, Z31, Z17)
	ADD(Z18, Z29, Z24, Z30, Z18)
	ADD(Z19, Z26, Z24, Z31, Z19)
	ADD(Z20, Z27, Z24, Z30, Z20)
	ADD(Z21, Z28, Z24, Z31, Z21)
	ADD(Z22, Z29, Z24, Z30, Z22)
	ADD(Z23, Z26, Z24, Z31, Z23)
	ADDQ         $24, R14
	JMP          loop_7

done_8:
	VMOVDQU32 Z0, 0(R15)
	VMOVDQU32 Z1, 64(R15)
	VMOVDQU32 Z2, 128(R15)
	VMOVDQU32 Z3, 192(R15)
	VMOVDQU32 Z4, 256(R15)
	VMOVDQU32 Z5, 320(R15)
	VMOVDQU32 Z6, 384(R15)
	VMOVDQU32 Z7, 448(R15)
	VMOVDQU32 Z8, 512(R15)
	VMOVDQU32 Z9, 576(R15)
	VMOVDQU32 Z10, 640(R15)
	VMOVDQU32 Z11, 704(R15)
	VMOVDQU32 Z12, 768(R15)
	VMOVDQU32 Z13, 832(R15)
	VMOVDQU32 Z14, 896(R15)
	VMOVDQU32 Z15, 960(R15)
	VMOVDQU32 Z16, 1024(R15)
	VMOVDQU32 Z17, 1088(R15)
	VMOVDQU32 Z18, 1152(R15)
	VMOVDQU32 Z19, 1216(R15)
	VMOVDQU32 Z20, 1280(R15)
	VMOVDQU32 Z21, 1344(R15)
	VMOVDQU32 Z22, 1408(R15)
	VMOVDQU32 Z23, 1472(R15)
	RET

TEXT ·permutation16_avx512(SB), NOSPLIT, $0-48
	MOVQ         $0x0000000000005555, AX
	KMOVD        AX, K3
	MOVQ         $1, AX
	KMOVQ        AX, K2
	MOVD         $const_q, AX
	VPBROADCASTD AX, Z0
	MOVD         $const_qInvNeg, AX
	VPBROADCASTD AX, Z1
	MOVQ         input+0(FP), R15
	MOVQ         roundKeys+24(FP), R14
	VMOVDQU32    0(R15), Z2
	MOVQ         ·diag16+0(SB), CX
	VMOVDQU32    0(CX), Z18
	VPSRLQ       $32, Z18, Z19

#define MAT_MUL_EXTERNAL_16() \
	MAT_MUL_M4(Z2, Z6, Z7, Z8, Z0, Z11) \
	VEXTRACTI64X4 $1, Z2, Y16           \
	ADD(Y16, Y2, Y0, Y11, Y16)          \
	VSHUFF64X2    $1, Y16, Y16, Y17     \
	ADD(Y16, Y17, Y0, Y11, Y16)         \
	VINSERTI64X4  $1, Y16, Z16, Z16     \
	ADD(Z2, Z16, Z0, Z11, Z2)           \

#define SBOX_FULL_16() \
	MULD(Z2, Z2, Z12, Z13, Z6, Z7, Z14, Z15, Z0, Z1, Z8) \
	REDUCE1Q(Z0, Z8, Z15)                                \
	MULD(Z8, Z8, Z12, Z13, Z6, Z7, Z14, Z15, Z0, Z1, Z9) \
	MULD(Z2, Z8, Z12, Z13, Z6, Z7, Z14, Z15, Z0, Z1, Z2) \
	MULD(Z2, Z9, Z12, Z13, Z6, Z7, Z14, Z15, Z0, Z1, Z2) \
	REDUCE1Q(Z0, Z2, Z15)                                \

#define SUM_STATE_16() \
	VEXTRACTI64X4 $1, Z2, Y16                   \
	ADD(Y16, Y10, Y0, Y11, Y16)                 \
	VSHUFF64X2    $1, Y16, Y16, Y17             \
	ADD(Y16, Y17, Y0, Y11, Y16)                 \
	VPSHUFD       $0x000000000000004e, Y16, Y17 \
	ADD(Y16, Y17, Y0, Y11, Y16)                 \
	VPSHUFD       $0x00000000000000b1, Y16, Y17 \
	ADD(Y16, Y17, Y0, Y11, Y16)                 \
	VINSERTI64X4  $1, Y16, Z16, Z16             \

#define FULL_ROUND_16() \
	VMOVDQU32 0(BX), Z4      \
	ADD(Z2, Z4, Z0, Z11, Z2) \
	SBOX_FULL_16()           \
	MAT_MUL_EXTERNAL_16()    \

	MAT_MUL_EXTERNAL_16()
	MOVQ 0(R14), BX
	FULL_ROUND_16()
	MOVQ 24(R14), BX
	FULL_ROUND_16()
	MOVQ 48(R14), BX
	FULL_ROUND_16()
	MOVQ 72(R14), BX
	FULL_ROUND_16()

	// loop over the partial rounds
	MOVQ $0x000000000000000d, SI // nb partial rounds --> 13
	MOVQ R14, DI
	ADDQ $0x0000000000000060, DI

loop_9:
	TESTQ     SI, SI
	JEQ       done_10
	DECQ      SI
	MOVQ      0(DI), BX
	VMOVD     0(BX), X4
	VMOVDQA32 Z2, Z10
	ADD(X10, X4, X0, X14, X5)
	SBOX_PARTIAL()
	VPBLENDMD Z5, Z10, K2, Z10
	VPSRLQ    $32, Z2, Z12
	VPMULUDQ  Z12, Z19, Z8
	VPMULUDQ  Z8, Z1, Z15
	VPMULUDQ  Z15, Z0, Z15
	VPADDQ    Z8, Z15, Z8
	SUM_STATE_16()
	VPMULUDQ  Z10, Z18, Z6
	VPMULUDQ  Z6, Z1, Z14
	VPMULUDQ  Z14, Z0, Z14
	VPADDQ    Z6, Z14, Z6
	VMOVSHDUP Z6, K3, Z8
	VPSUBD    Z0, Z8, Z11
	VPMINUD   Z8, Z11, Z2
	ADD(Z2, Z16, Z0, Z11, Z2)
	ADDQ      $24, DI
	JMP       loop_9

done_10:
	MOVQ      408(R14), BX
	FULL_ROUND_16()
	MOVQ      432(R14), BX
	FULL_ROUND_16()
	MOVQ      456(R14), BX
	FULL_ROUND_16()
	MOVQ      480(R14), BX
	FULL_ROUND_16()
	VMOVDQU32 Z2, 0(R15)
	RET
