// Code generated by gnark-crypto/generator. DO NOT EDIT.
#include "textflag.h"
#include "funcdata.h"
#include "go_asm.h"

// butterfly(a, b *Element)
// a, b = a+b, a-b
TEXT ·Butterfly(SB), NOFRAME|NOSPLIT, $0-16
	LDP  x+0(FP), (R25, R26)
	LDP  0(R25), (R0, R1)
	LDP  16(R25), (R2, R3)
	LDP  32(R25), (R4, R5)
	LDP  0(R26), (R6, R7)
	LDP  16(R26), (R8, R9)
	LDP  32(R26), (R10, R11)
	ADDS R0, R6, R12
	ADCS R1, R7, R13
	ADCS R2, R8, R14
	ADCS R3, R9, R15
	ADCS R4, R10, R16
	ADC  R5, R11, R17
	SUBS R6, R0, R6
	SBCS R7, R1, R7
	SBCS R8, R2, R8
	SBCS R9, R3, R9
	SBCS R10, R4, R10
	SBCS R11, R5, R11
	LDP  ·qElement+0(SB), (R0, R1)
	CSEL CS, ZR, R0, R19
	CSEL CS, ZR, R1, R20
	LDP  ·qElement+16(SB), (R2, R3)
	CSEL CS, ZR, R2, R21
	CSEL CS, ZR, R3, R22
	LDP  ·qElement+32(SB), (R4, R5)
	CSEL CS, ZR, R4, R23
	CSEL CS, ZR, R5, R24

	// add q if underflow, 0 if not
	ADDS R6, R19, R6
	ADCS R7, R20, R7
	STP  (R6, R7), 0(R26)
	ADCS R8, R21, R8
	ADCS R9, R22, R9
	STP  (R8, R9), 16(R26)
	ADCS R10, R23, R10
	ADC  R11, R24, R11
	STP  (R10, R11), 32(R26)

	// q = t - q
	SUBS R0, R12, R0
	SBCS R1, R13, R1
	SBCS R2, R14, R2
	SBCS R3, R15, R3
	SBCS R4, R16, R4
	SBCS R5, R17, R5

	// if no borrow, return q, else return t
	CSEL CS, R0, R12, R12
	CSEL CS, R1, R13, R13
	STP  (R12, R13), 0(R25)
	CSEL CS, R2, R14, R14
	CSEL CS, R3, R15, R15
	STP  (R14, R15), 16(R25)
	CSEL CS, R4, R16, R16
	CSEL CS, R5, R17, R17
	STP  (R16, R17), 32(R25)
	RET

// mul(res, x, y *Element)
// Algorithm 2 of Faster Montgomery Multiplication and Multi-Scalar-Multiplication for SNARKS
// by Y. El Housni and G. Botrel https://doi.org/10.46586/tches.v2023.i3.504-521
TEXT ·mul(SB), NOFRAME|NOSPLIT, $0-24
#define DIVSHIFT() \
	MUL   R17, R16, R0 \
	ADDS  R0, R8, R8   \
	MUL   R19, R16, R0 \
	ADCS  R0, R9, R9   \
	MUL   R20, R16, R0 \
	ADCS  R0, R10, R10 \
	MUL   R21, R16, R0 \
	ADCS  R0, R11, R11 \
	MUL   R22, R16, R0 \
	ADCS  R0, R12, R12 \
	MUL   R23, R16, R0 \
	ADCS  R0, R13, R13 \
	ADC   R14, ZR, R14 \
	UMULH R17, R16, R0 \
	ADDS  R0, R9, R8   \
	UMULH R19, R16, R0 \
	ADCS  R0, R10, R9  \
	UMULH R20, R16, R0 \
	ADCS  R0, R11, R10 \
	UMULH R21, R16, R0 \
	ADCS  R0, R12, R11 \
	UMULH R22, R16, R0 \
	ADCS  R0, R13, R12 \
	UMULH R23, R16, R0 \
	ADCS  R0, R14, R13 \

#define MUL_WORD_N() \
	MUL   R2, R1, R0   \
	ADDS  R0, R8, R8   \
	MUL   R8, R15, R16 \
	MUL   R3, R1, R0   \
	ADCS  R0, R9, R9   \
	MUL   R4, R1, R0   \
	ADCS  R0, R10, R10 \
	MUL   R5, R1, R0   \
	ADCS  R0, R11, R11 \
	MUL   R6, R1, R0   \
	ADCS  R0, R12, R12 \
	MUL   R7, R1, R0   \
	ADCS  R0, R13, R13 \
	ADC   ZR, ZR, R14  \
	UMULH R2, R1, R0   \
	ADDS  R0, R9, R9   \
	UMULH R3, R1, R0   \
	ADCS  R0, R10, R10 \
	UMULH R4, R1, R0   \
	ADCS  R0, R11, R11 \
	UMULH R5, R1, R0   \
	ADCS  R0, R12, R12 \
	UMULH R6, R1, R0   \
	ADCS  R0, R13, R13 \
	UMULH R7, R1, R0   \
	ADC   R0, R14, R14 \
	DIVSHIFT()         \

#define MUL_WORD_0() \
	MUL   R2, R1, R8   \
	MUL   R3, R1, R9   \
	MUL   R4, R1, R10  \
	MUL   R5, R1, R11  \
	MUL   R6, R1, R12  \
	MUL   R7, R1, R13  \
	UMULH R2, R1, R0   \
	ADDS  R0, R9, R9   \
	UMULH R3, R1, R0   \
	ADCS  R0, R10, R10 \
	UMULH R4, R1, R0   \
	ADCS  R0, R11, R11 \
	UMULH R5, R1, R0   \
	ADCS  R0, R12, R12 \
	UMULH R6, R1, R0   \
	ADCS  R0, R13, R13 \
	UMULH R7, R1, R0   \
	ADC   R0, ZR, R14  \
	MUL   R8, R15, R16 \
	DIVSHIFT()         \

	MOVD y+16(FP), R24
	MOVD x+8(FP), R0
	LDP  0(R0), (R2, R3)
	LDP  16(R0), (R4, R5)
	LDP  32(R0), (R6, R7)
	MOVD 0(R24), R1
	MOVD $const_qInvNeg, R15
	LDP  ·qElement+0(SB), (R17, R19)
	LDP  ·qElement+16(SB), (R20, R21)
	LDP  ·qElement+32(SB), (R22, R23)
	MUL_WORD_0()
	MOVD 8(R24), R1
	MUL_WORD_N()
	MOVD 16(R24), R1
	MUL_WORD_N()
	MOVD 24(R24), R1
	MUL_WORD_N()
	MOVD 32(R24), R1
	MUL_WORD_N()
	MOVD 40(R24), R1
	MUL_WORD_N()

	// reduce if necessary
	SUBS R17, R8, R17
	SBCS R19, R9, R19
	SBCS R20, R10, R20
	SBCS R21, R11, R21
	SBCS R22, R12, R22
	SBCS R23, R13, R23
	MOVD res+0(FP), R0
	CSEL CS, R17, R8, R8
	CSEL CS, R19, R9, R9
	STP  (R8, R9), 0(R0)
	CSEL CS, R20, R10, R10
	CSEL CS, R21, R11, R11
	STP  (R10, R11), 16(R0)
	CSEL CS, R22, R12, R12
	CSEL CS, R23, R13, R13
	STP  (R12, R13), 32(R0)
	RET

// reduce(res *Element)
TEXT ·reduce(SB), NOFRAME|NOSPLIT, $0-8
	LDP  ·qElement+0(SB), (R6, R7)
	LDP  ·qElement+16(SB), (R8, R9)
	LDP  ·qElement+32(SB), (R10, R11)
	MOVD res+0(FP), R12
	LDP  0(R12), (R0, R1)
	LDP  16(R12), (R2, R3)
	LDP  32(R12), (R4, R5)

	// q = t - q
	SUBS R6, R0, R6
	SBCS R7, R1, R7
	SBCS R8, R2, R8
	SBCS R9, R3, R9
	SBCS R10, R4, R10
	SBCS R11, R5, R11

	// if no borrow, return q, else return t
	CSEL CS, R6, R0, R0
	CSEL CS, R7, R1, R1
	STP  (R0, R1), 0(R12)
	CSEL CS, R8, R2, R2
	CSEL CS, R9, R3, R3
	STP  (R2, R3), 16(R12)
	CSEL CS, R10, R4, R4
	CSEL CS, R11, R5, R5
	STP  (R4, R5), 32(R12)
	RET
