// Code generated by github.com/99designs/gqlgen, DO NOT EDIT.

package server

import (
	"fmt"
	"io"
	"strconv"
)

type Being interface {
	IsBeing()
	GetID() string
	GetName() string
}

type Lucky interface {
	IsLucky()
	GetLuckyNumber() *int
}

type Animal struct {
	ID      string      `json:"id"`
	Name    string      `json:"name"`
	Species Species     `json:"species"`
	Owner   Being       `json:"owner,omitempty"`
	Hair    *BeingsHair `json:"hair,omitempty"`
}

func (Animal) IsBeing()             {}
func (this Animal) GetID() string   { return this.ID }
func (this Animal) GetName() string { return this.Name }

type BeingsHair struct {
	HasHair bool `json:"hasHair"`
}

type Hair struct {
	Color *string `json:"color,omitempty"`
}

type Mutation struct {
}

type NewUser struct {
	Name string `json:"name"`
}

type Query struct {
}

type Subscription struct {
}

type User struct {
	ID          string  `json:"id"`
	Name        string  `json:"name"`
	LuckyNumber *int    `json:"luckyNumber,omitempty"`
	Hair        *Hair   `json:"hair,omitempty"`
	Birthdate   *string `json:"birthdate,omitempty"`
	Friends     []*User `json:"friends"`
	GreatScalar *string `json:"greatScalar,omitempty"`
}

func (User) IsBeing()             {}
func (this User) GetID() string   { return this.ID }
func (this User) GetName() string { return this.Name }

func (User) IsLucky()                  {}
func (this User) GetLuckyNumber() *int { return this.LuckyNumber }

type Species string

const (
	SpeciesDog        Species = "DOG"
	SpeciesCoelacanth Species = "COELACANTH"
)

var AllSpecies = []Species{
	SpeciesDog,
	SpeciesCoelacanth,
}

func (e Species) IsValid() bool {
	switch e {
	case SpeciesDog, SpeciesCoelacanth:
		return true
	}
	return false
}

func (e Species) String() string {
	return string(e)
}

func (e *Species) UnmarshalGQL(v interface{}) error {
	str, ok := v.(string)
	if !ok {
		return fmt.Errorf("enums must be strings")
	}

	*e = Species(str)
	if !e.IsValid() {
		return fmt.Errorf("%s is not a valid Species", str)
	}
	return nil
}

func (e Species) MarshalGQL(w io.Writer) {
	fmt.Fprint(w, strconv.Quote(e.String()))
}
