"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const react_1 = __importDefault(require("react"));
const dev_warnings_1 = require("./dev-warnings");
const is_server_environment_1 = require("./is-server-environment");
const sheet_1 = __importStar(require("./sheet"));
const style_cache_1 = require("./style-cache");
function Style(props) {
    const inserted = (0, style_cache_1.useCache)();
    if (process.env.NODE_ENV === 'development') {
        props.children.forEach(dev_warnings_1.analyzeCssInDev);
    }
    if (props.children.length) {
        if ((0, is_server_environment_1.isServerEnvironment)()) {
            const bucketedSheets = {};
            let hasSheets = false;
            for (let i = 0; i < props.children.length; i++) {
                const sheet = props.children[i];
                if (inserted[sheet]) {
                    continue;
                }
                else {
                    inserted[sheet] = true;
                    hasSheets = true;
                }
                const bucketName = (0, sheet_1.getStyleBucketName)(sheet);
                bucketedSheets[bucketName] = (bucketedSheets[bucketName] || '') + sheet;
            }
            if (!hasSheets) {
                return null;
            }
            return (react_1.default.createElement("style", { "data-cmpld": true, nonce: props.nonce, dangerouslySetInnerHTML: {
                    __html: sheet_1.styleBucketOrdering.map((bucket) => bucketedSheets[bucket]).join(''),
                } }));
        }
        else {
            for (let i = 0; i < props.children.length; i++) {
                const sheet = props.children[i];
                if (inserted[sheet]) {
                    continue;
                }
                inserted[sheet] = true;
                (0, sheet_1.default)(sheet, props);
            }
        }
    }
    return null;
}
exports.default = Style;
//# sourceMappingURL=style.js.map