"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.UNSAFE_BREAKPOINTS_ORDERED_LIST = exports.UNSAFE_BREAKPOINTS_CONFIG = exports.SMALLEST_BREAKPOINT = void 0;
/**
 * Our internal configuration for breakpoints configuration.
 *
 * We explicitly use `-0.01rem` for "max" values to both ensure we do not overlap our media queries, but also don't skip any fractional pixels.  There is a chance this is not safe in some browsers, eg. Safari has weird rounding.
 * @see: https://tzi.fr/css/prevent-double-breakpoint/
 *
 * @experimental Unsafe for direct consumption outside of the design system itself; please use our `media` export instead for media queries.
 */
var UNSAFE_BREAKPOINTS_CONFIG = exports.UNSAFE_BREAKPOINTS_CONFIG = {
  // mobile
  xxs: {
    gridItemGutter: "var(--ds-space-200, 16px)",
    gridMargin: "var(--ds-space-200, 16px)",
    min: '0rem',
    max: '29.99rem'
  },
  // phablet
  xs: {
    gridItemGutter: "var(--ds-space-200, 16px)",
    gridMargin: "var(--ds-space-200, 16px)",
    min: '30rem',
    max: '47.99rem'
  },
  // tablet
  sm: {
    gridItemGutter: "var(--ds-space-200, 16px)",
    gridMargin: "var(--ds-space-300, 24px)",
    min: '48rem',
    max: '63.99rem'
  },
  // laptop desktop
  md: {
    gridItemGutter: "var(--ds-space-300, 24px)",
    gridMargin: "var(--ds-space-400, 32px)",
    min: '64rem',
    max: '89.99rem'
  },
  // monitor
  lg: {
    gridItemGutter: "var(--ds-space-400, 32px)",
    gridMargin: "var(--ds-space-400, 32px)",
    min: '90rem',
    max: '110.49rem'
  },
  // large high res
  xl: {
    gridItemGutter: "var(--ds-space-400, 32px)",
    gridMargin: "var(--ds-space-500, 40px)",
    min: '110.5rem',
    max: null
  }
  // NOTE: We previously had an `xxl=135rem` breakpoint, but it was removed as it was not used anywhere and felt too large
}; //TODO: This `as const` should really be `satisfies Record<Breakpoint, BreakpointConfig>`, but that's not possible in our shipped TypeScript version yet.

/**
 * The list of breakpoints in order from smallest to largest.  You may need to clone and reverse this list if you want the opposite.
 *
 * This is intentional for cascading with `min-width` or `media.above`. Media queries go from lowest width to highest.
 *
 * @experimental Unsafe for consumption outside of the design system itself.
 */
var UNSAFE_BREAKPOINTS_ORDERED_LIST = exports.UNSAFE_BREAKPOINTS_ORDERED_LIST = Object.keys(UNSAFE_BREAKPOINTS_CONFIG);

/**
 * This is our smallest breakpoint with a few nuances to it:
 * 1. It is the default value for shorthands, eg. `<GridItem span={6} />` maps to `{ [SMALLEST_BREAKPOINT]: props.span }`
 * 2. It's omitted in `media.below` as there's nothing below `0px`.
 */
var SMALLEST_BREAKPOINT = exports.SMALLEST_BREAKPOINT = UNSAFE_BREAKPOINTS_ORDERED_LIST[0];