"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = void 0;
var _react = _interopRequireDefault(require("react"));
var _react2 = require("@emotion/react");
var _xcss = require("../xcss/xcss");
/**
 * @jsxRuntime classic
 * @jsx jsx
 */

// eslint-disable-next-line @atlaskit/ui-styling-standard/use-compiled -- Ignored via go/DSP-18766

var baseStyles = (0, _react2.css)({
  boxSizing: 'border-box'
});
var blockBleedMap = {
  'space.025': (0, _react2.css)({
    marginBlock: "var(--ds-space-negative-025, -0.125rem)"
  }),
  'space.050': (0, _react2.css)({
    marginBlock: "var(--ds-space-negative-050, -0.25rem)"
  }),
  'space.100': (0, _react2.css)({
    marginBlock: "var(--ds-space-negative-100, -0.5rem)"
  }),
  'space.150': (0, _react2.css)({
    marginBlock: "var(--ds-space-negative-150, -0.75rem)"
  }),
  'space.200': (0, _react2.css)({
    marginBlock: "var(--ds-space-negative-200, -1rem)"
  })
};
var inlineBleedMap = {
  'space.025': (0, _react2.css)({
    marginInline: "var(--ds-space-negative-025, -0.125rem)"
  }),
  'space.050': (0, _react2.css)({
    marginInline: "var(--ds-space-negative-050, -0.25rem)"
  }),
  'space.100': (0, _react2.css)({
    marginInline: "var(--ds-space-negative-100, -0.5rem)"
  }),
  'space.150': (0, _react2.css)({
    marginInline: "var(--ds-space-negative-150, -0.75rem)"
  }),
  'space.200': (0, _react2.css)({
    marginInline: "var(--ds-space-negative-200, -1rem)"
  })
};

/**
 * __Bleed__
 *
 * `Bleed` is a primitive layout component that controls negative whitespace.
 *
 * - [Examples](https://atlassian.design/components/primitives/bleed/examples)
 * - [Code](https://atlassian.design/components/primitives/bleed/code)
 */
var Bleed = /*#__PURE__*/_react.default.memo(function (_ref) {
  var children = _ref.children,
    testId = _ref.testId,
    inline = _ref.inline,
    block = _ref.block,
    all = _ref.all,
    xcss = _ref.xcss;
  var resolvedStyles = (0, _xcss.parseXcss)(xcss);
  return (0, _react2.jsx)("div", {
    // eslint-disable-next-line @atlaskit/ui-styling-standard/no-classname-prop -- Ignored via go/DSP-18766
    className: resolvedStyles.static,
    css: [baseStyles, (inline || all) && inlineBleedMap[inline || all], (block || all) && blockBleedMap[block || all], resolvedStyles.emotion],
    "data-testid": testId
  }, children);
});
Bleed.displayName = 'Bleed';
var _default = exports.default = Bleed;