import _asyncToGenerator from "@babel/runtime/helpers/asyncToGenerator";
import _regeneratorRuntime from "@babel/runtime/regenerator";
import { fg } from '@atlaskit/platform-feature-flags';
import themeImportMap from '../artifacts/theme-import-map';
import { CUSTOM_THEME_ATTRIBUTE, THEME_DATA_ATTRIBUTE } from '../constants';
export var loadAndAppendThemeCss = /*#__PURE__*/function () {
  var _ref = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee(themeId) {
    var themeCss, style;
    return _regeneratorRuntime.wrap(function _callee$(_context) {
      while (1) switch (_context.prev = _context.next) {
        case 0:
          if (!document.head.querySelector("style[".concat(THEME_DATA_ATTRIBUTE, "=\"").concat(themeId, "\"]:not([").concat(CUSTOM_THEME_ATTRIBUTE, "])"))) {
            _context.next = 2;
            break;
          }
          return _context.abrupt("return");
        case 2:
          if (themeId) {
            _context.next = 4;
            break;
          }
          return _context.abrupt("return");
        case 4:
          _context.next = 6;
          return loadThemeCss(themeId);
        case 6:
          themeCss = _context.sent;
          style = document.createElement('style');
          style.textContent = themeCss;
          style.dataset.theme = themeId;
          document.head.appendChild(style);
        case 11:
        case "end":
          return _context.stop();
      }
    }, _callee);
  }));
  return function loadAndAppendThemeCss(_x) {
    return _ref.apply(this, arguments);
  };
}();
export var loadThemeCss = /*#__PURE__*/function () {
  var _ref2 = _asyncToGenerator( /*#__PURE__*/_regeneratorRuntime.mark(function _callee2(themeId) {
    var _yield$themeImportMap, themeCss;
    return _regeneratorRuntime.wrap(function _callee2$(_context2) {
      while (1) switch (_context2.prev = _context2.next) {
        case 0:
          if ((themeId === 'light' || themeId === 'dark') && fg('platform-component-visual-refresh')) {
            themeId += '-brand-refresh';
          }
          _context2.next = 3;
          return themeImportMap[themeId]();
        case 3:
          _yield$themeImportMap = _context2.sent;
          themeCss = _yield$themeImportMap.default;
          return _context2.abrupt("return", themeCss);
        case 6:
        case "end":
          return _context2.stop();
      }
    }, _callee2);
  }));
  return function loadThemeCss(_x2) {
    return _ref2.apply(this, arguments);
  };
}();
export var darkModeMediaQuery = '(prefers-color-scheme: dark)';
export var moreContrastMediaQuery = '(prefers-contrast: more)';