"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = usePreviousValue;
var _react = require("react");
/**
 * Returns the previous value in a given render cycle.
 *
 * ```js
 * const [currentValue] = useState(1);
 * const previousValue = usePreviousValue(currentValue);
 *
 * previousValue; // undefined
 * currentValue; // 1
 * ```
 *
 * @param value
 */
function usePreviousValue(value) {
  var ref = (0, _react.useRef)();
  (0, _react.useEffect)(function () {
    ref.current = value;
  }, [value]);
  return ref.current;
}